/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.java_client.ui.dialogs.trees.TreeOutput;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TreeOutputPlots
extends BaseProcedureTab
implements ItemListener {
    static final String PERCENTILE_INC_COMBO = "IDS_TREEOUTPUTPLOT_PERCENT_INC_COMBO";
    static final String VAR_IMPORTANCE_TO_MODEL_CHECKBOX = "IDS_TREE_OUTPUT_INDEPENDENT_VARIABLE_IMPORTANCE_TO_MODEL";
    static final String GAIN_CHECKBOX = "IDS_TREE_OUTPUT_GAIN";
    static final String INDEX_CHECKBOX = "IDS_TREE_OUTPUT_INDEX";
    static final String RESPONCE_CHECKBOX = "IDS_TREE_OUTPUT_RESPONSE";
    static final String MEAN_CHECKBOX = "IDS_TREE_OUTPUT_MEAN";
    static final String AVG_PROFIT_CHECKBOX = "IDS_TREE_OUTPUT_AVERAGE_PROFIT";
    static final String ROI_CHECKBOX = "IDS_TREE_OUTPUT_RETURN_ON_INVESTMENT_(ROI)";
    private JCheckBox mVarImpToModelCheck;
    private JLabel mPercentileIncLbl;
    private JComboBox mPercentileIncCombo;
    private JCheckBox mGainCheck;
    private JCheckBox mIndexCheck;
    private JCheckBox mResponceCheck;
    private JCheckBox mMeanCheck;
    private JCheckBox mAvgProfitCheck;
    private JCheckBox mROICheck;

    public TreeOutputPlots(BaseTabbedSubDialog baseTabbedSubDialog) {
        super(baseTabbedSubDialog, true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
        if (jCheckBox.isEnabled()) {
            boolean bl = jCheckBox.isSelected() || this.isAnyCheckBoxEnabled();
            this.mPercentileIncLbl.setEnabled(bl);
            this.mPercentileIncCombo.setEnabled(bl);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_output_plot";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        String string;
        DialogDataModel dialogDataModel = ((TreeDlg)((Object)this.mParent.getParent())).getDialogDataModel();
        ISpssVariable iSpssVariable = ((TreeDlg)((Object)this.mParent.getParent())).getDependentVariable();
        boolean bl = iSpssVariable != null ? iSpssVariable.getMeasurementLevel().value() != 3 : true;
        boolean bl2 = ((TreeDlg)((Object)this.mParent.getParent())).isTargetCategoryDefined();
        boolean bl3 = false;
        Boolean bl4 = dialogDataModel.getBoolean("IDS_TREE_OPT_PROFIT_CUSTOM");
        if (bl4 != null) {
            bl3 = bl4;
        }
        if ((string = this.getResStringArray("IDS_TREE_GROWING_METHOD_ARRAY")[dialogDataModel.getInteger("IDS_TREE_GROWING_METHOD_COMBOBOX")]).equals(this.getResString("IDS_TREE_GROWING_METHOD_CRT_ITEM"))) {
            return this.mVarImpToModelCheck;
        }
        if (bl && bl2) {
            return this.mGainCheck;
        }
        if (!bl) {
            return this.mMeanCheck;
        }
        if (bl && bl3) {
            return this.mAvgProfitCheck;
        }
        return this.mVarImpToModelCheck;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeOutputPlots.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, n2, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(this, this.mVarImpToModelCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(this, this.setupNodePerformancePanel(), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, VAR_IMPORTANCE_TO_MODEL_CHECKBOX);
        this.mVarImpToModelCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, GAIN_CHECKBOX);
        this.mGainCheck = new JCheckBox(toggleButtonAction);
        this.mGainCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, INDEX_CHECKBOX);
        this.mIndexCheck = new JCheckBox(toggleButtonAction);
        this.mIndexCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, RESPONCE_CHECKBOX);
        this.mResponceCheck = new JCheckBox(toggleButtonAction);
        this.mResponceCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, MEAN_CHECKBOX);
        this.mMeanCheck = new JCheckBox(toggleButtonAction);
        this.mMeanCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, AVG_PROFIT_CHECKBOX);
        this.mAvgProfitCheck = new JCheckBox(toggleButtonAction);
        this.mAvgProfitCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, ROI_CHECKBOX);
        this.mROICheck = new JCheckBox(toggleButtonAction);
        this.mROICheck.addItemListener(this);
        this.mPercentileIncLbl = DialogUtil.createLabel(this.mParent, "IDS_TREE_OUTPUT_PLOTS_PERCENTILE_INCREMENT");
        this.mPercentileIncCombo = new JComboBox<String>(new String[]{"1%", "2%", "5%", "10%", "20%", "25%"});
        this.mPercentileIncCombo.setAction(new ComboboxAction(this.mParent, PERCENTILE_INC_COMBO));
        this.mPercentileIncCombo.setMaximumRowCount(5);
        this.mPercentileIncLbl.setLabelFor(this.mPercentileIncCombo);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mGainCheck);
        spssButtonGroup.add(this.mIndexCheck);
        spssButtonGroup.add(this.mResponceCheck);
        spssButtonGroup.add(this.mMeanCheck);
        spssButtonGroup.add(this.mAvgProfitCheck);
        spssButtonGroup.add(this.mROICheck);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mVarImpToModelCheck);
        vector.add(this.mGainCheck);
        vector.add(this.mIndexCheck);
        vector.add(this.mResponceCheck);
        vector.add(this.mMeanCheck);
        vector.add(this.mAvgProfitCheck);
        vector.add(this.mROICheck);
        vector.add(this.mPercentileIncCombo);
        JPanel jPanel = ((TreeOutput)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private JPanel setupNodePerformancePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TREE_OUTPUT_NODE_PERFORMANCE")));
        JPanel jPanel2 = new JPanel();
        DialogUtil.applyTopBorder(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mGainCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mIndexCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mResponceCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mMeanCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mAvgProfitCheck, gridBagConstraints, 0, 4, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mROICheck, gridBagConstraints, 0, 5, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, jPanel2, gridBagConstraints, 0, 6, 1, 1, n, new Insets(n2, insets.left, 0, insets.right));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.setupComboboxPanel(), gridBagConstraints, 0, 7, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupComboboxPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mPercentileIncLbl, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mPercentileIncCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setDefaults() {
        DialogDataModel dialogDataModel = ((TreeDlg)((Object)this.mParent.getParent())).getDialogDataModel();
        ISpssVariable iSpssVariable = ((TreeDlg)((Object)this.mParent.getParent())).getDependentVariable();
        boolean bl = iSpssVariable != null ? iSpssVariable.getMeasurementLevel().value() != 3 : true;
        boolean bl2 = ((TreeDlg)((Object)this.mParent.getParent())).isTargetCategoryDefined();
        boolean bl3 = false;
        Boolean bl4 = dialogDataModel.getBoolean("IDS_TREE_OPT_PROFIT_CUSTOM");
        if (bl4 != null) {
            bl3 = bl4;
        }
        String string = this.getResStringArray("IDS_TREE_GROWING_METHOD_ARRAY")[dialogDataModel.getInteger("IDS_TREE_GROWING_METHOD_COMBOBOX")];
        this.mVarImpToModelCheck.setEnabled(string.equals(this.getResString("IDS_TREE_GROWING_METHOD_CRT_ITEM")));
        this.mGainCheck.setEnabled(bl && bl2);
        this.mIndexCheck.setEnabled(bl && bl2);
        this.mResponceCheck.setEnabled(bl && bl2);
        this.mMeanCheck.setEnabled(!bl);
        this.mAvgProfitCheck.setEnabled(bl && bl3);
        this.mROICheck.setEnabled(bl && bl3);
        boolean bl5 = this.mGainCheck.isEnabled() && this.mGainCheck.isSelected() || this.mIndexCheck.isEnabled() && this.mIndexCheck.isSelected() || this.mResponceCheck.isEnabled() && this.mResponceCheck.isSelected() || this.mMeanCheck.isEnabled() && this.mMeanCheck.isSelected() || this.mAvgProfitCheck.isEnabled() && this.mAvgProfitCheck.isSelected() || this.mROICheck.isEnabled() && this.mROICheck.isSelected();
        this.mPercentileIncLbl.setEnabled(bl5);
        this.mPercentileIncCombo.setEnabled(bl5);
        this.mPercentileIncCombo.setSelectedIndex(3);
    }

    private boolean isAnyCheckBoxEnabled() {
        return this.mGainCheck.isEnabled() && this.mGainCheck.isSelected() || this.mIndexCheck.isEnabled() && this.mIndexCheck.isSelected() || this.mResponceCheck.isEnabled() && this.mResponceCheck.isSelected() || this.mMeanCheck.isEnabled() && this.mMeanCheck.isSelected() || this.mAvgProfitCheck.isEnabled() && this.mAvgProfitCheck.isSelected() || this.mROICheck.isEnabled() && this.mROICheck.isSelected();
    }
}

