/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.java_client.ui.dialogs.trees.TreeOutputPlots;
import com.spss.java_client.ui.dialogs.trees.TreeOutputRules;
import com.spss.java_client.ui.dialogs.trees.TreeOutputStats;
import com.spss.java_client.ui.dialogs.trees.TreeOutputTree;

public class TreeOutput
extends BaseTabbedSubDialog {
    private static final String SELECTED_TAB_INDEX = "IDS_TREE_OUTPUT_SELECTED_TAB_INDEX";
    TreeOutputTree mTreeTab;
    TreeOutputStats mStatsTab;
    TreeOutputPlots mPlotsTab;
    TreeOutputRules mRulesTab;

    public TreeOutput(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_TREE_OUTPUT_TITLE"), true);
    }

    @Override
    public boolean continuePressed() {
        if (this.mTreeTab.isShowing()) {
            return this.mTreeTab.isValidate();
        }
        if (this.mRulesTab.isShowing()) {
            return this.mRulesTab.isValidate(true);
        }
        return true;
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        super.saveState(dialogDataModel);
        dialogDataModel.putInteger(SELECTED_TAB_INDEX, this.mTabbedPane.getSelectedIndex());
        return true;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        Integer n = dialogDataModel.getInteger(SELECTED_TAB_INDEX) != null ? dialogDataModel.getInteger(SELECTED_TAB_INDEX) : 0;
        if (this.mTabbedPane.getComponentCount() > n) {
            this.mTabbedPane.setSelectedIndex(n);
        }
    }

    @Override
    protected void init() {
        super.init();
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        this.mTreeTab = new TreeOutputTree(this);
        this.addTab(this.getResString("IDS_TREE_OUTPUT_TREE"), this.mTreeTab);
        this.mStatsTab = new TreeOutputStats(this);
        this.addTab(this.getResString("IDS_TREE_OUTPUT_STATISTICS"), this.mStatsTab);
        String string = this.getResStringArray("IDS_TREE_GROWING_METHOD_ARRAY")[dialogDataModel.getInteger("IDS_TREE_GROWING_METHOD_COMBOBOX")];
        ISpssVariable iSpssVariable = ((TreeDlg)((Object)this.getParent())).getDependentVariable();
        boolean bl = iSpssVariable != null ? iSpssVariable.getMeasurementLevel().value() != 3 : true;
        boolean bl2 = ((TreeDlg)((Object)this.getParent())).isTargetCategoryDefined();
        boolean bl3 = false;
        Boolean bl4 = dialogDataModel.getBoolean("IDS_TREE_OPT_PROFIT_CUSTOM");
        if (bl4 != null) {
            bl3 = bl4;
        }
        if (string.equals(this.getResString("IDS_TREE_GROWING_METHOD_CRT_ITEM")) || !bl || bl && (bl2 || bl3)) {
            this.mPlotsTab = new TreeOutputPlots(this);
            this.addTab(this.getResString("IDS_TREE_OUTPUT_PLOTS"), this.mPlotsTab);
        }
        this.mRulesTab = new TreeOutputRules(this);
        this.addTab(this.getResString("IDS_TREE_OUTPUT_RULES"), this.mRulesTab);
        this.pack();
    }
}

