/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trees.TableVariable;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormatSymbols;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class TreeOptionsScoresTab
extends BaseProcedureTab
implements ItemListener,
FocusListener {
    static final String BLANK_STRING = "";
    static final int TABLE_HEIGHT = 120;
    static final int TABLE_WIDTH = 400;
    static final int TABLE_ROW = 100;
    static final int TABLE_ROWHEIGHT = 100;
    static final String USE_ORDINAL_RADIO_KEY = "IDS_TREE_OPT_SCR_USE_ORDINAL";
    static final String CUSTOM_RADIO_KEY = "IDS_TREE_OPT_SCR_CUSTOM";
    static final String SCORE_TABLE_KEY = "IDS_TREE_OPTIONS_SCORE_KEY";
    private JRadioButton mUseOrdinalRadio;
    private JRadioButton mCustomRadio;
    private SpssButtonGroup mButtonGroup;
    private JLabel mCategoryLabel;
    private JTable mTable;
    private JScrollPane mScrollPane;
    private JLabel mScoresLabel;
    private boolean mMessageFlag;
    private ISpssVariable mVar;
    protected DecimalFormatSymbols mSymbol;
    private char mDecimalSeparator;

    public TreeOptionsScoresTab(BaseTabbedSubDialog baseTabbedSubDialog, TreeDlg treeDlg, ISpssVariable iSpssVariable) {
        super(baseTabbedSubDialog, true);
        this.mVar = iSpssVariable;
        this.mSymbol = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
        this.mDecimalSeparator = this.mSymbol.getDecimalSeparator();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        TableCellEditor tableCellEditor = this.mTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
            this.mTable.getSelectionModel().clearSelection();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mUseOrdinalRadio || itemEvent.getSource() == this.mCustomRadio) {
            if (this.mUseOrdinalRadio.isSelected()) {
                this.mCategoryLabel.setEnabled(false);
                this.mTable.setEnabled(false);
                this.mScrollPane.getVerticalScrollBar().setEnabled(false);
                this.mScoresLabel.setEnabled(false);
            } else {
                this.mCategoryLabel.setEnabled(true);
                this.mTable.setEnabled(true);
                this.mScrollPane.getVerticalScrollBar().setEnabled(true);
                this.mScoresLabel.setEnabled(true);
            }
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_options_scores";
    }

    @Override
    public boolean validateTab() {
        return this.isValidate();
    }

    public boolean isValidate() {
        boolean bl = true;
        try {
            Vector<String> vector = new Vector<String>();
            if (this.mCustomRadio.isSelected()) {
                for (int i = 0; i < this.mTable.getModel().getRowCount(); ++i) {
                    for (int j = 0; j < this.mTable.getModel().getColumnCount(); ++j) {
                        if (j <= 0) continue;
                        String string = this.mDecimalSeparator != '.' ? this.mTable.getModel().getValueAt(i, j).toString().replace(this.mDecimalSeparator, '.') : this.mTable.getModel().getValueAt(i, j).toString();
                        TableCellEditor tableCellEditor = this.mTable.getCellEditor();
                        if (tableCellEditor != null) {
                            tableCellEditor.stopCellEditing();
                            this.mTable.getSelectionModel().clearSelection();
                            if (this.mMessageFlag) {
                                return false;
                            }
                        }
                        vector.add(string);
                        if (string.equals(BLANK_STRING) || Double.valueOf(string) < 0.0) {
                            if (this.mMessageFlag) {
                                this.changeSelection(i);
                                this.mMessageFlag = false;
                                return false;
                            }
                            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_ENTER_NUMBER_MSG"), VersionInfo.getAppVersionString());
                            this.mMessageFlag = false;
                            this.changeSelection(i);
                            return false;
                        }
                        if (!this.isDuplicateValue(vector)) continue;
                        SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_UNIQUE_MSG"), VersionInfo.getAppVersionString());
                        this.changeSelection(i);
                        return false;
                    }
                }
            }
        }
        catch (Exception exception) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_ENTER_NUMBER_MSG"), VersionInfo.getAppVersionString());
            bl = false;
        }
        return bl;
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        if (this.mUseOrdinalRadio.isSelected()) {
            return this.mUseOrdinalRadio;
        }
        return this.mCustomRadio;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        TreeDlg treeDlg = (TreeDlg)((Object)this.mParent.getParent());
        DialogDataModel dialogDataModel = treeDlg.getDialogDataModel();
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray(SCORE_TABLE_KEY);
        Vector<TableVariable> vector = new Vector<TableVariable>();
        TreeDlg.DependentVarFormatter dependentVarFormatter = treeDlg.getDepVarListFormatter();
        Vector vector2 = (Vector)dependentVarFormatter.getVarMap().get(this.mVar.getId().asInt());
        if (serializableObjectArray != null) {
            int n = serializableObjectArray.length;
            int n2 = vector2.size();
            int n3 = 0;
            if (n2 > n) {
                for (int i = 0; i < n2; ++i) {
                    boolean bl = false;
                    for (int j = 0; j < n; ++j) {
                        if (((TreeDlg.Categories)vector2.get(i)).getObs() != ((TableVariable)serializableObjectArray[j]).getObs()) continue;
                        bl = true;
                        n3 = j;
                        break;
                    }
                    if (bl) {
                        vector.add((TableVariable)serializableObjectArray[n3]);
                        continue;
                    }
                    vector.add(new TableVariable(((TreeDlg.Categories)vector2.get(i)).getLabel(), ((TreeDlg.Categories)vector2.get(i)).getObs()));
                }
                this.mMessageFlag = true;
            } else {
                for (int i = 0; i < n; ++i) {
                    if (n2 == n) {
                        vector.add((TableVariable)serializableObjectArray[i]);
                        continue;
                    }
                    if (n2 >= n) continue;
                    for (int j = 0; j < n2; ++j) {
                        if (((TreeDlg.Categories)vector2.get(j)).getObs() != ((TableVariable)serializableObjectArray[i]).getObs()) continue;
                        vector.add((TableVariable)serializableObjectArray[i]);
                    }
                }
            }
            ((ScoreTableModel)this.mTable.getModel()).setTableData(vector);
        }
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeOptionsScoresTab.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        Vector<TableVariable> vector = ((ScoreTableModel)this.mTable.getModel()).getTableData();
        SerializableObject[] serializableObjectArray = new SerializableObject[vector.size()];
        dialogDataModel.putSerializableArray(SCORE_TABLE_KEY, vector.toArray(serializableObjectArray));
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JComponent[] jComponentArray = new JComponent[]{this.mUseOrdinalRadio, this.mCustomRadio};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, BLANK_STRING);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupTablePanel();
        Insets insets2 = new Insets(0, 3 * insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
    }

    private void changeSelection(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeOptionsScoresTab.this.mTable.changeSelection(n, 1, false, false);
                TreeOptionsScoresTab.this.mTable.editCellAt(n, 1, null);
                TreeOptionsScoresTab.this.mTable.requestFocusInWindow();
            }
        });
    }

    private boolean isDuplicateValue(Vector<String> vector) {
        Object[] objectArray = vector.toArray();
        try {
            for (int i = 0; i <= vector.toArray().length - 1; ++i) {
                for (int j = i + 1; j <= vector.toArray().length - 1; ++j) {
                    if (!Double.valueOf(objectArray[i].toString()).equals(Double.valueOf(objectArray[j].toString()))) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_ENTER_NUMBER_MSG"), VersionInfo.getAppVersionString());
            this.mMessageFlag = true;
            return false;
        }
        return false;
    }

    private void setDefaults() {
        this.mUseOrdinalRadio.setSelected(true);
        this.mCategoryLabel.setEnabled(false);
        this.mTable.setEnabled(false);
        this.mScoresLabel.setEnabled(false);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mButtonGroup);
        vector.add(this.mTable);
        this.setComponentOrder(vector);
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, USE_ORDINAL_RADIO_KEY);
        this.mUseOrdinalRadio = new JRadioButton(toggleButtonAction);
        this.mUseOrdinalRadio.addItemListener(this);
        this.mUseOrdinalRadio.addFocusListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, CUSTOM_RADIO_KEY);
        this.mCustomRadio = new JRadioButton(toggleButtonAction);
        this.mCustomRadio.addItemListener(this);
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mUseOrdinalRadio);
        this.mButtonGroup.add(this.mCustomRadio);
        this.mTable = new JTable();
        this.mTable = new JTable(new ScoreTableModel(this.getTableModel())){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                final Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    if (eventObject == null) {
                        ((JTextComponent)component).selectAll();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)component).selectAll();
                            }
                        });
                    }
                }
                return bl;
            }
        };
        FloatTextField floatTextField = new FloatTextField();
        ColumnCellEditor columnCellEditor = new ColumnCellEditor(floatTextField);
        this.mTable.getColumnModel().getColumn(1).setCellEditor(columnCellEditor);
        this.mTable.addFocusListener(this);
        this.mTable.setDefaultRenderer(Object.class, new ScoresTableRenderer());
        this.mTable.setPreferredScrollableViewportSize(new Dimension(400, 120));
        this.mTable.setGridColor(Color.darkGray);
        this.mTable.setRowHeight(100, 100);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mTable.setColumnSelectionAllowed(true);
        this.mTable.setRowSelectionAllowed(true);
        this.mScrollPane = new JScrollPane(this.mTable);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mTable.getActionMap().put("tabIn", abstractAction2);
        this.mTable.getActionMap().put("tabOut", abstractAction);
        this.mCategoryLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_OPT_SCR_CATEGORY");
        this.mCategoryLabel.setLabelFor(this.mTable);
        this.mScoresLabel = new JLabel(this.getResString("IDS_TREE_OPT_SCORES_LABEL"));
    }

    private JPanel setupTablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCategoryLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mScoresLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private Vector<TableVariable> getTableModel() {
        DialogDataModel dialogDataModel = ((TreeDlg)((Object)((BaseSubDialog)this.mParent).getParent())).getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_TREE_DEPENDENT_VAR_LIST");
        TreeDlg.DependentVarFormatter dependentVarFormatter = ((TreeDlg)((Object)((BaseSubDialog)this.mParent).getParent())).getDepVarListFormatter();
        Vector vector = (Vector)dependentVarFormatter.getVarMap().get(iSpssVariableArray[0].getId().asInt());
        Vector<TableVariable> vector2 = new Vector<TableVariable>();
        for (Object e : vector) {
            TreeDlg.Categories categories = (TreeDlg.Categories)e;
            vector2.add(new TableVariable(categories.getLabel(), categories.getObs()));
        }
        return vector2;
    }

    class ColumnCellEditor
    extends DefaultCellEditor {
        FloatTextField floatTextField;

        public ColumnCellEditor(FloatTextField floatTextField) {
            super((JTextField)floatTextField);
            this.floatTextField = floatTextField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.floatTextField.setText(object.toString());
            return this.floatTextField;
        }
    }

    class ScoresTableRenderer
    extends DefaultTableCellRenderer {
        JLabel mLabel;

        ScoresTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.mLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jTable.getTableHeader().setFont(this.getFont().deriveFont(1));
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (TreeOptionsScoresTab.this.mCustomRadio.isSelected()) {
                if (n2 == 0) {
                    this.setOpaque(true);
                    this.setBorder(UIManager.getBorder("TableCell.cellBorder"));
                    this.setForeground(Color.BLACK);
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(this.getFont().deriveFont(1));
                    this.setHorizontalAlignment(2);
                } else if (n2 == 1) {
                    this.setOpaque(false);
                    this.setForeground(Color.BLACK);
                    this.setHorizontalAlignment(0);
                }
                jTableHeader.setForeground(Color.BLACK);
            } else {
                this.setOpaque(true);
                this.setBorder(UIManager.getBorder("TableCell.cellBorder"));
                this.setForeground(Color.GRAY);
                this.setBackground(jTableHeader.getBackground());
                jTableHeader.setForeground(Color.GRAY);
                this.setFont(this.getFont().deriveFont(1));
                this.setHorizontalAlignment(2);
                if (n2 == 0) {
                    this.setFont(this.getFont().deriveFont(1));
                    this.setHorizontalAlignment(2);
                } else if (n2 == 1) {
                    this.setFont(this.getFont().deriveFont(0));
                    this.setHorizontalAlignment(0);
                }
            }
            return this.mLabel;
        }
    }

    class ScoreTableModel
    extends AbstractTableModel {
        static final int COLUMN_COUNT = 2;
        static final String COLUMN_NAME = " ";
        Vector<TableVariable> data;

        public ScoreTableModel(Vector<TableVariable> vector) {
            this.data = vector;
        }

        public void setTableData(Vector<TableVariable> vector) {
            this.data = vector;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return COLUMN_NAME;
                }
            }
            return TreeOptionsScoresTab.this.getResString("IDS_TREE_OPT_SCORES_VALUE");
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TableVariable tableVariable = this.data.get(n);
            switch (n2) {
                case 0: {
                    return tableVariable.getLabel();
                }
                case 1: {
                    String string = TreeOptionsScoresTab.this.mDecimalSeparator != '.' ? tableVariable.getValue().replace('.', TreeOptionsScoresTab.this.mDecimalSeparator) : tableVariable.getValue();
                    return string;
                }
            }
            return TreeOptionsScoresTab.BLANK_STRING;
        }

        public Vector<TableVariable> getTableData() {
            return this.data;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string = this.getValueAt(n, n2).toString();
            TableVariable tableVariable = this.data.get(n);
            switch (n2) {
                case 1: {
                    if (!object.toString().startsWith("-")) {
                        try {
                            if (object.toString().length() < 1) {
                                tableVariable.setValue(object.toString());
                                break;
                            }
                            Double.valueOf(object.toString());
                            tableVariable.setValue(object.toString());
                        }
                        catch (Exception exception) {
                            TreeOptionsScoresTab.this.mTable.getSelectionModel().clearSelection();
                            tableVariable.setValue(string);
                            SpssAlertOptionPane.showInformationMessageDialog((Window)TreeOptionsScoresTab.this.mParent, TreeOptionsScoresTab.this.getResString("ERR_TREE_ENTER_NUMBER_MSG"), VersionInfo.getAppVersionString());
                            TreeOptionsScoresTab.this.mMessageFlag = true;
                        }
                        break;
                    }
                    SpssAlertOptionPane.showInformationMessageDialog((Window)TreeOptionsScoresTab.this.mParent, TreeOptionsScoresTab.this.getResString("ERR_TREE_ENTER_NUMBER_MSG"), VersionInfo.getAppVersionString());
                    TreeOptionsScoresTab.this.mMessageFlag = true;
                }
            }
        }
    }
}

