/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormatSymbols;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class TreeOptionsProfitsTab
extends BaseProcedureTab
implements ItemListener,
FocusListener,
MouseListener {
    static final String BLANK_STRING = "";
    static final int TABLE_HEIGHT = 100;
    static final int TABLE_WIDTH = 400;
    static final int TABLE_ROW = 100;
    static final int TABLE_ROWHEIGHT = 100;
    static final String CUSTOM_RADIO_KEY = "IDS_TREE_OPT_PROFIT_CUSTOM";
    static final String NONE_RADIO_KEY = "IDS_TREE_OPT_PROFIT_NONE";
    static final String PROFIT_TABLE_KEY = "IDS_TREE_OPTIONS_PROFIT_KEY";
    private JRadioButton mNoneRadio;
    private JRadioButton mCustomRadio;
    private SpssButtonGroup mGroup;
    private JLabel mRevenueLabel;
    private JTable mTable;
    private JScrollPane mScrollPane;
    private JLabel mEnterLabel;
    private boolean mMessageFlag;
    private ISpssVariable mVar;
    protected DecimalFormatSymbols mSymbol;
    private char mDecimalSeparator;

    public TreeOptionsProfitsTab(BaseTabbedSubDialog baseTabbedSubDialog, ISpssVariable iSpssVariable) {
        super(baseTabbedSubDialog, true);
        this.mVar = iSpssVariable;
        this.mSymbol = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
        this.mDecimalSeparator = this.mSymbol.getDecimalSeparator();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_options_profits";
    }

    @Override
    public boolean validateTab() {
        return this.isValidate();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mNoneRadio)) {
            TableCellEditor tableCellEditor = this.mTable.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            this.mTable.getSelectionModel().clearSelection();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.mTable)) {
            TableCellEditor tableCellEditor = this.mTable.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            this.mTable.getSelectionModel().clearSelection();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mNoneRadio || itemEvent.getSource() == this.mCustomRadio) {
            if (this.mNoneRadio.isSelected()) {
                this.mRevenueLabel.setEnabled(false);
                this.mTable.setEnabled(false);
                this.mScrollPane.getVerticalScrollBar().setEnabled(false);
            } else {
                this.mRevenueLabel.setEnabled(true);
                this.mTable.setEnabled(true);
                this.mScrollPane.getVerticalScrollBar().setEnabled(true);
            }
        }
    }

    public boolean isValidate() {
        boolean bl = true;
        try {
            if (this.mCustomRadio.isSelected()) {
                for (int i = 0; i < this.mTable.getModel().getRowCount(); ++i) {
                    for (int j = 0; j < this.mTable.getModel().getColumnCount(); ++j) {
                        if (j <= 0 || j >= 3) continue;
                        TableCellEditor tableCellEditor = this.mTable.getCellEditor();
                        if (tableCellEditor != null) {
                            tableCellEditor.stopCellEditing();
                            this.mTable.getSelectionModel().clearSelection();
                        }
                        if (!this.mTable.getModel().getValueAt(i, j).toString().equals(BLANK_STRING)) continue;
                        if (this.mMessageFlag) {
                            this.mMessageFlag = false;
                            return false;
                        }
                        SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_ENTER_NUMBER_MSG"), VersionInfo.getAppVersionString());
                        this.changeSelection(i, j);
                        this.mMessageFlag = false;
                        return false;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_ENTER_NUMBER_MSG"), VersionInfo.getAppVersionString());
            bl = false;
        }
        return bl;
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        if (this.mNoneRadio.isSelected()) {
            return this.mNoneRadio;
        }
        return this.mCustomRadio;
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        Vector<RevExpVal> vector = ((ProfitsTableModel)this.mTable.getModel()).getTableData();
        SerializableObject[] serializableObjectArray = new SerializableObject[vector.size()];
        dialogDataModel.putSerializableArray(PROFIT_TABLE_KEY, vector.toArray(serializableObjectArray));
        super.saveTabState(dialogDataModel);
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        TreeDlg treeDlg = (TreeDlg)((Object)this.mParent.getParent());
        DialogDataModel dialogDataModel = treeDlg.getDialogDataModel();
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray(PROFIT_TABLE_KEY);
        Vector<RevExpVal> vector = new Vector<RevExpVal>();
        TreeDlg.DependentVarFormatter dependentVarFormatter = treeDlg.getDepVarListFormatter();
        Vector vector2 = (Vector)dependentVarFormatter.getVarMap().get(this.mVar.getId().asInt());
        if (serializableObjectArray != null) {
            int n = serializableObjectArray.length;
            int n2 = vector2.size();
            int n3 = 0;
            if (n2 > n) {
                for (int i = 0; i < n2; ++i) {
                    boolean bl = false;
                    for (int j = 0; j < n; ++j) {
                        if (!((TreeDlg.Categories)vector2.get(i)).getLabel().equals(((RevExpVal)serializableObjectArray[j]).getLabel())) continue;
                        bl = true;
                        n3 = j;
                        break;
                    }
                    if (bl) {
                        try {
                            vector.add((RevExpVal)((RevExpVal)serializableObjectArray[n3]).clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                        continue;
                    }
                    vector.add(new RevExpVal(((TreeDlg.Categories)vector2.get(i)).getLabel(), ((TreeDlg.Categories)vector2.get(i)).getObs()));
                }
                this.mMessageFlag = true;
            } else {
                for (int i = 0; i < n; ++i) {
                    if (n2 == n) {
                        try {
                            vector.add((RevExpVal)((RevExpVal)serializableObjectArray[i]).clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                        continue;
                    }
                    if (n2 >= n) continue;
                    for (int j = 0; j < n2; ++j) {
                        if (!((TreeDlg.Categories)vector2.get(j)).getLabel().equals(((RevExpVal)serializableObjectArray[i]).getLabel())) continue;
                        try {
                            vector.add((RevExpVal)((RevExpVal)serializableObjectArray[i]).clone());
                            continue;
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            // empty catch block
                        }
                    }
                }
            }
            ((ProfitsTableModel)this.mTable.getModel()).setTableData(vector);
        }
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeOptionsProfitsTab.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JComponent[] jComponentArray = new JComponent[]{this.mNoneRadio, this.mCustomRadio};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, BLANK_STRING);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupTablePanel();
        Insets insets2 = new Insets(0, 2 * insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
    }

    private void changeSelection(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeOptionsProfitsTab.this.mTable.changeSelection(n, n2, false, false);
                TreeOptionsProfitsTab.this.mTable.editCellAt(n, n2, null);
                TreeOptionsProfitsTab.this.mTable.requestFocusInWindow();
            }
        });
    }

    private void setDefaults() {
        this.mNoneRadio.setSelected(true);
        this.mRevenueLabel.setEnabled(false);
        this.mTable.setEnabled(false);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mGroup);
        vector.add(this.mTable);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (component instanceof JButton) {
                vector.add(component);
            }
            this.setComponentOrder(vector);
        }
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, NONE_RADIO_KEY);
        this.mNoneRadio = new JRadioButton(toggleButtonAction);
        this.mNoneRadio.addItemListener(this);
        this.mNoneRadio.addFocusListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, CUSTOM_RADIO_KEY);
        this.mCustomRadio = new JRadioButton(toggleButtonAction);
        this.mCustomRadio.addItemListener(this);
        this.mGroup = new SpssButtonGroup();
        this.mGroup.add(this.mNoneRadio);
        this.mGroup.add(this.mCustomRadio);
        this.mTable = new JTable(new ProfitsTableModel(this.getTableModel())){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                final Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    if (eventObject == null) {
                        ((JTextComponent)component).selectAll();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)component).selectAll();
                            }
                        });
                    }
                }
                return bl;
            }
        };
        FloatTextField floatTextField = new FloatTextField();
        ColumnCellEditor columnCellEditor = new ColumnCellEditor(floatTextField);
        this.mTable.getColumnModel().getColumn(0).setCellEditor(columnCellEditor);
        this.mTable.getColumnModel().getColumn(1).setCellEditor(columnCellEditor);
        this.mTable.getColumnModel().getColumn(2).setCellEditor(columnCellEditor);
        this.mTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        this.mTable.setRowHeight(100, 100);
        this.mScrollPane = new JScrollPane(this.mTable);
        this.mTable.setDefaultRenderer(Object.class, new ProfitTableRenderer());
        this.mTable.getTableHeader().setResizingAllowed(false);
        this.mTable.addMouseListener(this);
        this.mTable.setGridColor(Color.darkGray);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mTable.getActionMap().put("tabIn", abstractAction2);
        this.mTable.getActionMap().put("tabOut", abstractAction);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mRevenueLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_OPT_MIS_REVENUE");
        this.mRevenueLabel.setLabelFor(this.mTable);
        this.mEnterLabel = new JLabel(this.getResString("IDS_TREE_OPT_PROFIT_ENTER"));
    }

    private Vector<RevExpVal> getTableModel() {
        DialogDataModel dialogDataModel = ((TreeDlg)((Object)((BaseSubDialog)this.mParent).getParent())).getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_TREE_DEPENDENT_VAR_LIST");
        TreeDlg.DependentVarFormatter dependentVarFormatter = ((TreeDlg)((Object)((BaseSubDialog)this.mParent).getParent())).getDepVarListFormatter();
        Vector vector = (Vector)dependentVarFormatter.getVarMap().get(iSpssVariableArray[0].getId().asInt());
        Vector<RevExpVal> vector2 = new Vector<RevExpVal>();
        for (Object e : vector) {
            try {
                TreeDlg.Categories categories = ((TreeDlg.Categories)e).clone();
                vector2.add(new RevExpVal(categories.getLabel(), categories.getObs()));
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        return vector2;
    }

    private JPanel setupTablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRevenueLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mEnterLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    class ColumnCellEditor
    extends DefaultCellEditor {
        FloatTextField floatTextField;

        public ColumnCellEditor(FloatTextField floatTextField) {
            super((JTextField)floatTextField);
            this.floatTextField = floatTextField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.floatTextField.setText(object.toString());
            return this.floatTextField;
        }
    }

    class ProfitTableRenderer
    extends DefaultTableCellRenderer {
        JLabel mLabel;

        ProfitTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.mLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jTable.getTableHeader().setFont(this.getFont().deriveFont(1));
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (TreeOptionsProfitsTab.this.mCustomRadio.isSelected()) {
                jTableHeader.setForeground(Color.BLACK);
                if (n2 == 0) {
                    this.setOpaque(true);
                    this.setBorder(UIManager.getBorder("TableCell.cellBorder"));
                    this.setForeground(Color.BLACK);
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(this.getFont().deriveFont(1));
                    this.setHorizontalAlignment(2);
                } else if (n2 == 1) {
                    this.setOpaque(false);
                    this.setForeground(Color.BLACK);
                    this.setHorizontalAlignment(0);
                } else if (n2 == 2) {
                    this.setOpaque(false);
                    this.setForeground(Color.BLACK);
                    this.setHorizontalAlignment(0);
                } else {
                    this.setOpaque(true);
                    this.setBorder(UIManager.getBorder("TableCell.cellBorder"));
                    this.setForeground(Color.BLACK);
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(this.getFont().deriveFont(0));
                    this.setHorizontalAlignment(0);
                }
            } else if (n2 == 0) {
                this.setOpaque(true);
                this.setBorder(UIManager.getBorder("TableCell.cellBorder"));
                this.setForeground(Color.GRAY);
                this.setBackground(jTableHeader.getBackground());
                jTableHeader.setForeground(Color.GRAY);
                this.setFont(this.getFont().deriveFont(1));
                this.setHorizontalAlignment(2);
            } else {
                this.setOpaque(false);
                this.setHorizontalAlignment(0);
                this.setOpaque(true);
                this.setBorder(UIManager.getBorder("TableCell.cellBorder"));
                this.setForeground(Color.GRAY);
                this.setBackground(jTableHeader.getBackground());
                jTableHeader.setForeground(Color.GRAY);
                this.setFont(this.getFont().deriveFont(0));
            }
            return this.mLabel;
        }
    }

    class ProfitsTableModel
    extends AbstractTableModel {
        static final int COLUMN_COUNT = 4;
        static final String COLUMN_NAME = " ";
        Vector<RevExpVal> data;

        public ProfitsTableModel(Vector<RevExpVal> vector) {
            this.data = vector;
        }

        public Vector<RevExpVal> getTableData() {
            return this.data;
        }

        public void setTableData(Vector<RevExpVal> vector) {
            this.data = vector;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return COLUMN_NAME;
                }
                case 1: {
                    return TreeOptionsProfitsTab.this.getResString("IDS_TREE_OPT_PROFIT_REVENUE");
                }
                case 2: {
                    return TreeOptionsProfitsTab.this.getResString("IDS_TREE_OPT_PROFIT_EXPENSE");
                }
                case 3: {
                    return TreeOptionsProfitsTab.this.getResString("IDS_TREE_OPT_PROFIT");
                }
            }
            return COLUMN_NAME;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            RevExpVal revExpVal = this.data.get(n);
            switch (n2) {
                case 0: {
                    return revExpVal.getLabel();
                }
                case 1: {
                    String string = TreeOptionsProfitsTab.this.mDecimalSeparator != '.' ? revExpVal.getRevenue().replace('.', TreeOptionsProfitsTab.this.mDecimalSeparator) : revExpVal.getRevenue();
                    return string;
                }
                case 2: {
                    String string = TreeOptionsProfitsTab.this.mDecimalSeparator != '.' ? revExpVal.getExpense().replace('.', TreeOptionsProfitsTab.this.mDecimalSeparator) : revExpVal.getExpense();
                    return string;
                }
                case 3: {
                    if (revExpVal.getRevenue().equals(TreeOptionsProfitsTab.BLANK_STRING) || revExpVal.getExpense().equals(TreeOptionsProfitsTab.BLANK_STRING)) {
                        return TreeOptionsProfitsTab.BLANK_STRING;
                    }
                    Double d = Double.valueOf(revExpVal.getRevenue()) - Double.valueOf(revExpVal.getExpense());
                    String string = TreeOptionsProfitsTab.this.mDecimalSeparator != '.' ? String.valueOf(d).replace('.', TreeOptionsProfitsTab.this.mDecimalSeparator) : String.valueOf(d);
                    return string;
                }
            }
            return TreeOptionsProfitsTab.BLANK_STRING;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 || n2 == 2;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string = this.getValueAt(n, n2).toString();
            RevExpVal revExpVal = this.data.get(n);
            switch (n2) {
                case 1: {
                    try {
                        if (object.toString().length() < 1) {
                            revExpVal.setRevenue(object.toString());
                            break;
                        }
                        Double.valueOf(object.toString());
                        revExpVal.setRevenue(object.toString());
                    }
                    catch (Exception exception) {
                        revExpVal.setRevenue(string);
                        SpssAlertOptionPane.showInformationMessageDialog((Window)TreeOptionsProfitsTab.this.mParent, TreeOptionsProfitsTab.this.getResString("ERR_TREE_ENTER_NUMBER_MSG"), VersionInfo.getAppVersionString());
                        TreeOptionsProfitsTab.this.mTable.setEditingColumn(n2);
                        TreeOptionsProfitsTab.this.mTable.setEditingRow(n);
                        TreeOptionsProfitsTab.this.mMessageFlag = true;
                    }
                    break;
                }
                case 2: {
                    try {
                        if (object.toString().length() < 1) {
                            revExpVal.setExpense(object.toString());
                            break;
                        }
                        Double.valueOf(object.toString());
                        revExpVal.setExpense(object.toString());
                        break;
                    }
                    catch (Exception exception) {
                        revExpVal.setExpense(string);
                        SpssAlertOptionPane.showInformationMessageDialog((Window)TreeOptionsProfitsTab.this.mParent, TreeOptionsProfitsTab.this.getResString("ERR_TREE_ENTER_NUMBER_MSG"), VersionInfo.getAppVersionString());
                        TreeOptionsProfitsTab.this.mTable.setEditingColumn(n2);
                        TreeOptionsProfitsTab.this.mTable.setEditingRow(n);
                        TreeOptionsProfitsTab.this.mMessageFlag = true;
                    }
                }
            }
        }
    }

    public static class RevExpVal
    implements SerializableObject {
        String label = "";
        OBS obs;
        String revenue = "";
        String expense = "";

        public RevExpVal() {
            this.label = TreeOptionsProfitsTab.BLANK_STRING;
            this.expense = TreeOptionsProfitsTab.BLANK_STRING;
            this.revenue = TreeOptionsProfitsTab.BLANK_STRING;
            this.obs = new OBS();
        }

        public RevExpVal(String string, OBS oBS) {
            this.label = string;
            this.obs = oBS;
        }

        public String getExpense() {
            return this.expense;
        }

        public void setExpense(String string) {
            this.expense = string;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String string) {
            this.label = string;
        }

        public String getRevenue() {
            return this.revenue;
        }

        public void setRevenue(String string) {
            this.revenue = string;
        }

        public OBS getOBS() {
            return this.obs;
        }

        protected Object clone() throws CloneNotSupportedException {
            RevExpVal revExpVal = new RevExpVal(this.label, (OBS)this.obs.clone());
            revExpVal.setExpense(this.expense);
            revExpVal.setRevenue(this.revenue);
            return revExpVal;
        }

        public String getClassName() {
            return "com.spss.java_client.ui.dialogs.trees.TreeOptionsProfitsTab$RevExpVal";
        }

        public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
            this.label = objectInputStream.readUTF();
            this.revenue = objectInputStream.readUTF();
            this.expense = objectInputStream.readUTF();
            this.obs = DocUtil.readObs(objectInputStream);
            if (this.obs == null) {
                this.obs = new OBS();
                return false;
            }
            return true;
        }

        public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
            objectOutputStream.writeUTF(this.label);
            objectOutputStream.writeUTF(this.revenue);
            objectOutputStream.writeUTF(this.expense);
            return DocUtil.writeObs(objectOutputStream, this.obs);
        }
    }
}

