/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trees.TableVariable;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class TreeOptionsPriorProbabilitiesTab
extends BaseProcedureTab
implements ItemListener,
FocusListener {
    static final int NUMBER_OF_COLUMNS = 25;
    static final int TABLE_HEIGHT = 100;
    static final int TABLE_WIDTH = 400;
    static final int TABLE_ROW = 100;
    static final int TABLE_ROWHEIGHT = 100;
    static final String SUM_OF_VALUES_TEXT = "IDS_TREE_OPT_PP_SUM";
    static final String OBTAIN_RADIO_KEY = "IDS_TREE_OPT_PP_OBTAIN";
    static final String EQUAL_RADIO_KEY = "IDS_TREE_OPT_PP_EQUAL";
    static final String CUSTOM_RADIO_KEY = "IDS_TREE_OPT_PP_CUSTOM";
    static final String ADJUST_CHECK = "IDS_TREE_OPT_PP_ADJUST";
    static final String PRIOR_PROBABILITY_TABLE_KEY = "IDS_TREE_PRIOR_PROB_TABLE_KEY";
    private JRadioButton mObtainRadio;
    private JRadioButton mEqualRadio;
    private JRadioButton mCustomRadio;
    private JCheckBox mAdjustCheck;
    private SpssButtonGroup mGroup;
    private JTable mTable;
    private JScrollPane mScrollPane;
    private JLabel mPriorsLabel;
    private JLabel mSumOfValues;
    private JLabel mValues;
    private boolean mMessageFlag;
    private FloatTextField mSum;
    private ISpssVariable mVar;
    protected DecimalFormatSymbols mSymbol;
    private char mDecimalSeparator;

    public TreeOptionsPriorProbabilitiesTab(BaseTabbedSubDialog baseTabbedSubDialog, ISpssVariable iSpssVariable) {
        super(baseTabbedSubDialog, true);
        this.mVar = iSpssVariable;
        this.mSymbol = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
        this.mDecimalSeparator = this.mSymbol.getDecimalSeparator();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mObtainRadio || itemEvent.getSource() == this.mEqualRadio || itemEvent.getSource() == this.mCustomRadio) {
            if (this.mCustomRadio.isSelected()) {
                this.mPriorsLabel.setEnabled(true);
                this.mTable.setEnabled(true);
                this.mScrollPane.getVerticalScrollBar().setEnabled(true);
                this.mSumOfValues.setEnabled(true);
                this.mSum.setEnabled(true);
                this.mValues.setEnabled(true);
            } else {
                this.mPriorsLabel.setEnabled(false);
                this.mTable.setEnabled(false);
                this.mScrollPane.getVerticalScrollBar().setEnabled(false);
                this.mSumOfValues.setEnabled(false);
                this.mSum.setEnabled(false);
                this.mValues.setEnabled(false);
            }
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_options_priors";
    }

    @Override
    public boolean validateTab() {
        return this.isValidate();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        TableCellEditor tableCellEditor = this.mTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
            this.mTable.getSelectionModel().clearSelection();
        }
        this.mSum.setText("");
        this.mSum.setText(this.getSumOfValues());
    }

    public boolean isValidate() {
        boolean bl = true;
        try {
            if (this.mCustomRadio.isSelected()) {
                for (int i = 0; i < this.mTable.getModel().getRowCount(); ++i) {
                    for (int j = 0; j < this.mTable.getModel().getColumnCount(); ++j) {
                        if (j != 1) continue;
                        String string = this.mDecimalSeparator != '.' ? this.mTable.getModel().getValueAt(i, j).toString().replace(this.mDecimalSeparator, '.') : this.mTable.getModel().getValueAt(i, j).toString();
                        TableCellEditor tableCellEditor = this.mTable.getCellEditor();
                        if (tableCellEditor != null) {
                            tableCellEditor.stopCellEditing();
                            this.mTable.getSelectionModel().clearSelection();
                        }
                        if (this.mTable.getModel().getValueAt(i, j).toString().equals("")) {
                            if (this.mMessageFlag) {
                                this.changeSelection(i);
                                this.mMessageFlag = false;
                                return false;
                            }
                            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_ENTER_NUMBER_MSG"), VersionInfo.getAppVersionString());
                            this.changeSelection(i);
                            this.mMessageFlag = false;
                            return false;
                        }
                        if (!(Double.valueOf(string) < 0.0)) continue;
                        SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_NON_NEGATE_MSG"), VersionInfo.getAppVersionString());
                        this.changeSelection(i);
                        return false;
                    }
                }
            }
            this.mSum.setText("");
            this.mSum.setText(this.getSumOfValues());
        }
        catch (Exception exception) {
            this.mSum.setText("");
            this.mSum.setText(this.getSumOfValues());
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_NON_NEGATE_MSG"), VersionInfo.getAppVersionString());
            bl = false;
        }
        return bl;
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        if (this.mObtainRadio.isSelected()) {
            return this.mObtainRadio;
        }
        if (this.mEqualRadio.isSelected()) {
            return this.mEqualRadio;
        }
        return this.mCustomRadio;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        TreeDlg treeDlg = (TreeDlg)((Object)this.mParent.getParent());
        DialogDataModel dialogDataModel = treeDlg.getDialogDataModel();
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray(PRIOR_PROBABILITY_TABLE_KEY);
        Vector<TableVariable> vector = new Vector<TableVariable>();
        TreeDlg.DependentVarFormatter dependentVarFormatter = treeDlg.getDepVarListFormatter();
        Vector vector2 = (Vector)dependentVarFormatter.getVarMap().get(this.mVar.getId().asInt());
        if (serializableObjectArray != null) {
            int n = serializableObjectArray.length;
            int n2 = vector2.size();
            int n3 = 0;
            if (n2 > n) {
                for (int i = 0; i < n2; ++i) {
                    boolean bl = false;
                    for (int j = 0; j < n; ++j) {
                        if (((TreeDlg.Categories)vector2.get(i)).getObs() != ((TableVariable)serializableObjectArray[j]).getObs()) continue;
                        bl = true;
                        n3 = j;
                        break;
                    }
                    if (bl) {
                        vector.add((TableVariable)serializableObjectArray[n3]);
                        continue;
                    }
                    vector.add(new TableVariable(((TreeDlg.Categories)vector2.get(i)).getLabel(), ((TreeDlg.Categories)vector2.get(i)).getObs()));
                }
                this.mMessageFlag = true;
            } else {
                for (int i = 0; i < n; ++i) {
                    if (n2 == n) {
                        vector.add((TableVariable)serializableObjectArray[i]);
                        continue;
                    }
                    if (n2 >= n) continue;
                    for (int j = 0; j < n2; ++j) {
                        if (((TreeDlg.Categories)vector2.get(j)).getObs() != ((TableVariable)serializableObjectArray[i]).getObs()) continue;
                        vector.add((TableVariable)serializableObjectArray[i]);
                    }
                }
            }
            ((TableModel)this.mTable.getModel()).setTableData(vector);
        }
        this.mSum.setText("");
        this.mSum.setText(this.getSumOfValues());
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeOptionsPriorProbabilitiesTab.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        Vector<TableVariable> vector = ((TableModel)this.mTable.getModel()).getTableData();
        SerializableObject[] serializableObjectArray = new SerializableObject[vector.size()];
        dialogDataModel.putSerializableArray(PRIOR_PROBABILITY_TABLE_KEY, vector.toArray(serializableObjectArray));
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardDialogInsets();
        JComponent[] jComponentArray = new JComponent[]{this.mObtainRadio, this.mEqualRadio, this.mCustomRadio};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, "");
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupTablePanel();
        Insets insets2 = new Insets(0, 3 * insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        insets2.set(insets.top, 2 * insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(this, this.mAdjustCheck, gridBagConstraints, 0, 2, 1, 1, n, insets2);
    }

    private JPanel setupTablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPriorsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 1, 3, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSumOfValues, gridBagConstraints, 0, 2, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top, 0, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSum, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        n = 24;
        DialogUtil.addUsingGBL(jPanel, this.mValues, gridBagConstraints, 2, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void setDefaults() {
        this.mObtainRadio.setSelected(true);
        this.mPriorsLabel.setEnabled(false);
        this.mTable.setEnabled(false);
        this.mSumOfValues.setEnabled(false);
        this.mSum.setEnabled(false);
        this.mValues.setEnabled(false);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mGroup);
        vector.add(this.mTable);
        vector.add(this.mAdjustCheck);
        this.setComponentOrder(vector);
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, OBTAIN_RADIO_KEY);
        this.mObtainRadio = new JRadioButton(toggleButtonAction);
        this.mObtainRadio.addItemListener(this);
        this.mObtainRadio.addFocusListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, EQUAL_RADIO_KEY);
        this.mEqualRadio = new JRadioButton(toggleButtonAction);
        this.mEqualRadio.addItemListener(this);
        this.mEqualRadio.addFocusListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, CUSTOM_RADIO_KEY);
        this.mCustomRadio = new JRadioButton(toggleButtonAction);
        this.mCustomRadio.addItemListener(this);
        this.mGroup = new SpssButtonGroup();
        this.mGroup.add(this.mObtainRadio);
        this.mGroup.add(this.mEqualRadio);
        this.mGroup.add(this.mCustomRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParent, ADJUST_CHECK);
        this.mAdjustCheck = new JCheckBox(toggleButtonAction);
        FloatTextField floatTextField = new FloatTextField();
        ColumnCellEditor columnCellEditor = new ColumnCellEditor(floatTextField);
        this.mTable = new JTable(new TableModel(this.getTableModel())){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                final Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    if (eventObject == null) {
                        ((JTextComponent)component).selectAll();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)component).selectAll();
                            }
                        });
                    }
                }
                return bl;
            }
        };
        this.mTable.setDefaultRenderer(Object.class, new PriorProbTableRenderer());
        this.mTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        this.mTable.setGridColor(Color.darkGray);
        this.mTable.setRowHeight(100, 100);
        this.mTable.getColumnModel().getColumn(1).setCellEditor(columnCellEditor);
        this.mTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mTable.getActionMap().put("tabIn", abstractAction2);
        this.mTable.getActionMap().put("tabOut", abstractAction);
        this.mScrollPane = new JScrollPane(this.mTable);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mPriorsLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_OPT_PPT_PRIORS");
        this.mPriorsLabel.setLabelFor(this.mTable);
        this.mSumOfValues = new JLabel(this.getResString("IDS_TREE_OPT_PPT_SUM"));
        this.mValues = new JLabel(this.getResString("IDS_TREE_OPT_PPT_VALUES"));
        this.mSum = new FloatTextField();
        this.mSum.setAction((Action)new TextFieldAction(this.mParent, SUM_OF_VALUES_TEXT));
        this.mSum.setBorder(null);
        this.mSum.setColumns(25);
        this.mSum.setEditable(false);
        this.mSum.setOpaque(false);
    }

    private String getSumOfValues() {
        double d = 0.0;
        for (int i = 0; i < this.mTable.getModel().getRowCount(); ++i) {
            for (int j = 0; j < this.mTable.getModel().getColumnCount(); ++j) {
                if (j != 1 || this.mTable.getModel().getValueAt(i, j).toString().equals("")) continue;
                String string = this.mDecimalSeparator != '.' ? this.mTable.getModel().getValueAt(i, j).toString().replace(this.mDecimalSeparator, '.') : this.mTable.getModel().getValueAt(i, j).toString();
                d += Double.valueOf(string).doubleValue();
            }
        }
        BigDecimal bigDecimal = new BigDecimal(d);
        return bigDecimal.toString();
    }

    private void changeSelection(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeOptionsPriorProbabilitiesTab.this.mTable.changeSelection(n, 1, false, false);
                TreeOptionsPriorProbabilitiesTab.this.mTable.editCellAt(n, 1, null);
                TreeOptionsPriorProbabilitiesTab.this.mTable.requestFocusInWindow();
            }
        });
    }

    private Vector<TableVariable> getTableModel() {
        DialogDataModel dialogDataModel = ((TreeDlg)((Object)((BaseSubDialog)this.mParent).getParent())).getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_TREE_DEPENDENT_VAR_LIST");
        TreeDlg.DependentVarFormatter dependentVarFormatter = ((TreeDlg)((Object)((BaseSubDialog)this.mParent).getParent())).getDepVarListFormatter();
        Vector vector = (Vector)dependentVarFormatter.getVarMap().get(iSpssVariableArray[0].getId().asInt());
        Vector<TableVariable> vector2 = new Vector<TableVariable>();
        for (Object e : vector) {
            TreeDlg.Categories categories = (TreeDlg.Categories)e;
            vector2.add(new TableVariable(categories.getLabel(), categories.getObs()));
        }
        return vector2;
    }

    class PriorProbTableRenderer
    extends DefaultTableCellRenderer {
        JLabel label;

        PriorProbTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.label = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jTable.getTableHeader().setFont(this.getFont().deriveFont(1));
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (TreeOptionsPriorProbabilitiesTab.this.mCustomRadio.isSelected()) {
                if (n2 == 0) {
                    this.setOpaque(true);
                    this.setBorder(UIManager.getBorder("TableCell.cellBorder"));
                    jTableHeader.setForeground(Color.BLACK);
                    this.setForeground(Color.BLACK);
                    this.setForeground(jTableHeader.getForeground());
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(this.getFont().deriveFont(1));
                    this.setHorizontalAlignment(2);
                } else if (n2 == 1) {
                    this.setOpaque(false);
                    jTableHeader.setForeground(Color.BLACK);
                    this.setForeground(Color.BLACK);
                    this.setHorizontalAlignment(0);
                }
            } else {
                this.setOpaque(true);
                this.setBorder(UIManager.getBorder("TableCell.cellBorder"));
                this.setForeground(Color.GRAY);
                this.setBackground(jTableHeader.getBackground());
                jTableHeader.setForeground(Color.GRAY);
                if (n2 == 0) {
                    this.setFont(this.getFont().deriveFont(1));
                    this.setHorizontalAlignment(2);
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                    this.setHorizontalAlignment(0);
                }
            }
            return this.label;
        }
    }

    class TableModel
    extends AbstractTableModel {
        static final int COLUMN_COUNT = 2;
        static final String COLUMN_ONE_NAME = " ";
        static final String BLANK_STRING = "";
        Vector<TableVariable> data;

        public TableModel(Vector<TableVariable> vector) {
            this.data = vector;
        }

        public Vector<TableVariable> getTableData() {
            return this.data;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        public void setTableData(Vector<TableVariable> vector) {
            this.data = vector;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return COLUMN_ONE_NAME;
                }
            }
            return TreeOptionsPriorProbabilitiesTab.this.getResString("IDS_TREE_OPT_SCORES_VALUE");
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 1) {
                return FloatTextField.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TableVariable tableVariable = this.data.get(n);
            switch (n2) {
                case 0: {
                    return tableVariable.getLabel();
                }
                case 1: {
                    String string = TreeOptionsPriorProbabilitiesTab.this.mDecimalSeparator != '.' ? tableVariable.getValue().replace('.', TreeOptionsPriorProbabilitiesTab.this.mDecimalSeparator) : tableVariable.getValue();
                    return string;
                }
            }
            return BLANK_STRING;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string = this.getValueAt(n, n2).toString();
            TableVariable tableVariable = this.data.get(n);
            switch (n2) {
                case 1: {
                    if (!object.toString().startsWith("-")) {
                        try {
                            if (object.toString().length() < 1) {
                                tableVariable.setValue(object.toString());
                                TreeOptionsPriorProbabilitiesTab.this.mSum.setText(BLANK_STRING);
                                TreeOptionsPriorProbabilitiesTab.this.mSum.setText(TreeOptionsPriorProbabilitiesTab.this.getSumOfValues());
                                break;
                            }
                            Double.valueOf(object.toString());
                            tableVariable.setValue(object.toString());
                            String string2 = "12345678";
                            TreeOptionsPriorProbabilitiesTab.this.mSum.setText(TreeOptionsPriorProbabilitiesTab.this.getSumOfValues());
                        }
                        catch (Exception exception) {
                            TreeOptionsPriorProbabilitiesTab.this.mTable.getSelectionModel().clearSelection();
                            tableVariable.setValue(string);
                            TreeOptionsPriorProbabilitiesTab.this.mSum.setText(BLANK_STRING);
                            TreeOptionsPriorProbabilitiesTab.this.mSum.setText(TreeOptionsPriorProbabilitiesTab.this.getSumOfValues());
                            SpssAlertOptionPane.showInformationMessageDialog((Window)TreeOptionsPriorProbabilitiesTab.this.mParent, TreeOptionsPriorProbabilitiesTab.this.getResString("ERR_TREE_NON_NEGATE_MSG"), VersionInfo.getAppVersionString());
                            TreeOptionsPriorProbabilitiesTab.this.mMessageFlag = true;
                        }
                        break;
                    }
                    tableVariable.setValue(string);
                    TreeOptionsPriorProbabilitiesTab.this.mSum.setText(BLANK_STRING);
                    TreeOptionsPriorProbabilitiesTab.this.mSum.setText(TreeOptionsPriorProbabilitiesTab.this.getSumOfValues());
                    SpssAlertOptionPane.showInformationMessageDialog((Window)TreeOptionsPriorProbabilitiesTab.this.mParent, TreeOptionsPriorProbabilitiesTab.this.getResString("ERR_TREE_NON_NEGATE_MSG"), VersionInfo.getAppVersionString());
                    TreeOptionsPriorProbabilitiesTab.this.mMessageFlag = true;
                }
            }
        }
    }

    class ColumnCellEditor
    extends DefaultCellEditor {
        FloatTextField floatTextField;

        public ColumnCellEditor(FloatTextField floatTextField) {
            super((JTextField)floatTextField);
            this.floatTextField = floatTextField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.floatTextField.setText(object.toString());
            return this.floatTextField;
        }
    }
}

