/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trees.TreeOptions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class TreeOptionsMissingValuesTab
extends BaseProcedureTab {
    static final String TREAT_AS_MISSING_KEY = "IDS_TREE_OPT_TREAT_AS_MISSING";
    static final String TREAT_AS_VALID_KEY = "IDS_TREE_OPT_TREAT_AS_VALID";
    private JRadioButton mTreatAsMissingRadio;
    private JRadioButton mTreatAsValidRadio;
    private SpssButtonGroup mGroup;

    public TreeOptionsMissingValuesTab(BaseTabbedSubDialog baseTabbedSubDialog) {
        super(baseTabbedSubDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_options_missing";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        if (this.mTreatAsMissingRadio.isSelected()) {
            return this.mTreatAsMissingRadio;
        }
        return this.mTreatAsValidRadio;
    }

    @Override
    protected void aboutToShowTab() {
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeOptionsMissingValuesTab.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardDialogInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JComponent[] jComponentArray = new JComponent[]{this.mTreatAsMissingRadio, this.mTreatAsValidRadio};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_TREE_OPT_USER_MISSING_TITLE"));
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupAreaPanel();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(insets.top, 2 * n2, insets.bottom, 2 * n2);
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
    }

    private void setDefaults() {
        this.mTreatAsMissingRadio.setSelected(true);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mGroup);
        JPanel jPanel = ((TreeOptions)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (component instanceof JButton) {
                vector.add(component);
            }
            this.setComponentOrder(vector);
        }
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, TREAT_AS_MISSING_KEY);
        this.mTreatAsMissingRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, TREAT_AS_VALID_KEY);
        this.mTreatAsValidRadio = new JRadioButton(toggleButtonAction);
        this.mGroup = new SpssButtonGroup();
        this.mGroup.add(this.mTreatAsMissingRadio);
        this.mGroup.add(this.mTreatAsValidRadio);
    }

    private JPanel setupAreaPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_TREE_OPT_TREATMENT"));
        jTextArea.setRows(10);
        jTextArea.setFont(this.mTreatAsMissingRadio.getFont());
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setMinimumSize(new Dimension(350, 150));
        jTextArea.setPreferredSize(new Dimension(350, 150));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel;
    }
}

