/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListModel;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SpssVarFormatter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertDialog;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.trees.TableVariable;
import com.spss.java_client.ui.dialogs.trees.TreeCategories;
import com.spss.java_client.ui.dialogs.trees.TreeCriteria;
import com.spss.java_client.ui.dialogs.trees.TreeCriteriaIntervalsTab;
import com.spss.java_client.ui.dialogs.trees.TreeOptions;
import com.spss.java_client.ui.dialogs.trees.TreeOptionsMisclassificationCostsTab;
import com.spss.java_client.ui.dialogs.trees.TreeOptionsProfitsTab;
import com.spss.java_client.ui.dialogs.trees.TreeOutput;
import com.spss.java_client.ui.dialogs.trees.TreeSave;
import com.spss.java_client.ui.dialogs.trees.TreeValidation;
import com.spss.java_client.ui.dialogs.trees.res.TreeResBundle;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class TreeDlg
extends BaseProcedureDialog
implements ActionListener,
ListDataListener,
ItemListener,
FocusListener {
    public static final String DEPENDENT_VAR_LIST = "IDS_TREE_DEPENDENT_VAR_LIST";
    public static final String GROWING_METHOD_COMBOBOX = "IDS_TREE_GROWING_METHOD_COMBOBOX";
    private static final int MAX_CATEGORICAL_CAPACITY = 64;
    static final int INDEPENDENTLIST_HEIGHT = 120;
    static final int INDEPENDENTLIST_WIDTH = 150;
    static final int NUMBER_OF_ROWS = 3;
    static final String DEFINE_CATEGORIES_KEY = "IDS_TREE_CATE_MAX_DEFINE_CATEGORIES";
    static final String DEFINE_CATEGORIES_CANCEL = "IDS_TREE_CATE_MAX_DEFINE_CATEGORIES_CANCEL";
    static final int NUMBER_OF_ROW = 7;
    static final String GROWING_METHOD_CRT = "IDS_TREE_GROWING_METHOD_CRT_ITEM";
    static final String GROWING_METHOD_QUEST = "IDS_TREE_GROWING_METHOD_QUEST_ITEM";
    static final String GROWING_METHOD_CHAID = "IDS_TREE_GROWING_METHOD_CHAID_ITEM";
    static final String GROWING_METHOD_ECHAID = "IDS_TREE_GROWING_METHOD_ECHAID_ITEM";
    static final String INDEPENDENT_VAR_LIST = "IDS_TREE_INDEPENDENT_VAR_LIST";
    static final String FORCE_FIRST_KEY = "IDS_TREE_FORCE_FIRST_VARIABLE";
    static final String OUTPUT_BUTTON_KEY = "IDS_COMMON_OUTPUT_BUTTON";
    static final String VALIDATION_BUTTON_KEY = "IDS_TREE_VALIDATION_BUTTON";
    static final String CRITERIA_BUTTON_KEY = "IDS_TREE_CRITERIA_BUTTON";
    static final String SAVE_BUTTON_KEY = "IDS_COMMON_SAVE_BUTTON";
    static final String OPTIONS_BUTTON_KEY = "IDS_COMMON_OPTIONS_3DOT";
    static final String CATEGORIES_BUTTON_KEY = "IDS_TREE_CATEGORIES";
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private TargetVariableList mDependentTargetVarList;
    private JScrollPane mDependentTargetScrollPane;
    private JScrollPane mInDependentTargetScrollPane;
    private JScrollPane mInfluenceTargetScrollPane;
    private TargetVariableList mInDependentTargetVarList;
    private TargetVariableList mInfluenceTargetVarList;
    private ArrowButton mDependentArrowButton;
    private ArrowButton mInDependentArrowButton;
    private ArrowButton mInfluenceArrowButton;
    private JButton mCategories;
    private JCheckBox mForceCheck;
    private JComboBox mGrowingMethodCombo;
    private DependentVarFormatter mFormatter;
    private JButton mOptionButton;
    private JLabel mInfluenceLabel;
    private JButton mDefineCategories;
    private JButton mCancel;
    private TreeDlg mTreeDlg;
    private Vector<Categories> mCategoryVector = new Vector();
    private Vector<Categories> mExcludeCategoryVector = new Vector();
    private boolean isChangedCategory;
    private String mRulesFile;

    public TreeDlg(JFrame jFrame) {
        super(jFrame, false, TreeResBundle.getDefaultResourceBundleName(), TreeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_TREE_TITLE"));
        this.mTreeDlg = this;
        this.setLocationRelativeTo(this.getParent());
    }

    public static void setSelectionText(final JTextField jTextField) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jTextField.requestFocusInWindow();
            }
        });
        jTextField.setSelectionStart(0);
        jTextField.setSelectionEnd(jTextField.getText().length());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        this.updateTargetListBehavior(object);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean okPastePressed() {
        Vector vector = (Vector)this.mFormatter.getVarMap().get(this.getDependentVariable().getId().asInt());
        if (vector != null && vector.size() > 64) {
            ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, DEFINE_CATEGORIES_KEY);
            this.mDefineCategories = new JButton(toggleButtonAction);
            toggleButtonAction = new ToggleButtonAction(this, DEFINE_CATEGORIES_CANCEL);
            this.mCancel = new JButton(toggleButtonAction);
            new MaximumDependentCategories(this, this.getResString("ERR_TREE_CATE_MAX_MESSAGE"), this.getResString("IDS_TREE_CATE_MAX_TITLE"));
            return false;
        }
        return this.isValidateValues();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_TREE_VALIDATION_CROSSVALIDATION_RADIO");
        if (bl != null && bl.booleanValue() && this.mForceCheck.isSelected()) {
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_FORCE_VARIABLE_CHECK"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (n == 0) {
                dialogDataModel.putBoolean("IDS_TREE_VALIDATION_CROSSVALIDATION_RADIO", false);
            } else {
                this.mForceCheck.setSelected(false);
            }
        }
    }

    public SrcVariableList getSrcVariableList() {
        return this.mSrcVarList;
    }

    @Override
    public void reset() {
        super.reset();
        this.mCategoryVector.clear();
        this.setDefaults();
    }

    public String getMeasurementLevelChar(MeasurementLevel measurementLevel) {
        switch (measurementLevel.value()) {
            case 1: {
                return "n";
            }
            case 2: {
                return "o";
            }
        }
        return "s";
    }

    @Override
    public String getIActionKey() {
        return "analyze_classify_tree";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.mCategories)) {
            this.runCategoriesSubDialog();
        }
        if (actionEvent.getSource().equals(this.mGrowingMethodCombo)) {
            if (this.mGrowingMethodCombo.getSelectedItem().equals(this.getResString(GROWING_METHOD_QUEST))) {
                if (this.mInfluenceTargetVarList.getModel().getSize() > 0) {
                    int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_TREE_QUEST_WRNING_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                    if (n == 0) {
                        this.mSrcVarList.getModel().addElement(this.mInfluenceTargetVarList.getModel().getElementAt(0));
                        this.mSrcVarList.requestFocus();
                        this.mSrcVarList.setSelectedIndex(0);
                        this.mInfluenceTargetVarList.removeAll();
                        this.mInfluenceArrowButton.setEnabled(false);
                        this.mInfluenceTargetVarList.setEnabled(false);
                        this.mInfluenceTargetVarList.setOpaque(false);
                        this.mInfluenceLabel.setEnabled(false);
                    } else {
                        this.mGrowingMethodCombo.setSelectedIndex(0);
                    }
                } else {
                    this.mInfluenceArrowButton.setEnabled(false);
                    this.mInfluenceTargetVarList.setEnabled(false);
                    this.mInfluenceTargetVarList.setOpaque(false);
                    this.mInfluenceLabel.setEnabled(false);
                }
            } else {
                this.mInfluenceArrowButton.setEnabled(true);
                this.mInfluenceTargetVarList.setEnabled(true);
                this.mInfluenceTargetVarList.setOpaque(true);
                this.mInfluenceLabel.setEnabled(true);
            }
        }
    }

    public boolean isContainsScale() {
        boolean bl = false;
        for (int i = 0; i < this.mInDependentTargetVarList.getModel().getSize(); ++i) {
            int n = this.mInDependentTargetVarList.getModel().getElementAt(i).getDisplayMeasurementLevel().value();
            if (n != 0 && n != 3) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isSelectedForceCheck() {
        return this.mForceCheck.isEnabled() && this.mForceCheck.isSelected();
    }

    public String getGrowingMethod() {
        return this.mGrowingMethodCombo.getSelectedItem().toString();
    }

    public boolean canShowVarLabels() {
        return this.mSrcVarList.getShowVarLabels();
    }

    public ISpssVariable getDependentVariable() {
        if (this.mDependentTargetVarList.getModel().getSize() != 0) {
            return this.mDependentTargetVarList.getModel().getElementAt(0);
        }
        return null;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mDependentTargetVarList.getModel()) {
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            dialogDataModel.putSerializableArray("IDS_TREE_OPTIONS_PROFIT_KEY", null);
            dialogDataModel.putSerializableArray("IDS_TREE_OPTIONS_SCORE_KEY", null);
            TreeOptionsMisclassificationCostsTab.putDdmModelData(dialogDataModel, null);
            dialogDataModel.putSerializableArray("IDS_TREE_PRIOR_PROB_TABLE_KEY", null);
            dialogDataModel.putSerializableArray("IDS_TREE_CATEGORIES_EXCLUDE_LIST_KEY", null);
        }
        this.enableButtons();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mDependentTargetVarList.getModel()) {
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            dialogDataModel.putSerializableArray("IDS_TREE_OPTIONS_PROFIT_KEY", null);
            dialogDataModel.putSerializableArray("IDS_TREE_OPTIONS_SCORE_KEY", null);
            TreeOptionsMisclassificationCostsTab.putDdmModelData(dialogDataModel, null);
            dialogDataModel.putSerializableArray("IDS_TREE_PRIOR_PROB_TABLE_KEY", null);
            dialogDataModel.putSerializableArray("IDS_TREE_CATEGORIES_EXCLUDE_LIST_KEY", null);
            dialogDataModel.putSerializableArray("IDS_TREE_CRITERIA_INTERVAL_VALUE_EDIT", null);
        }
        this.enableButtons();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableButtons();
    }

    public boolean isTargetCategoryDefined() {
        if (this.mDependentTargetVarList.getModel().getSize() > 0) {
            ISpssVariable iSpssVariable = this.mDependentTargetVarList.getModel().getElementAt(0);
            Vector vector = (Vector)this.mFormatter.getVarMap().get(iSpssVariable.getId().asInt());
            if (vector != null) {
                for (Categories categories : vector) {
                    if (!categories.isTargetCategory()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_treegui_main";
    }

    @Override
    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    public DependentVarFormatter getDepVarListFormatter() {
        return this.mFormatter;
    }

    public TargetVariableList getInDependentTargetVarList() {
        return this.mInDependentTargetVarList;
    }

    public Vector<Categories> buildCategoryTableModel(ISpssVariable iSpssVariable) {
        this.mCategoryVector = iSpssVariable.getType() == 0 ? this.buildNumericCategoryTableModel(iSpssVariable) : this.buildStringCategoryTableModel(iSpssVariable);
        return this.mCategoryVector;
    }

    public Vector<Categories> getCategoryTableModel() {
        return this.mCategoryVector;
    }

    public Vector<Categories> getExcludeCategoryVector() {
        ISpssVariable iSpssVariable = this.mDependentTargetVarList.getModel().getElementAt(0);
        if (iSpssVariable.getType() == 0) {
            this.buildNumericCategoryTableModel(iSpssVariable);
        } else {
            this.buildStringCategoryTableModel(iSpssVariable);
        }
        return this.mExcludeCategoryVector;
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2;
        String string3;
        String string4;
        Object object;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* ");
        stringBuffer.append(this.getResString("IDS_TREE_SYNTAX_TITLE"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("TREE"));
        ISpssVariable iSpssVariable = this.getDependentVariable();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(iSpssVariable.getName()));
        stringBuffer.append(" [");
        stringBuffer.append(this.getMeasurementLevelChar(iSpssVariable.getDisplayMeasurementLevel()));
        stringBuffer.append("]");
        stringBuffer.append(" BY ");
        VarListModel varListModel = this.mInDependentTargetVarList.getModel();
        boolean bl = false;
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable2 = varListModel.getElementAt(i);
            object = iSpssVariable2.getDisplayMeasurementLevel();
            stringBuffer.append(iSpssVariable2.getName());
            stringBuffer.append(" [");
            stringBuffer.append(this.getMeasurementLevelChar((MeasurementLevel)object));
            stringBuffer.append("] ");
            if (!object.toString().equals("nominal")) continue;
            bl = true;
        }
        if (this.mForceCheck.isSelected()) {
            stringBuffer.append("FORCE=");
            stringBuffer.append(varListModel.getElementAt(0).getName());
            stringBuffer.append(" [");
            stringBuffer.append(this.getMeasurementLevelChar(varListModel.getElementAt(0).getDisplayMeasurementLevel()));
            stringBuffer.append("]");
        }
        stringBuffer.append(this.getTreeTabSyntax());
        String string5 = iSpssVariable.getDisplayMeasurementLevel().toString();
        if (string5.equals("nominal") || string5.equals("ordinal")) {
            stringBuffer.append(this.getDepCategoriesSyntax());
        }
        stringBuffer.append(this.getPrintSyntax());
        stringBuffer.append(this.getGainSyntax());
        stringBuffer.append(this.getPlotSyntax());
        this.mRulesFile = null;
        stringBuffer.append(this.getRulesSyntax());
        stringBuffer.append(this.getSaveSyntax());
        stringBuffer.append(this.getMethodSyntax());
        stringBuffer.append(this.getGrowthLimitSyntax());
        stringBuffer.append(this.getValidationTabSyntax());
        object = this.getResStringArray("IDS_TREE_GROWING_METHOD_ARRAY")[dialogDataModel.getInteger(GROWING_METHOD_COMBOBOX)].toUpperCase();
        if (!((String)object).equals(this.getResString(GROWING_METHOD_CRT)) && !((String)object).equals(this.getResString(GROWING_METHOD_QUEST))) {
            stringBuffer.append(this.getCHAIDTabSyntax());
        }
        if (((String)object).equals(this.getResString(GROWING_METHOD_CRT))) {
            stringBuffer.append(this.getCRTTabSyntax());
        }
        if (((String)object).equals(this.getResString(GROWING_METHOD_QUEST))) {
            stringBuffer.append(this.getQUESTTabSyntax());
        }
        String string6 = null;
        String string7 = null;
        if (iSpssVariable != null) {
            boolean bl2;
            boolean bl3;
            if (((String)object).equals(this.getResString(GROWING_METHOD_CHAID)) || ((String)object).equalsIgnoreCase(this.getResString(GROWING_METHOD_ECHAID))) {
                if (this.mOptionButton.isEnabled() && (string5.equals("nominal") || string5.equals("ordinal"))) {
                    stringBuffer.append(this.getCostSyntax());
                }
                if (string5.equals("ordinal") && this.getCategoryTableModel().size() > 1) {
                    stringBuffer.append(this.getScoresSyntax());
                }
                stringBuffer.append(this.getProfitSyntax());
                if (this.mInfluenceTargetVarList.getModel().getSize() > 0) {
                    stringBuffer.append("\n");
                    stringBuffer.append(SyntaxUtil.getSubCommand("/INFLUENCE "));
                    stringBuffer.append(this.mInfluenceTargetVarList.getModel().getElementAt(0).getName());
                }
                Boolean bl4 = dialogDataModel.getBoolean("IDS_TREE_SAVE_TRAINING_SAMPLE");
                if (!RemoteFileChooser.enableSaveInModeler()) {
                    string4 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TRAINING_SUFFIX");
                    bl4 = string4 != null && string4.length() > 0;
                }
                if (bl4 != null && bl4.booleanValue()) {
                    stringBuffer.append("\n");
                    stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE"));
                    stringBuffer.append(" TRAININGMODEL=");
                    string6 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TRAINING_SUFFIX");
                    stringBuffer.append(CharacterUtil.smartQuote((String)string6));
                    bl4 = dialogDataModel.getBoolean("IDS_TREE_SAVE_IDS_TEST_SAMPLE");
                    if (!RemoteFileChooser.enableSaveInModeler()) {
                        string4 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TEST_SUFFIX");
                        bl3 = string4 != null && string4.length() > 0;
                        bl2 = this.getDialogDataModel().getSafeBoolean("IDS_TREE_VALIDATION_SPLIT_SAMPLE_RADIO");
                        bl4 = bl3 && bl2;
                    }
                    if (bl4 != null && bl4.booleanValue()) {
                        stringBuffer.append(" TESTMODEL=");
                        string7 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TEST_SUFFIX");
                        stringBuffer.append(CharacterUtil.smartQuote((String)string7));
                    }
                } else {
                    bl4 = dialogDataModel.getBoolean("IDS_TREE_SAVE_IDS_TEST_SAMPLE");
                    if (!RemoteFileChooser.enableSaveInModeler()) {
                        string4 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TEST_SUFFIX");
                        bl3 = string4 != null && string4.length() > 0;
                        bl2 = this.getDialogDataModel().getSafeBoolean("IDS_TREE_VALIDATION_SPLIT_SAMPLE_RADIO");
                        bl4 = bl3 && bl2;
                    }
                    if (bl4 != null && bl4.booleanValue()) {
                        stringBuffer.append("\n");
                        stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE"));
                        stringBuffer.append(" TESTMODEL=");
                        string7 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TEST_SUFFIX");
                        stringBuffer.append(CharacterUtil.smartQuote((String)string7));
                    }
                }
                if (bl) {
                    stringBuffer.append(this.getMissingSyntax());
                }
            } else if (((String)object).equals(this.getResString(GROWING_METHOD_CRT)) || ((String)object).equals(this.getResString(GROWING_METHOD_QUEST))) {
                if (string5.equals("nominal") || string5.equals("ordinal")) {
                    stringBuffer.append(this.getCostSyntax());
                    stringBuffer.append(this.getPriorSyntax());
                    stringBuffer.append(this.getProfitSyntax());
                }
                if (this.mInfluenceTargetVarList.getModel().getSize() > 0) {
                    stringBuffer.append("\n");
                    stringBuffer.append(SyntaxUtil.getSubCommand("/INFLUENCE "));
                    stringBuffer.append(this.mInfluenceTargetVarList.getModel().getElementAt(0).getName());
                }
                Boolean bl5 = dialogDataModel.getBoolean("IDS_TREE_SAVE_TRAINING_SAMPLE");
                if (!RemoteFileChooser.enableSaveInModeler()) {
                    string4 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TRAINING_SUFFIX");
                    bl5 = string4 != null && string4.length() > 0;
                }
                if (bl5 != null && bl5.booleanValue()) {
                    stringBuffer.append("\n");
                    stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE"));
                    stringBuffer.append(" TRAININGMODEL=");
                    string6 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TRAINING_SUFFIX");
                    stringBuffer.append(CharacterUtil.smartQuote((String)string6));
                    bl5 = dialogDataModel.getBoolean("IDS_TREE_SAVE_IDS_TEST_SAMPLE");
                    if (!RemoteFileChooser.enableSaveInModeler()) {
                        string4 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TEST_SUFFIX");
                        bl3 = string4 != null && string4.length() > 0;
                        bl2 = this.getDialogDataModel().getSafeBoolean("IDS_TREE_VALIDATION_SPLIT_SAMPLE_RADIO");
                        bl5 = bl3 && bl2;
                    }
                    if (bl5 != null && bl5.booleanValue()) {
                        stringBuffer.append(" TESTMODEL=");
                        string7 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TEST_SUFFIX");
                        stringBuffer.append(CharacterUtil.smartQuote((String)string7));
                    }
                } else {
                    bl5 = dialogDataModel.getBoolean("IDS_TREE_SAVE_IDS_TEST_SAMPLE");
                    if (!RemoteFileChooser.enableSaveInModeler()) {
                        string4 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TEST_SUFFIX");
                        bl3 = string4 != null && string4.length() > 0;
                        bl2 = this.getDialogDataModel().getSafeBoolean("IDS_TREE_VALIDATION_SPLIT_SAMPLE_RADIO");
                        bl5 = bl3 && bl2;
                    }
                    if (bl5 != null && bl5.booleanValue()) {
                        stringBuffer.append("\n");
                        stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE"));
                        stringBuffer.append(" TESTMODEL=");
                        string7 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TEST_SUFFIX");
                        stringBuffer.append(CharacterUtil.smartQuote((String)string7));
                    }
                }
                if (bl) {
                    stringBuffer.append(this.getMissingSyntax());
                }
            }
        } else {
            Boolean bl6;
            if (this.mInfluenceTargetVarList.getModel().getSize() > 0) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/INFLUENCE "));
                stringBuffer.append(this.mInfluenceTargetVarList.getModel().getElementAt(0).getName());
            }
            if ((bl6 = dialogDataModel.getBoolean("IDS_TREE_SAVE_TRAINING_SAMPLE")) != null && bl6.booleanValue()) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE"));
                stringBuffer.append(" TRAININGMODEL=");
                string6 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TRAINING_SUFFIX");
                stringBuffer.append(CharacterUtil.smartQuote((String)string6));
                bl6 = dialogDataModel.getBoolean("IDS_TREE_SAVE_IDS_TEST_SAMPLE");
                if (bl6 != null && bl6.booleanValue()) {
                    stringBuffer.append(" TESTMODEL=");
                    string7 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TEST_SUFFIX");
                    stringBuffer.append(CharacterUtil.smartQuote((String)string7));
                }
            } else {
                bl6 = dialogDataModel.getBoolean("IDS_TREE_SAVE_IDS_TEST_SAMPLE");
                if (bl6 != null && bl6.booleanValue()) {
                    stringBuffer.append("\n");
                    stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE"));
                    stringBuffer.append(" TESTMODEL=");
                    string7 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_TEST_SUFFIX");
                    stringBuffer.append(CharacterUtil.smartQuote((String)dialogDataModel.getString("EXPORT_XML_FILE_PATH_TEST_SUFFIX")));
                }
            }
            if (bl) {
                stringBuffer.append(this.getMissingSyntax());
            }
        }
        string4 = stringBuffer.toString().trim() + ".\n";
        PesFile pesFile = PES_Repository.getPesFile((String)string6);
        if (pesFile != null && (string3 = pesFile.getPerAttributesSyntax()) != null) {
            string4 = string4 + string3;
        }
        if ((pesFile = PES_Repository.getPesFile((String)string7)) != null && (string2 = pesFile.getPerAttributesSyntax()) != null) {
            string4 = string4 + string2;
        }
        if ((pesFile = PES_Repository.getPesFile((String)this.mRulesFile)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            string4 = string4 + string;
        }
        return string4;
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.putVarFormatterToDDM();
    }

    private void putVarFormatterToDDM() {
        Map.Entry<Integer, Object> entry;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        HashMap<Integer, Object> hashMap = this.mFormatter.getVarMap();
        if (hashMap.size() > 0 && (entry = hashMap.entrySet().iterator().next()).getValue() instanceof Vector) {
            Vector vector = (Vector)entry.getValue();
            SerializableObject[] serializableObjectArray = new SerializableObject[vector.size()];
            dialogDataModel.putSerializableArray(this.mDependentTargetVarList.getIdentifier(), vector.toArray(serializableObjectArray));
            dialogDataModel.putInteger(this.mDependentTargetVarList.getIdentifier(), entry.getKey());
        }
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray(this.mDependentTargetVarList.getIdentifier());
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        Integer n = dialogDataModel.getInteger(this.mDependentTargetVarList.getIdentifier());
        Vector<Categories> vector = new Vector<Categories>();
        if (serializableObjectArray != null && serializableObjectArray.length > 0 && serializableObjectArray[0] instanceof Categories) {
            for (SerializableObject serializableObject : serializableObjectArray) {
                vector.add((Categories)serializableObject);
            }
        }
        if (n != null) {
            hashMap.put(n, vector);
            this.mFormatter.setVarMap(hashMap);
            this.mCategoryVector = vector;
            this.enableButtons();
        }
        this.mDependentTargetVarList.getModel().addListDataListener(this);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupLists();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.pack();
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.setFocusListeners();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(OUTPUT_BUTTON_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeDlg.this.runOutputSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        toggleButtonAction = new ToggleButtonAction(this, VALIDATION_BUTTON_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeDlg.this.runValidationSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        toggleButtonAction = new ToggleButtonAction(this, CRITERIA_BUTTON_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeDlg.this.runCriteriaSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        toggleButtonAction = new ToggleButtonAction(SAVE_BUTTON_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeDlg.this.runSaveSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeDlg.this.runOptionsSubDialog();
            }
        };
        this.mOptionButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionButton);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new WeightVarFilter());
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setContextMenuFlags(this.mSrcVarList.getContextMenuFlags() | 8);
        this.mDependentTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mFormatter = new DependentVarFormatter(this.mDependentTargetVarList);
        DependentVarListModel dependentVarListModel = new DependentVarListModel(this.mFormatter);
        this.mDependentTargetVarList.setModel(dependentVarListModel);
        this.mDependentTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDependentTargetScrollPane = new JScrollPane(this.mDependentTargetVarList);
        this.mDependentTargetScrollPane.setPreferredSize(this.mDependentTargetVarList.getMinimumSize());
        this.mDependentTargetScrollPane.setMinimumSize(this.mDependentTargetVarList.getMinimumSize());
        this.mDependentTargetScrollPane.setHorizontalScrollBarPolicy(31);
        this.mDependentTargetScrollPane.setVerticalScrollBarPolicy(21);
        this.mDependentTargetVarList.setIdentifier(DEPENDENT_VAR_LIST);
        this.mInDependentTargetVarList = new TargetVariableList();
        this.mInDependentTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mInDependentTargetScrollPane = new JScrollPane(this.mInDependentTargetVarList);
        this.mInDependentTargetScrollPane.setPreferredSize(new Dimension(150, 120));
        this.mInDependentTargetVarList.getModel().addListDataListener(this);
        this.mInDependentTargetVarList.setIdentifier(INDEPENDENT_VAR_LIST);
        this.mInfluenceTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mInfluenceTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mInfluenceTargetVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mInfluenceTargetScrollPane = new JScrollPane(this.mInfluenceTargetVarList);
        this.mInfluenceTargetScrollPane.setPreferredSize(this.mInfluenceTargetVarList.getMinimumSize());
        this.mInfluenceTargetScrollPane.setMinimumSize(this.mInfluenceTargetVarList.getMinimumSize());
        this.mInfluenceTargetScrollPane.setHorizontalScrollBarPolicy(31);
        this.mInfluenceTargetScrollPane.setVerticalScrollBarPolicy(21);
        this.mDependentArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mInDependentArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mInfluenceArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        varTargetMoveHandler varTargetMoveHandler2 = new varTargetMoveHandler();
        this.mDependentArrowButton.setVarMoveHandler(varTargetMoveHandler2);
        this.mInDependentArrowButton.setVarMoveHandler(varTargetMoveHandler2);
        this.mDependentArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDependentArrowButton.registerVariableList(this.mDependentTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mInDependentArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mInDependentArrowButton.registerVariableList(this.mInDependentTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mInfluenceArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mInfluenceArrowButton.registerVariableList(this.mInfluenceTargetVarList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, CATEGORIES_BUTTON_KEY);
        this.mCategories = new JButton(toggleButtonAction);
        this.mCategories.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this, FORCE_FIRST_KEY);
        this.mForceCheck = new JCheckBox(toggleButtonAction);
        this.mForceCheck.addItemListener(this);
        this.mGrowingMethodCombo = new JComboBox<String>(this.getResStringArray("IDS_TREE_GROWING_METHOD_ARRAY"));
        this.mGrowingMethodCombo.addActionListener(this);
        this.mGrowingMethodCombo.setAction(new ComboboxAction(this, GROWING_METHOD_COMBOBOX));
        this.mInfluenceLabel = DialogUtil.createLabel(this, "IDS_TREE_INFLUENCE_VARIABLES");
        this.mInfluenceLabel.setLabelFor(this.mInfluenceTargetVarList);
        this.mVarMoveHandler = new varTargetMoveHandler();
    }

    private void updateTargetListBehavior(Object object) {
        if (this.mDependentTargetVarList.getModel().getSize() > 0) {
            ISpssVariable iSpssVariable = this.mDependentTargetVarList.getModel().getElementAt(0);
            MeasurementLevel measurementLevel = iSpssVariable.getDisplayMeasurementLevel();
            if (!measurementLevel.equals((Object)MeasurementLevel.nominal) && this.mGrowingMethodCombo.getSelectedIndex() == 3) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mTreeDlg), this.getResString("ERR_TREE_WRNING_MSG"), VersionInfo.getAppVersionString());
                this.mDependentArrowButton.doClick();
            }
            this.enableButtons();
        }
    }

    private String getTreeTabSyntax() {
        String string = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/TREE");
        Boolean bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_TREE");
        if (bl != null && bl.booleanValue()) {
            string = string + " DISPLAY=";
            bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_TOP_DOWN");
            if (bl != null && bl.booleanValue()) {
                string = string + "TOPDOWN";
            }
            if ((bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_LEFT_TO_RIGHT")) != null && bl.booleanValue()) {
                string = string + "LEFTTORIGHT";
            }
            if ((bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_RIGHT_TO_LEFT")) != null && bl.booleanValue()) {
                string = string + "RIGHTTOLEFT";
            }
            string = string + " NODES=";
            bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_TABLE");
            if (bl != null && bl.booleanValue()) {
                string = string + "STATISTICS";
            }
            if ((bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_CHART")) != null && bl.booleanValue()) {
                string = string + "CHART";
            }
            if ((bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_TABLE_AND_CHART")) != null && bl.booleanValue()) {
                string = string + "BOTH";
            }
            string = string + " BRANCHSTATISTICS=";
            bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_INDEPENDENT_VARIABLE_STATISTICS");
            string = bl != null && bl != false ? string + "YES" : string + "NO";
            string = string + " NODEDEFS=";
            bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_NODE_DEFINITIONS");
            string = bl != null && bl != false ? string + "YES" : string + "NO";
            string = string + " SCALE=";
            bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_AUTOMATIC_REDUCES_SCALE_FOR_LARGE_TREES");
            if (bl != null && bl.booleanValue()) {
                string = string + "AUTO";
            }
            if ((bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_CUSTOM")) != null && bl.booleanValue()) {
                string = string + dialogDataModel.getString("IDS_TREEOUTPUTTREE_SCALE_PERCENT");
            }
        } else if (bl != null) {
            string = string + " DISPLAY=NONE";
        } else {
            string = string + " DISPLAY=TOPDOWN";
            string = string + " NODES=STATISTICS";
            string = string + " BRANCHSTATISTICS=YES";
            string = string + " NODEDEFS=YES";
            string = string + " SCALE=AUTO";
        }
        return string;
    }

    private String getDepCategoriesSyntax() {
        String string = "";
        String string2 = "";
        string = string + "\n" + SyntaxUtil.getSubCommand("/DEPCATEGORIES");
        string = string + " USEVALUES=";
        SPSS_Format sPSS_Format = this.getDependentVariable().getFormat();
        if (sPSS_Format.getFormatType().isNumericFormat()) {
            sPSS_Format.setFormatType(FormatType.F);
        }
        Vector vector = (Vector)this.mFormatter.getVarMap().get(this.getDependentVariable().getId().asInt());
        string = string + "[";
        this.isValidateValues();
        if (this.isChangedCategory) {
            if (this.mCategoryVector.size() > 1) {
                String string3;
                for (Categories categories : this.mCategoryVector) {
                    string3 = categories.getObs().isString() ? "'" : "";
                    string2 = string2 + string3 + CellValueFormatter.obsToString((OBS)categories.getObs(), (SPSS_Format)sPSS_Format) + string3 + " ";
                }
                string2 = string2.trim();
                string = string + string2 + "]";
                if (this.isTargetCategoryDefined()) {
                    string = string + " TARGET=[";
                    for (Categories categories : vector) {
                        String string4 = string3 = categories.getObs().isString() ? "'" : "";
                        if (!categories.isTargetCategory()) continue;
                        string = string + string3 + CellValueFormatter.obsToString((OBS)categories.getObs(), (SPSS_Format)sPSS_Format) + string3 + " ";
                    }
                    string = string.substring(0, string.length() - 1);
                    string = string + "]";
                }
            } else {
                string = string + "VALID]";
            }
        } else if (vector != null && vector.size() > 1) {
            String string5;
            String string6;
            for (Categories categories : vector) {
                string6 = categories.getObs().isString() ? "'" : "";
                string5 = CellValueFormatter.obsToString((OBS)categories.getObs(), (SPSS_Format)sPSS_Format);
                if (!categories.getObs().isString()) {
                    string5 = UIToolResUtil.removeLocale((String)string5);
                }
                string2 = string2 + string6 + string5 + string6 + " ";
            }
            string2 = string2.trim();
            string = string + string2 + "]";
            if (this.isTargetCategoryDefined()) {
                string = string + " TARGET=[";
                for (Categories categories : vector) {
                    String string7 = string6 = categories.getObs().isString() ? "'" : "";
                    if (!categories.isTargetCategory()) continue;
                    string5 = CellValueFormatter.obsToString((OBS)categories.getObs(), (SPSS_Format)sPSS_Format);
                    if (!categories.getObs().isString()) {
                        string5 = UIToolResUtil.removeLocale((String)string5);
                    }
                    string = string + string6 + string5 + string6 + " ";
                }
                string = string.substring(0, string.length() - 1);
                string = string + "]";
            }
        } else {
            string = string + "VALID]";
        }
        return string;
    }

    private String getPrintSyntax() {
        boolean bl = false;
        String string = "";
        String string2 = "";
        String string3 = "";
        ISpssVariable iSpssVariable = this.getDependentVariable();
        boolean bl2 = iSpssVariable != null && iSpssVariable.getDisplayMeasurementLevel().value() != 0 && iSpssVariable.getDisplayMeasurementLevel().value() != 3;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/PRINT");
        Boolean bl3 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_SUMMARY");
        if (bl3 != null && bl3.booleanValue()) {
            string2 = string2 + " MODELSUMMARY";
        } else if (bl3 == null) {
            bl = true;
            string3 = string3 + " MODELSUMMARY";
        }
        String string4 = this.getResStringArray("IDS_TREE_GROWING_METHOD_ARRAY")[dialogDataModel.getInteger(GROWING_METHOD_COMBOBOX)].toUpperCase();
        if (string4.equals(this.getResString(GROWING_METHOD_CRT)) || string4.equals(this.getResString(GROWING_METHOD_QUEST))) {
            bl3 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_IMPORTANCE_TO_MODEL");
            if (bl3 != null && bl3.booleanValue()) {
                string2 = string2 + " IMPORTANCE";
            } else if (bl3 == null) {
                bl = true;
            }
            bl3 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_SURROGATES_BY_SPLIT");
            if (bl3 != null && bl3.booleanValue()) {
                string2 = string2 + " SURROGATES";
            } else if (bl3 == null) {
                bl = true;
            }
        }
        if (bl2) {
            bl3 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_CLASSIFICATION_TABLE");
            if (bl3 != null && bl3.booleanValue()) {
                string2 = string2 + " CLASSIFICATION";
            } else if (bl3 == null) {
                bl = true;
                string3 = string3 + " CLASSIFICATION";
            }
        }
        if ((bl3 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_RISK")) != null && bl3.booleanValue()) {
            string2 = string2 + " RISK";
        } else if (bl3 == null) {
            bl = true;
            string3 = string3 + " RISK";
        }
        if (bl2) {
            bl3 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_COST_PRIOR_PROBABILITY_SCORE_AND_PROFIT_VALUES");
            if (bl3 != null && bl3.booleanValue()) {
                string2 = string2 + " CATEGORYSPECS";
            } else if (bl3 == null) {
                bl = true;
            }
        }
        if ((bl3 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_TREE_IN_TABLE_FORMAT")) != null && bl3.booleanValue()) {
            string2 = string2 + " TREETABLE";
        } else if (bl3 == null) {
            bl = true;
        }
        if (string2.equals("") && !bl) {
            string2 = string2 + " NONE";
            string = string + string2;
        } else if (!string2.equals("") && !bl) {
            string = string + string2;
        } else if (bl) {
            string = string + string3;
        }
        return string;
    }

    private String getGainSyntax() {
        String string = "";
        String string2 = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/GAIN");
        ISpssVariable iSpssVariable = this.getDependentVariable();
        boolean bl = iSpssVariable != null && iSpssVariable.getDisplayMeasurementLevel().value() != 0 && iSpssVariable.getDisplayMeasurementLevel().value() != 3;
        boolean bl2 = this.isTargetCategoryDefined();
        boolean bl3 = false;
        Boolean bl4 = dialogDataModel.getBoolean("IDS_TREE_OPT_PROFIT_CUSTOM");
        if (bl4 != null) {
            bl3 = bl4;
        }
        if (!bl || bl && bl3) {
            string2 = string2 + " SUMMARYTABLE=";
            bl4 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_SUMMARY_NP");
            string2 = bl4 != null && bl4 != false ? string2 + "YES" : (bl4 != null ? string2 + "NO" : string2 + "YES");
        }
        if (bl && bl2) {
            string2 = string2 + " CATEGORYTABLE=";
            bl4 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_BY_TARGET_CATEGORY");
            string2 = bl4 != null && bl4 != false ? string2 + "YES" : (bl4 != null ? string2 + "NO" : string2 + "YES");
        }
        if (string2.equals("")) {
            return "";
        }
        string = string + string2;
        string = string + " TYPE=";
        Integer n = dialogDataModel.getInteger("IDS_TREEOUTPUTSTAT_ROWS_COMBO");
        if (n != null) {
            switch (n) {
                case 0: {
                    string = string + "[NODE]";
                    break;
                }
                case 1: {
                    string = string + "[PTILE]";
                    break;
                }
                case 2: {
                    string = string + "[NODE PTILE]";
                }
            }
        } else {
            string = string + "[NODE]";
        }
        string = string + " SORT=";
        Integer n2 = dialogDataModel.getInteger("IDS_TREEOUTPUTSTAT_SORT_ORDER_COMBO");
        if (n2 != null) {
            switch (n2) {
                case 0: {
                    string = string + "DESCENDING";
                    break;
                }
                case 1: {
                    string = string + "ASCENDING";
                }
            }
        } else {
            string = string + "DESCENDING";
        }
        if (n != null && n != 0) {
            string = string + " INCREMENT=";
            Integer n3 = dialogDataModel.getInteger("IDS_TREEOUTPUTSTAT_PERCENT_INC_COMBO");
            if (n3 != null) {
                switch (n3) {
                    case 0: {
                        string = string + "1";
                        break;
                    }
                    case 1: {
                        string = string + "2";
                        break;
                    }
                    case 2: {
                        string = string + "5";
                        break;
                    }
                    case 3: {
                        string = string + "10";
                        break;
                    }
                    case 4: {
                        string = string + "20";
                        break;
                    }
                    case 5: {
                        string = string + "25";
                    }
                }
            } else {
                string = string + "10";
            }
        }
        if (n != null && n != 1) {
            string = string + " CUMULATIVE=";
            bl4 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_DISPLAY_CUMULATIVE_STATISTICS");
            string = bl4 != null && bl4.booleanValue() ? string + "YES" : string + "NO";
        } else {
            string = string + " CUMULATIVE=NO";
        }
        return string;
    }

    private String getPlotSyntax() {
        Integer n;
        String string = "";
        String string2 = "";
        String string3 = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ISpssVariable iSpssVariable = this.getDependentVariable();
        boolean bl = iSpssVariable != null && iSpssVariable.getDisplayMeasurementLevel().value() != 0 && iSpssVariable.getDisplayMeasurementLevel().value() != 3;
        boolean bl2 = this.isTargetCategoryDefined();
        boolean bl3 = false;
        Boolean bl4 = dialogDataModel.getBoolean("IDS_TREE_OPT_PROFIT_CUSTOM");
        if (bl4 != null) {
            bl3 = bl4;
        }
        string = string + "\n" + SyntaxUtil.getSubCommand("/PLOT");
        String string4 = this.getResStringArray("IDS_TREE_GROWING_METHOD_ARRAY")[dialogDataModel.getInteger(GROWING_METHOD_COMBOBOX)].toUpperCase();
        if (string4.equals(this.getResString(GROWING_METHOD_CRT)) && (bl4 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_INDEPENDENT_VARIABLE_IMPORTANCE_TO_MODEL")) != null && bl4.booleanValue()) {
            string3 = string3 + " IMPORTANCE";
        }
        if (bl && bl2) {
            bl4 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_GAIN");
            if (bl4 != null && bl4.booleanValue()) {
                string2 = string2 + " GAIN";
            }
            if ((bl4 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_INDEX")) != null && bl4.booleanValue()) {
                string2 = string2 + " INDEX";
            }
            if ((bl4 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_RESPONSE")) != null && bl4.booleanValue()) {
                string2 = string2 + " RESPONSE";
            }
        }
        if (!bl && (bl4 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_MEAN")) != null && bl4.booleanValue()) {
            string2 = string2 + " MEAN";
        }
        if (bl && bl3) {
            bl4 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_AVERAGE_PROFIT");
            if (bl4 != null && bl4.booleanValue()) {
                string2 = string2 + " PROFIT";
            }
            if ((bl4 = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_RETURN_ON_INVESTMENT_(ROI)")) != null && bl4.booleanValue()) {
                string2 = string2 + " ROI";
            }
        }
        if ((string2 + string3).equals("")) {
            return "";
        }
        string = string + string3 + string2;
        if (!string2.equals("") && (n = dialogDataModel.getInteger("IDS_TREEOUTPUTPLOT_PERCENT_INC_COMBO")) != null) {
            string = string + " INCREMENT=";
            switch (n) {
                case 0: {
                    string = string + "1";
                    break;
                }
                case 1: {
                    string = string + "2";
                    break;
                }
                case 2: {
                    string = string + "5";
                    break;
                }
                case 3: {
                    string = string + "10";
                    break;
                }
                case 4: {
                    string = string + "20";
                    break;
                }
                case 5: {
                    string = string + "25";
                }
            }
        }
        return string;
    }

    private String getRulesSyntax() {
        String string = "";
        String string2 = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_GENERATE_CLASSIFICATION_RULES");
        if (bl == null || !bl.booleanValue()) {
            return "";
        }
        string = string + "\n" + SyntaxUtil.getSubCommand("/RULES");
        string = string + " NODES=";
        bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_ALL_TERMINAL_NODES");
        if (bl != null && bl.booleanValue()) {
            string2 = string2 + "TERMINAL";
        }
        if (this.isTargetCategoryDefined()) {
            bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_BEST_TERMINAL_NODES");
            if (bl != null && bl.booleanValue()) {
                string2 = string2 + " TOPN(" + dialogDataModel.getString("IDS_TREEOUTPUTRULES_NUMBER_OF_NODES_EDIT") + ")";
            }
            if ((bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_BEST_TERMINAL_NODES_UP_TO_A_SPECIFIED_PERCENTAGE_OF_CASES")) != null && bl.booleanValue()) {
                string2 = string2 + " TOPPCT(" + dialogDataModel.getString("IDS_TREEOUTPUTRULES_PERCENT_EDIT") + ")";
            }
            if ((bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_TERMINAL_NODES_WHOSE_INDEX_VALUE_MEETS_OR_EXCEEDS_A_CUTOFF_VALUE")) != null && bl.booleanValue()) {
                string2 = string2 + " MININDEX(" + dialogDataModel.getString("IDS_TREEOUTPUTRULES_MIN_INDEX_EDIT") + ")";
            }
        }
        if ((bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_ALL_NODES")) != null && bl.booleanValue()) {
            string2 = string2 + "ALL";
        }
        string = string2.equals("") ? string + "TERMINAL" : string + string2;
        string = string + " SYNTAX=";
        bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_SPSS");
        if (bl != null && bl.booleanValue()) {
            string = string + "INTERNAL";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_SQL")) != null && bl.booleanValue()) {
            string = string + "SQL";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_SIMPLE_TEXT")) != null && bl.booleanValue()) {
            string = string + "GENERIC";
            string = string + " LABELS=";
            bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_USE_VARIABLE_AND_VALUE_LABELS");
            string = bl != null && bl.booleanValue() ? string + "YES" : string + "NO";
        } else if (bl != null) {
            String string3;
            string = string + " TYPE=";
            bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_ASSIGN_VALUES_TO_CASES");
            if (bl != null && bl.booleanValue()) {
                string = string + "SCORING";
            }
            if ((bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_SELECT_CASES")) != null && bl.booleanValue()) {
                string = string + "SELECTION";
            }
            if ((string3 = this.getResStringArray("IDS_TREE_GROWING_METHOD_ARRAY")[dialogDataModel.getInteger(GROWING_METHOD_COMBOBOX)].toUpperCase()).equals(this.getResString(GROWING_METHOD_CRT)) || string3.equals(this.getResString(GROWING_METHOD_QUEST))) {
                string = string + " SURROGATES=";
                bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_INCLUDE_SURROGATES_IN_SPSS_AND_SQL_RULES");
                string = bl != null && bl != false ? string + "INCLUDE" : string + "EXCLUDE";
            }
        }
        bl = dialogDataModel.getBoolean("IDS_TREE_OUTPUT_EXPORT_RULES_TO_A_FILE");
        if (bl != null && bl.booleanValue()) {
            this.mRulesFile = dialogDataModel.getString("IDS_TREEOUTPUTRULES_FILE_EDIT");
            string = string + " OUTFILE=" + CharacterUtil.smartQuote((String)this.mRulesFile);
        }
        return string;
    }

    private String getSaveSyntax() {
        ISpssVariable iSpssVariable;
        boolean bl;
        String string = "";
        String string2 = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/SAVE");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_TREE_SAVE_TERMINAL_NODE");
        if (bl2 != null && bl2.booleanValue()) {
            string2 = string2 + " NODEID";
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_TREE_SAVE_PREDICTED_VALUE")) != null && bl2.booleanValue()) {
            string2 = string2 + " PREDVAL";
        }
        boolean bl3 = bl = (iSpssVariable = this.getDependentVariable()) != null && (iSpssVariable.getDisplayMeasurementLevel().value() == 1 || iSpssVariable.getDisplayMeasurementLevel().value() == 2);
        if (bl && (bl2 = dialogDataModel.getBoolean("IDS_TREE_SAVE_PREDICTED_PROBABILITIES")) != null && bl2.booleanValue()) {
            string2 = string2 + " PREDPROB";
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_TREE_VALIDATION_SPLIT_SAMPLE_RADIO")) != null && bl2.booleanValue() && (bl2 = dialogDataModel.getBoolean("IDS_TREE_SAVE_SAMPLE_ASSIGNMENT")) != null && bl2.booleanValue()) {
            string2 = string2 + " ASSIGNMENT";
        }
        if (string2.equals("")) {
            return "";
        }
        string = string + string2;
        return string;
    }

    private String getMethodType(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "CHAID";
                break;
            }
            case 1: {
                string = "EXHAUSTIVECHAID";
                break;
            }
            case 2: {
                string = "CRT";
                break;
            }
            case 3: {
                string = "QUEST";
                break;
            }
        }
        return string;
    }

    private String getMethodSyntax() {
        String string = "";
        String string2 = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/METHOD");
        string = string + " TYPE=";
        String string3 = this.getMethodType(dialogDataModel.getInteger(GROWING_METHOD_COMBOBOX));
        string3 = string3.replace(" ", "");
        string = string + string3.toUpperCase();
        if (string3.equalsIgnoreCase(this.getResString(GROWING_METHOD_CRT)) || string3.equalsIgnoreCase(this.getResString(GROWING_METHOD_QUEST))) {
            string = string + " MAXSURROGATES=";
            Boolean bl = dialogDataModel.getBoolean("IDS_TREE_CRI_SGATES_AUTOMATIC_RADIO");
            if (bl != null && bl.booleanValue()) {
                string2 = string2 + "AUTO";
            }
            if ((bl = dialogDataModel.getBoolean("IDS_TREE_CRI_SGATES_CUSTOM_RADIO")) != null && bl.booleanValue()) {
                ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(INDEPENDENT_VAR_LIST);
                int n = iSpssVariableArray.length;
                String string4 = dialogDataModel.getString("IDS_TREE_CRI_SGATES_VALUE_TEXT");
                if (Integer.parseInt(string4) >= n) {
                    string4 = String.valueOf(n - 1);
                }
                string2 = string2 + string4;
            }
            if (string2.equals("")) {
                string2 = string2 + "AUTO";
            }
            string = string + string2;
            string = string + " PRUNE=";
            bl = dialogDataModel.getBoolean("IDS_TREE_CRI_PRUN_PRUNE_TREE_CHECK");
            string = bl != null && bl != false ? string + "SE(" + dialogDataModel.getString("IDS_TREE_CRITERIA_PRUNING_MAX_DIFF_EDIT") + ")" : string + "NONE";
        }
        return string;
    }

    private String getGrowthLimitSyntax() {
        String string = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/GROWTHLIMIT");
        string = string + " MAXDEPTH=";
        Boolean bl = dialogDataModel.getBoolean("IDS_TREE_CRI_GL_CUSTOM");
        string = bl != null && bl != false ? string + dialogDataModel.getString("IDS_TREECRITERIA_GROWTHLIMIT_VALUE_EDIT") : string + "AUTO";
        string = string + " MINPARENTSIZE=";
        String string2 = dialogDataModel.getString("IDS_TREECRITERIA_GROWTHLIMIT_PARENT_NODE_EDIT");
        string = string2 != null && !string2.equals("") ? string + string2 : string + "100";
        string = string + " MINCHILDSIZE=";
        string2 = dialogDataModel.getString("IDS_TREECRITERIA_GROWTHLIMIT_CHILD_NODE_EDIT");
        string = string2 != null && !string2.equals("") ? string + string2 : string + "50";
        return string;
    }

    private String getValidationTabSyntax() {
        String string = "";
        String string2 = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/VALIDATION");
        string = string + " TYPE=";
        Boolean bl = dialogDataModel.getBoolean("IDS_TREE_VALIDATION_CROSSVALIDATION_RADIO");
        if (bl != null && bl.booleanValue()) {
            string2 = string2 + "CROSSVALIDATION(" + dialogDataModel.getString("IDS_TREE_VALIDATION_NUMBER_OF_SAMPLES_FOLDS_EDIT") + ")";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_TREE_VALIDATION_SPLIT_SAMPLE_RADIO")) != null && bl.booleanValue()) {
            bl = dialogDataModel.getBoolean("IDS_TREE_VALIDATION_USE_RANDOM_RADIO");
            if (bl != null && bl.booleanValue()) {
                string2 = string2 + "SPLITSAMPLE(" + dialogDataModel.getString("IDS_TREE_VALIDATION_NUMBER_OF_SAMPLES_EDIT") + ")";
            }
            if ((bl = dialogDataModel.getBoolean("IDS_TREE_VALIDATION_USE_VARIABLE_RADIO")) != null && bl.booleanValue()) {
                LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
                ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
                ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_TREE_VALIDATION_SPLIT_SAMPLE_BY_LIST");
                if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
                    ISpssVariable iSpssVariable = iSpssVariableArray[0];
                    string2 = string2 + "SPLITSAMPLE(" + iSpssVariable.getName() + ")";
                }
            }
        }
        string = string2.equals("") ? string + "NONE" : string + string2;
        string = string + " OUTPUT=";
        bl = dialogDataModel.getBoolean("IDS_TREE_VALIDATIONTEST_SAMPLE_RADIO");
        string = bl != null && bl != false ? string + "TESTSAMPLE" : string + "BOTHSAMPLES";
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String getCHAIDTabSyntax() {
        ISpssVariable iSpssVariable;
        String string = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/CHAID");
        string = string + " ALPHASPLIT=";
        String string2 = dialogDataModel.getString("IDS_TREE_CATEGORIES_CHAID_SPLITING_NODE_EDIT");
        string = string2 != null ? string + string2 : string + "0.05";
        String string3 = this.getResStringArray("IDS_TREE_GROWING_METHOD_ARRAY")[dialogDataModel.getInteger(GROWING_METHOD_COMBOBOX)].toUpperCase();
        if (!string3.equalsIgnoreCase(this.getResString(GROWING_METHOD_ECHAID))) {
            string = string + " ALPHAMERGE=";
            string2 = dialogDataModel.getString("IDS_TREE_CATEGORIES_CHAID_MERGE_CATEGORIES_EDIT");
            string = string2 != null ? string + string2 : string + "0.05";
        }
        boolean bl = (iSpssVariable = this.getDependentVariable()) != null && (iSpssVariable.getDisplayMeasurementLevel().value() == 1 || iSpssVariable.getDisplayMeasurementLevel().value() == 2);
        boolean bl2 = iSpssVariable != null && iSpssVariable.getDisplayMeasurementLevel().value() == 1;
        string = string + " SPLITMERGED=";
        Boolean bl3 = dialogDataModel.getBoolean("IDS_TREE_CRI_CHAID_ALLOW_CHECK");
        string = bl3 != null && bl3 != false ? string + "YES" : string + "NO";
        if (bl2) {
            bl3 = dialogDataModel.getBoolean("IDS_TREE_CRI_CHAID_PEARSON");
            string = bl3 != null ? (bl3.booleanValue() ? string + " CHISQUARE=PEARSON" : string + " CHISQUARE=LR") : string + " CHISQUARE=PEARSON";
        }
        if (bl) {
            string = string + " CONVERGE=";
            string2 = dialogDataModel.getString("IDS_TREE_CATEGORIES_CHAID_MIN_CHANGE_EDIT");
            string = string2 != null ? string + string2 : string + "0.001";
            string = string + " MAXITERATIONS=";
            string2 = dialogDataModel.getString("IDS_TREE_CATEGORIES_CHAID_MAX_NO_OF_ITERATIONS_EDIT");
            string = string2 != null ? string + string2 : string + "100";
        }
        string = string + " ADJUST=";
        bl3 = dialogDataModel.getBoolean("IDS_TREE_CRI_CHAID_ADJUST_CHECK");
        string = bl3 != null && bl3 == false ? string + "NONE" : string + "BONFERRONI";
        if (this.isContainsScale()) {
            Object object;
            Object object2;
            string = string + " INTERVALS=";
            bl3 = dialogDataModel.getBoolean("IDS_TREE_CRI_INVALS_CUSTOM");
            ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
            if (bl3 != null && bl3.booleanValue()) {
                int n;
                object2 = dialogDataModel.getSerializableArray("IDS_TREE_CRITERIA_INTERVAL_VALUE_EDIT");
                object = new Vector();
                Vector<ISpssVariable> vector = this.getIndependentScaleVariable();
                int n2 = vector.size();
                if (n2 == (n = ((SerializableObject[])object2).length)) {
                    for (SerializableObject intervalTableVar : object2) {
                        ArrayList<String> arrayList5 = new ArrayList<String>();
                        TreeCriteriaIntervalsTab.IntervalTableVar intervalTableVar2 = (TreeCriteriaIntervalsTab.IntervalTableVar)intervalTableVar;
                        ((Vector)object).add(intervalTableVar2);
                        arrayList5.add(0, intervalTableVar2.getSpssVar().getName());
                        arrayList5.add(1, intervalTableVar2.getInterval());
                        arrayList.add(arrayList5);
                    }
                } else if (n2 > n) {
                    boolean i = false;
                    while (i < n2) {
                        boolean bl4 = false;
                        for (int j = 0; j < n; ++j) {
                            TreeCriteriaIntervalsTab.IntervalTableVar intervalTableVar = (TreeCriteriaIntervalsTab.IntervalTableVar)object2[j];
                            if (vector.get((int)i).getName().equals(intervalTableVar.getSpssVar().getName())) {
                                ArrayList<String> arrayList2 = new ArrayList<String>();
                                arrayList2.add(0, intervalTableVar.getSpssVar().getName());
                                arrayList2.add(1, intervalTableVar.getInterval());
                                ((Vector)object).add(intervalTableVar);
                                bl4 = false;
                                arrayList.add(arrayList2);
                                break;
                            }
                            bl4 = true;
                        }
                        if (bl4) {
                            ArrayList<String> arrayList3 = new ArrayList<String>();
                            arrayList3.add(0, vector.get((int)i).getName());
                            arrayList3.add(1, "10");
                            arrayList.add(arrayList3);
                        }
                        ++i;
                    }
                } else if (n2 < n) {
                    void var15_19;
                    boolean bl5 = false;
                    while (var15_19 < n) {
                        boolean bl6 = false;
                        for (int i = 0; i < n2; ++i) {
                            TreeCriteriaIntervalsTab.IntervalTableVar intervalTableVar = (TreeCriteriaIntervalsTab.IntervalTableVar)object2[var15_19];
                            if (!vector.get(i).getName().equals(intervalTableVar.getSpssVar().getName())) continue;
                            ArrayList<String> arrayList4 = new ArrayList<String>();
                            arrayList4.add(0, intervalTableVar.getSpssVar().getName());
                            arrayList4.add(1, intervalTableVar.getInterval());
                            arrayList.add(arrayList4);
                            ((Vector)object).add(intervalTableVar);
                            break;
                        }
                        ++var15_19;
                    }
                }
                object2 = new SerializableObject[((Vector)object).size()];
                dialogDataModel.putSerializableArray("IDS_TREE_CRITERIA_INTERVAL_VALUE_EDIT", ((Vector)object).toArray((T[])object2));
            } else {
                string2 = dialogDataModel.getString("IDS_TREE_CRITERIA_INTERVAL_VALUE_EDIT");
                string = string2 != null ? string + string2 : string + "10";
            }
            object2 = this.sort(arrayList);
            object = this.getSortedIntervalSyntax((ArrayList<ArrayList<String>>)object2);
            string = string + ((String)object).trim();
        }
        return string;
    }

    private ArrayList<ArrayList<String>> sort(ArrayList<ArrayList<String>> arrayList) {
        int n = arrayList.size();
        while (--n >= 0) {
            for (int i = 0; i < n; ++i) {
                if (Integer.parseInt(arrayList.get(i).get(1)) <= Integer.parseInt(arrayList.get(i + 1).get(1))) continue;
                ArrayList<String> arrayList2 = arrayList.get(i);
                arrayList.add(i, arrayList.get(i + 1));
                arrayList.remove(i + 1);
                arrayList.add(i + 1, arrayList2);
                arrayList.remove(i + 2);
            }
        }
        return arrayList;
    }

    private String getSortedIntervalSyntax(ArrayList<ArrayList<String>> arrayList) {
        String string = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!string.contains(arrayList.get(i).get(0))) {
                string = string + " " + arrayList.get(i).get(0);
            }
            for (int j = i + 1; j < arrayList.size(); ++j) {
                if (Integer.parseInt(arrayList.get(i).get(1)) != Integer.parseInt(arrayList.get(j).get(1)) || string.contains(arrayList.get(j).get(0))) continue;
                string = string + " " + arrayList.get(j).get(0);
            }
            if (string.contains(arrayList.get(i).get(1))) continue;
            string = string + "(" + arrayList.get(i).get(1) + ")";
        }
        return string;
    }

    private String getCRTTabSyntax() {
        boolean bl;
        Boolean bl2;
        boolean bl3;
        boolean bl4 = false;
        String string = "";
        String string2 = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/CRT");
        ISpssVariable iSpssVariable = this.getDependentVariable();
        boolean bl5 = bl3 = iSpssVariable != null && (iSpssVariable.getDisplayMeasurementLevel().value() == 1 || iSpssVariable.getDisplayMeasurementLevel().value() == 2);
        if (bl3) {
            bl2 = dialogDataModel.getBoolean("IDS_TREE_CRI_CRT_GINI_RADIO");
            if (bl2 != null && bl2.booleanValue()) {
                string2 = string2 + "GINI";
            } else if (bl2 == null) {
                bl4 = true;
            }
            bl2 = dialogDataModel.getBoolean("IDS_TREE_CRI_CRT_TWOING_RADIO");
            if (bl2 != null && bl2.booleanValue()) {
                string2 = string2 + "TWOING";
            } else if (bl2 == null) {
                bl4 = true;
            }
        }
        boolean bl6 = bl = iSpssVariable != null && iSpssVariable.getDisplayMeasurementLevel().value() == 2;
        if (bl) {
            bl2 = dialogDataModel.getBoolean("IDS_TREE_CRI_ORDER_RADIO");
            if (bl2 != null && bl2.booleanValue()) {
                string2 = string2 + "ORDEREDTWOING";
            } else if (bl2 == null) {
                bl4 = true;
            }
        }
        if (!string2.equals("")) {
            string = string + " IMPURITY=" + string2;
        }
        if (bl4) {
            string = string + " IMPURITY=GINI";
        }
        string = string + " MINIMPROVEMENT=";
        string2 = dialogDataModel.getString("");
        string = string2 != null ? string + string2 : string + "0.0001";
        return string;
    }

    private String getQUESTTabSyntax() {
        String string = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/QUEST");
        string = string + " ALPHASPLIT=";
        String string2 = dialogDataModel.getString("IDS_TREE_CRITERIA_QUEST_SIGN_LEVEL_EDIT");
        string = string2 != null ? string + string2 : string + "0.05";
        return string;
    }

    private String getCostSyntax() {
        String string = "";
        String string2 = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/COSTS ");
        Boolean bl = dialogDataModel.getBoolean("IDS_TREE_POT_CUSTOM");
        if (bl != null && bl.booleanValue()) {
            string2 = string2 + "CUSTOM=";
            SPSS_Format sPSS_Format = this.getDependentVariable().getFormat();
            Map<OBS, ArrayList<String>> map = TreeOptionsMisclassificationCostsTab.getDdmModelData(dialogDataModel);
            Vector vector = (Vector)this.mFormatter.getVarMap().get(this.getDependentVariable().getId().asInt());
            int n = 0;
            for (Categories categories : vector) {
                string2 = string2 + " ";
                String string3 = categories.getObs().isString() ? "'" : "";
                int n2 = 0;
                ArrayList<String> arrayList = this.getCostDataFromMap(map, categories.getObs());
                for (Categories categories2 : vector) {
                    if (arrayList == null) continue;
                    String string4 = CellValueFormatter.obsToString((OBS)categories.getObs(), (SPSS_Format)sPSS_Format);
                    String string5 = CellValueFormatter.obsToString((OBS)categories2.getObs(), (SPSS_Format)sPSS_Format);
                    if (!categories.getObs().isString()) {
                        string4 = UIToolResUtil.removeLocale((String)CellValueFormatter.obsToString((OBS)categories.getObs(), (SPSS_Format)sPSS_Format));
                    }
                    if (!categories2.getObs().isString()) {
                        string5 = UIToolResUtil.removeLocale((String)CellValueFormatter.obsToString((OBS)categories2.getObs(), (SPSS_Format)sPSS_Format));
                    }
                    string2 = string2 + string3 + string4 + string3 + " ";
                    string2 = string2 + string3 + string5 + string3;
                    string2 = string2 + " [" + arrayList.get(n2) + "] ";
                    ++n2;
                }
                ++n;
            }
        }
        string = string2.equals("") ? string + "EQUAL" : string + string2;
        return string;
    }

    private ArrayList<String> getCostDataFromMap(Map<OBS, ArrayList<String>> map, OBS oBS) {
        for (Map.Entry<OBS, ArrayList<String>> entry : map.entrySet()) {
            if (!entry.getKey().equals((Object)oBS)) continue;
            return entry.getValue();
        }
        return null;
    }

    private String getPriorSyntax() {
        String string = "";
        String string2 = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/PRIORS ");
        Boolean bl = dialogDataModel.getBoolean("IDS_TREE_OPT_PP_EQUAL");
        if (bl != null && bl.booleanValue()) {
            string2 = string2 + "EQUAL";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_TREE_OPT_PP_CUSTOM")) != null && bl.booleanValue()) {
            SerializableObject[] serializableObjectArray;
            string2 = string2 + "CUSTOM=";
            SPSS_Format sPSS_Format = this.getDependentVariable().getFormat();
            for (SerializableObject serializableObject : serializableObjectArray = dialogDataModel.getSerializableArray("IDS_TREE_PRIOR_PROB_TABLE_KEY")) {
                TableVariable tableVariable = (TableVariable)serializableObject;
                String string3 = tableVariable.getObs().isString() ? "'" : "";
                String string4 = CellValueFormatter.obsToString((OBS)tableVariable.getObs(), (SPSS_Format)sPSS_Format);
                if (!tableVariable.getObs().isString()) {
                    string4 = UIToolResUtil.removeLocale((String)string4);
                }
                string2 = string2 + string3 + string4 + string3 + " [" + tableVariable.getValue() + "] ";
            }
        }
        string = string2.equals("") ? string + "FROMDATA" : string + string2;
        string = string + " ADJUST=";
        bl = dialogDataModel.getBoolean("IDS_TREE_OPT_PP_ADJUST");
        string = bl != null && bl != false ? string + "YES" : string + "NO";
        return string;
    }

    private String getScoresSyntax() {
        String string = "";
        String string2 = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/SCORES ");
        Boolean bl = dialogDataModel.getBoolean("IDS_TREE_OPT_SCR_CUSTOM");
        if (bl != null && bl.booleanValue()) {
            SerializableObject[] serializableObjectArray;
            string2 = string2 + "CUSTOM=";
            SPSS_Format sPSS_Format = this.getDependentVariable().getFormat();
            for (SerializableObject serializableObject : serializableObjectArray = dialogDataModel.getSerializableArray("IDS_TREE_OPTIONS_SCORE_KEY")) {
                TableVariable tableVariable = (TableVariable)serializableObject;
                String string3 = tableVariable.getObs().isString() ? "'" : "";
                String string4 = CellValueFormatter.obsToString((OBS)tableVariable.getObs(), (SPSS_Format)sPSS_Format);
                if (!tableVariable.getObs().isString()) {
                    string4 = UIToolResUtil.removeLocale((String)string4);
                }
                string2 = string2 + string3 + string4 + string3 + " [" + tableVariable.getValue() + "] ";
            }
        }
        string = string2.equals("") ? string + "EQUALINCREMENTS" : string + string2;
        return string;
    }

    private String getProfitSyntax() {
        String string = "";
        String string2 = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/PROFITS ");
        Boolean bl = dialogDataModel.getBoolean("IDS_TREE_OPT_PROFIT_CUSTOM");
        if (bl != null && bl.booleanValue()) {
            SerializableObject[] serializableObjectArray;
            string2 = string2 + "CUSTOM=";
            SPSS_Format sPSS_Format = this.getDependentVariable().getFormat();
            for (SerializableObject serializableObject : serializableObjectArray = dialogDataModel.getSerializableArray("IDS_TREE_OPTIONS_PROFIT_KEY")) {
                TreeOptionsProfitsTab.RevExpVal revExpVal = (TreeOptionsProfitsTab.RevExpVal)serializableObject;
                String string3 = revExpVal.getOBS().isString() ? "'" : "";
                String string4 = CellValueFormatter.obsToString((OBS)revExpVal.getOBS(), (SPSS_Format)sPSS_Format);
                if (!revExpVal.getOBS().isString()) {
                    string4 = UIToolResUtil.removeLocale((String)string4);
                }
                string2 = string2 + string3 + string4 + string3 + " [" + revExpVal.getRevenue() + " " + revExpVal.getExpense() + "] ";
            }
        }
        if (string2.equals("")) {
            return "";
        }
        string = string + string2;
        return string;
    }

    private String getMissingSyntax() {
        String string = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        string = string + "\n" + SyntaxUtil.getSubCommand("/MISSING");
        string = string + " NOMINALMISSING=";
        Boolean bl = dialogDataModel.getBoolean("IDS_TREE_OPT_TREAT_AS_VALID");
        string = bl != null && bl != false ? string + "VALID" : string + "MISSING";
        return string;
    }

    private void enableButtons() {
        this.enableOkPaste(this.mDependentTargetVarList.getModel().getSize() > 0 && this.mInDependentTargetVarList.getModel().getSize() > 0);
        boolean bl = false;
        for (int i = 0; i < this.mInDependentTargetVarList.getModel().getSize(); ++i) {
            int n = this.mInDependentTargetVarList.getModel().getElementAt(i).getDisplayMeasurementLevel().value();
            if (n != 1) continue;
            bl = true;
        }
        if (this.mDependentTargetVarList.getModel().getSize() > 0) {
            if (!(this.mDependentTargetVarList.getModel().getElementAt(0).getDisplayMeasurementLevel().value() != 1 && this.mDependentTargetVarList.getModel().getElementAt(0).getDisplayMeasurementLevel().value() != 2 || this.isCategoryListEmpty())) {
                this.mCategories.setEnabled(true);
                this.mOptionButton.setEnabled(true);
            } else if (bl) {
                this.mCategories.setEnabled(false);
                this.mOptionButton.setEnabled(true);
            }
            if (this.mDependentTargetVarList.getModel().getElementAt(0).getDisplayMeasurementLevel().value() != 1 && this.mGrowingMethodCombo.getItemCount() > 3) {
                this.mGrowingMethodCombo.removeItemAt(this.mGrowingMethodCombo.getItemCount() - 1);
            }
            if (this.getCategoryTableModel().size() < 2) {
                this.mCategories.setEnabled(false);
                if (!bl) {
                    this.mOptionButton.setEnabled(false);
                }
            }
        } else if (bl) {
            this.mCategories.setEnabled(false);
            this.mOptionButton.setEnabled(true);
            if (this.mGrowingMethodCombo.getItemCount() == 3) {
                this.mGrowingMethodCombo.insertItemAt(this.getResString(GROWING_METHOD_QUEST), this.mGrowingMethodCombo.getItemCount());
            }
        } else {
            this.mCategories.setEnabled(false);
            this.mOptionButton.setEnabled(false);
            if (this.mGrowingMethodCombo.getItemCount() == 3) {
                this.mGrowingMethodCombo.insertItemAt(this.getResString(GROWING_METHOD_QUEST), this.mGrowingMethodCombo.getItemCount());
            }
        }
        this.mForceCheck.setEnabled(this.mInDependentTargetVarList.getModel().getSize() > 0);
    }

    private boolean isCategoryListEmpty() {
        Vector vector = (Vector)this.mFormatter.getVarMap().get(this.getDependentVariable().getId().asInt());
        return vector != null && vector.size() == 0;
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new TreeOptions(this));
    }

    private void runOutputSubDialog() {
        this.runSubDialog(new TreeOutput(this));
    }

    private void runCriteriaSubDialog() {
        this.runSubDialog(new TreeCriteria(this));
    }

    private void runSaveSubDialog() {
        this.runSubDialog(new TreeSave(this));
    }

    private void runValidationSubDialog() {
        this.runSubDialog(new TreeValidation(this));
    }

    private void runCategoriesSubDialog() {
        this.runSubDialog(new TreeCategories(this));
        this.putVarFormatterToDDM();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray(this.mDependentTargetVarList.getIdentifier());
        if (serializableObjectArray != null && serializableObjectArray.length > 0 && serializableObjectArray[0] instanceof Categories) {
            Vector<Categories> vector = new Vector<Categories>();
            for (SerializableObject serializableObject : serializableObjectArray) {
                vector.add((Categories)serializableObject);
            }
            this.mCategoryVector = vector;
        }
    }

    private JPanel setupLists() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TREE_VARIABLES");
        jLabel.setLabelFor(this.mSrcVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_TREE_DEPENDENT_VARIABLES");
        jLabel2.setLabelFor(this.mDependentTargetVarList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_TREE_INDEPENDENT_VARIABLES");
        jLabel3.setLabelFor(this.mInDependentTargetVarList);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_TREE_GROWING_METHOD");
        jLabel4.setLabelFor(this.mGrowingMethodCombo);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_TREE_CONTEXT_MENU_DESC_LABEL"));
        jTextArea.setEditable(false);
        jTextArea.setFont(this.mInfluenceLabel.getFont());
        jTextArea.setRows(3);
        jTextArea.setFocusable(false);
        jTextArea.setOpaque(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setRows(4);
        jTextArea.setColumns(14);
        jTextArea.setMinimumSize(new Dimension(160, 60));
        jTextArea.setPreferredSize(new Dimension(100, 50));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 7, n2, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 8, 1, 2, n2, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 20;
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDependentArrowButton, gridBagConstraints, 1, 0, 1, 2, n2, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n2, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDependentTargetScrollPane, gridBagConstraints, 2, 1, 1, 1, n2, null);
        insets2.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCategories, gridBagConstraints, 2, 2, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(2 * n, 0, 0, 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 3, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 10;
        insets = DialogUtil.getArrowButtonInsets();
        insets.set(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mInDependentArrowButton, gridBagConstraints, 1, 4, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 20;
        insets2.set(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mInfluenceArrowButton, gridBagConstraints, 1, 6, 1, 2, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n2 = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mInDependentTargetScrollPane, gridBagConstraints, 2, 4, 1, 1, n2, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mForceCheck, gridBagConstraints, 2, 5, 1, 1, n2, insets2);
        insets2.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mInfluenceLabel, gridBagConstraints, 2, 6, 1, 1, n2, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mInfluenceTargetScrollPane, gridBagConstraints, 2, 7, 1, 1, n2, null);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 8, 1, 1, n2, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mGrowingMethodCombo, gridBagConstraints, 2, 9, 1, 1, n2, null);
        return jPanel;
    }

    private void setFocusListeners() {
        int n;
        this.mSrcVarList.addFocusListener(this);
        this.mDependentArrowButton.addFocusListener(this);
        this.mInDependentArrowButton.addFocusListener(this);
        this.mInfluenceArrowButton.addFocusListener(this);
        this.mDependentTargetVarList.addFocusListener(this);
        this.mCategories.addFocusListener(this);
        this.mInDependentTargetVarList.addFocusListener(this);
        this.mForceCheck.addFocusListener(this);
        this.mInfluenceTargetVarList.addFocusListener(this);
        this.mGrowingMethodCombo.addFocusListener(this);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            if (!(this.mOptionButtonPanel.getComponent(n) instanceof JButton)) continue;
            this.mOptionButtonPanel.getComponent(n).addFocusListener(this);
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mCmdButtonPanel.getComponent(i).addFocusListener(this);
        }
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDependentArrowButton);
        vector.add(this.mInDependentArrowButton);
        vector.add(this.mInfluenceArrowButton);
        vector.add(this.mDependentTargetVarList);
        vector.add(this.mCategories);
        vector.add(this.mInDependentTargetVarList);
        vector.add(this.mForceCheck);
        vector.add(this.mInfluenceTargetVarList);
        vector.add(this.mGrowingMethodCombo);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            if (!(this.mOptionButtonPanel.getComponent(n) instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        super.setFocusTraversalPolicy((FocusTraversalPolicy)dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.enableOkPaste(false);
        this.mCategories.setEnabled(false);
        this.mOptionButton.setEnabled(false);
        this.mForceCheck.setEnabled(false);
        this.mForceCheck.setSelected(false);
        this.mDependentTargetVarList.getModel().removeAll();
        this.mInDependentTargetVarList.getModel().removeAll();
        this.mFormatter.clear();
        this.mInfluenceTargetVarList.removeAll();
        this.mGrowingMethodCombo.setSelectedIndex(0);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private boolean isValidateValues() {
        int n;
        this.isChangedCategory = false;
        ISpssVariable iSpssVariable = this.mDependentTargetVarList.getModel().getElementAt(0);
        int n2 = this.mCategoryVector.size();
        Vector vector = (Vector)this.mFormatter.getVarMap().get(this.getDependentVariable().getId().asInt());
        int n3 = n = vector != null ? vector.size() : 0;
        if (n2 < n) {
            String string = String.format(this.getResString("ERR_TREE_RESET"), iSpssVariable.getName());
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mTreeDlg), string, VersionInfo.getAppVersionString());
            this.isChangedCategory = true;
            return false;
        }
        if (n2 > 1 && n2 > n) {
            this.isChangedCategory = true;
            return true;
        }
        if (n2 > 0 && n2 == n) {
            for (int i = 0; i < n2; ++i) {
                Categories categories;
                Categories categories2 = categories = vector != null ? (Categories)vector.get(i) : null;
                if (categories != null && this.mCategoryVector.get(i).getObs().equals((Object)categories.getObs())) continue;
                String string = String.format(this.getResString("ERR_TREE_RESET"), iSpssVariable.getName());
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mTreeDlg), string, VersionInfo.getAppVersionString());
                this.isChangedCategory = true;
                return false;
            }
        }
        return true;
    }

    private boolean isSelectCustomButton() {
        boolean bl = false;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl2 = dialogDataModel.getBoolean("IDS_TREE_POT_CUSTOM");
        if (bl2 != null && bl2.booleanValue()) {
            return true;
        }
        bl2 = dialogDataModel.getBoolean("IDS_TREE_OPT_PROFIT_CUSTOM");
        if (bl2 != null && bl2.booleanValue()) {
            return true;
        }
        bl2 = dialogDataModel.getBoolean("IDS_TREE_OPT_PP_CUSTOM");
        if (bl2 != null && bl2.booleanValue()) {
            return true;
        }
        bl2 = dialogDataModel.getBoolean("IDS_TREE_OPT_SCR_CUSTOM");
        if (bl2 != null && bl2.booleanValue()) {
            return true;
        }
        return bl;
    }

    private void clearDataModel() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_TREE_POT_CUSTOM");
        if (bl != null && bl.booleanValue()) {
            dialogDataModel.putBoolean("IDS_TREE_POT_CUSTOM", false);
            TreeOptionsMisclassificationCostsTab.putDdmModelData(dialogDataModel, null);
        }
        if ((bl = dialogDataModel.getBoolean("IDS_TREE_OPT_PROFIT_CUSTOM")) != null && bl.booleanValue()) {
            dialogDataModel.putBoolean("IDS_TREE_OPT_PROFIT_CUSTOM", false);
            dialogDataModel.putSerializableArray("IDS_TREE_OPTIONS_PROFIT_KEY", null);
        }
        if ((bl = dialogDataModel.getBoolean("IDS_TREE_OPT_PP_CUSTOM")) != null && bl.booleanValue()) {
            dialogDataModel.putBoolean("IDS_TREE_OPT_PP_CUSTOM", false);
            dialogDataModel.putSerializableArray("IDS_TREE_PRIOR_PROB_TABLE_KEY", null);
            dialogDataModel.putBoolean("IDS_TREE_OPT_PP_ADJUST", false);
            dialogDataModel.putString("IDS_TREE_OPT_PP_SUM", null);
        }
        if ((bl = dialogDataModel.getBoolean("IDS_TREE_OPT_SCR_CUSTOM")) != null && bl.booleanValue()) {
            dialogDataModel.putBoolean("IDS_TREE_OPT_SCR_CUSTOM", false);
            dialogDataModel.putSerializableArray("IDS_TREE_OPTIONS_SCORE_KEY", null);
        }
    }

    private Vector<Categories> buildStringCategoryTableModel(ISpssVariable iSpssVariable) {
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        Vector<Categories> vector = new Vector<Categories>();
        this.mExcludeCategoryVector.clear();
        if (iValueLabelMap.size() > 0) {
            Set set = iValueLabelMap.getValueLabelEntries();
            OBS oBS = new OBS();
            OBS oBS2 = new OBS();
            OBS oBS3 = new OBS();
            for (Map.Entry entry : set) {
                String string;
                String string2;
                OBS oBS4 = (OBS)entry.getKey();
                String string3 = oBS4.getString();
                String string4 = (String)entry.getValue();
                ISpssVariable.Rule rule = iSpssVariable.getMissingValues(oBS, oBS2, oBS3);
                if (rule.value() == ISpssVariable.Rule.three.value()) {
                    string2 = oBS.getString();
                    string = oBS2.getString();
                    String string5 = oBS3.getString();
                    if (!(string3.equals(string5) || string3.equals(string2) || string3.equals(string))) {
                        vector.add(new Categories(oBS4, string4));
                        continue;
                    }
                    if (iSpssVariable.getDisplayMeasurementLevel().value() != 1) continue;
                    this.mExcludeCategoryVector.add(new Categories(oBS4, string4));
                    continue;
                }
                if (rule.value() == ISpssVariable.Rule.two.value()) {
                    string2 = oBS.getString();
                    string = oBS2.getString();
                    if (!string3.equals(string2) && !string3.equals(string)) {
                        vector.add(new Categories(oBS4, string4));
                        continue;
                    }
                    if (iSpssVariable.getDisplayMeasurementLevel().value() != 1) continue;
                    this.mExcludeCategoryVector.add(new Categories(oBS4, string4));
                    continue;
                }
                if (rule.value() == ISpssVariable.Rule.one.value()) {
                    string2 = oBS.getString();
                    if (!string3.equals(string2)) {
                        vector.add(new Categories(oBS4, string4));
                        continue;
                    }
                    if (iSpssVariable.getDisplayMeasurementLevel().value() != 1) continue;
                    this.mExcludeCategoryVector.add(new Categories(oBS4, string4));
                    continue;
                }
                vector.add(new Categories(oBS4, string4));
            }
        }
        Collections.sort(vector, new CategoriesTableSorter());
        return vector;
    }

    private Vector<ISpssVariable> getIndependentScaleVariable() {
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        boolean bl = false;
        for (int i = 0; i < this.mInDependentTargetVarList.getModel().getSize(); ++i) {
            int n = this.mInDependentTargetVarList.getModel().getElementAt(i).getDisplayMeasurementLevel().value();
            if (n != 0 && n != 3) continue;
            vector.add(this.mInDependentTargetVarList.getModel().getElementAt(i));
        }
        return vector;
    }

    private Vector<Categories> buildNumericCategoryTableModel(ISpssVariable iSpssVariable) {
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        Vector<Categories> vector = new Vector<Categories>();
        this.mExcludeCategoryVector.clear();
        if (iValueLabelMap.size() > 0) {
            Set set = iValueLabelMap.getValueLabelEntries();
            OBS oBS = new OBS();
            OBS oBS2 = new OBS();
            OBS oBS3 = new OBS();
            for (Map.Entry entry : set) {
                double d;
                double d2;
                double d3;
                OBS oBS4 = (OBS)entry.getKey();
                double d4 = oBS4.getNum();
                String string = (String)entry.getValue();
                ISpssVariable.Rule rule = iSpssVariable.getMissingValues(oBS, oBS2, oBS3);
                if (rule == ISpssVariable.Rule.range_plus) {
                    d3 = oBS.getNum();
                    d2 = oBS2.getNum();
                    d = oBS3.getNum();
                    if (d4 != d && (d4 < d3 || d4 > d2)) {
                        vector.add(new Categories(oBS4, string));
                        continue;
                    }
                    if (iSpssVariable.getDisplayMeasurementLevel().value() != 1) continue;
                    this.mExcludeCategoryVector.add(new Categories(oBS4, string));
                    continue;
                }
                if (rule == ISpssVariable.Rule.range) {
                    d3 = oBS.getNum();
                    d2 = oBS2.getNum();
                    if (d4 < d3 || d4 > d2) {
                        vector.add(new Categories(oBS4, string));
                        continue;
                    }
                    if (iSpssVariable.getDisplayMeasurementLevel().value() != 1) continue;
                    this.mExcludeCategoryVector.add(new Categories(oBS4, string));
                    continue;
                }
                if (rule == ISpssVariable.Rule.three) {
                    d3 = oBS.getNum();
                    d2 = oBS2.getNum();
                    d = oBS3.getNum();
                    if (d4 != d && d4 != d3 && d4 != d2) {
                        vector.add(new Categories(oBS4, string));
                        continue;
                    }
                    if (iSpssVariable.getDisplayMeasurementLevel().value() != 1) continue;
                    this.mExcludeCategoryVector.add(new Categories(oBS4, string));
                    continue;
                }
                if (rule == ISpssVariable.Rule.two) {
                    d3 = oBS.getNum();
                    d2 = oBS2.getNum();
                    if (d4 != d3 && d4 != d2) {
                        vector.add(new Categories(oBS4, string));
                        continue;
                    }
                    if (iSpssVariable.getDisplayMeasurementLevel().value() != 1) continue;
                    this.mExcludeCategoryVector.add(new Categories(oBS4, string));
                    continue;
                }
                if (rule == ISpssVariable.Rule.one) {
                    d3 = oBS.getNum();
                    if (d4 != d3) {
                        vector.add(new Categories(oBS4, string));
                        continue;
                    }
                    if (iSpssVariable.getDisplayMeasurementLevel().value() != 1) continue;
                    this.mExcludeCategoryVector.add(new Categories(oBS4, string));
                    continue;
                }
                vector.add(new Categories(oBS4, string));
            }
        }
        Collections.sort(vector, new CategoriesTableSorter());
        return vector;
    }

    private class WeightVarFilter
    implements IVarFilter {
        private WeightVarFilter() {
        }

        @Override
        public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
            LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.getWeightVarIndex();
            if (n >= 0) {
                ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(n);
                if (iSpssVariable != null && iSpssVariable2 != null && iSpssVariable.getId().equals((Object)iSpssVariable2.getId())) {
                    return false;
                }
            }
            return true;
        }
    }

    class MaximumDependentCategories
    extends SpssAlertDialog {
        public MaximumDependentCategories(BaseProcedureDialog baseProcedureDialog, String string, String string2) {
            super(baseProcedureDialog, baseProcedureDialog.getResourceBundle(), string, string2, SpssAlertOptionPane.IconType.eWarning);
            TreeDlg.this.mCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MaximumDependentCategories.this.setVisible(false);
                    MaximumDependentCategories.this.dispose();
                }
            });
            TreeDlg.this.mDefineCategories.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MaximumDependentCategories.this.setVisible(false);
                    MaximumDependentCategories.this.dispose();
                    TreeDlg.this.runCategoriesSubDialog();
                }
            });
            this.setLocationRelativeTo(this.getParent());
            this.setVisible(true);
        }

        @Override
        protected JPanel setupCmdButtons() {
            JPanel jPanel = new JPanel(true);
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new FlowLayout(2, 5, 0));
                jPanel.add(TreeDlg.this.mCancel);
                jPanel.add(TreeDlg.this.mDefineCategories);
            } else {
                jPanel.setLayout(new FlowLayout(1, 5, 0));
                jPanel.add(TreeDlg.this.mDefineCategories);
                jPanel.add(TreeDlg.this.mCancel);
            }
            return jPanel;
        }
    }

    class DependentVarFormatter
    extends SpssVarFormatter {
        public DependentVarFormatter(TargetVariableList targetVariableList) {
            super(targetVariableList);
        }

        @Override
        public String getDisplayText(ISpssVariable iSpssVariable) {
            return iSpssVariable.getName();
        }
    }

    public static class Categories
    implements SerializableObject,
    Cloneable {
        String label = "";
        OBS obs;
        boolean targetCategory = false;

        public Categories() {
            this.label = "";
            this.obs = new OBS();
            this.targetCategory = false;
        }

        public Categories(String string) {
            this.label = string;
        }

        public Categories(OBS oBS, String string) {
            this.obs = oBS;
            this.label = string;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String string) {
            this.label = string;
        }

        public boolean isTargetCategory() {
            return this.targetCategory;
        }

        public void setTargetCategory(boolean bl) {
            this.targetCategory = bl;
        }

        public OBS getObs() {
            return this.obs;
        }

        protected Categories clone() throws CloneNotSupportedException {
            Categories categories = (Categories)super.clone();
            categories.obs = (OBS)this.obs.clone();
            return categories;
        }

        public String getClassName() {
            return "com.spss.java_client.ui.dialogs.trees.TreeDlg$Categories";
        }

        public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
            this.label = objectInputStream.readUTF();
            this.targetCategory = objectInputStream.readBoolean();
            this.obs = DocUtil.readObs(objectInputStream);
            if (this.obs == null) {
                this.obs = new OBS();
                return false;
            }
            return true;
        }

        public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
            objectOutputStream.writeUTF(this.label);
            objectOutputStream.writeBoolean(this.targetCategory);
            return DocUtil.writeObs(objectOutputStream, this.obs);
        }
    }

    public class CategoriesTableSorter
    implements Comparator<Categories> {
        @Override
        public int compare(Categories categories, Categories categories2) {
            OBS oBS = categories.getObs();
            OBS oBS2 = categories2.getObs();
            return oBS.compareTo((Object)oBS2);
        }
    }

    class DependentVarListModel
    extends CustomVarListModel {
        public DependentVarListModel(SpssVarFormatter spssVarFormatter) {
            super(spssVarFormatter);
        }

        @Override
        public boolean addElement(ISpssVariable iSpssVariable) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), TreeDlg.this.buildCategoryTableModel(iSpssVariable));
            return super.addElement(iSpssVariable);
        }

        @Override
        public void fireContentsChanged(Object object, int n, int n2) {
            super.fireContentsChanged(object, n, n2);
        }
    }

    class varTargetMoveHandler
    implements IVarMoveHandler {
        varTargetMoveHandler() {
        }

        @Override
        public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                ISpssVariable[] iSpssVariableArray2;
                boolean bl = false;
                if (variableList.equals(TreeDlg.this.mSrcVarList)) {
                    ArrayList<ISpssVariable> arrayList;
                    iSpssVariableArray2 = TreeDlg.this.mInDependentTargetVarList.getSelectedValues();
                    ArrayList<ISpssVariable> arrayList2 = new ArrayList<ISpssVariable>(Arrays.asList(iSpssVariableArray));
                    if (arrayList2.equals(arrayList = new ArrayList<ISpssVariable>(Arrays.asList(iSpssVariableArray2)))) {
                        bl = true;
                    }
                }
                if (!(iSpssVariableArray2 = iSpssVariable.getDisplayMeasurementLevel()).equals((Object)MeasurementLevel.nominal) && TreeDlg.this.mGrowingMethodCombo.getSelectedIndex() == 3 && variableList.equals(TreeDlg.this.mDependentTargetVarList)) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)TreeDlg.this.mTreeDlg), TreeDlg.this.getResString("ERR_TREE_WRNING_MSG"), VersionInfo.getAppVersionString());
                    return false;
                }
                if ((variableList.equals(TreeDlg.this.mDependentTargetVarList) || variableList.equals(TreeDlg.this.mInDependentTargetVarList)) && iSpssVariableArray2.equals((Object)MeasurementLevel.ordinal) && iSpssVariable.getType() > 0) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)TreeDlg.this.mTreeDlg), TreeDlg.this.getResString("IDS_TREE_ORDINAL_STRING_NOT_ACCEPTED_WRNING_MSG"), VersionInfo.getAppVersionString());
                    return false;
                }
                if (bl && (iSpssVariableArray2.equals((Object)MeasurementLevel.ordinal) || iSpssVariableArray2.equals((Object)MeasurementLevel.nominal) || iSpssVariableArray2.equals((Object)MeasurementLevel.scale))) {
                    return true;
                }
                if (variableList.equals(TreeDlg.this.mInDependentTargetVarList) || !TreeDlg.this.mOptionButton.isEnabled() || !iSpssVariableArray2.equals((Object)MeasurementLevel.ordinal) && !iSpssVariableArray2.equals((Object)MeasurementLevel.nominal) || !TreeDlg.this.isSelectCustomButton()) continue;
                if (SpssAlertOptionPane.showConfirmDialog((Window)((Object)TreeDlg.this.mTreeDlg), TreeDlg.this.getResString("ERR_TREE_CUSTOM_CATE_DEP_VAR_LOST_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) == 0) {
                    TreeDlg.this.clearDataModel();
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

