/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class TreeCriteriaSurrogatesTab
extends BaseProcedureTab
implements ItemListener,
FocusListener {
    static final int NUMBER_OF_ROWS = 2;
    static final int NUMBER_OF_COLUMN = 6;
    static final String AUTOMATIC_RADIO_KEY = "IDS_TREE_CRI_SGATES_AUTOMATIC_RADIO";
    static final String ALLOW_RADIO_KEY = "IDS_TREE_CRI_SGATES_CUSTOM_RADIO";
    static final String VALUE_EDIT_KEY = "IDS_TREE_CRI_SGATES_VALUE_TEXT";
    private JRadioButton mAutomaticRadio;
    private JRadioButton mCustomRadio;
    private JLabel mValueLabel;
    private IntTextField mValueText;
    private SpssButtonGroup mGroup;

    public TreeCriteriaSurrogatesTab(BaseTabbedSubDialog baseTabbedSubDialog) {
        super(baseTabbedSubDialog, true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mValueText)) {
            this.mValueText.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mValueText.setSelectionStart(0);
        this.mValueText.setSelectionEnd(0);
    }

    public boolean isValidate() {
        boolean bl = true;
        if (this.mValueText.isEnabled() && this.mValueText.getText().length() < 1) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_CRI_GL_WRNING_MSG"), VersionInfo.getAppVersionString());
            TreeDlg.setSelectionText((JTextField)this.mValueText);
            bl = false;
        }
        return bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mCustomRadio) {
            this.mValueLabel.setEnabled(this.mCustomRadio.isSelected());
            this.mValueText.setEnabled(this.mCustomRadio.isSelected());
            this.mValueText.setOpaque(this.mCustomRadio.isSelected());
        }
    }

    @Override
    public boolean validateTab() {
        return this.isValidate();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_criteria_surrogates";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        if (this.mAutomaticRadio.isSelected()) {
            return this.mAutomaticRadio;
        }
        return this.mCustomRadio;
    }

    @Override
    protected void aboutToShowTab() {
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeCriteriaSurrogatesTab.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, n2, n2);
        JPanel jPanel = this.setupMaxSurrogatesPanel();
        this.mGroup = DialogUtil.createButtonGroup(jPanel);
        DialogUtil.addUsingGBLOnSpssTab(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_TREE_CRI_SGATES_ARE_USED_LABEL"));
        jTextArea.setRows(2);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setOpaque(false);
        jTextArea.setFont(this.mCustomRadio.getFont());
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(insets.top, insets.left, 0, n2);
        DialogUtil.addUsingGBLOnSpssTab(this, jTextArea, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.setFocusTraversalPolicy();
    }

    private JPanel setupMaxSurrogatesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_TREE_CRI_SGATES_MAX_SGATES"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mAutomaticRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mCustomRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel2 = this.setupValuePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Insets insets2 = new Insets(insets.top, 8 * insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupValuePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mValueLabel, gridBagConstraints, 0, 3, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, (JComponent)this.mValueText, gridBagConstraints, 1, 3, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mGroup);
        vector.add(this.mValueText);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void setDefaults() {
        this.mAutomaticRadio.setSelected(true);
        this.mValueLabel.setEnabled(false);
        this.mValueText.setEnabled(false);
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, AUTOMATIC_RADIO_KEY);
        this.mAutomaticRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, ALLOW_RADIO_KEY);
        this.mCustomRadio = new JRadioButton(toggleButtonAction);
        this.mCustomRadio.addItemListener(this);
        this.mValueText = new IntTextField(true);
        this.mValueText.setAction((Action)new TextFieldAction(this.mParent, VALUE_EDIT_KEY));
        this.mValueText.setColumns(6);
        this.mValueText.addFocusListener((FocusListener)this);
        this.mValueLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_CRI_SGATES_VALUE_LABEL");
        this.mValueLabel.setLabelFor((Component)this.mValueText);
    }
}

