/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.trees.TreeCriteria;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TreeCriteriaQuestTab
extends BaseProcedureTab
implements FocusListener {
    static final int NUMBER_OF_ROWS = 2;
    static final int NUMBER_OF_COLUMN = 5;
    static final String SIGN_LEVEL_EDIT = "IDS_TREE_CRITERIA_QUEST_SIGN_LEVEL_EDIT";
    static final String SIGN_LEVEL_EDIT_DEFAULT_VALUE = "0.05";
    private FloatTextField mSignLevelText;

    public TreeCriteriaQuestTab(BaseTabbedSubDialog baseTabbedSubDialog) {
        super(baseTabbedSubDialog, true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        TreeDlg.setSelectionText((JTextField)this.mSignLevelText);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mSignLevelText.setSelectionStart(0);
        this.mSignLevelText.setSelectionEnd(0);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_criteria_quest";
    }

    public boolean isValidate() {
        boolean bl = true;
        if (this.mSignLevelText.getText().length() < 1 || Double.valueOf(this.mSignLevelText.getText()) <= 0.0 || Double.valueOf(this.mSignLevelText.getText()) >= 1.0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_CRI_QUEST_WRNING_MSG"), VersionInfo.getAppVersionString());
            TreeDlg.setSelectionText((JTextField)this.mSignLevelText);
            return false;
        }
        return bl;
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mSignLevelText;
    }

    @Override
    protected void aboutToShowTab() {
        this.mSignLevelText.setOpaque(true);
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeCriteriaQuestTab.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected boolean validateTab() {
        return this.isValidate();
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        JPanel jPanel = this.setupTextPanel();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(6 * n2, 2 * n2, n2, n2);
        DialogUtil.addUsingGBLOnSpssTab(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_TREE_CRI_QUEST_AN_INDEPENDENT"));
        jTextArea.setRows(2);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setOpaque(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        insets.set(n2, 2 * n2, 0, n2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBLOnSpssTab(this, jTextArea, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSignLevelText);
        JPanel jPanel = ((TreeCriteria)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (component instanceof JButton) {
                vector.add(component);
            }
            this.setComponentOrder(vector);
        }
    }

    private void initVars() {
        this.mSignLevelText = new FloatTextField(0.0, 1.0, 2);
        this.mSignLevelText.setIncludeMinRange(false);
        this.mSignLevelText.setIncludeMaxRange(false);
        this.mSignLevelText.setColumns(5);
        this.mSignLevelText.setAction((Action)new TextFieldAction(this.mParent, SIGN_LEVEL_EDIT));
        this.mSignLevelText.setText(SIGN_LEVEL_EDIT_DEFAULT_VALUE);
        this.mSignLevelText.addFocusListener((FocusListener)this);
    }

    private JPanel setupTextPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_CRI_QUEST_SIGN_LABEL");
        jLabel.setLabelFor((Component)this.mSignLevelText);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, (JComponent)this.mSignLevelText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }
}

