/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trees.TreeCriteria;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TreeCriteriaPruningTab
extends BaseProcedureTab
implements ItemListener,
FocusListener {
    static final int NUMBER_OF_ROWS = 8;
    static final String MAX_DIFF_DEFAULT_VALUE = "1";
    static final String PRUNE_CHECK_KEY = "IDS_TREE_CRI_PRUN_PRUNE_TREE_CHECK";
    static final String MAX_DIFF_EDIT = "IDS_TREE_CRITERIA_PRUNING_MAX_DIFF_EDIT";
    private JCheckBox mPruneTreeCheck;
    private JLabel mMaximumDiffLabel;
    private FloatTextField mMaxDiffText;

    public TreeCriteriaPruningTab(BaseTabbedSubDialog baseTabbedSubDialog) {
        super(baseTabbedSubDialog, true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mMaxDiffText)) {
            this.mMaxDiffText.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mMaxDiffText.setSelectionStart(0);
        this.mMaxDiffText.setSelectionEnd(0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mPruneTreeCheck) {
            this.mMaximumDiffLabel.setEnabled(this.mPruneTreeCheck.isSelected());
            this.mMaxDiffText.setEnabled(this.mPruneTreeCheck.isSelected());
            this.mMaxDiffText.setOpaque(this.mPruneTreeCheck.isSelected());
        }
    }

    public boolean isValidate() {
        boolean bl = true;
        if (this.mMaxDiffText.isEnabled() && (this.mMaxDiffText.getText().length() < 1 || this.mMaxDiffText.getText().startsWith("."))) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_CRI_PRUN_MAX_DIFF_WRNING_MSG"), VersionInfo.getAppVersionString());
            TreeDlg.setSelectionText((JTextField)this.mMaxDiffText);
            return false;
        }
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_criteria_prune";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mPruneTreeCheck;
    }

    @Override
    protected void aboutToShowTab() {
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeCriteriaPruningTab.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected boolean validateTab() {
        return this.isValidate();
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets3 = new Insets(insets2.top, insets2.left, insets2.bottom, insets2.right);
        DialogUtil.addUsingGBLOnSpssTab(this, this.mPruneTreeCheck, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        JPanel jPanel = this.setupTextLabelPanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets4 = new Insets(insets.top, 8 * insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(this, jPanel, gridBagConstraints, 0, 1, 1, 1, n, insets4);
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPruneTreeCheck);
        vector.add(this.mMaxDiffText);
        JPanel jPanel = ((TreeCriteria)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (component instanceof JButton) {
                vector.add(component);
            }
            this.setComponentOrder(vector);
        }
    }

    private void setDefaults() {
        this.mMaximumDiffLabel.setEnabled(false);
        this.mMaxDiffText.setEnabled(false);
        this.mMaxDiffText.setText(MAX_DIFF_DEFAULT_VALUE);
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, PRUNE_CHECK_KEY);
        this.mPruneTreeCheck = new JCheckBox(toggleButtonAction);
        this.mPruneTreeCheck.addItemListener(this);
        this.mMaxDiffText = new FloatTextField(true);
        this.mMaxDiffText.setAction((Action)new TextFieldAction(this.mParent, MAX_DIFF_EDIT));
        this.mMaxDiffText.addFocusListener((FocusListener)this);
        this.mMaximumDiffLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_CRI_PRUN_MAX_DIFF_LABEL");
        this.mMaximumDiffLabel.setLabelFor((Component)this.mMaxDiffText);
    }

    private JPanel setupTextLabelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        JPanel jPanel2 = this.setupPanel();
        Insets insets = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_TREE_CRI_PRUN_TEXT"));
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setOpaque(false);
        jTextArea.setFont(this.mPruneTreeCheck.getFont());
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setMinimumSize(new Dimension(300, 200));
        jTextArea.setPreferredSize(new Dimension(300, 200));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(n, 0, 0, 0);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, jTextArea, gridBagConstraints, 0, 1, 2, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mMaximumDiffLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, (JComponent)this.mMaxDiffText, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        return jPanel;
    }
}

