/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.VarInfoBag;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trees.TreeCriteria;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class TreeCriteriaIntervalsTab
extends BaseProcedureTab
implements ItemListener,
FocusListener {
    static final int NUMBER_OF_COLUMN = 6;
    static final int TABLE_HEIGHT = 120;
    static final int TABLE_WIDTH = 400;
    static final int TABLE_ROW = 100;
    static final int TABLE_ROWHEIGHT = 100;
    static final String FIXED_RADIO_KEY = "IDS_TREE_CRI_INVALS_FIXED";
    static final String CUSTOM_RADIO_KEY = "IDS_TREE_CRI_INVALS_CUSTOM";
    static final String VALUE_DEFAULT = "10";
    static final String VALUE_EDIT = "IDS_TREE_CRITERIA_INTERVAL_VALUE_EDIT";
    static final String INTERVAL_TABLE_KEY = "IDS_TREE_CRITERIA_INTERVAL_VALUE_EDIT";
    private JRadioButton mFixedNoRadio;
    private JRadioButton mCustomRadio;
    private SpssButtonGroup mGroup;
    private JLabel mValueLabel;
    private IntTextField mValueText;
    private JLabel mIntervalsLabel;
    private JTable mTable;
    private JScrollPane mScrollPane;
    private boolean mMessageFlag;
    private boolean mShowLabels;

    public TreeCriteriaIntervalsTab(BaseTabbedSubDialog baseTabbedSubDialog) {
        super(baseTabbedSubDialog, true);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mValueText.setSelectionStart(0);
        this.mValueText.setSelectionEnd(0);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        TableCellEditor tableCellEditor = this.mTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
            this.mTable.getSelectionModel().clearSelection();
        }
        if (focusEvent.getSource().equals(this.mValueText)) {
            this.mValueText.selectAll();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mFixedNoRadio || itemEvent.getSource() == this.mCustomRadio) {
            if (this.mFixedNoRadio.isSelected()) {
                this.mValueText.setEnabled(true);
                this.mValueText.setOpaque(true);
                this.mValueLabel.setEnabled(true);
                this.mTable.setEnabled(false);
                this.mScrollPane.getVerticalScrollBar().setEnabled(false);
                this.mIntervalsLabel.setEnabled(false);
            } else {
                this.mValueText.setEnabled(false);
                this.mValueLabel.setEnabled(false);
                this.mValueText.setOpaque(false);
                this.mTable.setEnabled(true);
                this.mScrollPane.getVerticalScrollBar().setEnabled(true);
                this.mIntervalsLabel.setEnabled(true);
            }
        }
    }

    @Override
    public boolean validateTab() {
        return this.isValidate();
    }

    public boolean isValidate() {
        boolean bl = true;
        try {
            this.mMessageFlag = false;
            if (this.mCustomRadio.isSelected()) {
                for (int i = 0; i < this.mTable.getModel().getRowCount(); ++i) {
                    for (int j = 0; j < this.mTable.getModel().getColumnCount(); ++j) {
                        if (j <= 0) continue;
                        TableCellEditor tableCellEditor = this.mTable.getCellEditor();
                        if (tableCellEditor != null) {
                            tableCellEditor.stopCellEditing();
                            this.mTable.getSelectionModel().clearSelection();
                            if (this.mMessageFlag) {
                                this.mMessageFlag = false;
                                return false;
                            }
                        }
                        if (!this.mTable.getModel().getValueAt(i, j).toString().equals("")) continue;
                        if (this.mMessageFlag) {
                            return false;
                        }
                        SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_CRI_INVALS_RANGE_WRNING_MSG"), VersionInfo.getAppVersionString());
                        this.mMessageFlag = false;
                        return false;
                    }
                }
            } else if (this.mValueText.isEnabled() && (this.mValueText.getText().length() == 0 || Integer.valueOf(this.mValueText.getText()) < 2 || Integer.valueOf(this.mValueText.getText()) > 64)) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("IDS_TREE_CRI_INVALS_RANGE_WRNING_MSG"), VersionInfo.getAppVersionString());
                TreeDlg.setSelectionText((JTextField)this.mValueText);
                return false;
            }
        }
        catch (Exception exception) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_CRI_INVALS_RANGE_WRNING_MSG"), VersionInfo.getAppVersionString());
            bl = false;
        }
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_criteria_intervals";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        if (this.mFixedNoRadio.isSelected()) {
            return this.mFixedNoRadio;
        }
        return this.mCustomRadio;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        TreeDlg treeDlg = (TreeDlg)((Object)this.mParent.getParent());
        DialogDataModel dialogDataModel = treeDlg.getDialogDataModel();
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("IDS_TREE_CRITERIA_INTERVAL_VALUE_EDIT");
        Vector<IntervalTableVar> vector = new Vector<IntervalTableVar>();
        TreeDlg.DependentVarFormatter dependentVarFormatter = treeDlg.getDepVarListFormatter();
        Vector<IntervalTableVar> vector2 = this.getIndependentVar();
        if (serializableObjectArray != null) {
            int n = serializableObjectArray.length;
            int n2 = vector2.size();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                boolean bl = false;
                for (int j = 0; j < n; ++j) {
                    if (!vector2.get(i).getSpssVar().getName().equals(((IntervalTableVar)serializableObjectArray[j]).getSpssVar().getName())) continue;
                    bl = true;
                    n3 = j;
                    break;
                }
                if (bl) {
                    vector.add((IntervalTableVar)serializableObjectArray[n3]);
                    continue;
                }
                vector.add(new IntervalTableVar(vector2.get(i).getSpssVar()));
            }
            ((TableModel)this.mTable.getModel()).setTableData(vector);
        }
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeCriteriaIntervalsTab.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        Vector<IntervalTableVar> vector = ((TableModel)this.mTable.getModel()).getTableData();
        SerializableObject[] serializableObjectArray = new SerializableObject[vector.size()];
        dialogDataModel.putSerializableArray("IDS_TREE_CRITERIA_INTERVAL_VALUE_EDIT", vector.toArray(serializableObjectArray));
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel = this.setupIntervalsPanel();
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 3, 1, n, insets2);
        this.setFocusTraversalPolicy();
    }

    private Vector<IntervalTableVar> getIndependentVar() {
        Vector<IntervalTableVar> vector = new Vector<IntervalTableVar>();
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        TreeCriteria treeCriteria = (TreeCriteria)this.mParent;
        DialogDataModel dialogDataModel = ((TreeDlg)((Object)treeCriteria.getParent())).getDialogDataModel();
        this.mShowLabels = ((TreeDlg)((Object)treeCriteria.getParent())).canShowVarLabels();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_TREE_INDEPENDENT_VAR_LIST");
        if (iSpssVariableArray != null) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (iSpssVariable.getMeasurementLevel().value() != 3) continue;
                IntervalTableVar intervalTableVar = new IntervalTableVar(iSpssVariable);
                vector.addElement(intervalTableVar);
            }
        }
        return vector;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mGroup);
        vector.add(this.mValueText);
        vector.add(this.mTable);
        this.setComponentOrder(vector);
    }

    private void setDefaults() {
        this.mFixedNoRadio.setSelected(true);
        this.mValueText.setText(VALUE_DEFAULT);
        TableModel tableModel = new TableModel(this.getIndependentVar());
        this.mTable.setModel(tableModel);
    }

    private void initVars() {
        Serializable serializable;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, FIXED_RADIO_KEY);
        this.mFixedNoRadio = new JRadioButton(toggleButtonAction);
        this.mFixedNoRadio.addItemListener(this);
        this.mFixedNoRadio.addFocusListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, CUSTOM_RADIO_KEY);
        this.mCustomRadio = new JRadioButton(toggleButtonAction);
        this.mCustomRadio.addItemListener(this);
        this.mValueText = new IntTextField(true);
        this.mValueText.setAction((Action)new TextFieldAction(this.mParent, "IDS_TREE_CRITERIA_INTERVAL_VALUE_EDIT"));
        this.mValueText.setColumns(6);
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            serializable = this.mValueText.getMinimumSize();
            serializable.width *= 10;
            this.mValueText.setMinimumSize(serializable);
        }
        this.mValueText.addFocusListener((FocusListener)this);
        serializable = new TableModel(this.getIndependentVar());
        this.mTable = new JTable((javax.swing.table.TableModel)((Object)serializable)){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                final Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    if (eventObject == null) {
                        ((JTextComponent)component).selectAll();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)component).selectAll();
                            }
                        });
                    }
                }
                return bl;
            }
        };
        this.mTable.setDefaultRenderer(Object.class, new TableRenderer());
        this.mTable.setPreferredScrollableViewportSize(new Dimension(400, 120));
        this.mTable.setRowHeight(100, 100);
        this.mScrollPane = new JScrollPane(this.mTable);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mTable.getTableHeader().setResizingAllowed(false);
        this.mTable.setGridColor(Color.darkGray);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mScrollPane = new JScrollPane(this.mTable);
        this.mValueLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_CRI_INVALS_VALUE");
        this.mValueLabel.setLabelFor((Component)this.mValueText);
        this.mIntervalsLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_CRI_INVALS_INTERVALS");
        this.mIntervalsLabel.setLabelFor(this.mTable);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mTable.getActionMap().put("tabIn", abstractAction2);
        this.mTable.getActionMap().put("tabOut", abstractAction);
    }

    private JPanel setupIntervalsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_TREE_CRI_INVALS_INTERVALS_TITLE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFixedNoRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = this.setupValuePanel();
        Insets insets2 = new Insets(n2 - 6, n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCustomRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets2.set(insets.top, 8 * insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mIntervalsLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(insets.top, 8 * insets.left, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 3, 3, 1, n, insets2);
        this.mGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupValuePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mValueLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValueText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    public static class IntervalTableVar
    implements SerializableObject {
        ISpssVariable mVariable;
        String mInterval = "10";

        public IntervalTableVar() {
            this.mVariable = null;
            this.mInterval = null;
        }

        public IntervalTableVar(ISpssVariable iSpssVariable) {
            this.mVariable = iSpssVariable;
        }

        public String getInterval() {
            return this.mInterval;
        }

        public void setInterval(String string) {
            this.mInterval = string;
        }

        public ISpssVariable getSpssVar() {
            return this.mVariable;
        }

        public String getClassName() {
            return "com.spss.java_client.ui.dialogs.trees.TableVariable.TreeCriteriaIntervalsTab$IntervalTableVar";
        }

        public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
            this.mInterval = objectInputStream.readUTF();
            VarInfoBag varInfoBag = new VarInfoBag();
            boolean bl = varInfoBag.readVersionedObject(objectInputStream, n);
            if (bl) {
                this.mVariable = DialogDataModel.varBagToVariable(varInfoBag);
            }
            return bl;
        }

        public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
            objectOutputStream.writeUTF(this.mInterval);
            VarInfoBag varInfoBag = new VarInfoBag(this.mVariable);
            return varInfoBag.writeVersionedObject(objectOutputStream, n);
        }
    }

    class TableModel
    extends AbstractTableModel {
        IntervalTableVar var;
        Vector<IntervalTableVar> vector;
        private String[] columnNames;

        public TableModel(Vector<IntervalTableVar> vector) {
            this.columnNames = new String[]{TreeCriteriaIntervalsTab.this.getResString("IDS_TREE_CRI_VARIABLE"), TreeCriteriaIntervalsTab.this.getResString("IDS_TREE_CRI_INTERVALS")};
            this.vector = vector;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Vector<IntervalTableVar> getTableData() {
            return this.vector;
        }

        public void setTableData(Vector<IntervalTableVar> vector) {
            this.vector = vector;
        }

        @Override
        public int getRowCount() {
            return this.vector.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            this.var = this.vector.get(n);
            if (n2 == 1) {
                return this.var.getInterval();
            }
            if (TreeCriteriaIntervalsTab.this.mShowLabels) {
                return this.var.getSpssVar().getLabel() != null && this.var.getSpssVar().getLabel().trim().length() > 0 ? this.var.getSpssVar().getLabel() : this.var.getSpssVar().getName();
            }
            return this.var.getSpssVar().getName();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.var = this.vector.get(n);
            try {
                if (n2 == 1 && !object.equals("")) {
                    if (Integer.parseInt(object.toString()) < 2 || Integer.parseInt(object.toString()) > 64) {
                        SpssAlertOptionPane.showInformationMessageDialog((Window)TreeCriteriaIntervalsTab.this.mParent, TreeCriteriaIntervalsTab.this.getResString("ERR_TREE_CRI_INVALS_RANGE_WRNING_MSG"), VersionInfo.getAppVersionString());
                        TreeCriteriaIntervalsTab.this.mMessageFlag = true;
                    } else {
                        this.var.setInterval(object.toString());
                    }
                } else if (n2 == 1 && object.equals("")) {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)TreeCriteriaIntervalsTab.this.mParent, TreeCriteriaIntervalsTab.this.getResString("ERR_TREE_CRI_INVALS_RANGE_WRNING_MSG"), VersionInfo.getAppVersionString());
                    TreeCriteriaIntervalsTab.this.mMessageFlag = true;
                }
            }
            catch (Exception exception) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)TreeCriteriaIntervalsTab.this.mParent, TreeCriteriaIntervalsTab.this.getResString("ERR_TREE_CRI_INVALS_RANGE_WRNING_MSG"), VersionInfo.getAppVersionString());
                TreeCriteriaIntervalsTab.this.mMessageFlag = true;
            }
            this.fireTableChanged(new TableModelEvent(this));
        }
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        JLabel label;
        JLabel label1;
        JCheckBox check = new JCheckBox();

        TableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.label = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jTable.getTableHeader().setFont(this.getFont().deriveFont(1));
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (TreeCriteriaIntervalsTab.this.mCustomRadio.isSelected()) {
                jTableHeader.setForeground(Color.BLACK);
                this.setForeground(Color.BLACK);
                this.setHorizontalAlignment(0);
                if (n2 == 0) {
                    this.setOpaque(true);
                    this.setBorder(UIManager.getBorder("TableCell.cellBorder"));
                    this.setBackground(jTableHeader.getBackground());
                } else {
                    this.setOpaque(false);
                }
            } else if (TreeCriteriaIntervalsTab.this.mFixedNoRadio.isSelected()) {
                this.setOpaque(true);
                this.setBorder(UIManager.getBorder("TableCell.cellBorder"));
                this.setForeground(Color.GRAY);
                this.setBackground(jTableHeader.getBackground());
                jTableHeader.setForeground(Color.GRAY);
                this.setHorizontalAlignment(0);
            }
            return this.label;
        }
    }
}

