/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trees.TreeCriteria;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class TreeCriteriaGrowthLimitTab
extends BaseProcedureTab
implements ItemListener,
FocusListener {
    static final int NUMBER_OF_COLUMN = 6;
    static final String AUTOMATIC_RADIO_KEY = "IDS_TREE_CRI_GL_AUTOMATIC";
    static final String CUSTOM_RADIO_KEY = "IDS_TREE_CRI_GL_CUSTOM";
    static final String PARENT_NODE_VALUE = "100";
    static final String CHILD_NODE_VALUE = "50";
    static final String VALUE_EDIT = "IDS_TREECRITERIA_GROWTHLIMIT_VALUE_EDIT";
    static final String PARENT_NODE_EDIT = "IDS_TREECRITERIA_GROWTHLIMIT_PARENT_NODE_EDIT";
    static final String CHILDT_NODE_EDIT = "IDS_TREECRITERIA_GROWTHLIMIT_CHILD_NODE_EDIT";
    private JRadioButton mAutomaticRadio;
    private JRadioButton mCustomRadio;
    private SpssButtonGroup mGroup;
    private JLabel mValueLabel;
    private IntTextField mValueText;
    private IntTextField mParentNodeText;
    private IntTextField mChildNodeText;

    public TreeCriteriaGrowthLimitTab(BaseTabbedSubDialog baseTabbedSubDialog) {
        super(baseTabbedSubDialog, true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mValueText)) {
            this.mValueText.selectAll();
        }
        if (focusEvent.getSource().equals(this.mParentNodeText)) {
            this.mParentNodeText.selectAll();
        }
        if (focusEvent.getSource().equals(this.mChildNodeText)) {
            this.mChildNodeText.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mParentNodeText.setSelectionStart(0);
        this.mParentNodeText.setSelectionEnd(0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mCustomRadio) {
            this.mValueLabel.setEnabled(this.mCustomRadio.isSelected());
            this.mValueText.setEnabled(this.mCustomRadio.isSelected());
            this.mValueText.setOpaque(this.mCustomRadio.isSelected());
        }
    }

    public boolean isValidate() {
        boolean bl = true;
        if (this.mValueText.isEnabled() && (this.mValueText.getText().length() < 1 || Integer.valueOf(this.mValueText.getText()) <= 0)) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_CRI_GL_WRNING_MSG"), VersionInfo.getAppVersionString());
            TreeDlg.setSelectionText((JTextField)this.mValueText);
            return false;
        }
        if (this.mParentNodeText.getText().length() < 1 || Integer.valueOf(this.mParentNodeText.getText()) <= 0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_CRI_GL_WRNING_MSG"), VersionInfo.getAppVersionString());
            TreeDlg.setSelectionText((JTextField)this.mParentNodeText);
            return false;
        }
        if (this.mChildNodeText.getText().length() < 1 || Integer.valueOf(this.mChildNodeText.getText()) <= 0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_CRI_GL_WRNING_MSG"), VersionInfo.getAppVersionString());
            TreeDlg.setSelectionText((JTextField)this.mChildNodeText);
            return false;
        }
        if (Integer.valueOf(this.mParentNodeText.getText()) < Integer.valueOf(this.mChildNodeText.getText())) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_CRI_GL_PARENT_CHILD_MSG"), VersionInfo.getAppVersionString());
            TreeDlg.setSelectionText((JTextField)this.mParentNodeText);
            return false;
        }
        return bl;
    }

    @Override
    public boolean validateTab() {
        return this.isValidate();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_criteria_growthlimit";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        if (this.mAutomaticRadio.isSelected()) {
            return this.mAutomaticRadio;
        }
        return this.mCustomRadio;
    }

    @Override
    protected void aboutToShowTab() {
        this.mParentNodeText.setOpaque(true);
        this.mChildNodeText.setOpaque(true);
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeCriteriaGrowthLimitTab.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel = this.setupMaxTreeDepthPanel();
        DialogUtil.addUsingGBLOnSpssTab(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = this.setupMinOfCasePanel();
        insets2.set(insets.top, 0, n2, n2);
        DialogUtil.addUsingGBLOnSpssTab(this, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets2);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mGroup);
        vector.add(this.mValueText);
        vector.add(this.mParentNodeText);
        vector.add(this.mChildNodeText);
        JPanel jPanel = ((TreeCriteria)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (component instanceof JButton) {
                vector.add(component);
            }
            this.setComponentOrder(vector);
        }
    }

    private void setDefaults() {
        this.mAutomaticRadio.setSelected(true);
        this.mParentNodeText.setText(PARENT_NODE_VALUE);
        this.mChildNodeText.setText(CHILD_NODE_VALUE);
        this.mValueLabel.setEnabled(false);
        this.mValueText.setEnabled(false);
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, AUTOMATIC_RADIO_KEY);
        this.mAutomaticRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, CUSTOM_RADIO_KEY);
        this.mCustomRadio = new JRadioButton(toggleButtonAction);
        this.mCustomRadio.addItemListener(this);
        this.mValueText = new IntTextField(true);
        this.mValueText.addFocusListener((FocusListener)this);
        this.mValueText.setColumns(6);
        this.mValueText.setAction((Action)new TextFieldAction(this.mParent, VALUE_EDIT));
        this.mValueLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_CRI_GL_VALUE");
        this.mValueLabel.setLabelFor((Component)this.mValueText);
        this.mParentNodeText = new IntTextField();
        this.mParentNodeText.setAction((Action)new TextFieldAction(this.mParent, PARENT_NODE_EDIT));
        this.mParentNodeText.setColumns(6);
        this.mParentNodeText.addFocusListener((FocusListener)this);
        this.mChildNodeText = new IntTextField();
        this.mChildNodeText.setAction((Action)new TextFieldAction(this.mParent, CHILDT_NODE_EDIT));
        this.mChildNodeText.setColumns(6);
        this.mChildNodeText.addFocusListener((FocusListener)this);
    }

    private JPanel setupMaxTreeDepthPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_TREE_CRI_GL_MAX_DEPTH"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mAutomaticRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = this.createInfoPanel(this.mCustomRadio.getFont());
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mCustomRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top, 8 * insets.left, insets.bottom, insets.right);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, jPanel2, gridBagConstraints, 0, 1, 3, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        JPanel jPanel3 = this.setupValuePanel();
        DialogUtil.addUsingGBLOnSpssTab(jPanel, jPanel3, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        this.mGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    public JPanel createInfoPanel(Font font) {
        FocusableTextArea focusableTextArea = new FocusableTextArea(this.getResString("IDS_TREE_CRI_GL_MAX_NO"));
        focusableTextArea.setFont(font);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, focusableTextArea, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupValuePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mValueLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, (JComponent)this.mValueText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupMinOfCasePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_TREE_CRI_GL_MAX_CASES"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, 0, n2);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_CRI_GL_PARENT_NODE");
        jLabel.setLabelFor((Component)this.mParentNodeText);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, (JComponent)this.mParentNodeText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_TREE_CRI_GL_CHILD_NODE");
        jLabel2.setLabelFor((Component)this.mChildNodeText);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.5;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.5;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, (JComponent)this.mChildNodeText, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }
}

