/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class TreeCriteriaCRTTab
extends BaseProcedureTab
implements FocusListener {
    static final String MIN_CHANGE_VALUE = "0.0001";
    static final String GINI_RADIO_KEY = "IDS_TREE_CRI_CRT_GINI_RADIO";
    static final String TWOING_RADIO_KEY = "IDS_TREE_CRI_CRT_TWOING_RADIO";
    static final String ORDERED_TWOING_RADIO_KEY = "IDS_TREE_CRI_ORDER_RADIO";
    static final String MIN_CHANGE_IN_IMPROVEMENT = "";
    private JRadioButton mGiniRadio;
    private JRadioButton mTwoingRadio;
    private JRadioButton mOrderedTwoingRadio;
    private SpssButtonGroup mGroup;
    private FloatTextField mMinChangeText;
    private JTextArea mSplitArea;
    private JTextArea mCateArea;
    private JTextArea mSimilarArea;

    public TreeCriteriaCRTTab(BaseTabbedSubDialog baseTabbedSubDialog) {
        super(baseTabbedSubDialog, true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mMinChangeText)) {
            this.mMinChangeText.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mMinChangeText.setSelectionStart(0);
        this.mMinChangeText.setSelectionEnd(0);
    }

    public boolean isValidate() {
        boolean bl = true;
        if (this.mMinChangeText.getText().length() < 1 || Double.valueOf(this.mMinChangeText.getText()) <= 0.0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_CRI_CRT_MIN_CHNG_WRNING_MSG"), VersionInfo.getAppVersionString());
            TreeDlg.setSelectionText((JTextField)this.mMinChangeText);
            return false;
        }
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_criteria_crt";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        DialogDataModel dialogDataModel = ((TreeDlg)((Object)this.mParent.getParent())).getDialogDataModel();
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_TREE_DEPENDENT_VAR_LIST");
        boolean bl = false;
        boolean bl2 = false;
        if (iSpssVariableArray != null) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (iSpssVariable.getMeasurementLevel().toString().equals("nominal")) {
                    bl = true;
                    continue;
                }
                if (!iSpssVariable.getMeasurementLevel().toString().equals("ordinal")) continue;
                bl2 = true;
            }
        }
        if (bl || bl2) {
            if (bl && this.mOrderedTwoingRadio.isSelected()) {
                return this.mOrderedTwoingRadio;
            }
            if (this.mGiniRadio.isSelected()) {
                return this.mGiniRadio;
            }
            return this.mTwoingRadio;
        }
        return this.mMinChangeText;
    }

    @Override
    protected void aboutToShowTab() {
        this.setFocusTraversalPolicy();
        DialogDataModel dialogDataModel = ((TreeDlg)((Object)this.mParent.getParent())).getDialogDataModel();
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_TREE_DEPENDENT_VAR_LIST");
        boolean bl = false;
        boolean bl2 = false;
        if (iSpssVariableArray != null) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (iSpssVariable.getMeasurementLevel().toString().equals("nominal")) {
                    bl = true;
                    continue;
                }
                if (!iSpssVariable.getMeasurementLevel().toString().equals("ordinal")) continue;
                bl2 = true;
            }
        }
        if (bl || bl2) {
            this.mGiniRadio.setEnabled(true);
            this.mSplitArea.setEnabled(true);
            this.mTwoingRadio.setEnabled(true);
            this.mCateArea.setEnabled(true);
            if (bl2) {
                this.mOrderedTwoingRadio.setEnabled(true);
                this.mSimilarArea.setEnabled(true);
            } else {
                this.mSimilarArea.setEnabled(false);
            }
        } else {
            this.mGiniRadio.setEnabled(false);
            this.mGiniRadio.setSelected(true);
            this.mSplitArea.setEnabled(false);
            this.mTwoingRadio.setEnabled(false);
            this.mCateArea.setEnabled(false);
            this.mOrderedTwoingRadio.setEnabled(false);
            this.mSimilarArea.setEnabled(false);
        }
        this.mMinChangeText.setOpaque(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeCriteriaCRTTab.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected boolean validateTab() {
        return this.isValidate();
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel = this.setupImpurityPanel();
        DialogUtil.addUsingGBLOnSpssTab(this, jPanel, gridBagConstraints, 0, 0, 3, 1, n, insets2);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_CRI_CRT_MIN_CHANGE");
        jLabel.setLabelFor((Component)this.mMinChangeText);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets3 = new Insets(n2 - 6, n2 * 2, 0, 0);
        DialogUtil.addUsingGBLOnSpssTab(this, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        DialogUtil.addUsingGBLOnSpssTab(this, (JComponent)this.mMinChangeText, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel2 = new JLabel(this.getResString("IDS_TREE_CRI_CRT_LARGE_VAL"));
        DialogUtil.addUsingGBLOnSpssTab(this, jLabel2, gridBagConstraints, 2, 1, 1, 1, n, insets3);
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mGroup);
        vector.add(this.mMinChangeText);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void setDefaults() {
        this.mMinChangeText.setText(MIN_CHANGE_VALUE);
        this.mGiniRadio.setSelected(true);
        this.mGiniRadio.setEnabled(false);
        this.mSplitArea.setEnabled(false);
        this.mTwoingRadio.setEnabled(false);
        this.mCateArea.setEnabled(false);
        this.mOrderedTwoingRadio.setEnabled(false);
        this.mSimilarArea.setEnabled(false);
    }

    private JPanel setupImpurityPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_TREE_CRI_CRT_IMPURITY_TITLE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mGiniRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(insets.top, 8 * insets.left, 0, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mSplitArea, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets2.set(insets.top, 8 * insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mTwoingRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets2.set(insets.top, 8 * insets.left, 0, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mCateArea, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        insets2.set(insets.top, 8 * insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mOrderedTwoingRadio, gridBagConstraints, 0, 6, 1, 1, n, insets);
        insets2.set(insets.top, 8 * insets.left, n2, insets.right);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mSimilarArea, gridBagConstraints, 0, 7, 2, 1, n, insets2);
        this.mGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, GINI_RADIO_KEY);
        this.mGiniRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, TWOING_RADIO_KEY);
        this.mTwoingRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, ORDERED_TWOING_RADIO_KEY);
        this.mOrderedTwoingRadio = new JRadioButton(toggleButtonAction);
        this.mMinChangeText = new FloatTextField(true);
        this.mMinChangeText.setMinVal(0.0);
        this.mMinChangeText.setIncludeMinRange(false);
        this.mMinChangeText.setAction((Action)new TextFieldAction(this.mParent, MIN_CHANGE_IN_IMPROVEMENT));
        this.mMinChangeText.addFocusListener((FocusListener)this);
        this.mSplitArea = new JTextArea(this.getResString("IDS_TREE_CRI_CRT_SPLIT_LABEL"));
        this.mSplitArea.setEditable(false);
        this.mSplitArea.setFont(this.mOrderedTwoingRadio.getFont());
        this.mSplitArea.setRows(2);
        this.mSplitArea.setFocusable(false);
        this.mSplitArea.setOpaque(false);
        this.mSplitArea.setWrapStyleWord(true);
        this.mSplitArea.setLineWrap(true);
        this.mSplitArea.setColumns(50);
        this.mCateArea = new JTextArea(this.getResString("IDS_TREE_CRI_CRT_CATE_LABEL"));
        this.mCateArea.setEditable(false);
        this.mCateArea.setFont(this.mOrderedTwoingRadio.getFont());
        this.mCateArea.setRows(2);
        this.mCateArea.setFocusable(false);
        this.mCateArea.setOpaque(false);
        this.mCateArea.setWrapStyleWord(true);
        this.mCateArea.setLineWrap(true);
        this.mCateArea.setColumns(50);
        this.mSimilarArea = new JTextArea(this.getResString("IDS_TREE_CRI_CRT_SIMIALR_LABEL"));
        this.mSimilarArea.setEditable(false);
        this.mSimilarArea.setFont(this.mOrderedTwoingRadio.getFont());
        this.mSimilarArea.setRows(2);
        this.mSimilarArea.setFocusable(false);
        this.mSimilarArea.setOpaque(false);
        this.mSimilarArea.setWrapStyleWord(true);
        this.mSimilarArea.setLineWrap(true);
        this.mSimilarArea.setColumns(50);
    }
}

