/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineCheckBox;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class TreeCriteriaCHAIDTab
extends BaseProcedureTab
implements FocusListener {
    static final int NUMBER_OF_COLUMN = 5;
    static final String SPLIT_DEFAULT_VALUE = "0.05";
    static final String MERGING_CATE_VALUE = "0.05";
    static final String MAX_NUMBER = "100";
    static final String MIN_CHANGE = "0.001";
    static final String PEARSON_RADIO_KEY = "IDS_TREE_CRI_CHAID_PEARSON";
    static final String LIKELIHOOD_RADIO_KEY = "IDS_TREE_CRI_CHAID_LIKELIHOOD";
    static final String ADJUST_CHECK_KEY = "IDS_TREE_CRI_CHAID_ADJUST_CHECK";
    static final String ALLOW_CHECK_KEY = "IDS_TREE_CRI_CHAID_ALLOW_CHECK";
    static final String SPLITING_NODE_EDIT = "IDS_TREE_CATEGORIES_CHAID_SPLITING_NODE_EDIT";
    static final String MERGE_CATEGORIES_EDIT = "IDS_TREE_CATEGORIES_CHAID_MERGE_CATEGORIES_EDIT";
    static final String MAX_NO_OF_ITERATIONS_EDIT = "IDS_TREE_CATEGORIES_CHAID_MAX_NO_OF_ITERATIONS_EDIT";
    static final String MIN_CHANGE_EDIT = "IDS_TREE_CATEGORIES_CHAID_MIN_CHANGE_EDIT";
    private FloatTextField mSplitText;
    private FloatTextField mMergCateText;
    private JRadioButton mPearsonRadio;
    private JRadioButton mLikeliHoodRadio;
    private JLabel mMaxNoLabel1;
    private JLabel mMinChangeLabel1;
    private IntTextField mMaxNoText;
    private FloatTextField mMinChangeText;
    private JCheckBox mAdjustSignCheck;
    private JCheckBox mAllowCheck;
    private SpssButtonGroup mGroup;
    private JLabel mMergingCateLabel;

    public TreeCriteriaCHAIDTab(BaseTabbedSubDialog baseTabbedSubDialog) {
        super(baseTabbedSubDialog, true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSplitText)) {
            this.mSplitText.selectAll();
        }
        if (focusEvent.getSource().equals(this.mMergCateText)) {
            this.mMergCateText.selectAll();
        }
        if (focusEvent.getSource().equals(this.mMaxNoText)) {
            this.mMaxNoText.selectAll();
        }
        if (focusEvent.getSource().equals(this.mMinChangeText)) {
            this.mMinChangeText.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSplitText)) {
            this.mSplitText.setSelectionStart(0);
            this.mSplitText.setSelectionEnd(0);
        }
        if (focusEvent.getSource().equals(this.mMergCateText)) {
            this.mMergCateText.setSelectionStart(0);
            this.mMergCateText.setSelectionEnd(0);
        }
        if (focusEvent.getSource().equals(this.mMaxNoText)) {
            this.mMaxNoText.setSelectionStart(0);
            this.mMaxNoText.setSelectionEnd(0);
        }
        if (focusEvent.getSource().equals(this.mMinChangeText)) {
            this.mMinChangeText.setSelectionStart(0);
            this.mMinChangeText.setSelectionEnd(0);
        }
    }

    @Override
    public boolean validateTab() {
        return this.isValidate();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_criteria_chaid";
    }

    public boolean isValidate() {
        boolean bl = true;
        if (this.mSplitText.getText().length() < 1 || Double.valueOf(this.mSplitText.getText()) <= 0.0 || Double.valueOf(this.mSplitText.getText()) >= 1.0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_CRI_CHAID_SPLIT_WRNING_MSG"), VersionInfo.getAppVersionString());
            TreeDlg.setSelectionText((JTextField)this.mSplitText);
            return false;
        }
        if (this.mMergCateText.getText().length() < 1 || Double.valueOf(this.mMergCateText.getText()) <= 0.0 || Double.valueOf(this.mMergCateText.getText()) > 1.0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_CRI_CHAID_MERG_WRNING_MSG"), VersionInfo.getAppVersionString());
            TreeDlg.setSelectionText((JTextField)this.mMergCateText);
            return false;
        }
        if (this.mMaxNoText.isEnabled() && (this.mMaxNoText.getText().length() < 1 || Integer.valueOf(this.mMaxNoText.getText()) <= 0)) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_CRI_GL_MAX_NO_WRN_MSG"), VersionInfo.getAppVersionString());
            TreeDlg.setSelectionText((JTextField)this.mMaxNoText);
            return false;
        }
        if (this.mMinChangeText.isEnabled() && (this.mMinChangeText.getText().length() < 1 || Double.valueOf(this.mMinChangeText.getText()) <= 0.0 || Double.valueOf(this.mMinChangeText.getText()) >= 1.0)) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_TREE_CRI_CHAID_SPLIT_WRNING_MSG"), VersionInfo.getAppVersionString());
            TreeDlg.setSelectionText((JTextField)this.mMinChangeText);
            return false;
        }
        return bl;
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mSplitText;
    }

    @Override
    protected void aboutToShowTab() {
        DialogDataModel dialogDataModel = ((TreeDlg)((Object)this.mParent.getParent())).getDialogDataModel();
        String string = this.getResStringArray("IDS_TREE_GROWING_METHOD_ARRAY")[dialogDataModel.getInteger("IDS_TREE_GROWING_METHOD_COMBOBOX")];
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_TREE_DEPENDENT_VAR_LIST");
        boolean bl = false;
        boolean bl2 = false;
        if (iSpssVariableArray != null) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (iSpssVariable.getMeasurementLevel().toString().equals("nominal")) {
                    bl = true;
                    continue;
                }
                if (!iSpssVariable.getMeasurementLevel().toString().equals("ordinal")) continue;
                bl2 = true;
            }
        }
        if (bl || bl2) {
            DialogUtil.enableHTMLComponent(this.mMaxNoLabel1, true);
            this.mMaxNoText.setEnabled(true);
            this.mMaxNoText.setOpaque(true);
            DialogUtil.enableHTMLComponent(this.mMinChangeLabel1, true);
            this.mMinChangeText.setEnabled(true);
            this.mMinChangeText.setOpaque(true);
        } else {
            DialogUtil.enableHTMLComponent(this.mMaxNoLabel1, false);
            this.mMaxNoText.setEnabled(false);
            this.mMaxNoText.setOpaque(false);
            DialogUtil.enableHTMLComponent(this.mMinChangeLabel1, false);
            this.mMinChangeText.setEnabled(false);
            this.mMinChangeText.setOpaque(false);
        }
        if (bl) {
            this.mPearsonRadio.setEnabled(true);
            this.mLikeliHoodRadio.setEnabled(true);
        } else {
            this.mPearsonRadio.setEnabled(false);
            this.mLikeliHoodRadio.setEnabled(false);
        }
        this.mMergCateText.setOpaque(!string.equals(this.getResString("IDS_TREE_GROWING_METHOD_ECHAID_ITEM")));
        this.mMergCateText.setEnabled(!string.equals(this.getResString("IDS_TREE_GROWING_METHOD_ECHAID_ITEM")));
        this.mMergingCateLabel.setEnabled(!string.equals(this.getResString("IDS_TREE_GROWING_METHOD_ECHAID_ITEM")));
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeCriteriaCHAIDTab.this.getDefaultFocusComponent().requestFocus();
            }
        });
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, n2, n2);
        DialogUtil.addUsingGBLOnSpssTab(this, this.setupSignLevelPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets2);
        JComponent[] jComponentArray = new JComponent[]{this.mPearsonRadio, this.mLikeliHoodRadio};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_TREE_CRI_CHAID_CHI_SQUARE"));
        this.mGroup = DialogUtil.createButtonGroup(jPanel);
        insets2.set(insets.top, 0, n2, n2);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets2.set(0, insets.left, n2, n2);
        JPanel jPanel2 = this.setupModelEstimationPanel();
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets2.set(insets.top, 0, n2, n2);
        JPanel jPanel3 = this.setupCheckBoxPanel();
        DialogUtil.addUsingGBL(this, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets2);
    }

    private void setDefaults() {
        this.mSplitText.setText("0.05");
        this.mMergCateText.setText("0.05");
        this.mMaxNoText.setText(MAX_NUMBER);
        this.mMinChangeText.setText(MIN_CHANGE);
        this.mMaxNoText.setEnabled(false);
        DialogUtil.enableHTMLComponent(this.mMaxNoLabel1, false);
        DialogUtil.enableHTMLComponent(this.mMinChangeLabel1, false);
        this.mMinChangeText.setEnabled(false);
        this.mPearsonRadio.setEnabled(false);
        this.mPearsonRadio.setSelected(true);
        this.mLikeliHoodRadio.setEnabled(false);
        this.mAdjustSignCheck.setSelected(true);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSplitText);
        vector.add(this.mMergCateText);
        vector.add(this.mMaxNoText);
        vector.add(this.mMinChangeText);
        vector.add(this.mGroup);
        vector.add(this.mAdjustSignCheck);
        vector.add(this.mAllowCheck);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void initVars() {
        this.mSplitText = new FloatTextField(0.0, 1.0, 2);
        this.mSplitText.setIncludeMinRange(false);
        this.mSplitText.setIncludeMaxRange(false);
        this.mSplitText.setAction((Action)new TextFieldAction(this.mParent, SPLITING_NODE_EDIT));
        this.mSplitText.setColumns(5);
        this.mSplitText.addFocusListener((FocusListener)this);
        this.mMergCateText = new FloatTextField(0.0, 1.0, 2);
        this.mMergCateText.setIncludeMinRange(false);
        this.mMergCateText.setIncludeMaxRange(false);
        this.mMergCateText.setAction((Action)new TextFieldAction(this.mParent, MERGE_CATEGORIES_EDIT));
        this.mMergCateText.setColumns(5);
        this.mMergCateText.addFocusListener((FocusListener)this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, PEARSON_RADIO_KEY);
        this.mPearsonRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, LIKELIHOOD_RADIO_KEY);
        this.mLikeliHoodRadio = new JRadioButton(toggleButtonAction);
        this.mMaxNoText = new IntTextField(true);
        this.mMaxNoText.setAction((Action)new TextFieldAction(this.mParent, MAX_NO_OF_ITERATIONS_EDIT));
        this.mMaxNoText.setColumns(5);
        this.mMaxNoText.addFocusListener((FocusListener)this);
        this.mMinChangeText = new FloatTextField(0.0, 1.0, 3);
        this.mMinChangeText.setIncludeMinRange(false);
        this.mMinChangeText.setIncludeMaxRange(false);
        this.mMinChangeText.setAction((Action)new TextFieldAction(this.mParent, MIN_CHANGE_EDIT));
        this.mMinChangeText.setColumns(5);
        this.mMinChangeText.addFocusListener((FocusListener)this);
        this.mMaxNoLabel1 = DialogUtil.createMultiLineLabel(this.mParent, "IDS_TREE_CRI_CHAID_MAX_NO_ITERATION1", 120);
        this.mMaxNoLabel1.setLabelFor((Component)this.mMaxNoText);
        this.mMinChangeLabel1 = DialogUtil.createMultiLineLabel(this.mParent, "IDS_TREE_CRI_CHAID_MIN_CHANGES1", 150);
        this.mMinChangeLabel1.setLabelFor((Component)this.mMinChangeText);
        toggleButtonAction = new ToggleButtonAction(this.mParent, ADJUST_CHECK_KEY);
        this.mAdjustSignCheck = new SpssMultiLineCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, ALLOW_CHECK_KEY);
        this.mAllowCheck = new SpssMultiLineCheckBox(toggleButtonAction);
        this.mMergingCateLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_CRI_CHAID_MERG_CATE");
    }

    private JPanel setupCheckBoxPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(n2, n2, 0, n2);
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mAdjustSignCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBLOnSpssTab(jPanel, this.mAllowCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupModelEstimationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_TREE_CRI_CHAID_MODEL_ESTIMATION"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mMaxNoLabel1, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(0, n2, 0, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxNoText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMinChangeLabel1, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(0, n2, 0, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinChangeText, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupSignLevelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_TREE_CRI_CHAID_SIGN_LEVEL"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, 0, n2);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_TREE_CRI_CHAID_SPLIT_NODE");
        jLabel.setLabelFor((Component)this.mSplitText);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSplitText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mMergingCateLabel.setLabelFor((Component)this.mMergCateText);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMergingCateLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMergCateText, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }
}

