/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseTabbedSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.trees.TreeCriteriaCHAIDTab;
import com.spss.java_client.ui.dialogs.trees.TreeCriteriaCRTTab;
import com.spss.java_client.ui.dialogs.trees.TreeCriteriaGrowthLimitTab;
import com.spss.java_client.ui.dialogs.trees.TreeCriteriaIntervalsTab;
import com.spss.java_client.ui.dialogs.trees.TreeCriteriaPruningTab;
import com.spss.java_client.ui.dialogs.trees.TreeCriteriaQuestTab;
import com.spss.java_client.ui.dialogs.trees.TreeCriteriaSurrogatesTab;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;

public class TreeCriteria
extends BaseTabbedSubDialog {
    static final String SELECTED_TAB_INDEX = "IDS_CRI_INDEX_KEY";
    TreeCriteriaGrowthLimitTab mGLTab;
    TreeCriteriaCHAIDTab mCHAIDTab;
    TreeCriteriaIntervalsTab mInvalsTab;
    TreeCriteriaCRTTab mCRTTab;
    TreeCriteriaPruningTab mPrunTab;
    TreeCriteriaSurrogatesTab mSgateTab;
    TreeCriteriaQuestTab mQuestTab;

    public TreeCriteria(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_TREE_CRI_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public boolean continuePressed() {
        if (this.mGLTab != null && this.mGLTab.isShowing()) {
            return this.mGLTab.isValidate();
        }
        if (this.mCHAIDTab != null && this.mCHAIDTab.isShowing()) {
            return this.mCHAIDTab.isValidate();
        }
        if (this.mCRTTab != null && this.mCRTTab.isShowing()) {
            return this.mCRTTab.isValidate();
        }
        if (this.mPrunTab != null && this.mPrunTab.isShowing()) {
            return this.mPrunTab.isValidate();
        }
        if (this.mSgateTab != null && this.mSgateTab.isShowing()) {
            return this.mSgateTab.isValidate();
        }
        if (this.mInvalsTab != null && this.mInvalsTab.isShowing()) {
            return this.mInvalsTab.isValidate();
        }
        if (this.mQuestTab != null && this.mQuestTab.isShowing()) {
            return this.mQuestTab.isValidate();
        }
        return true;
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        super.saveState(dialogDataModel);
        this.mParentDlg.getDialogDataModel().putString(SELECTED_TAB_INDEX, this.mTabbedPane.getTitleAt(this.mTabbedPane.getSelectedIndex()));
        return true;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        String string = dialogDataModel.getString(SELECTED_TAB_INDEX);
        int n = this.mTabbedPane.indexOfTab(string);
        if (n != -1) {
            this.mTabbedPane.setSelectedIndex(n);
        } else {
            this.mTabbedPane.setSelectedIndex(0);
        }
    }

    @Override
    protected void init() {
        super.init();
        DialogDataModel dialogDataModel = ((TreeDlg)this.mParentDlg).getDialogDataModel();
        String string = this.getResStringArray("IDS_TREE_GROWING_METHOD_ARRAY")[dialogDataModel.getInteger("IDS_TREE_GROWING_METHOD_COMBOBOX")];
        if (string.equals(this.getResString("IDS_TREE_GROWING_METHOD_CHAID_ITEM")) || string.equals(this.getResString("IDS_TREE_GROWING_METHOD_ECHAID_ITEM"))) {
            this.mGLTab = new TreeCriteriaGrowthLimitTab(this);
            this.mCHAIDTab = new TreeCriteriaCHAIDTab(this);
            this.addTab(this.getResString("IDS_CRI_GLTAB_TITLE"), this.mGLTab);
            this.addTab(this.getResString("IDS_CRI_CHAIDTAB_TITLE"), this.mCHAIDTab);
            if (((TreeDlg)this.mParentDlg).isContainsScale()) {
                this.mInvalsTab = new TreeCriteriaIntervalsTab(this);
                this.addTab(this.getResString("IDS_CRI_INVALS_TAB_TITLE"), this.mInvalsTab);
            }
        }
        if (string.equals(this.getResString("IDS_TREE_GROWING_METHOD_CRT_ITEM"))) {
            this.mGLTab = new TreeCriteriaGrowthLimitTab(this);
            this.mCRTTab = new TreeCriteriaCRTTab(this);
            this.mPrunTab = new TreeCriteriaPruningTab(this);
            this.mSgateTab = new TreeCriteriaSurrogatesTab(this);
            this.addTab(this.getResString("IDS_CRI_GLTAB_TITLE"), this.mGLTab);
            this.addTab(this.getResString("IDS_CRI_CRTTAB_TITLE"), this.mCRTTab);
            this.addTab(this.getResString("IDS_CRI_PRUNETAB_TITLE"), this.mPrunTab);
            this.addTab(this.getResString("IDS_CRI_SGATETAB_TITLE"), this.mSgateTab);
        }
        if (string.equals(this.getResString("IDS_TREE_GROWING_METHOD_QUEST_ITEM"))) {
            this.mGLTab = new TreeCriteriaGrowthLimitTab(this);
            this.mQuestTab = new TreeCriteriaQuestTab(this);
            this.mPrunTab = new TreeCriteriaPruningTab(this);
            this.mSgateTab = new TreeCriteriaSurrogatesTab(this);
            this.addTab(this.getResString("IDS_CRI_GLTAB_TITLE"), this.mGLTab);
            this.addTab(this.getResString("IDS_CRI_QUESTTAB_TITLE"), this.mQuestTab);
            this.addTab(this.getResString("IDS_CRI_PRUNETAB_TITLE"), this.mPrunTab);
            this.addTab(this.getResString("IDS_CRI_SGATETAB_TITLE"), this.mSgateTab);
        }
        this.pack();
    }
}

