/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.trees;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.drag_drop.AbstractListDropListener;
import com.spss.java_client.ui.controls.drag_drop.AbstractTableDropListener;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainTableDragAdapter;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.trees.TreeDlg;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TreeCategories
extends BaseSubDialog
implements ActionListener,
ListSelectionListener,
ListDataListener,
FocusListener {
    static final String TARGET_CATEGORY_DEFINED = "IDS_TREE_CATEGORIES_TARGET_CATEGORY_DEFINED";
    static final String EXCLUDE_LIST_KEY = "IDS_TREE_CATEGORIES_EXCLUDE_LIST_KEY";
    private PlainList mTargetVarList;
    private PlainTable mTable;
    private JScrollPane mScrollPane;
    private JScrollPane mListScrollPane;
    private ComponentsArrowButton mArrowButton;
    private DefaultListModel mModel;
    private Vector<TreeDlg.Categories> mVector;
    static final int TABLE_ROW_COUNT = 64;
    private final int TABLE_WIDTH = 310;
    private final int TABLE_HEIGHT = 120;
    private final int LIST_WIDTH = 160;
    private final int LIST_HEIGHT = 120;
    private String[] mColumnNames = new String[]{this.getResString("IDS_TREE_CATE_CATEGORY"), this.getResString("IDS_TREE_CATE_TARGET")};

    public TreeCategories(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_TREE_CATE_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mTable)) {
            ListSelectionModel listSelectionModel = this.mTargetVarList.getSelectionModel();
            listSelectionModel.clearSelection();
            this.mArrowButton.setEnabled(this.mTable.getModel().getRowCount() > 0);
        } else if (focusEvent.getSource().equals(this.mTargetVarList)) {
            ListSelectionModel listSelectionModel = this.mTable.getSelectionModel();
            listSelectionModel.clearSelection();
            this.mArrowButton.setEnabled(this.mTargetVarList.getModel().getSize() > 0);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mArrowButton) {
            if (this.mArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.left) {
                if (this.isAllowInclude() && !this.mTargetVarList.isSelectionEmpty()) {
                    Object[] objectArray;
                    for (Object object : objectArray = this.mTargetVarList.getSelectedValues()) {
                        TreeDlg.Categories categories = (TreeDlg.Categories)object;
                        this.mModel.removeElement(categories);
                        this.mVector.add(categories);
                    }
                    this.mTable.setModel(new TableModel(this.mVector, this.mColumnNames));
                    this.mTable.addRowSelectionInterval(0, 0);
                }
            } else {
                int n;
                int[] nArray;
                int[] nArray2 = nArray = this.mTable.getSelectedRows();
                int n2 = nArray2.length;
                for (n = 0; n < n2; ++n) {
                    int n3 = nArray2[n];
                    this.mModel.addElement(this.mTable.getModel().getValueAt(n3, 0));
                }
                int n4 = this.mModel.getSize();
                this.mTargetVarList.setSelectionInterval(n4 - nArray.length, n4 - 1);
                Vector<TreeDlg.Categories> vector = new Vector<TreeDlg.Categories>();
                for (int n5 : nArray) {
                    for (n = 0; n < this.mVector.size(); ++n) {
                        if (!this.mVector.get(n).equals(this.mTable.getModel().getValueAt(n5, 0))) continue;
                        vector.add(this.mVector.get(n));
                    }
                }
                this.mVector.removeAll(vector);
                this.mTable.setModel(new TableModel(this.mVector, this.mColumnNames));
            }
            this.updateTableSize();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.mTargetVarList) {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        }
        if (listSelectionEvent.getSource() == this.mTable.getSelectionModel()) {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        }
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this.mVarMoveHandler);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_tree_categories";
    }

    @Override
    public boolean continuePressed() {
        if (this.mTable.getModel().getRowCount() > 64) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_TREE_CATEGORIES_WRNING_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        boolean bl = ((TreeDlg)this.mParentDlg).isTargetCategoryDefined();
        TreeDlg.DependentVarFormatter dependentVarFormatter = ((TreeDlg)this.mParentDlg).getDepVarListFormatter();
        if (!bl && dialogDataModel.getSerializableArray(EXCLUDE_LIST_KEY) == null) {
            Vector<TreeDlg.Categories> vector = ((TreeDlg)this.mParentDlg).getCategoryTableModel();
            this.mTable.setModel(new TableModel(vector, this.mColumnNames));
            Vector<TreeDlg.Categories> vector2 = ((TreeDlg)this.mParentDlg).getExcludeCategoryVector();
            if (vector2.size() > 0) {
                for (TreeDlg.Categories categories : vector2) {
                    this.mModel.addElement(categories);
                }
            }
        } else {
            ISpssVariable iSpssVariable = ((TreeDlg)this.mParentDlg).getDependentVariable();
            Vector vector = (Vector)dependentVarFormatter.getVarMap().get(iSpssVariable.getId().asInt());
            Vector<TreeDlg.Categories> vector3 = new Vector<TreeDlg.Categories>();
            for (TreeDlg.Categories categories : vector) {
                try {
                    vector3.add(categories);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.mTable.setModel(new TableModel(vector3, this.mColumnNames));
        }
        this.mTable.setRowSelectionInterval(0, 0);
        this.updateTableSize();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        super.saveState(dialogDataModel);
        ISpssVariable iSpssVariable = ((TreeDlg)this.mParentDlg).getDependentVariable();
        TreeDlg.DependentVarFormatter dependentVarFormatter = ((TreeDlg)this.mParentDlg).getDepVarListFormatter();
        dependentVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), ((TableModel)this.mTable.getModel()).getTableData());
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_TREE_CATE_DEP_VAR_CATE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, 0, 0);
        JPanel jPanel2 = this.setupLabelPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupPanel(), gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void updateTableSize() {
        final PlainTable plainTable = this.mTable;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableColumnModel tableColumnModel = plainTable.getColumnModel();
                TableColumn tableColumn = tableColumnModel.getColumn(0);
                tableColumn.setPreferredWidth(400);
                tableColumn = tableColumnModel.getColumn(1);
                tableColumn.setPreferredWidth(100);
                plainTable.revalidate();
            }
        });
    }

    private boolean isAllowInclude() {
        DialogDataModel dialogDataModel = ((TreeDlg)((Object)this.getParent())).getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_TREE_POT_CUSTOM");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl != null && bl.booleanValue()) {
            arrayList.add(this.getResString("IDS_TREE_CATE_MESSAGE_PART_COST"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_TREE_OPT_PROFIT_CUSTOM")) != null && bl.booleanValue()) {
            arrayList.add(this.getResString("IDS_TREE_CATE_MESSAGE_PART_PROFIT"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_TREE_OPT_PP_CUSTOM")) != null && bl.booleanValue()) {
            arrayList.add(this.getResString("IDS_TREE_CATE_MESSAGE_PART_PPT"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_TREE_OPT_SCR_CUSTOM")) != null && bl.booleanValue()) {
            arrayList.add(this.getResString("IDS_TREE_CATE_MESSAGE_PART_SCORE"));
        }
        String string = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            string = string + " " + (String)arrayList.get(i);
            if (arrayList.size() < 2) continue;
            if (i == arrayList.size() - 2) {
                string = string + " " + this.getResString("IDS_TREE_CATE_MESSAGE_PART_AND");
                continue;
            }
            if (i == arrayList.size() - 1) continue;
            string = string + ",";
        }
        if (string.length() > 0) {
            String string2 = String.format(ComponentState.getSPSSLocale(), this.getResString("ERR_TREE_CATE_MESSAGE"), string.trim());
            return SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) == 0;
        }
        return true;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTable);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupLabelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.right = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(this.getResString("IDS_TREE_CATE_VAR"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JLabel jLabel2 = new JLabel(((TreeDlg)this.mParentDlg).getDependentVariable().getLabel());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 0, 1, 1, n, DialogUtil.getStandardControlInsets());
        return jPanel;
    }

    private void initVars() {
        this.mModel = new DefaultListModel();
        this.mTargetVarList = new PlainList(EXCLUDE_LIST_KEY);
        this.mTargetVarList.setModel(this.mModel);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setCellRenderer(new CustomListRenderer());
        this.mTargetVarList.addFocusListener(this);
        this.mListScrollPane = new JScrollPane(this.mTargetVarList);
        this.mListScrollPane.setPreferredSize(new Dimension(160, 120));
        this.mListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mListScrollPane.setVerticalScrollBarPolicy(20);
        this.mTargetVarList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (focusEvent.getSource() == TreeCategories.this.mTable) {
                    TreeCategories.this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                }
                if (focusEvent.getSource() == TreeCategories.this.mTargetVarList) {
                    TreeCategories.this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                }
            }
        });
        this.mTable = new PlainTable();
        this.mTable.setDefaultRenderer(Object.class, new TableRenderer());
        this.mTable.setRowHeight(80, 100);
        this.mTable.addFocusListener(this);
        this.mTable.setRowSelectionAllowed(false);
        this.mTable.setCellSelectionEnabled(true);
        this.mArrowButton = new ComponentsArrowButton();
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mTable, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButton.addActionListener(this);
        this.mScrollPane = new JScrollPane(this.mTable);
        this.mScrollPane.setPreferredSize(new Dimension(310, 120));
        this.mTable.getTableHeader().setReorderingAllowed(false);
        Font font = this.mTable.getTableHeader().getFont();
        Font font2 = new Font(font.getFontName(), 1, font.getSize());
        this.mTable.getTableHeader().setFont(font2);
        this.mTable.getColumnModel().getSelectionModel().addListSelectionListener(this);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mTable.getActionMap().put("tabIn", abstractAction2);
        this.mTable.getActionMap().put("tabOut", abstractAction);
    }

    private void addDragAdapters(DragPane dragPane, Component component, IVarMoveHandler iVarMoveHandler) {
        JComponent jComponent = null;
        if (component instanceof PlainList) {
            PlainList plainList = (PlainList)component;
            if (plainList == this.mTargetVarList) {
                jComponent = this.mTable;
            }
            ListDragAdapter listDragAdapter = new ListDragAdapter(plainList, dragPane, "PlainList");
            DialogUtil.modifyMouseInputListeners(plainList, listDragAdapter);
            dragPane.addDropListener((IDropListener)new CatsListDropListener(plainList, iVarMoveHandler, jComponent));
        } else if (component instanceof PlainTable) {
            PlainTable plainTable = (PlainTable)component;
            if (plainTable == this.mTable) {
                jComponent = this.mTargetVarList;
            }
            PlainTableDragAdapter plainTableDragAdapter = new PlainTableDragAdapter(plainTable, dragPane, "PlainTable");
            DialogUtil.modifyMouseInputListeners(plainTable, plainTableDragAdapter);
            dragPane.addDropListener((IDropListener)new CatsTableDropListener(plainTable, iVarMoveHandler, jComponent));
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                this.addDragAdapters(dragPane, component2, iVarMoveHandler);
            }
        }
    }

    private JPanel setupPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_TREE_CATE_USE_IN");
        jLabel.setLabelFor(this.mTable);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParentDlg, "IDS_TREE_CATE_EXCLUDE");
        jLabel2.setLabelFor(this.mTargetVarList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mListScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_TREE_CATE_LABEL"));
        jTextArea.setFont(jLabel2.getFont());
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setMinimumSize(new Dimension(50, 30));
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 2, 3, 1, n, new Insets(8, 0, 2, 0));
        return jPanel;
    }

    private class CatsTableDropListener
    extends AbstractTableDropListener {
        public CatsTableDropListener(PlainTable plainTable, Component component) {
            super(plainTable, component);
        }

        public CatsTableDropListener(PlainTable plainTable, IVarMoveHandler iVarMoveHandler, Component component) {
            super(plainTable, iVarMoveHandler, component);
        }

        @Override
        protected void importData(Object object, JComponent jComponent, int n) {
            Object object2;
            if (!(this.mDropTarget instanceof PlainTable)) {
                assert (false);
                return;
            }
            if (TreeCategories.this.isAllowInclude() && !TreeCategories.this.mTargetVarList.isSelectionEmpty()) {
                Object[] objectArray;
                for (Object object3 : objectArray = TreeCategories.this.mTargetVarList.getSelectedValues()) {
                    object2 = (TreeDlg.Categories)object3;
                    TreeCategories.this.mModel.removeElement(object2);
                    TreeCategories.this.mVector.add(object2);
                }
                TreeCategories.this.mTable.setModel(new TableModel(TreeCategories.this.mVector, TreeCategories.this.mColumnNames));
                TreeCategories.this.mTable.addRowSelectionInterval(0, 0);
            }
            object2 = (PlainTable)this.mDropTarget;
            SwingUtilities.invokeLater(new Runnable((PlainTable)object2){
                final /* synthetic */ PlainTable val$varTable;
                {
                    this.val$varTable = plainTable;
                }

                @Override
                public void run() {
                    this.val$varTable.requestFocus();
                }
            });
            TreeCategories.this.updateTableSize();
        }

        @Override
        protected void finish(JComponent jComponent, int n, int[] nArray, int n2) {
        }
    }

    private class CatsListDropListener
    extends AbstractListDropListener {
        public CatsListDropListener(PlainList plainList, Component component) {
            super(plainList, component);
        }

        public CatsListDropListener(PlainList plainList, IVarMoveHandler iVarMoveHandler, Component component) {
            super(plainList, iVarMoveHandler, component);
        }

        @Override
        protected void importData(Object object, JComponent jComponent, int n) {
            int n2;
            int[] nArray;
            if (!(object instanceof Vector)) {
                return;
            }
            int[] nArray2 = nArray = TreeCategories.this.mTable.getSelectedRows();
            int n3 = nArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = nArray2[n2];
                TreeCategories.this.mModel.addElement(TreeCategories.this.mTable.getModel().getValueAt(n4, 0));
            }
            int n5 = TreeCategories.this.mModel.getSize();
            TreeCategories.this.mTargetVarList.setSelectionInterval(n5 - nArray.length, n5 - 1);
            Vector vector = new Vector();
            for (int n4 : nArray) {
                for (n2 = 0; n2 < TreeCategories.this.mVector.size(); ++n2) {
                    if (!((TreeDlg.Categories)TreeCategories.this.mVector.get(n2)).equals(TreeCategories.this.mTable.getModel().getValueAt(n4, 0))) continue;
                    vector.add(TreeCategories.this.mVector.get(n2));
                }
            }
            TreeCategories.this.mVector.removeAll(vector);
            TreeCategories.this.mTable.setModel(new TableModel(TreeCategories.this.mVector, TreeCategories.this.mColumnNames));
            final PlainList plainList = (PlainList)this.mDropTarget;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    plainList.requestFocusInWindow();
                }
            });
            TreeCategories.this.updateTableSize();
        }

        @Override
        protected void finish(JComponent jComponent, int n, int[] nArray, int n2) {
        }
    }

    class TableModel
    extends DefaultTableModel {
        private String[] columnNames;
        Boolean b;

        public TableModel(Vector<TreeDlg.Categories> vector, String[] stringArray) {
            TreeCategories.this.mVector = vector;
            this.b = false;
            this.columnNames = stringArray;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            if (this.columnNames != null) {
                return this.columnNames.length;
            }
            return 2;
        }

        @Override
        public int getRowCount() {
            if (TreeCategories.this.mVector != null) {
                return TreeCategories.this.mVector.size();
            }
            return 0;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TreeDlg.Categories categories = (TreeDlg.Categories)TreeCategories.this.mVector.get(n);
            if (n2 == 1) {
                return categories.isTargetCategory();
            }
            return categories;
        }

        public Object getValue(int n) {
            return TreeCategories.this.mVector.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                Boolean bl = (Boolean)object;
                ((TreeDlg.Categories)TreeCategories.this.mVector.get(n)).setTargetCategory(bl);
            }
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 1) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public void fireTableDataChanged() {
            super.fireTableDataChanged();
            TreeCategories.this.enableContinue(this.getRowCount() >= 2);
            if (TreeCategories.this.mVector != null) {
                Collections.sort(TreeCategories.this.mVector, new TreeDlg.CategoriesTableSorter((TreeDlg)TreeCategories.this.mParentDlg));
            }
        }

        public Vector<TreeDlg.Categories> getTableData() {
            return TreeCategories.this.mVector;
        }
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        JLabel label;
        JLabel label1;
        JCheckBox check = new JCheckBox();
        Border mEmptyBorder = BorderFactory.createEmptyBorder();
        Border mHighLightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");

        TableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.label = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 0) {
                TreeDlg.Categories categories = null;
                if (object instanceof TreeDlg.Categories) {
                    categories = (TreeDlg.Categories)object;
                }
                try {
                    URL uRL = ResUtil.getCommonDlgImageResource(TreeCategories.this.getResString("IDS_TREE_CATEGORIES_TABLW_IMAGE"));
                    Vector<TreeDlg.Categories> vector = ((TreeDlg)TreeCategories.this.mParentDlg).getExcludeCategoryVector();
                    for (TreeDlg.Categories categories2 : vector) {
                        if (categories == null || !categories2.getObs().equals((Object)categories.getObs())) continue;
                        uRL = ResUtil.getCommonDlgImageResource(TreeCategories.this.getResString("IDS_TREE_CATEGORIES_TABLW_MISSING_IMAGE"));
                        break;
                    }
                    this.label.setHorizontalAlignment(2);
                    this.setText(categories != null ? categories.getLabel() : "");
                    this.setIcon(new ImageIcon(uRL));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }

    public class CustomListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            TreeDlg.Categories categories = (TreeDlg.Categories)object;
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            URL uRL = ResUtil.getCommonDlgImageResource(TreeCategories.this.getResString("IDS_TREE_CATEGORIES_TABLW_IMAGE"));
            Vector<TreeDlg.Categories> vector = ((TreeDlg)TreeCategories.this.mParentDlg).getExcludeCategoryVector();
            for (TreeDlg.Categories categories2 : vector) {
                if (!categories2.getObs().equals((Object)categories.getObs())) continue;
                uRL = ResUtil.getCommonDlgImageResource(TreeCategories.this.getResString("IDS_TREE_CATEGORIES_TABLW_MISSING_IMAGE"));
                break;
            }
            if (ComponentState.isBtdRtlOrLtr() && categories.getLabel() != null && categories.getLabel().length() > 0) {
                jLabel.setText(ComponentState.prepareStringForBidiRendering((String)categories.getLabel()));
            } else {
                jLabel.setText(categories.getLabel());
            }
            jLabel.setIcon(new ImageIcon(uRL));
            return jLabel;
        }
    }
}

