/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.rfm_analysis;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.rfm_analysis.RFMBaseDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class VariablesTab
extends BaseProcedureTab
implements ItemListener,
ListDataListener {
    private JScrollPane mSrcScrollPane;
    private SrcVariableList mSrcVarList;
    private ArrowButton mIntervalListArrow;
    private ArrowButton mTransactionsListArrow;
    private ArrowButton mAmountListArrow;
    private ArrowButton mIdentifiersListArrow;
    private JScrollPane mAmountListScrollPane;
    private JScrollPane mIntervalListScrollPane;
    private JScrollPane mTransactionsListScrollPane;
    private JScrollPane mIdentifiersListScrollPane;
    private TargetVariableList mIntervalList;
    private TargetVariableList mTransactionsList;
    private TargetVariableList mAmountList;
    private TargetVariableList mIdentifiersList;
    static final String INTERVAL_LIST = "IDS_RFM_INTERVAL_LIST";
    static final String TRANSACTIONS_LIST = "IDS_RFM_TRANSACTIONS_LIST";
    static final String AMOUNT_LIST = "IDS_RFM_AMOUNT_LIST";
    static final String IDENTIFIERS_LIST = "IDS_RFM_IDENTIFIERS_LIST";

    public VariablesTab(RFMBaseDialog rFMBaseDialog) {
        super(rFMBaseDialog, true);
    }

    @Override
    public void reset() {
        super.reset();
        this.mIntervalList.getModel().removeAll();
        this.mTransactionsList.getModel().removeAll();
        this.mAmountList.getModel().removeAll();
        this.mIdentifiersList.getModel().removeAll();
        this.mSrcVarList.loadFromActiveDataset(true);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mIntervalListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mIntervalList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mIntervalList.addVarFilter(spssVarFilter);
        this.mIntervalList.setIdentifier(INTERVAL_LIST);
        this.mIntervalList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mIntervalListScrollPane = new JScrollPane(this.mIntervalList);
        this.mIntervalListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mIntervalListScrollPane.setVerticalScrollBarPolicy(21);
        this.mIntervalListScrollPane.setPreferredSize(this.mIntervalList.getMinimumSize());
        this.mTransactionsListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTransactionsList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        spssVarFilter = new SpssVarFilter(8, true, false);
        this.mTransactionsList.addVarFilter(spssVarFilter);
        this.mTransactionsList.setIdentifier(TRANSACTIONS_LIST);
        this.mTransactionsList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTransactionsListScrollPane = new JScrollPane(this.mTransactionsList);
        this.mTransactionsListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTransactionsListScrollPane.setVerticalScrollBarPolicy(21);
        this.mTransactionsListScrollPane.setPreferredSize(this.mTransactionsList.getMinimumSize());
        this.mAmountListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mAmountList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        spssVarFilter = new SpssVarFilter(8, true, false);
        this.mAmountList.addVarFilter(spssVarFilter);
        this.mAmountList.setIdentifier(AMOUNT_LIST);
        this.mAmountList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mAmountListScrollPane = new JScrollPane(this.mAmountList);
        this.mAmountListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mAmountListScrollPane.setVerticalScrollBarPolicy(21);
        this.mAmountListScrollPane.setPreferredSize(this.mAmountList.getMinimumSize());
        this.mIdentifiersListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mIdentifiersList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mIdentifiersList.setIdentifier(IDENTIFIERS_LIST);
        this.mIdentifiersList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mIdentifiersList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mIdentifiersList.getFixedCellHeight() + 6));
        this.mIdentifiersListScrollPane = new JScrollPane(this.mIdentifiersList);
        this.mIdentifiersListScrollPane.setPreferredSize(this.mIdentifiersList.getMinimumSize());
        this.mIntervalList.getModel().addListDataListener(this);
        this.mIntervalListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mIntervalListArrow.registerVariableList(this.mIntervalList, SpssArrowButton.ButtonOrientation.left);
        this.mTransactionsList.getModel().addListDataListener(this);
        this.mTransactionsListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTransactionsListArrow.registerVariableList(this.mTransactionsList, SpssArrowButton.ButtonOrientation.left);
        this.mAmountList.getModel().addListDataListener(this);
        this.mAmountListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mAmountListArrow.registerVariableList(this.mAmountList, SpssArrowButton.ButtonOrientation.left);
        this.mIdentifiersList.getModel().addListDataListener(this);
        this.mIdentifiersListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mIdentifiersListArrow.registerVariableList(this.mIdentifiersList, SpssArrowButton.ButtonOrientation.left);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_RFM_SOURCE_VARIABLE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_RFM_INTERVAL_VARIABLE_LIST_LABEL");
        jLabel2.setLabelFor(this.mIntervalList);
        JLabel jLabel3 = DialogUtil.createLabel(this.mParent, "IDS_RFM_TRANSACTIONS_VARIABLE_LIST_LABEL");
        jLabel3.setLabelFor(this.mTransactionsList);
        JLabel jLabel4 = DialogUtil.createLabel(this.mParent, "IDS_RFM_AMOUNT_VARIABLE_LIST_LABEL");
        jLabel4.setLabelFor(this.mAmountList);
        JLabel jLabel5 = DialogUtil.createLabel(this.mParent, "IDS_RFM_IDENTIFIERS_VARIABLE_LIST_LABEL");
        jLabel5.setLabelFor(this.mIdentifiersList);
        JLabel jLabel6 = new JLabel(new ImageIcon(this.getResImageURL("IDS_RFM_CUSTOMER_IMAGE")));
        Insets insets = new Insets(10, 2, 1, 2);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets3 = DialogUtil.getStandardControlInsets();
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_RFM_CUSTOMER_DESCRIPTION"));
        jTextArea.setRows(3);
        jTextArea.setFont(jLabel.getFont());
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setMinimumSize(new Dimension(150, 50));
        jTextArea.setPreferredSize(new Dimension(150, 50));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(this, jLabel6, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(this, jTextArea, gridBagConstraints, 1, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(this, this.mSrcScrollPane, gridBagConstraints, 0, 2, 1, 8, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 11;
        insets2.top = 0;
        DialogUtil.addUsingGBL(this, this.mIntervalListArrow, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this, this.mTransactionsListArrow, gridBagConstraints, 1, 4, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this, this.mAmountListArrow, gridBagConstraints, 1, 6, 1, 1, n, insets2);
        insets2 = DialogUtil.getArrowButtonInsets();
        n = 10;
        DialogUtil.addUsingGBL(this, this.mIdentifiersListArrow, gridBagConstraints, 1, 8, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, jLabel2, gridBagConstraints, 2, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mIntervalListScrollPane, gridBagConstraints, 2, 2, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, jLabel3, gridBagConstraints, 2, 3, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(this, this.mTransactionsListScrollPane, gridBagConstraints, 2, 4, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, jLabel4, gridBagConstraints, 2, 5, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(this, this.mAmountListScrollPane, gridBagConstraints, 2, 6, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, jLabel5, gridBagConstraints, 2, 7, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(this, this.mIdentifiersListScrollPane, gridBagConstraints, 2, 8, 1, 1, n, insets3);
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        JComponent jComponent;
        Vector<Object> vector = new Vector<Object>();
        if (this.mParent instanceof RFMBaseDialog) {
            jComponent = ((RFMBaseDialog)this.mParent).getTabbedPane();
            vector.add(jComponent);
        }
        vector.add(this.mSrcVarList);
        vector.add(this.mIntervalListArrow);
        vector.add(this.mTransactionsListArrow);
        vector.add(this.mAmountListArrow);
        vector.add(this.mIdentifiersListArrow);
        vector.add(this.mIntervalList);
        vector.add(this.mTransactionsList);
        vector.add(this.mAmountList);
        vector.add(this.mIdentifiersList);
        jComponent = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    protected void generateSyntax(StringBuffer stringBuffer) {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        String string = VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)"RFM_TEMP1_", (int)0);
        String string2 = VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)"RFM_TEMP2_", (int)0);
        String string3 = VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)"RFM_TEMP3_", (int)0);
        String string4 = ((RFMBaseDialog)this.mParent).getRecencyBinVariable();
        String string5 = ((RFMBaseDialog)this.mParent).getFrequencyBinVariable();
        String string6 = ((RFMBaseDialog)this.mParent).getAmountBinVariable();
        String string7 = ((RFMBaseDialog)this.mParent).getRFMScoreVariable();
        String string8 = ((RFMBaseDialog)this.mParent).getRecencyNumberOfBins();
        String string9 = ((RFMBaseDialog)this.mParent).getFrequencyNumberOfBins();
        String string10 = ((RFMBaseDialog)this.mParent).getAmountNumberOfBins();
        ISpssVariable iSpssVariable = this.mIntervalList.getModel().getElementAt(0);
        String string11 = this.mIntervalList.getVariablesStringList();
        String string12 = this.mTransactionsList.getVariablesStringList();
        String string13 = this.mAmountList.getVariablesStringList();
        if (((RFMBaseDialog)this.mParent).isRandomTies()) {
            stringBuffer.append(SyntaxUtil.getCommand("COMPUTE"));
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(string11);
            stringBuffer.append("+(rv.uniform(.0001, .1))");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getCommand("COMPUTE"));
            stringBuffer.append(" ");
            stringBuffer.append(string2);
            stringBuffer.append("=");
            stringBuffer.append(string12);
            stringBuffer.append("+(rv.uniform(.0001, .1))");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getCommand("COMPUTE"));
            stringBuffer.append(" ");
            stringBuffer.append(string3);
            stringBuffer.append("=");
            stringBuffer.append(string13);
            stringBuffer.append("+(rv.uniform(.0001, .1))");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (this.mSrcVarList.getModel().findElementIndexesByName(string4).length == 1) {
            stringBuffer.append(SyntaxUtil.getCommand("DELETE VARIABLES"));
            stringBuffer.append(" ");
            stringBuffer.append(string4);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("RANK"));
        stringBuffer.append("\n");
        stringBuffer.append(" ");
        if (((RFMBaseDialog)this.mParent).isRandomTies()) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string11);
        }
        stringBuffer.append("\n");
        if (iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat()) {
            stringBuffer.append(" (A)");
        } else {
            stringBuffer.append(" (D)");
        }
        stringBuffer.append("\n");
        stringBuffer.append(" /NTILES ");
        stringBuffer.append("(");
        stringBuffer.append(string8);
        stringBuffer.append(")");
        stringBuffer.append(" INTO ");
        stringBuffer.append(string4);
        stringBuffer.append("\n /PRINT=NO");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mSrcVarList.getModel().findElementIndexesByName(string5).length == 1) {
            stringBuffer.append(SyntaxUtil.getCommand("DELETE VARIABLES"));
            stringBuffer.append(" ");
            stringBuffer.append(string5);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("RANK"));
        stringBuffer.append("\n");
        stringBuffer.append(" ");
        if (((RFMBaseDialog)this.mParent).isRandomTies()) {
            stringBuffer.append(string2);
        } else {
            stringBuffer.append(string12);
        }
        if (((RFMBaseDialog)this.mParent).isNestedBinning()) {
            stringBuffer.append(" BY ");
            stringBuffer.append(string4);
        }
        stringBuffer.append("\n");
        stringBuffer.append(" /NTILES ");
        stringBuffer.append("(");
        stringBuffer.append(string9);
        stringBuffer.append(")");
        stringBuffer.append(" INTO ");
        stringBuffer.append(string5);
        stringBuffer.append("\n /PRINT=NO");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mSrcVarList.getModel().findElementIndexesByName(string6).length == 1) {
            stringBuffer.append(SyntaxUtil.getCommand("DELETE VARIABLES"));
            stringBuffer.append(" ");
            stringBuffer.append(string6);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("RANK"));
        stringBuffer.append("\n");
        stringBuffer.append(" ");
        if (((RFMBaseDialog)this.mParent).isRandomTies()) {
            stringBuffer.append(string3);
        } else {
            stringBuffer.append(string13);
        }
        if (((RFMBaseDialog)this.mParent).isNestedBinning()) {
            stringBuffer.append(" BY ");
            stringBuffer.append(string4);
            stringBuffer.append(" ");
            stringBuffer.append(string5);
        }
        stringBuffer.append("\n");
        stringBuffer.append(" /NTILES ");
        stringBuffer.append("(");
        stringBuffer.append(string10);
        stringBuffer.append(")");
        stringBuffer.append(" INTO ");
        stringBuffer.append(string6);
        stringBuffer.append("\n /PRINT=NO");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mSrcVarList.getModel().findElementIndexesByName(string7).length == 1) {
            stringBuffer.append(SyntaxUtil.getCommand("DELETE VARIABLES"));
            stringBuffer.append(" ");
            stringBuffer.append(string7);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getCommand("COMPUTE"));
        stringBuffer.append(" ");
        stringBuffer.append(string7);
        stringBuffer.append("=");
        stringBuffer.append(string4);
        stringBuffer.append("*100+");
        stringBuffer.append(string5);
        stringBuffer.append("*10+");
        stringBuffer.append(string6);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getCommand("EXECUTE"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getCommand("FORMATS"));
        stringBuffer.append(" ");
        stringBuffer.append(string7);
        stringBuffer.append(" (F3.0)");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getCommand("VARIABLE LABELS"));
        stringBuffer.append(" ");
        stringBuffer.append(string4);
        stringBuffer.append(" '");
        stringBuffer.append(this.getResString("IDS_RFM_SAVE_DESC_ROW_RECENCY_SCORE"));
        stringBuffer.append("'\n");
        stringBuffer.append(" /");
        stringBuffer.append(string5);
        stringBuffer.append(" '");
        stringBuffer.append(this.getResString("IDS_RFM_SAVE_DESC_ROW_FREQUENCY_SCORE"));
        stringBuffer.append("'\n");
        stringBuffer.append(" /");
        stringBuffer.append(string6);
        stringBuffer.append(" '");
        stringBuffer.append(this.getResString("IDS_RFM_SAVE_DESC_ROW_MONETARY_SCORE"));
        stringBuffer.append("'\n");
        stringBuffer.append(" /");
        stringBuffer.append(string7);
        stringBuffer.append(" '");
        stringBuffer.append(this.getResString("IDS_RFM_SAVE_DESC_ROW_RFM_SCORE"));
        stringBuffer.append("'");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (((RFMBaseDialog)this.mParent).isRandomTies()) {
            stringBuffer.append(SyntaxUtil.getCommand("DELETE VARIABLES"));
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(string2);
            stringBuffer.append(" ");
            stringBuffer.append(string3);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
    }

    protected String getRecencyVariable() {
        return this.mIntervalList.getVariablesStringList();
    }

    protected String getFrequencyVariable() {
        return this.mTransactionsList.getVariablesStringList();
    }

    protected String getAmountVariable() {
        return this.mAmountList.getVariablesStringList();
    }

    public void generateSyntaxForDeleteNotUsedVariables(StringBuffer stringBuffer) {
        stringBuffer.append(SyntaxUtil.getCommand("DELETE VARIABLES"));
        int n = this.mSrcVarList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
            String string = this.mSrcVarList.getModel().getElementAt(i).getName();
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.mIntervalList.getVariablesStringList());
        stringBuffer.append("\n");
        stringBuffer.append(" ");
        stringBuffer.append(this.mTransactionsList.getVariablesStringList());
        stringBuffer.append("\n");
        stringBuffer.append(" ");
        stringBuffer.append(this.mAmountList.getVariablesStringList());
        stringBuffer.append(SyntaxUtil.terminateSyntax());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    private void updateOkPaste() {
        ((RFMBaseDialog)this.mParent).enableOkPaste(this.mIntervalList.getModel().getSize() > 0 && this.mTransactionsList.getModel().getSize() > 0 && this.mAmountList.getModel().getSize() > 0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rfm_customers";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mSrcVarList;
    }

    public TargetVariableList getIdentifiersList() {
        return this.mIdentifiersList;
    }

    @Override
    protected boolean validateTab() {
        if (this.mIdentifiersList.getModel().getSize() == 0 && (((RFMBaseDialog)this.mParent).isDataSetUsed() || ((RFMBaseDialog)this.mParent).isDataFileUsed())) {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_RFM_NO_CUSTOMER_ID"), VersionInfo.getAppVersionString());
            this.mSrcVarList.requestFocusInWindow();
            return false;
        }
        return super.validateTab();
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
    }
}

