/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.rfm_analysis;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.rfm_analysis.RFMBaseDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class TransactionsVariablesTab
extends BaseProcedureTab
implements ItemListener,
ListDataListener {
    private JScrollPane mSrcScrollPane;
    private SrcVariableList mSrcVarList;
    private ArrowButton mIntervalListArrow;
    private ArrowButton mAmountListArrow;
    private ArrowButton mIdentifiersListArrow;
    private JScrollPane mAmountListScrollPane;
    private JScrollPane mIntervalListScrollPane;
    private JScrollPane mIdentifiersListScrollPane;
    private TargetVariableList mIntervalList;
    private TargetVariableList mAmountList;
    private TargetVariableList mIdentifiersList;
    private JComboBox mSummaryList;
    private String[] mSummaryItems;
    private String[] mSummaryFunctions = new String[]{"MAX", "MEAN", "MEDIAN", "SUM"};
    static final String INTERVAL_LIST = "IDS_RFM_INTERVAL_LIST";
    static final String AMOUNT_LIST = "IDS_RFM_AMOUNT_LIST";
    static final String IDENTIFIERS_LIST = "IDS_RFM_IDENTIFIERS_LIST";

    public TransactionsVariablesTab(RFMBaseDialog rFMBaseDialog) {
        super(rFMBaseDialog, true);
    }

    @Override
    public void reset() {
        super.reset();
        this.mIntervalList.getModel().removeAll();
        this.mAmountList.getModel().removeAll();
        this.mIdentifiersList.getModel().removeAll();
        this.mSrcVarList.loadFromActiveDataset(true);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mIntervalListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mIntervalList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        SpssVarFilter spssVarFilter = new SpssVarFilter(32, false, false);
        this.mIntervalList.addVarFilter(spssVarFilter);
        this.mIntervalList.setIdentifier(INTERVAL_LIST);
        this.mIntervalList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mIntervalListScrollPane = new JScrollPane(this.mIntervalList);
        this.mIntervalListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mIntervalListScrollPane.setVerticalScrollBarPolicy(21);
        this.mIntervalListScrollPane.setPreferredSize(this.mIntervalList.getMinimumSize());
        this.mAmountListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mAmountList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        spssVarFilter = new SpssVarFilter(8, true, false);
        this.mAmountList.addVarFilter(spssVarFilter);
        this.mAmountList.setIdentifier(AMOUNT_LIST);
        this.mAmountList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mAmountListScrollPane = new JScrollPane(this.mAmountList);
        this.mAmountListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mAmountListScrollPane.setVerticalScrollBarPolicy(21);
        this.mAmountListScrollPane.setPreferredSize(this.mAmountList.getMinimumSize());
        this.mSummaryItems = new String[]{this.getResString("IDS_RFM_SUMMARY_METHOD_MAXIMUM"), this.getResString("IDS_RFM_SUMMARY_METHOD_MEAN"), this.getResString("IDS_RFM_SUMMARY_METHOD_MEDIAN"), this.getResString("IDS_RFM_SUMMARY_METHOD_TOTAL")};
        this.mSummaryList = new JComboBox<String>(this.mSummaryItems);
        this.mSummaryList.setSelectedItem(this.getResString("IDS_RFM_SUMMARY_METHOD_TOTAL"));
        this.mIdentifiersListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mIdentifiersList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mIdentifiersList.setIdentifier(IDENTIFIERS_LIST);
        this.mIdentifiersList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mIdentifiersList.getFixedCellHeight() + 6));
        this.mIdentifiersList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mIdentifiersListScrollPane = new JScrollPane(this.mIdentifiersList);
        this.mIdentifiersListScrollPane.setPreferredSize(this.mIdentifiersList.getMinimumSize());
        this.mIntervalList.getModel().addListDataListener(this);
        this.mIntervalListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mIntervalListArrow.registerVariableList(this.mIntervalList, SpssArrowButton.ButtonOrientation.left);
        this.mAmountList.getModel().addListDataListener(this);
        this.mAmountListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mAmountListArrow.registerVariableList(this.mAmountList, SpssArrowButton.ButtonOrientation.left);
        this.mIdentifiersList.getModel().addListDataListener(this);
        this.mIdentifiersListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mIdentifiersListArrow.registerVariableList(this.mIdentifiersList, SpssArrowButton.ButtonOrientation.left);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_RFM_SOURCE_VARIABLE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_RFM_DATE_VARIABLE_LIST_LABEL");
        jLabel2.setLabelFor(this.mIntervalList);
        JLabel jLabel3 = DialogUtil.createLabel(this.mParent, "IDS_RFM_TRANSACTION_AMOUNT_VARIABLE_LIST_LABEL");
        jLabel3.setLabelFor(this.mAmountList);
        JLabel jLabel4 = DialogUtil.createLabel(this.mParent, "IDS_RFM_IDENTIFIERS_VARIABLE_LIST_LABEL");
        jLabel4.setLabelFor(this.mIdentifiersList);
        JLabel jLabel5 = DialogUtil.createLabel(this.mParent, "IDS_RFM_SUMMARY_METHOD_LABEL");
        jLabel5.setLabelFor(this.mSummaryList);
        JLabel jLabel6 = new JLabel(new ImageIcon(this.getResImageURL("IDS_RFM_TRANSACTION_IMAGE")));
        Insets insets = DialogUtil.getArrowButtonInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets2 = DialogUtil.getStandardControlInsets();
        Insets insets3 = new Insets(10, 2, 1, 2);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_RFM_TRANSACTION_DESCRIPTION"));
        jTextArea.setRows(3);
        jTextArea.setFont(jLabel.getFont());
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setMinimumSize(new Dimension(150, 50));
        jTextArea.setPreferredSize(new Dimension(150, 50));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(this, jLabel6, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(this, jTextArea, gridBagConstraints, 1, 0, 2, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(this, this.mSrcScrollPane, gridBagConstraints, 0, 2, 1, 4, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 11;
        insets.top = 0;
        DialogUtil.addUsingGBL(this, this.mIntervalListArrow, gridBagConstraints, 1, 2, 1, 1, n, insets);
        insets.top = 20;
        DialogUtil.addUsingGBL(this, this.mAmountListArrow, gridBagConstraints, 1, 3, 1, 1, n, insets);
        n = 10;
        insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(this, this.mIdentifiersListArrow, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, jLabel2, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(this, this.mIntervalListScrollPane, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        DialogUtil.applyTopBorder(jPanel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mAmountListScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, jLabel5, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mSummaryList, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 5, 1, 1, n, OptionsUtil.DROPDOWN_INSETS);
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        DialogUtil.applyTopBorder(jPanel3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, jLabel4, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel3, this.mIdentifiersListScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(this, jPanel3, gridBagConstraints, 2, 4, 1, 1, n, insets2);
        this.setFocusTraversalPolicy();
        this.mSrcVarList.requestFocus();
    }

    private void setFocusTraversalPolicy() {
        JComponent jComponent;
        Vector<Object> vector = new Vector<Object>();
        if (this.mParent instanceof RFMBaseDialog) {
            jComponent = ((RFMBaseDialog)this.mParent).getTabbedPane();
            vector.add(jComponent);
        }
        vector.add(this.mSrcVarList);
        vector.add(this.mIntervalListArrow);
        vector.add(this.mAmountListArrow);
        vector.add(this.mIdentifiersListArrow);
        vector.add(this.mIntervalList);
        vector.add(this.mAmountList);
        vector.add(this.mSummaryList);
        vector.add(this.mIdentifiersList);
        jComponent = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        dialogDataModel.putString("IDS_RFM_TRANSACTION_SELECTED_SUMMARY_FUNCTION", (String)this.mSummaryList.getSelectedItem());
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
        String string = dialogDataModel.getString("IDS_RFM_TRANSACTION_SELECTED_SUMMARY_FUNCTION");
        if (string != null) {
            this.mSummaryList.setSelectedItem(string);
        }
    }

    protected void generateSyntax(StringBuffer stringBuffer) {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        ISpssVariable iSpssVariable = this.mIntervalList.getModel().getElementAt(0);
        String string = this.mIntervalList.getVariablesStringList();
        String string2 = this.mAmountList.getVariablesStringList();
        String string3 = this.mAmountList.getVariablesStringList();
        String string4 = ((RFMBaseDialog)this.mParent).getRecencyVariable();
        String string5 = ((RFMBaseDialog)this.mParent).getFrequencyVariable();
        String string6 = ((RFMBaseDialog)this.mParent).getAmountVariable();
        String string7 = VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)"RFM_TEMP1_", (int)0);
        String string8 = VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)"RFM_TEMP2_", (int)0);
        String string9 = VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)"RFM_TEMP3_", (int)0);
        String string10 = ((RFMBaseDialog)this.mParent).getRecencyBinVariable();
        String string11 = ((RFMBaseDialog)this.mParent).getFrequencyBinVariable();
        String string12 = ((RFMBaseDialog)this.mParent).getAmountBinVariable();
        String string13 = ((RFMBaseDialog)this.mParent).getRFMScoreVariable();
        String string14 = ((RFMBaseDialog)this.mParent).getRecencyNumberOfBins();
        String string15 = ((RFMBaseDialog)this.mParent).getFrequencyNumberOfBins();
        String string16 = ((RFMBaseDialog)this.mParent).getAmountNumberOfBins();
        if (((RFMBaseDialog)this.mParent).isDataSetUsed() && DatasetNameValidator.getActiveDatasetName().length() == 0) {
            stringBuffer.append(SyntaxUtil.getCommand("DATASET NAME"));
            stringBuffer.append(" ");
            stringBuffer.append(DataDocument.getNextFreeDatasetName());
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        String string17 = ((RFMBaseDialog)this.mParent).getDataSetName();
        if (((RFMBaseDialog)this.mParent).isDataFileUsed()) {
            string17 = DataDocument.getNextFreeDatasetName((boolean)true);
        }
        stringBuffer.append(SyntaxUtil.getCommand("DATASET DECLARE"));
        stringBuffer.append(" ");
        stringBuffer.append(string17);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getCommand("AGGREGATE"));
        stringBuffer.append(" /OUTFILE=");
        stringBuffer.append(string17);
        stringBuffer.append("\n");
        stringBuffer.append(" /BREAK=");
        stringBuffer.append(this.mIdentifiersList.getVariablesStringList());
        stringBuffer.append("\n");
        stringBuffer.append(" /");
        stringBuffer.append(string4);
        if (iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat()) {
            stringBuffer.append("=MAX(");
        } else {
            stringBuffer.append("=MIN(");
        }
        stringBuffer.append(string);
        stringBuffer.append(")\n");
        stringBuffer.append(" /");
        stringBuffer.append(string5);
        stringBuffer.append("=NU(");
        stringBuffer.append(string2);
        stringBuffer.append(")\n");
        stringBuffer.append(" /");
        stringBuffer.append(string6);
        stringBuffer.append("=");
        stringBuffer.append(this.getSummaryFunction((String)this.mSummaryList.getSelectedItem()));
        stringBuffer.append("(");
        stringBuffer.append(string3);
        stringBuffer.append(")");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getCommand("DATASET ACTIVATE"));
        stringBuffer.append(" ");
        stringBuffer.append(string17);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (((RFMBaseDialog)this.mParent).isRandomTies()) {
            stringBuffer.append(SyntaxUtil.getCommand("COMPUTE"));
            stringBuffer.append(" ");
            stringBuffer.append(string7);
            stringBuffer.append("=");
            stringBuffer.append(string4);
            stringBuffer.append("+(rv.uniform(.0001, .1))");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getCommand("COMPUTE"));
            stringBuffer.append(" ");
            stringBuffer.append(string8);
            stringBuffer.append("=");
            stringBuffer.append(string5);
            stringBuffer.append("+(rv.uniform(.0001, .1))");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getCommand("COMPUTE"));
            stringBuffer.append(" ");
            stringBuffer.append(string9);
            stringBuffer.append("=");
            stringBuffer.append(string6);
            stringBuffer.append("+(rv.uniform(.0001, .1))");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (this.mSrcVarList.getModel().findElementIndexesByName(string10).length == 1) {
            stringBuffer.append(SyntaxUtil.getCommand("DELETE VARIABLES"));
            stringBuffer.append(" ");
            stringBuffer.append(string10);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("RANK"));
        stringBuffer.append("\n");
        stringBuffer.append(" ");
        if (((RFMBaseDialog)this.mParent).isRandomTies()) {
            stringBuffer.append(string7);
        } else {
            stringBuffer.append(string4);
        }
        stringBuffer.append("\n");
        if (iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat()) {
            stringBuffer.append(" (A)");
        } else {
            stringBuffer.append(" (D)");
        }
        stringBuffer.append("\n");
        stringBuffer.append(" /NTILES ");
        stringBuffer.append("(");
        stringBuffer.append(string14);
        stringBuffer.append(")");
        stringBuffer.append(" INTO ");
        stringBuffer.append(string10);
        stringBuffer.append("\n /PRINT=NO");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mSrcVarList.getModel().findElementIndexesByName(string11).length == 1) {
            stringBuffer.append(SyntaxUtil.getCommand("DELETE VARIABLES"));
            stringBuffer.append(" ");
            stringBuffer.append(string11);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("RANK"));
        stringBuffer.append("\n");
        stringBuffer.append(" ");
        if (((RFMBaseDialog)this.mParent).isRandomTies()) {
            stringBuffer.append(string8);
        } else {
            stringBuffer.append(string5);
        }
        if (((RFMBaseDialog)this.mParent).isNestedBinning()) {
            stringBuffer.append(" BY ");
            stringBuffer.append(string10);
        }
        stringBuffer.append("\n");
        stringBuffer.append(" /NTILES ");
        stringBuffer.append("(");
        stringBuffer.append(string15);
        stringBuffer.append(")");
        stringBuffer.append(" INTO ");
        stringBuffer.append(string11);
        stringBuffer.append("\n /PRINT=NO");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mSrcVarList.getModel().findElementIndexesByName(string12).length == 1) {
            stringBuffer.append(SyntaxUtil.getCommand("DELETE VARIABLES"));
            stringBuffer.append(" ");
            stringBuffer.append(string12);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("RANK"));
        stringBuffer.append("\n");
        stringBuffer.append(" ");
        if (((RFMBaseDialog)this.mParent).isRandomTies()) {
            stringBuffer.append(string9);
        } else {
            stringBuffer.append(string6);
        }
        if (((RFMBaseDialog)this.mParent).isNestedBinning()) {
            stringBuffer.append(" BY ");
            stringBuffer.append(string10);
            stringBuffer.append(" ");
            stringBuffer.append(string11);
        }
        stringBuffer.append("\n");
        stringBuffer.append(" /NTILES ");
        stringBuffer.append("(");
        stringBuffer.append(string16);
        stringBuffer.append(")");
        stringBuffer.append(" INTO ");
        stringBuffer.append(string12);
        stringBuffer.append("\n /PRINT=NO");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mSrcVarList.getModel().findElementIndexesByName(string13).length == 1) {
            stringBuffer.append(SyntaxUtil.getCommand("DELETE VARIABLES"));
            stringBuffer.append(" ");
            stringBuffer.append(string13);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getCommand("COMPUTE"));
        stringBuffer.append(" ");
        stringBuffer.append(string13);
        stringBuffer.append("=");
        stringBuffer.append(string10);
        stringBuffer.append("*100+");
        stringBuffer.append(string11);
        stringBuffer.append("*10+");
        stringBuffer.append(string12);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getCommand("EXECUTE"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getCommand("FORMATS"));
        stringBuffer.append(" ");
        stringBuffer.append(string13);
        stringBuffer.append(" (F3.0)");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getCommand("VARIABLE LABELS"));
        stringBuffer.append(" ");
        stringBuffer.append(string4);
        stringBuffer.append(" '");
        stringBuffer.append(this.getResString("IDS_RFM_SAVE_DESC_ROW_RECENCY"));
        stringBuffer.append("'\n");
        stringBuffer.append(" /");
        stringBuffer.append(string5);
        stringBuffer.append(" '");
        stringBuffer.append(this.getResString("IDS_RFM_SAVE_DESC_ROW_FREQUENCY"));
        stringBuffer.append("'\n");
        stringBuffer.append(" /");
        stringBuffer.append(string6);
        stringBuffer.append(" '");
        stringBuffer.append(this.getResString("IDS_RFM_SAVE_DESC_ROW_MONETARY"));
        stringBuffer.append("'\n");
        stringBuffer.append(" /");
        stringBuffer.append(string10);
        stringBuffer.append(" '");
        stringBuffer.append(this.getResString("IDS_RFM_SAVE_DESC_ROW_RECENCY_SCORE"));
        stringBuffer.append("'\n");
        stringBuffer.append(" /");
        stringBuffer.append(string11);
        stringBuffer.append(" '");
        stringBuffer.append(this.getResString("IDS_RFM_SAVE_DESC_ROW_FREQUENCY_SCORE"));
        stringBuffer.append("'\n");
        stringBuffer.append(" /");
        stringBuffer.append(string12);
        stringBuffer.append(" '");
        stringBuffer.append(this.getResString("IDS_RFM_SAVE_DESC_ROW_MONETARY_SCORE"));
        stringBuffer.append("'\n");
        stringBuffer.append(" /");
        stringBuffer.append(string13);
        stringBuffer.append(" '");
        stringBuffer.append(this.getResString("IDS_RFM_SAVE_DESC_ROW_RFM_SCORE"));
        stringBuffer.append("'");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (((RFMBaseDialog)this.mParent).isRandomTies()) {
            stringBuffer.append(SyntaxUtil.getCommand("DELETE VARIABLES"));
            stringBuffer.append(" ");
            stringBuffer.append(string7);
            stringBuffer.append(" ");
            stringBuffer.append(string8);
            stringBuffer.append(" ");
            stringBuffer.append(string9);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
    }

    public void generateSyntaxForDeleteNotUsedVariables(StringBuffer stringBuffer) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    private void updateOkPaste() {
        ((RFMBaseDialog)this.mParent).enableOkPaste(this.mIntervalList.getModel().getSize() > 0 && this.mAmountList.getModel().getSize() > 0 && this.mIdentifiersList.getModel().getSize() > 0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    private String getSummaryFunction(String string) {
        String string2 = null;
        for (int i = 0; i < this.mSummaryItems.length; ++i) {
            if (this.mSummaryItems[i].compareToIgnoreCase(string) != 0) continue;
            string2 = this.mSummaryFunctions[i];
            break;
        }
        return string2;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rfm_transactions";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mSrcVarList;
    }

    public TargetVariableList getIdentifiersList() {
        return this.mIdentifiersList;
    }
}

