/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.rfm_analysis;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.rfm_analysis.CheckBoxRenderer;
import com.spss.java_client.ui.dialogs.rfm_analysis.RFMBaseDialog;
import com.spss.java_client.ui.dialogs.rfm_analysis.SaveTableItem;
import com.spss.java_client.ui.dialogs.rfm_analysis.SaveTableModel;
import com.spss.java_client.ui.dialogs.rfm_analysis.SaveTableRenderer;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.TextAttribute;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class TransactionsSaveTab
extends BaseProcedureTab
implements ActionListener,
ItemListener,
FocusListener {
    private JRadioButton mNewButton;
    private JRadioButton mFileButton;
    private JLabel mDatasetNameLabel;
    private StringTextField mDatasetNameTxt;
    private JButton mBrowseButton;
    private FileTextField mFileTxt;
    private JLabel mVariablesLabel;
    private PlainTable mSaveTable;
    private JScrollPane mSaveTableScrollPane;
    private SpssButtonGroup mDatabuttonGrp;

    public TransactionsSaveTab(RFMBaseDialog rFMBaseDialog) {
        super(rFMBaseDialog, true);
    }

    protected String getRecencyVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        String string = "";
        string = this.isSaveRecencyVariable() ? (String)saveTableModel.getValueAt(0, 2) : RFMBaseDialog.getUniqueTempVarName(RFMBaseDialog.sDefault_recency_score);
        return string;
    }

    protected String getFrequencyVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        String string = "";
        string = this.isSaveFrequencyVariable() ? (String)saveTableModel.getValueAt(1, 2) : RFMBaseDialog.getUniqueTempVarName(RFMBaseDialog.sDefault_frequency_score);
        return string;
    }

    protected String getAmountVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        String string = "";
        string = this.isSaveAmountVariable() ? (String)saveTableModel.getValueAt(2, 2) : RFMBaseDialog.getUniqueTempVarName(RFMBaseDialog.sDefault_amount);
        return string;
    }

    protected String getRecencyBinVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        String string = "";
        string = this.isSaveRecencyBinVariable() ? (String)saveTableModel.getValueAt(3, 2) : RFMBaseDialog.getUniqueTempVarName(RFMBaseDialog.sDefault_recency_bin_score);
        return string;
    }

    protected String getFrequencyBinVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        String string = "";
        string = this.isSaveFrequencyBinVariable() ? (String)saveTableModel.getValueAt(4, 2) : RFMBaseDialog.getUniqueTempVarName(RFMBaseDialog.sDefault_frequency_bin_score);
        return string;
    }

    protected String getAmountBinVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        String string = "";
        string = this.isSaveAmountBinVariable() ? (String)saveTableModel.getValueAt(5, 2) : RFMBaseDialog.getUniqueTempVarName(RFMBaseDialog.sDefault_amount_bin);
        return string;
    }

    protected String getRFMScoreVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        return (String)saveTableModel.getValueAt(6, 2);
    }

    protected boolean isSaveRecencyVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        return (Boolean)saveTableModel.getValueAt(0, 0);
    }

    protected boolean isSaveFrequencyVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        return (Boolean)saveTableModel.getValueAt(1, 0);
    }

    protected boolean isSaveAmountVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        return (Boolean)saveTableModel.getValueAt(2, 0);
    }

    protected boolean isSaveRecencyBinVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        return (Boolean)saveTableModel.getValueAt(3, 0);
    }

    protected boolean isSaveFrequencyBinVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        return (Boolean)saveTableModel.getValueAt(4, 0);
    }

    protected boolean isSaveAmountBinVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        return (Boolean)saveTableModel.getValueAt(5, 0);
    }

    protected boolean isSaveRFMScoreVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        return (Boolean)saveTableModel.getValueAt(6, 0);
    }

    protected void enableOkPaste(boolean bl) {
        ((RFMBaseDialog)this.mParent).enableOkPaste(bl);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        JPanel jPanel = this.setupSavePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, 0, 0, 0);
        int n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets2 = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this, this.mVariablesLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mSaveTableScrollPane, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        JComponent jComponent;
        Vector<Object> vector = new Vector<Object>();
        if (this.mParent instanceof RFMBaseDialog) {
            jComponent = ((RFMBaseDialog)this.mParent).getTabbedPane();
            vector.add(jComponent);
        }
        vector.add(this.mSaveTable);
        vector.add(this.mDatabuttonGrp);
        vector.add(this.mDatasetNameTxt);
        vector.add(this.mBrowseButton);
        vector.add(this.mFileTxt);
        jComponent = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    protected String getDataSetName() {
        String string = null;
        if (this.mNewButton.isSelected()) {
            string = this.mDatasetNameTxt.getText();
        } else if (this.mFileButton.isSelected()) {
            string = CharacterUtil.smartQuote((String)this.mFileTxt.getText());
        }
        return string;
    }

    protected boolean isDataSetUsed() {
        return this.mNewButton.isSelected();
    }

    protected boolean isDataFileUsed() {
        return this.mFileButton.isSelected();
    }

    @Override
    public void reset() {
        super.reset();
        this.mNewButton.setSelected(true);
        this.mSaveTable.setModel(this.getSaveTableModel());
        TableColumnModel tableColumnModel = this.mSaveTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new CheckBoxRenderer(new SaveTableRenderer()));
    }

    private void initVars() {
        this.mSaveTable = new PlainTable(){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                final Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    if (ComponentState.isBtdRtlOrLtr() && (JTextComponent)component != null && ((JTextComponent)component).getDocument() != null) {
                        if (ComponentState.getBTD() == 1) {
                            ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                        } else {
                            ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                        }
                    }
                    if (eventObject == null) {
                        ((JTextComponent)component).selectAll();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)component).selectAll();
                            }
                        });
                    }
                }
                return bl;
            }
        };
        this.mSaveTable.setModel(this.getSaveTableModel());
        this.mSaveTable.setRowSelectionAllowed(false);
        this.mSaveTable.setCellSelectionEnabled(true);
        this.mSaveTable.setAutoResizeMode(3);
        this.mSaveTable.getColumnModel().getColumn(0).setPreferredWidth(15);
        this.mSaveTable.getColumnModel().getColumn(1).setPreferredWidth(130);
        this.mSaveTable.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.mSaveTable.setDefaultRenderer(Object.class, new SaveTableRenderer());
        JTableHeader jTableHeader = this.mSaveTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = null;
                jLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalAlignment(0);
                jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                jLabel.setBackground(jTable.getTableHeader().getBackground());
                jLabel.setForeground(jTable.getTableHeader().getForeground());
                jLabel.setFont(jTable.getTableHeader().getFont().deriveFont(1));
                return jLabel;
            }
        });
        TableColumnModel tableColumnModel = this.mSaveTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new CheckBoxRenderer(new SaveTableRenderer()));
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mSaveTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.mSaveTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mSaveTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mSaveTable.getActionMap().put("tabIn", abstractAction2);
        this.mSaveTable.getActionMap().put("tabOut", abstractAction);
        this.mSaveTableScrollPane = new JScrollPane(this.mSaveTable, 21, 31);
        Dimension dimension = this.mSaveTableScrollPane.getSize();
        dimension.height = 140;
        this.mSaveTableScrollPane.setPreferredSize(dimension);
        this.mVariablesLabel = DialogUtil.createLabel(this.mParent, "IDS_RFM_SAVE_VARIABLES_LABEL");
        this.mVariablesLabel.setLabelFor(this.mSaveTable);
        ControlAction controlAction = new ToggleButtonAction(this.mParent, "IDS_RFM_SAVE_NEW");
        this.mNewButton = new JRadioButton(controlAction);
        this.mNewButton.addItemListener(this);
        this.mDatasetNameTxt = new StringTextField(10);
        this.mDatasetNameTxt.setText(DataDocument.getNextFreeDatasetName((boolean)true));
        this.mDatasetNameLabel = DialogUtil.createLabel(this.mParent, "IDS_RFM_DATASET_NAME");
        this.mDatasetNameLabel.setLabelFor((Component)((Object)this.mDatasetNameTxt));
        controlAction = new TextFieldAction(this.mParent, "IDS_RFM_DATASET_NAME_TXT");
        this.mDatasetNameTxt.setAction(controlAction);
        this.mDatasetNameTxt.addFocusListener(this);
        controlAction = new ToggleButtonAction(this.mParent, "IDS_RFM_SAVE_FILE");
        this.mFileButton = new JRadioButton(controlAction);
        this.mFileButton.addItemListener(this);
        this.mDatabuttonGrp = new SpssButtonGroup();
        this.mDatabuttonGrp.add(this.mNewButton);
        this.mDatabuttonGrp.add(this.mFileButton);
        this.mFileTxt = new FileTextField();
        this.mFileTxt.setBorder(BorderFactory.createEmptyBorder());
        this.mFileTxt.setColumns(30);
        controlAction = new TextFieldAction(this.mParent, "IDS_RFM_FILE_TXT");
        this.mFileTxt.setAction(controlAction);
        this.mFileTxt.setEditable(false);
        controlAction = new ToggleButtonAction(this.mParent, "IDS_RFM_BROWSE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
                RefFileFilter refFileFilter = new RefFileFilter(TransactionsSaveTab.this.getResString("IDS_RFM_FILTER_DESCRIPTION"), TransactionsSaveTab.this.getResString("IDS_RFM_FILE_EXTENSION"));
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                remoteFileChooser.setDialogTitle(TransactionsSaveTab.this.getResString("IDS_RFM_FILE_DIALOG_TITLE"));
                int n = remoteFileChooser.showSaveDialog((Component)TransactionsSaveTab.this.mParent);
                if (n == 0) {
                    FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    String string = remoteFileChooser.getSelectedFilePath();
                    if (!string.endsWith(TransactionsSaveTab.this.getResString("IDS_RFM_FILE_EXTENSION"))) {
                        string = string + TransactionsSaveTab.this.getResString("IDS_RFM_FILE_EXTENSION");
                    }
                    TransactionsSaveTab.this.mFileTxt.setText(string);
                    TransactionsSaveTab.this.mFileTxt.setOpaque(true);
                    TransactionsSaveTab.this.mFileTxt.setFocusable(true);
                }
            }
        };
        this.mBrowseButton = new JButton(controlAction);
        this.mNewButton.setSelected(true);
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        Vector<SaveTableItem> vector = ((SaveTableModel)this.mSaveTable.getModel()).getTableData();
        dialogDataModel.putSerializableArray("IDS_RFM_SAVE_TAB_TABLE_MODEL", vector.toArray(new SerializableObject[vector.size()]));
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("IDS_RFM_SAVE_TAB_TABLE_MODEL");
        if (serializableObjectArray != null) {
            Vector<SaveTableItem> vector = new Vector<SaveTableItem>();
            for (SerializableObject serializableObject : serializableObjectArray) {
                try {
                    vector.add((SaveTableItem)((SaveTableItem)serializableObject).clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
            this.mSaveTable.setModel(new SaveTableModel(vector, this.mSaveTable, this.getColumnNames()));
            TableColumnModel tableColumnModel = this.mSaveTable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            tableColumn.setCellRenderer(new CheckBoxRenderer(new SaveTableRenderer()));
        }
    }

    private String[] getColumnNames() {
        String[] stringArray = new String[]{this.getResString("IDS_RFM_SAVE_SAVE_COL_HEADING"), this.getResString("IDS_RFM_SAVE_DESC_COL_HEADING"), this.getResString("IDS_RFM_SAVE_NAME_COL_HEADING")};
        return stringArray;
    }

    private SaveTableModel getSaveTableModel() {
        Vector<SaveTableItem> vector = new Vector<SaveTableItem>();
        SaveTableItem saveTableItem = new SaveTableItem(this.getResString("IDS_RFM_SAVE_DESC_ROW_RECENCY"), true, this.getResString("IDS_RFM_SAVE_DEFAULT_NAME_ROW_RECENCY"));
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(this.getResString("IDS_RFM_SAVE_DESC_ROW_FREQUENCY"), true, this.getResString("IDS_RFM_SAVE_DEFAULT_NAME_ROW_FREQUENCY"));
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(this.getResString("IDS_RFM_SAVE_DESC_ROW_MONETARY"), true, this.getResString("IDS_RFM_SAVE_DEFAULT_NAME_ROW_MONETARY"));
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(this.getResString("IDS_RFM_SAVE_DESC_ROW_RECENCY_SCORE"), true, this.getResString("IDS_RFM_SAVE_DEFAULT_NAME_ROW_RECENCY_SCORE"));
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(this.getResString("IDS_RFM_SAVE_DESC_ROW_FREQUENCY_SCORE"), true, this.getResString("IDS_RFM_SAVE_DEFAULT_NAME_ROW_FREQUENCY_SCORE"));
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(this.getResString("IDS_RFM_SAVE_DESC_ROW_MONETARY_SCORE"), true, this.getResString("IDS_RFM_SAVE_DEFAULT_NAME_ROW_MONETARY_SCORE"));
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(this.getResString("IDS_RFM_SAVE_DESC_ROW_RFM_SCORE"), true, this.getResString("IDS_RFM_SAVE_DEFAULT_NAME_ROW_RFM_SCORE"));
        saveTableItem.setCheckboxEnabled(false);
        vector.addElement(saveTableItem);
        return new SaveTableModel(vector, this.mSaveTable, this.getColumnNames());
    }

    @Override
    protected void aboutToShowTab() {
        SerializableObject[] serializableObjectArray;
        DialogDataModel dialogDataModel = ((RFMBaseDialog)this.mParent).getDialogDataModel();
        if (dialogDataModel != null && (serializableObjectArray = dialogDataModel.getSerializableArray("IDS_RFM_SAVE_TAB_TABLE_MODEL")) != null) {
            Vector<SaveTableItem> vector = new Vector<SaveTableItem>();
            for (SerializableObject serializableObject : serializableObjectArray) {
                try {
                    vector.add((SaveTableItem)((SaveTableItem)serializableObject).clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
            this.mSaveTable.setModel(new SaveTableModel(vector, this.mSaveTable, this.getColumnNames()));
            TableColumnModel tableColumnModel = this.mSaveTable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            tableColumn.setCellRenderer(new CheckBoxRenderer(new SaveTableRenderer()));
        }
    }

    private JPanel setupSavePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_RFM_SAVE_TITLE")));
        int n = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, n2, 0, n2);
        insets2.set(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mNewButton, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.set(n2, n2 * 6, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDatasetNameLabel, gridBagConstraints, 1, 0, 1, 1, 10, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(n2, n3, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDatasetNameTxt), gridBagConstraints, 2, 0, 1, 1, 21, insets2);
        gridBagConstraints.fill = 0;
        insets2.set(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mFileButton, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(n2 + insets.left, insets.left, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileTxt), gridBagConstraints, 2, 1, 1, 1, n, insets);
        return jPanel;
    }

    private boolean checkTextValidation(StringTextField stringTextField) {
        boolean bl;
        int n = DatasetNameValidator.validateDatasetName((String)stringTextField.getText(), (Component)this);
        if (n == 1) {
            bl = true;
        } else {
            bl = false;
            stringTextField.selectAll();
            stringTextField.requestFocus();
        }
        return bl;
    }

    @Override
    protected boolean validateTab() {
        if (!this.isValidTable()) {
            return false;
        }
        if (this.mNewButton.isSelected() && this.mDatasetNameTxt.getText().trim().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_RFM_NO_DATASET_MSG"), VersionInfo.getAppVersionString());
            this.mDatasetNameTxt.selectAll();
            this.mDatasetNameTxt.requestFocus();
            return false;
        }
        if (this.mNewButton.isSelected() && this.mDatasetNameTxt.getText().length() >= 1) {
            return this.checkTextValidation(this.mDatasetNameTxt);
        }
        if (this.mFileButton.isSelected()) {
            if (this.mFileTxt.getText().trim().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_RFM_NO_FILE_MSG"), VersionInfo.getAppVersionString());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TransactionsSaveTab.this.mBrowseButton.requestFocus();
                    }
                });
                return false;
            }
            if (!FileValidator.validatePath(this, this.mFileTxt.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection())) {
                this.mFileTxt.requestFocus();
                this.mFileTxt.selectAll();
                return false;
            }
        }
        return super.validateTab();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mNewButton) {
            this.mDatasetNameLabel.setEnabled(true);
            this.mDatasetNameTxt.setEnabled(true);
            this.mDatasetNameTxt.setOpaque(true);
            this.mFileTxt.setEnabled(false);
            this.mBrowseButton.setEnabled(false);
        } else if (object == this.mFileButton) {
            this.mDatasetNameLabel.setEnabled(false);
            this.mDatasetNameTxt.setEnabled(false);
            this.mDatasetNameTxt.setOpaque(false);
            this.mFileTxt.setEnabled(true);
            this.mFileTxt.setOpaque(true);
            this.mFileTxt.setFocusable(true);
            this.mBrowseButton.setEnabled(true);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mDatasetNameTxt) {
            this.mDatasetNameTxt.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    protected void generateSyntax(StringBuffer stringBuffer) {
        if (this.mFileButton.isSelected()) {
            this.generateSyntaxForDeleteNotUsedScores(stringBuffer);
            stringBuffer.append("SAVE OUTFILE=");
            stringBuffer.append(CharacterUtil.smartQuote((String)this.mFileTxt.getText()));
            stringBuffer.append("\n /COMPRESSED");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (this.mNewButton.isSelected()) {
            this.generateSyntaxForDeleteNotUsedScores(stringBuffer);
        }
    }

    private void generateSyntaxForDeleteNotUsedScores(StringBuffer stringBuffer) {
        if (!(this.isSaveRecencyVariable() && this.isSaveFrequencyVariable() && this.isSaveAmountVariable() && this.isSaveRecencyBinVariable() && this.isSaveFrequencyBinVariable() && this.isSaveAmountBinVariable() && this.isSaveRFMScoreVariable())) {
            String string = this.getRecencyVariable();
            String string2 = this.getFrequencyVariable();
            String string3 = this.getAmountVariable();
            String string4 = this.getRecencyBinVariable();
            String string5 = this.getFrequencyBinVariable();
            String string6 = this.getAmountBinVariable();
            String string7 = this.getRFMScoreVariable();
            stringBuffer.append(SyntaxUtil.getCommand("DELETE VARIABLES"));
            if (!this.isSaveRecencyVariable()) {
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            if (!this.isSaveFrequencyVariable()) {
                stringBuffer.append(" ");
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            if (!this.isSaveAmountVariable()) {
                stringBuffer.append(" ");
                stringBuffer.append(string3);
                stringBuffer.append("\n");
            }
            if (!this.isSaveRecencyBinVariable()) {
                stringBuffer.append(" ");
                stringBuffer.append(string4);
                stringBuffer.append("\n");
            }
            if (!this.isSaveFrequencyBinVariable()) {
                stringBuffer.append(" ");
                stringBuffer.append(string5);
                stringBuffer.append("\n");
            }
            if (!this.isSaveAmountBinVariable()) {
                stringBuffer.append(" ");
                stringBuffer.append(string6);
                stringBuffer.append("\n");
            }
            if (!this.isSaveRFMScoreVariable()) {
                stringBuffer.append(" ");
                stringBuffer.append(string7);
                stringBuffer.append("\n");
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rfm_save_transactions";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mSaveTable;
    }

    public boolean isValidTable() {
        boolean bl = true;
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        try {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.mSaveTable.getModel().getRowCount(); ++i) {
                String string;
                int n = 2;
                SaveTableItem saveTableItem = (SaveTableItem)saveTableModel.getValue(i);
                if (!saveTableItem.getSave() || !saveTableItem.isEnabled()) continue;
                TableCellEditor tableCellEditor = this.mSaveTable.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                    this.mSaveTable.getSelectionModel().clearSelection();
                }
                if (!this.isLegalValue(string = this.mSaveTable.getModel().getValueAt(i, n).toString())) {
                    this.changeSelection(i, n);
                    return false;
                }
                vector.add(this.mSaveTable.getModel().getValueAt(i, n).toString());
                if (!this.isDuplicateValue(vector)) continue;
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_RFM_SAVE_DUPLICATE_VALUE_MSG"), VersionInfo.getAppVersionString());
                this.changeSelection(i, n);
                return false;
            }
        }
        catch (Exception exception) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_RFM_SAVE_WARNING_MESG1"), VersionInfo.getAppVersionString());
            bl = false;
        }
        return bl;
    }

    private boolean isLegalValue(String string) {
        boolean bl;
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        if (n > 0 && n != 100) {
            DialogUtil.showBadSpssVarNameWarning(n, this.mParent);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isDuplicateValue(Vector<String> vector) {
        Object[] objectArray = vector.toArray();
        for (int i = 0; i <= vector.toArray().length - 1; ++i) {
            for (int j = i + 1; j <= vector.toArray().length - 1; ++j) {
                if (objectArray[i].toString().trim().compareToIgnoreCase(objectArray[j].toString().trim()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    private void changeSelection(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TransactionsSaveTab.this.mSaveTable.changeSelection(n, n2, false, false);
                TransactionsSaveTab.this.mSaveTable.editCellAt(n, n2, null);
                TransactionsSaveTab.this.mSaveTable.requestFocusInWindow();
            }
        });
    }
}

