/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.rfm_analysis;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.rfm_analysis.CheckBoxRenderer;
import com.spss.java_client.ui.dialogs.rfm_analysis.RFMBaseDialog;
import com.spss.java_client.ui.dialogs.rfm_analysis.SaveTableItem;
import com.spss.java_client.ui.dialogs.rfm_analysis.SaveTableModel;
import com.spss.java_client.ui.dialogs.rfm_analysis.SaveTableRenderer;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.TextAttribute;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class SaveTab
extends BaseProcedureTab
implements ActionListener,
ItemListener,
FocusListener {
    private JRadioButton mAutomaticButton;
    private JRadioButton mCustomButton;
    private JRadioButton mActiveButton;
    private JRadioButton mNewButton;
    private JRadioButton mFileButton;
    private JLabel mDatasetNameLabel;
    private StringTextField mDatasetNameTxt;
    private JButton mBrowseButton;
    private FileTextField mFileTxt;
    private JLabel mVariablesLabel;
    private PlainTable mSaveTable;
    private JScrollPane mSaveTableScrollPane;
    private SpssButtonGroup mNamesButtonGrp;
    private SpssButtonGroup mDatabuttonGrp;
    private String mCopyDatasetName = null;
    private String mOriginalDatasetName = null;

    public SaveTab(RFMBaseDialog rFMBaseDialog) {
        super(rFMBaseDialog, true);
    }

    protected String getRFMScoreVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        return (String)saveTableModel.getValueAt(3, 2);
    }

    protected String getRecencyBinVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        String string = "";
        string = this.isSaveRecencyBinVariable() ? (String)saveTableModel.getValueAt(0, 2) : RFMBaseDialog.getUniqueTempVarName(RFMBaseDialog.sDefault_recency_bin_score);
        return string;
    }

    protected String getFrequencyBinVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        String string = "";
        string = this.isSaveFrequencyBinVariable() ? (String)saveTableModel.getValueAt(1, 2) : RFMBaseDialog.getUniqueTempVarName(RFMBaseDialog.sDefault_frequency_bin_score);
        return string;
    }

    protected String getAmountBinVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        String string = "";
        string = this.isSaveAmountBinVariable() ? (String)saveTableModel.getValueAt(2, 2) : RFMBaseDialog.getUniqueTempVarName(RFMBaseDialog.sDefault_amount_bin);
        return string;
    }

    protected boolean isSaveRFMScoreVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        return (Boolean)saveTableModel.getValueAt(3, 0);
    }

    protected boolean isSaveRecencyBinVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        return (Boolean)saveTableModel.getValueAt(0, 0);
    }

    protected boolean isSaveFrequencyBinVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        return (Boolean)saveTableModel.getValueAt(1, 0);
    }

    protected boolean isSaveAmountBinVariable() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        return (Boolean)saveTableModel.getValueAt(2, 0);
    }

    protected void enableOkPaste(boolean bl) {
        ((RFMBaseDialog)this.mParent).enableOkPaste(bl);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        JPanel jPanel = this.setupSavePanel();
        JPanel jPanel2 = this.setupNamesPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, 0, 0, 0);
        int n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        Insets insets2 = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this, this.mVariablesLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mSaveTableScrollPane, gridBagConstraints, 0, 2, 1, 1, n2, insets2);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        JComponent jComponent;
        Vector<Object> vector = new Vector<Object>();
        if (this.mParent instanceof RFMBaseDialog) {
            jComponent = ((RFMBaseDialog)this.mParent).getTabbedPane();
            vector.add(jComponent);
        }
        vector.add(this.mNamesButtonGrp);
        vector.add(this.mSaveTable);
        vector.add(this.mDatabuttonGrp);
        vector.add(this.mDatasetNameTxt);
        vector.add(this.mBrowseButton);
        vector.add(this.mFileTxt);
        jComponent = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    @Override
    public void reset() {
        super.reset();
        this.mActiveButton.setSelected(true);
        this.mAutomaticButton.setSelected(true);
        this.mSaveTable.setModel(this.getSaveTableModel());
        TableColumnModel tableColumnModel = this.mSaveTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new CheckBoxRenderer(new SaveTableRenderer()));
    }

    private void initVars() {
        this.mAutomaticButton = DialogUtil.createRadioButton(this.mParent, "IDS_RFM_SAVE_AUTOMATIC_NAME", (ActionListener)this);
        this.mCustomButton = DialogUtil.createRadioButton(this.mParent, "IDS_RFM_SAVE_CUSTOM_NAME", (ActionListener)this);
        this.mNamesButtonGrp = new SpssButtonGroup();
        this.mNamesButtonGrp.add(this.mAutomaticButton);
        this.mNamesButtonGrp.add(this.mCustomButton);
        this.mSaveTable = new PlainTable(){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                final Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    if (ComponentState.isBtdRtlOrLtr() && (JTextComponent)component != null && ((JTextComponent)component).getDocument() != null) {
                        if (ComponentState.getBTD() == 1) {
                            ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                        } else {
                            ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                        }
                    }
                    if (eventObject == null) {
                        ((JTextComponent)component).selectAll();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)component).selectAll();
                            }
                        });
                    }
                }
                return bl;
            }
        };
        this.mSaveTable.setModel(this.getSaveTableModel());
        this.mSaveTable.setRowSelectionAllowed(false);
        this.mSaveTable.setCellSelectionEnabled(true);
        this.mSaveTable.setAutoResizeMode(3);
        this.mSaveTable.getColumnModel().getColumn(0).setPreferredWidth(15);
        this.mSaveTable.getColumnModel().getColumn(1).setPreferredWidth(130);
        this.mSaveTable.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.mSaveTable.setDefaultRenderer(Object.class, new SaveTableRenderer());
        JTableHeader jTableHeader = this.mSaveTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = null;
                jLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalAlignment(0);
                jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                jLabel.setBackground(jTable.getTableHeader().getBackground());
                jLabel.setForeground(jTable.getTableHeader().getForeground());
                jLabel.setFont(jTable.getTableHeader().getFont().deriveFont(1));
                return jLabel;
            }
        });
        TableColumnModel tableColumnModel = this.mSaveTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new CheckBoxRenderer(new SaveTableRenderer()));
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mSaveTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.mSaveTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mSaveTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mSaveTable.getActionMap().put("tabIn", abstractAction2);
        this.mSaveTable.getActionMap().put("tabOut", abstractAction);
        this.mSaveTableScrollPane = new JScrollPane(this.mSaveTable, 21, 31);
        Dimension dimension = this.mSaveTableScrollPane.getSize();
        dimension.height = 90;
        this.mSaveTableScrollPane.setPreferredSize(dimension);
        this.mVariablesLabel = DialogUtil.createLabel(this.mParent, "IDS_RFM_SAVE_VARIABLES_LABEL");
        this.mVariablesLabel.setLabelFor(this.mSaveTable);
        ControlAction controlAction = new ToggleButtonAction(this.mParent, "IDS_RFM_SAVE_ACTIVE");
        this.mActiveButton = new JRadioButton(controlAction);
        this.mActiveButton.addItemListener(this);
        controlAction = new ToggleButtonAction(this.mParent, "IDS_RFM_SAVE_NEW");
        this.mNewButton = new JRadioButton(controlAction);
        this.mNewButton.addItemListener(this);
        this.mDatasetNameTxt = new StringTextField(10);
        this.mDatasetNameLabel = DialogUtil.createLabel(this.mParent, "IDS_RFM_DATASET_NAME");
        this.mDatasetNameLabel.setLabelFor((Component)((Object)this.mDatasetNameTxt));
        controlAction = new TextFieldAction(this.mParent, "IDS_RFM_DATASET_NAME_TXT");
        this.mDatasetNameTxt.setAction(controlAction);
        this.mDatasetNameTxt.addFocusListener(this);
        controlAction = new ToggleButtonAction(this.mParent, "IDS_RFM_SAVE_FILE");
        this.mFileButton = new JRadioButton(controlAction);
        this.mFileButton.addItemListener(this);
        this.mDatabuttonGrp = new SpssButtonGroup();
        this.mDatabuttonGrp.add(this.mActiveButton);
        this.mDatabuttonGrp.add(this.mNewButton);
        this.mDatabuttonGrp.add(this.mFileButton);
        this.mFileTxt = new FileTextField();
        this.mFileTxt.setBorder(BorderFactory.createEmptyBorder());
        this.mFileTxt.setColumns(30);
        controlAction = new TextFieldAction(this.mParent, "IDS_RFM_FILE_TXT");
        this.mFileTxt.setAction(controlAction);
        this.mFileTxt.setEditable(false);
        controlAction = new ToggleButtonAction(this.mParent, "IDS_RFM_BROWSE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
                RefFileFilter refFileFilter = new RefFileFilter(SaveTab.this.getResString("IDS_RFM_FILTER_DESCRIPTION"), SaveTab.this.getResString("IDS_RFM_FILE_EXTENSION"));
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                remoteFileChooser.setDialogTitle(SaveTab.this.getResString("IDS_RFM_FILE_DIALOG_TITLE"));
                int n = remoteFileChooser.showSaveDialog((Component)SaveTab.this.mParent);
                if (n == 0) {
                    FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    String string = remoteFileChooser.getSelectedFilePath();
                    if (!string.endsWith(SaveTab.this.getResString("IDS_RFM_FILE_EXTENSION"))) {
                        string = string + SaveTab.this.getResString("IDS_RFM_FILE_EXTENSION");
                    }
                    SaveTab.this.mFileTxt.setText(string);
                    SaveTab.this.mFileTxt.setOpaque(true);
                    SaveTab.this.mFileTxt.setFocusable(true);
                }
            }
        };
        this.mBrowseButton = new JButton(controlAction);
        this.mActiveButton.setSelected(true);
        this.mAutomaticButton.addItemListener(this);
        this.mCustomButton.addItemListener(this);
        this.mAutomaticButton.setSelected(true);
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        Vector<SaveTableItem> vector = ((SaveTableModel)this.mSaveTable.getModel()).getTableData();
        dialogDataModel.putSerializableArray("IDS_RFM_SAVE_TAB_TABLE_MODEL", vector.toArray(new SerializableObject[vector.size()]));
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        super.loadTabState(dialogDataModel, nameLabelOption);
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("IDS_RFM_SAVE_TAB_TABLE_MODEL");
        if (serializableObjectArray != null) {
            Vector<SaveTableItem> vector = new Vector<SaveTableItem>();
            for (SerializableObject serializableObject : serializableObjectArray) {
                try {
                    SaveTableItem saveTableItem = (SaveTableItem)((SaveTableItem)serializableObject).clone();
                    if (this.mAutomaticButton.isSelected()) {
                        String string = saveTableItem.getDefaultVariableNamePrefix();
                        string = VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)string, (int)0);
                        saveTableItem.setVariableNamePrefix(string);
                    }
                    vector.add(saveTableItem);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
            SaveTableModel saveTableModel = new SaveTableModel(vector, this.mSaveTable, this.getColumnNames());
            saveTableModel.setNamesEditable(!this.mAutomaticButton.isSelected());
            this.mSaveTable.setModel(saveTableModel);
            TableColumnModel tableColumnModel = this.mSaveTable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            tableColumn.setCellRenderer(new CheckBoxRenderer(new SaveTableRenderer()));
        }
    }

    private String[] getColumnNames() {
        String[] stringArray = new String[]{this.getResString("IDS_RFM_SAVE_SAVE_COL_HEADING"), this.getResString("IDS_RFM_SAVE_DESC_COL_HEADING"), this.getResString("IDS_RFM_SAVE_NAME_COL_HEADING")};
        return stringArray;
    }

    private SaveTableModel getSaveTableModel() {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        Vector<SaveTableItem> vector = new Vector<SaveTableItem>();
        SaveTableItem saveTableItem = new SaveTableItem(this.getResString("IDS_RFM_SAVE_DESC_ROW_RECENCY_SCORE"), true, VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)this.getResString("IDS_RFM_SAVE_DEFAULT_NAME_ROW_RECENCY_SCORE"), (int)0));
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(this.getResString("IDS_RFM_SAVE_DESC_ROW_FREQUENCY_SCORE"), true, VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)this.getResString("IDS_RFM_SAVE_DEFAULT_NAME_ROW_FREQUENCY_SCORE"), (int)0));
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(this.getResString("IDS_RFM_SAVE_DESC_ROW_MONETARY_SCORE"), true, VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)this.getResString("IDS_RFM_SAVE_DEFAULT_NAME_ROW_MONETARY_SCORE"), (int)0));
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(this.getResString("IDS_RFM_SAVE_DESC_ROW_RFM_SCORE"), true, VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)this.getResString("IDS_RFM_SAVE_DEFAULT_NAME_ROW_RFM_SCORE"), (int)0));
        saveTableItem.setCheckboxEnabled(false);
        vector.addElement(saveTableItem);
        SaveTableModel saveTableModel = new SaveTableModel(vector, this.mSaveTable, this.getColumnNames());
        saveTableModel.setNamesEditable(!this.mAutomaticButton.isSelected());
        return saveTableModel;
    }

    @Override
    protected void aboutToShowTab() {
        SerializableObject[] serializableObjectArray;
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        DialogDataModel dialogDataModel = ((RFMBaseDialog)this.mParent).getDialogDataModel();
        if (dialogDataModel != null && (serializableObjectArray = dialogDataModel.getSerializableArray("IDS_RFM_SAVE_TAB_TABLE_MODEL")) != null) {
            Vector<SaveTableItem> vector = new Vector<SaveTableItem>();
            for (SerializableObject serializableObject : serializableObjectArray) {
                try {
                    SaveTableItem saveTableItem = (SaveTableItem)((SaveTableItem)serializableObject).clone();
                    if (this.mAutomaticButton.isSelected()) {
                        String string = saveTableItem.getDefaultVariableNamePrefix();
                        string = VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)string, (int)0);
                        saveTableItem.setVariableNamePrefix(string);
                    }
                    vector.add(saveTableItem);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
            SaveTableModel saveTableModel = new SaveTableModel(vector, this.mSaveTable, this.getColumnNames());
            saveTableModel.setNamesEditable(!this.mAutomaticButton.isSelected());
            this.mSaveTable.setModel(saveTableModel);
            TableColumnModel tableColumnModel = this.mSaveTable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            tableColumn.setCellRenderer(new CheckBoxRenderer(new SaveTableRenderer()));
        }
    }

    private JPanel setupNamesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_RFM_SAVE_NAMES_TITLE")));
        int n = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mAutomaticButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCustomButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupSavePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_RFM_SAVE_TITLE")));
        int n = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mActiveButton, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mNewButton, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.set(n2, n2 * 6, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDatasetNameLabel, gridBagConstraints, 1, 1, 1, 1, 10, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(n2, n3, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDatasetNameTxt), gridBagConstraints, 2, 1, 1, 1, 21, insets2);
        gridBagConstraints.fill = 0;
        insets2.set(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mFileButton, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(n2 + insets.left, insets.left, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileTxt), gridBagConstraints, 2, 2, 1, 1, n, insets);
        return jPanel;
    }

    private boolean checkTextValidation(StringTextField stringTextField) {
        boolean bl;
        int n = DatasetNameValidator.validateDatasetName((String)stringTextField.getText(), (Component)this);
        if (n == 1) {
            bl = true;
        } else {
            bl = false;
            stringTextField.selectAll();
            stringTextField.requestFocus();
        }
        return bl;
    }

    protected String getDataSetName() {
        String string = null;
        if (this.mNewButton.isSelected()) {
            string = this.mDatasetNameTxt.getText();
        } else if (this.mFileButton.isSelected()) {
            string = CharacterUtil.smartQuote((String)this.mFileTxt.getText());
        }
        return string;
    }

    protected boolean isDataSetUsed() {
        return this.mNewButton.isSelected();
    }

    protected boolean isDataFileUsed() {
        return this.mFileButton.isSelected();
    }

    @Override
    protected boolean validateTab() {
        if (!this.isValidTable()) {
            return false;
        }
        if (this.mNewButton.isSelected() && this.mDatasetNameTxt.getText().trim().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_RFM_NO_DATASET_MSG"), VersionInfo.getAppVersionString());
            this.mDatasetNameTxt.selectAll();
            this.mDatasetNameTxt.requestFocus();
            return false;
        }
        if (this.mNewButton.isSelected() && this.mDatasetNameTxt.getText().length() >= 1 && !this.checkTextValidation(this.mDatasetNameTxt)) {
            return false;
        }
        if (this.mFileButton.isSelected()) {
            if (this.mFileTxt.getText().trim().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_RFM_NO_FILE_MSG"), VersionInfo.getAppVersionString());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SaveTab.this.mBrowseButton.requestFocus();
                    }
                });
                return false;
            }
            if (!FileValidator.validatePath(this, this.mFileTxt.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection())) {
                this.mFileTxt.requestFocus();
                this.mFileTxt.selectAll();
                return false;
            }
        }
        return super.validateTab();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mActiveButton) {
            this.mDatasetNameLabel.setEnabled(false);
            this.mDatasetNameTxt.setEnabled(false);
            this.mDatasetNameTxt.setOpaque(false);
            this.mFileTxt.setEnabled(false);
            this.mBrowseButton.setEnabled(false);
        } else if (object == this.mNewButton) {
            this.mDatasetNameLabel.setEnabled(true);
            this.mDatasetNameTxt.setEnabled(true);
            this.mDatasetNameTxt.setOpaque(true);
            this.mFileTxt.setEnabled(false);
            this.mBrowseButton.setEnabled(false);
        } else if (object == this.mFileButton) {
            this.mDatasetNameLabel.setEnabled(false);
            this.mDatasetNameTxt.setEnabled(false);
            this.mDatasetNameTxt.setOpaque(false);
            this.mFileTxt.setEnabled(true);
            this.mFileTxt.setOpaque(true);
            this.mFileTxt.setFocusable(true);
            this.mBrowseButton.setEnabled(true);
        } else if (object == this.mAutomaticButton) {
            if (this.mAutomaticButton.isSelected()) {
                int n;
                boolean bl = true;
                if (this.isVariableNamesDifferent() && (n = SpssAlertOptionPane.showConfirmDialog((Window)this.mParent, this.getResString("ERR_RFM_AUTOMATIC_FROM_CUSTOM_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) == 2) {
                    bl = false;
                    this.mCustomButton.setSelected(true);
                    this.mCustomButton.requestFocus();
                }
                if (bl) {
                    SaveTableModel saveTableModel = this.getSaveTableModel();
                    saveTableModel.setNamesEditable(false);
                    this.mSaveTable.setModel(saveTableModel);
                    TableColumnModel tableColumnModel = this.mSaveTable.getColumnModel();
                    TableColumn tableColumn = tableColumnModel.getColumn(0);
                    tableColumn.setCellRenderer(new CheckBoxRenderer(new SaveTableRenderer()));
                }
            } else {
                ((SaveTableModel)this.mSaveTable.getModel()).setNamesEditable(true);
            }
            this.mSaveTable.repaint();
        }
    }

    private boolean isVariableNamesDifferent() {
        boolean bl = false;
        SaveTableModel saveTableModel = this.getSaveTableModel();
        Vector<SaveTableItem> vector = saveTableModel.getTableData();
        saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        Vector<SaveTableItem> vector2 = saveTableModel.getTableData();
        if (vector.size() == vector2.size()) {
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.get(i).getDefaultVariableNamePrefix().compareTo(vector2.get(i).getDefaultVariableNamePrefix()) == 0) continue;
                bl = true;
                break;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mDatasetNameTxt) {
            this.mDatasetNameTxt.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    protected void generateSyntax(StringBuffer stringBuffer) {
        if (this.mFileButton.isSelected()) {
            stringBuffer.append("SAVE OUTFILE=");
            stringBuffer.append(CharacterUtil.smartQuote((String)this.mFileTxt.getText()));
            stringBuffer.append("\n");
            this.generateKeepVariablesSyntax(stringBuffer);
            stringBuffer.append(" /COMPRESSED");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            if (this.mOriginalDatasetName != null && this.mCopyDatasetName != null) {
                stringBuffer.append(SyntaxUtil.getCommand("DATASET ACTIVATE "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mOriginalDatasetName));
                stringBuffer.append(SyntaxUtil.terminateSyntax());
                stringBuffer.append(SyntaxUtil.getCommand("DATASET CLOSE "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mCopyDatasetName));
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
        }
        if (this.mNewButton.isSelected()) {
            stringBuffer.append(SyntaxUtil.getCommand("ADD FILES "));
            stringBuffer.append(" FILE=*\n");
            this.generateKeepVariablesSyntax(stringBuffer);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getCommand("EXECUTE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        } else if (this.mActiveButton.isSelected()) {
            this.generateSyntaxForDeleteNotUsedScores(stringBuffer);
        }
    }

    protected void generateDatasetCopySyntax(StringBuffer stringBuffer) {
        this.mOriginalDatasetName = null;
        this.mCopyDatasetName = null;
        if (this.mFileButton.isSelected() || this.mNewButton.isSelected()) {
            String string;
            this.mOriginalDatasetName = DatasetNameValidator.getActiveDatasetName();
            if (this.mOriginalDatasetName == null || this.mOriginalDatasetName.length() == 0) {
                this.mOriginalDatasetName = DataDocument.getNextFreeDatasetName((boolean)true);
                stringBuffer.append(SyntaxUtil.getCommand("DATASET NAME "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mOriginalDatasetName));
                stringBuffer.append(" WINDOW=FRONT");
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
            if (this.mNewButton.isSelected()) {
                string = this.mDatasetNameTxt.getText();
            } else {
                this.mCopyDatasetName = string = DataDocument.getNextFreeDatasetName((boolean)true);
            }
            stringBuffer.append(SyntaxUtil.getCommand("DATASET COPY "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
            stringBuffer.append(" WINDOW=FRONT");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getCommand("DATASET ACTIVATE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
    }

    private void generateSyntaxForDeleteNotUsedScores(StringBuffer stringBuffer) {
        if (!(this.isSaveRecencyBinVariable() && this.isSaveFrequencyBinVariable() && this.isSaveAmountBinVariable() && this.isSaveRFMScoreVariable())) {
            String string = this.getRecencyBinVariable();
            String string2 = this.getFrequencyBinVariable();
            String string3 = this.getAmountBinVariable();
            String string4 = this.getRFMScoreVariable();
            stringBuffer.append(SyntaxUtil.getCommand("DELETE VARIABLES"));
            if (!this.isSaveRecencyBinVariable()) {
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            if (!this.isSaveFrequencyBinVariable()) {
                stringBuffer.append(" ");
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            if (!this.isSaveAmountBinVariable()) {
                stringBuffer.append(" ");
                stringBuffer.append(string3);
                stringBuffer.append("\n");
            }
            if (!this.isSaveRFMScoreVariable()) {
                stringBuffer.append(" ");
                stringBuffer.append(string4);
                stringBuffer.append("\n");
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
    }

    private void generateKeepVariablesSyntax(StringBuffer stringBuffer) {
        stringBuffer.append(" /KEEP");
        stringBuffer.append("\n");
        stringBuffer.append(" ");
        stringBuffer.append(((RFMBaseDialog)this.mParent).getIdentifiersList().getVariablesStringList());
        stringBuffer.append("\n");
        String string = this.getRecencyBinVariable();
        String string2 = this.getFrequencyBinVariable();
        String string3 = this.getAmountBinVariable();
        String string4 = this.getRFMScoreVariable();
        if (this.isSaveRecencyBinVariable()) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        if (this.isSaveFrequencyBinVariable()) {
            stringBuffer.append(" ");
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        if (this.isSaveAmountBinVariable()) {
            stringBuffer.append(" ");
            stringBuffer.append(string3);
            stringBuffer.append("\n");
        }
        if (this.isSaveRFMScoreVariable()) {
            stringBuffer.append(" ");
            stringBuffer.append(string4);
            stringBuffer.append("\n");
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rfm_save_customers";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mAutomaticButton;
    }

    public boolean isValidTable() {
        boolean bl = true;
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        try {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.mSaveTable.getModel().getRowCount(); ++i) {
                String string;
                int n = 2;
                SaveTableItem saveTableItem = (SaveTableItem)saveTableModel.getValue(i);
                if (!saveTableItem.getSave() || !saveTableItem.isEnabled()) continue;
                TableCellEditor tableCellEditor = this.mSaveTable.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                    this.mSaveTable.getSelectionModel().clearSelection();
                }
                if (!this.isLegalValue(string = this.mSaveTable.getModel().getValueAt(i, n).toString())) {
                    this.changeSelection(i, n);
                    return false;
                }
                vector.add(this.mSaveTable.getModel().getValueAt(i, n).toString());
                if (this.isDuplicateValue(vector)) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_RFM_SAVE_DUPLICATE_VALUE_MSG"), VersionInfo.getAppVersionString());
                    this.changeSelection(i, n);
                    return false;
                }
                LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
                ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
                if (iSpssDataSrc.findVarIndex(string) == -1 || !this.mActiveButton.isSelected()) continue;
                String string2 = this.getResString("ERR_RFM_SAVE_DUPLICATE_VALUE_IN_DATASET_MSG");
                int n2 = SpssAlertOptionPane.showConfirmDialog((Window)this.mParent, string2 = String.format(string2, string), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                if (n2 != 2) continue;
                this.changeSelection(i, n);
                return false;
            }
        }
        catch (Exception exception) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_RFM_SAVE_WARNING_MESG1"), VersionInfo.getAppVersionString());
            bl = false;
        }
        return bl;
    }

    private boolean isLegalValue(String string) {
        boolean bl;
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        if (n > 0 && n != 100) {
            DialogUtil.showBadSpssVarNameWarning(n, this.mParent);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isDuplicateValue(Vector<String> vector) {
        Object[] objectArray = vector.toArray();
        for (int i = 0; i <= vector.toArray().length - 1; ++i) {
            for (int j = i + 1; j <= vector.toArray().length - 1; ++j) {
                if (objectArray[i].toString().trim().compareToIgnoreCase(objectArray[j].toString().trim()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    private void changeSelection(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SaveTab.this.mSaveTable.changeSelection(n, n2, false, false);
                SaveTab.this.mSaveTable.editCellAt(n, n2, null);
                SaveTab.this.mSaveTable.requestFocusInWindow();
            }
        });
    }
}

