/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.rfm_analysis;

import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.rfm_analysis.BinningTab;
import com.spss.java_client.ui.dialogs.rfm_analysis.OutputTab;
import com.spss.java_client.ui.dialogs.rfm_analysis.RFMBaseDialog;
import com.spss.java_client.ui.dialogs.rfm_analysis.TransactionsSaveTab;
import com.spss.java_client.ui.dialogs.rfm_analysis.TransactionsVariablesTab;
import com.spss.java_client.ui.doc_types.SpssFrame;
import java.awt.Component;
import javax.swing.JFrame;

public class RFMTransactionsDialog
extends RFMBaseDialog {
    private TransactionsVariablesTab mTransactionsVariablesTab;
    private TransactionsSaveTab mTransactionsSaveTab;

    public RFMTransactionsDialog(SpssFrame spssFrame) {
        super(spssFrame, true);
    }

    public RFMTransactionsDialog(JFrame jFrame) {
        super(jFrame, true);
    }

    @Override
    protected void secondInit(Component component) {
        super.secondInit(component);
        this.setTitle(this.getResString("IDS_RFM_TRANSACTION_TITLE"));
    }

    @Override
    public String getIActionKey() {
        return "analyze_rfm_transaction";
    }

    @Override
    protected void init() {
        super.init();
        this.mTransactionsVariablesTab = new TransactionsVariablesTab(this);
        this.mBinningTab = new BinningTab(this);
        this.mTransactionsSaveTab = new TransactionsSaveTab(this);
        this.mOutputTab = new OutputTab(this);
        this.addTab(this.getResString("IDS_RFM_VARIABLES_PANEL_TITLE"), this.mTransactionsVariablesTab);
        this.addTab(this.getResString("IDS_RFM_BINNING_PANEL_TITLE"), this.mBinningTab);
        this.addTab(this.getResString("IDS_RFM_SAVE_PANEL_TITLE"), this.mTransactionsSaveTab);
        this.addTab(this.getResString("IDS_RFM_OUTPUT_PANEL_TITLE"), this.mOutputTab);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mTabbedPane.setEnabledAt(2, false);
        }
        this.mTabbedPane.addChangeListener(this);
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mTransactionsVariablesTab.loadTabState(this.getDialogDataModel(), this.getNameLabelOverride());
        this.mBinningTab.loadTabState(this.getDialogDataModel(), this.getNameLabelOverride());
        this.mTransactionsSaveTab.loadTabState(this.getDialogDataModel(), this.getNameLabelOverride());
        this.mBinningTab.setVisible(false);
        this.mTransactionsSaveTab.setVisible(false);
        this.mOutputTab.setVisible(false);
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.mTransactionsVariablesTab.saveTabState(this.getDialogDataModel());
        this.mBinningTab.saveTabState(this.getDialogDataModel());
        this.mTransactionsSaveTab.saveTabState(this.getDialogDataModel());
    }

    @Override
    protected String getRFMScoreVariable() {
        return this.mTransactionsSaveTab.getRFMScoreVariable();
    }

    @Override
    protected String getRecencyBinVariable() {
        return this.mTransactionsSaveTab.getRecencyBinVariable();
    }

    @Override
    protected String getFrequencyBinVariable() {
        return this.mTransactionsSaveTab.getFrequencyBinVariable();
    }

    @Override
    protected String getAmountBinVariable() {
        return this.mTransactionsSaveTab.getAmountBinVariable();
    }

    @Override
    protected String getRecencyVariable() {
        return this.mTransactionsSaveTab.getRecencyVariable();
    }

    @Override
    protected String getFrequencyVariable() {
        return this.mTransactionsSaveTab.getFrequencyVariable();
    }

    @Override
    protected String getAmountVariable() {
        return this.mTransactionsSaveTab.getAmountVariable();
    }

    @Override
    protected void generateSyntaxForDeleteNotUsedVariables(StringBuffer stringBuffer) {
        this.mTransactionsVariablesTab.generateSyntaxForDeleteNotUsedVariables(stringBuffer);
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* ").append(this.getTitle()).append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getCommand("PRESERVE."));
        stringBuffer.append(SyntaxUtil.getCommand("SET PRINTBACK OFF."));
        this.mTransactionsVariablesTab.generateSyntax(stringBuffer);
        this.mOutputTab.generateSyntax(stringBuffer);
        this.mTransactionsSaveTab.generateSyntax(stringBuffer);
        stringBuffer.append(SyntaxUtil.getCommand("RESTORE."));
        return stringBuffer.toString();
    }

    @Override
    protected String getDataSetName() {
        return this.mTransactionsSaveTab.getDataSetName();
    }

    @Override
    protected boolean isDataSetUsed() {
        return this.mTransactionsSaveTab.isDataSetUsed();
    }

    @Override
    protected boolean isDataFileUsed() {
        return this.mTransactionsSaveTab.isDataFileUsed();
    }

    @Override
    protected TargetVariableList getIdentifiersList() {
        return this.mTransactionsVariablesTab.getIdentifiersList();
    }

    @Override
    public boolean okPastePressed() {
        if (this.getTabbedPane().getSelectedIndex() != 2 && !this.mTransactionsSaveTab.validateTab()) {
            this.getTabbedPane().setSelectedIndex(2);
            return false;
        }
        return super.okPastePressed();
    }
}

