/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.rfm_analysis;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.rfm_analysis.BinningTab;
import com.spss.java_client.ui.dialogs.rfm_analysis.OutputTab;
import com.spss.java_client.ui.dialogs.rfm_analysis.RFMBaseDialog;
import com.spss.java_client.ui.dialogs.rfm_analysis.SaveTab;
import com.spss.java_client.ui.dialogs.rfm_analysis.VariablesTab;
import com.spss.java_client.ui.doc_types.SpssFrame;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class RFMCustomersDialog
extends RFMBaseDialog {
    private VariablesTab mVariablesTab;
    private SaveTab mSaveTab;
    private boolean mOkPastePressed = false;

    public RFMCustomersDialog(SpssFrame spssFrame) {
        super(spssFrame, false);
    }

    public RFMCustomersDialog(JFrame jFrame) {
        super(jFrame, false);
    }

    @Override
    protected void secondInit(Component component) {
        super.secondInit(component);
        this.setTitle(this.getResString("IDS_RFM_CUSTOMER_TITLE"));
    }

    protected void checkForSplitFiles() {
        if (this.hasSplitVar()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_RFM_SPLIT_FILE_PRESENT"), VersionInfo.getAppVersionString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RFMCustomersDialog.this.dispose();
                }
            });
        }
    }

    @Override
    protected void init() {
        super.init();
        this.mVariablesTab = new VariablesTab(this);
        this.mBinningTab = new BinningTab(this);
        this.mSaveTab = new SaveTab(this);
        this.mOutputTab = new OutputTab(this);
        this.addTab(this.getResString("IDS_RFM_VARIABLES_PANEL_TITLE"), this.mVariablesTab);
        this.addTab(this.getResString("IDS_RFM_BINNING_PANEL_TITLE"), this.mBinningTab);
        this.addTab(this.getResString("IDS_RFM_SAVE_PANEL_TITLE"), this.mSaveTab);
        this.addTab(this.getResString("IDS_RFM_OUTPUT_PANEL_TITLE"), this.mOutputTab);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mTabbedPane.setEnabledAt(2, false);
        }
        this.mTabbedPane.addChangeListener(this);
        this.checkForSplitFiles();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mBinningTab.loadTabState(this.getDialogDataModel(), this.getNameLabelOverride());
        this.mSaveTab.loadTabState(this.getDialogDataModel(), this.getNameLabelOverride());
        this.mBinningTab.setVisible(false);
        this.mSaveTab.setVisible(false);
        this.mOutputTab.setVisible(false);
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.mBinningTab.saveTabState(this.getDialogDataModel());
        this.mSaveTab.saveTabState(this.getDialogDataModel());
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("PRESERVE.\nSET PRINTBACK OFF.\n");
        stringBuffer.append("* ").append(this.getTitle()).append(SyntaxUtil.terminateSyntax());
        this.mSaveTab.generateDatasetCopySyntax(stringBuffer);
        this.mVariablesTab.generateSyntax(stringBuffer);
        this.mOutputTab.generateSyntax(stringBuffer);
        this.mSaveTab.generateSyntax(stringBuffer);
        stringBuffer.append("RESTORE.\n");
        return stringBuffer.toString();
    }

    @Override
    protected String getRFMScoreVariable() {
        return this.mSaveTab.getRFMScoreVariable();
    }

    @Override
    protected String getRecencyBinVariable() {
        return this.mSaveTab.getRecencyBinVariable();
    }

    @Override
    protected String getFrequencyBinVariable() {
        return this.mSaveTab.getFrequencyBinVariable();
    }

    @Override
    protected String getAmountBinVariable() {
        return this.mSaveTab.getAmountBinVariable();
    }

    @Override
    protected String getRecencyVariable() {
        return this.mVariablesTab.getRecencyVariable();
    }

    @Override
    protected String getFrequencyVariable() {
        return this.mVariablesTab.getFrequencyVariable();
    }

    @Override
    protected String getAmountVariable() {
        return this.mVariablesTab.getAmountVariable();
    }

    @Override
    protected String getDataSetName() {
        return this.mSaveTab.getDataSetName();
    }

    @Override
    protected boolean isDataSetUsed() {
        return this.mSaveTab.isDataSetUsed();
    }

    @Override
    protected boolean isDataFileUsed() {
        return this.mSaveTab.isDataFileUsed();
    }

    @Override
    protected TargetVariableList getIdentifiersList() {
        return this.mVariablesTab.getIdentifiersList();
    }

    @Override
    protected void generateSyntaxForDeleteNotUsedVariables(StringBuffer stringBuffer) {
        this.mVariablesTab.generateSyntaxForDeleteNotUsedVariables(stringBuffer);
    }

    @Override
    public String getIActionKey() {
        return "analyze_rfm_customer";
    }

    @Override
    public boolean okPastePressed() {
        if (!this.mVariablesTab.validateTab()) {
            return false;
        }
        if (this.getTabbedPane().getSelectedIndex() != 2 && !this.mSaveTab.validateTab()) {
            this.getTabbedPane().setSelectedIndex(2);
            return false;
        }
        return super.okPastePressed();
    }
}

