/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.rfm_analysis;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.rfm_analysis.BinningTab;
import com.spss.java_client.ui.dialogs.rfm_analysis.OutputTab;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class RFMBaseDialog
extends BaseTabbedDialog
implements ChangeListener {
    protected BinningTab mBinningTab;
    protected OutputTab mOutputTab;
    protected boolean mIsTransactions;
    public static String sDefault_recency_score = "@_recency_score_delete";
    public static String sDefault_recency_bin_score = "@_recency_bin_score_delete";
    public static String sDefault_frequency_score = "@_frequency_score_delete";
    public static String sDefault_frequency_bin_score = "@_frequency_score_bin_delete";
    public static String sDefault_amount = "@_amount_delete";
    public static String sDefault_amount_bin = "@_amount_bin_delete";

    public RFMBaseDialog(SpssFrame spssFrame, boolean bl) {
        super((JFrame)spssFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.mIsTransactions = bl;
        this.secondInit(spssFrame);
    }

    public RFMBaseDialog(JFrame jFrame, boolean bl) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder(), StatsHelp.Book.BASE);
        this.mIsTransactions = bl;
        this.secondInit(jFrame);
    }

    protected void secondInit(Component component) {
        this.pack();
        this.setLocationRelativeTo(component);
    }

    @Override
    public abstract String generateSyntax();

    @Override
    public abstract String getIActionKey();

    @Override
    public String getDialogHelpID() {
        BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
        return baseProcedureTab.getDialogHelpID();
    }

    public static String getUniqueTempVarName(String string) {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        String string2 = string;
        int n = 1;
        while (iSpssDataSrc.findVarIndex(string) > -1) {
            string2 = string + "_" + String.valueOf(n);
            ++n;
        }
        return string2;
    }

    @Override
    protected void init() {
        super.init();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
    }

    @Override
    protected boolean canSwitchTab() {
        return super.canSwitchTab();
    }

    @Override
    public void reset() {
        Object[] objectArray = this.getResStringArray("IDS_RFM_RESET_BUTTON_LABELS");
        int n = SpssAlertOptionPane.showOptionDialog((Window)((Object)this), this.getResString("ERR_RFM_RESET_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, objectArray, (Object)objectArray[0]);
        if (n != 2) {
            if (n == 0) {
                super.reset();
            } else {
                Component component = this.mTabbedPane.getSelectedComponent();
                if (component instanceof BaseProcedureTab) {
                    ((BaseProcedureTab)component).reset();
                }
            }
        }
    }

    public void resetAll() {
        super.reset();
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
    }

    protected boolean hasSplitVar() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.getNSplitVars();
        return n > 0;
    }

    protected boolean isNestedBinning() {
        return this.mBinningTab.isNestedBinning();
    }

    protected boolean isRandomTies() {
        return this.mBinningTab.isRandomTies();
    }

    protected String getRecencyNumberOfBins() {
        return this.mBinningTab.getRecencyNumberOfBins();
    }

    protected String getFrequencyNumberOfBins() {
        return this.mBinningTab.getFrequencyNumberOfBins();
    }

    protected String getAmountNumberOfBins() {
        return this.mBinningTab.getAmountNumberOfBins();
    }

    protected abstract String getRFMScoreVariable();

    protected abstract String getRecencyBinVariable();

    protected abstract String getFrequencyBinVariable();

    protected abstract String getAmountBinVariable();

    protected abstract String getRecencyVariable();

    protected abstract String getFrequencyVariable();

    protected abstract String getAmountVariable();

    protected abstract void generateSyntaxForDeleteNotUsedVariables(StringBuffer var1);

    protected abstract String getDataSetName();

    protected abstract boolean isDataSetUsed();

    protected abstract boolean isDataFileUsed();

    protected abstract TargetVariableList getIdentifiersList();
}

