/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.rfm_analysis;

import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.rfm_analysis.RFMBaseDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class OutputTab
extends BaseProcedureTab
implements ActionListener {
    private JCheckBox mChartBinCounts;
    private JCheckBox mTableBinCounts;
    private JCheckBox mHeatMap;
    private JCheckBox mHistograms;
    private JCheckBox mScatterplots;

    public OutputTab(RFMBaseDialog rFMBaseDialog) {
        super(rFMBaseDialog, true);
    }

    protected void generateSyntax(StringBuffer stringBuffer) {
        String string = ((RFMBaseDialog)this.mParent).getRecencyBinVariable();
        String string2 = ((RFMBaseDialog)this.mParent).getFrequencyBinVariable();
        String string3 = ((RFMBaseDialog)this.mParent).getAmountBinVariable();
        String string4 = ((RFMBaseDialog)this.mParent).getRecencyVariable();
        String string5 = ((RFMBaseDialog)this.mParent).getFrequencyVariable();
        String string6 = ((RFMBaseDialog)this.mParent).getAmountVariable();
        if (this.mChartBinCounts.isSelected()) {
            stringBuffer.append(SyntaxUtil.getCommand("DMGGRAPH"));
            stringBuffer.append(" /GRAPHDATASET NAME=\"graphdataset\" VARIABLES=");
            stringBuffer.append("\n");
            stringBuffer.append("COUNT()[name=\"COUNT\"]\n");
            stringBuffer.append(" ");
            stringBuffer.append(string3);
            stringBuffer.append("\n");
            stringBuffer.append(" ");
            stringBuffer.append(string2);
            stringBuffer.append("\n");
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append("\n");
            stringBuffer.append(" MISSING=LISTWISE");
            stringBuffer.append("\n");
            stringBuffer.append(" REPORTMISSING=NO");
            stringBuffer.append("\n");
            stringBuffer.append(" /GRAPHSPEC SOURCE=INLINE");
            stringBuffer.append("  label=\"");
            stringBuffer.append(this.getResString("IDS_RFM_BIN_CHART_TITLE"));
            stringBuffer.append("\"\n");
            stringBuffer.append(" /DESCRIPTION TEXT=BINCOUNT");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getCommand("BEGIN GPL"));
            stringBuffer.append(" PAGE: begin(scale(550px,425px))\n");
            stringBuffer.append(" SOURCE: s=userSource(id(\"graphdataset\"))\n");
            stringBuffer.append(" DATA: monetary=col(source(s), name(\"");
            stringBuffer.append(string3);
            stringBuffer.append("\"), unit.category())\n");
            stringBuffer.append(" DATA: recency=col(source(s), name(\"");
            stringBuffer.append(string);
            stringBuffer.append("\"), unit.category())\n");
            stringBuffer.append(" DATA: frequency=col(source(s), name(\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"), unit.category())\n");
            stringBuffer.append(" DATA: COUNT=col(source(s), name(\"COUNT\"))\n");
            stringBuffer.append(" GUIDE: text.title(label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_BIN_CHART_TITLE"));
            stringBuffer.append("\"))\n");
            stringBuffer.append(" GUIDE: axis(dim(2), ticks(null()))\n");
            stringBuffer.append(" GUIDE: axis(dim(4), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_RECENCY"));
            stringBuffer.append("\"), opposite(), gap(0px))\n");
            stringBuffer.append(" GUIDE: axis(dim(3), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_FREQUENCY"));
            stringBuffer.append("\") , opposite(), gap(0px))\n");
            stringBuffer.append(" GUIDE: axis(dim(3), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_MONETARY"));
            stringBuffer.append("\"), ticks(null()))\n");
            stringBuffer.append(" SCALE: cat(dim(1))\n");
            stringBuffer.append(" SCALE: linear(dim(2), include(0))\n");
            stringBuffer.append(" SCALE: cat(dim(4), reverse())\n");
            stringBuffer.append(" SCALE: cat(dim(3))\n");
            stringBuffer.append(" ELEMENT: interval(position(monetary*COUNT*frequency*recency),\n");
            stringBuffer.append(" shape.interior(shape.square),color.interior(color.blue),color.exterior(color.white))\n");
            stringBuffer.append(" PAGE: end()\n");
            stringBuffer.append("END GPL");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (this.mTableBinCounts.isSelected()) {
            stringBuffer.append(SyntaxUtil.getCommand("DMCROSSTABS"));
            stringBuffer.append(" /TABLES=");
            stringBuffer.append(string2);
            stringBuffer.append(" BY ");
            stringBuffer.append(string3);
            stringBuffer.append(" BY ");
            stringBuffer.append(string);
            stringBuffer.append("\n");
            stringBuffer.append(" /FORMAT=AVALUE TABLES");
            stringBuffer.append("\n");
            stringBuffer.append(" /CELLS=COUNT");
            stringBuffer.append("\n");
            stringBuffer.append(" /COUNT ROUND CELL");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (this.mHeatMap.isSelected()) {
            stringBuffer.append(SyntaxUtil.getCommand("DMGGRAPH"));
            stringBuffer.append(" /GRAPHDATASET NAME=\"graphdataset\" VARIABLES=");
            stringBuffer.append(" ");
            stringBuffer.append(string6);
            stringBuffer.append("\n");
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append("\n");
            stringBuffer.append(" ");
            stringBuffer.append(string2);
            stringBuffer.append("\n");
            stringBuffer.append(" MISSING=LISTWISE");
            stringBuffer.append("\n");
            stringBuffer.append(" REPORTMISSING=NO");
            stringBuffer.append("\n");
            stringBuffer.append(" /GRAPHSPEC SOURCE=INLINE");
            stringBuffer.append("  label=\"");
            stringBuffer.append(this.getResString("IDS_RFM_HEAT_MAP_CHART_TITLE"));
            stringBuffer.append("\"\n");
            stringBuffer.append(" /DESCRIPTION TEXT=HEATMAP");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getCommand("BEGIN GPL"));
            stringBuffer.append(" PAGE: begin(scale(550px,375px))\n");
            stringBuffer.append(" SOURCE: s=userSource(id(\"graphdataset\"))\n");
            stringBuffer.append(" DATA: amount=col(source(s), name(\"");
            stringBuffer.append(string6);
            stringBuffer.append("\"))\n");
            stringBuffer.append(" DATA: recency=col(source(s), name(\"");
            stringBuffer.append(string);
            stringBuffer.append("\"), unit.category())\n");
            stringBuffer.append(" DATA: frequency=col(source(s), name(\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"), unit.category())\n");
            stringBuffer.append(" GUIDE: text.title(label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_HEAT_MAP_CHART_TITLE"));
            stringBuffer.append("\"))\n");
            stringBuffer.append(" GUIDE: axis(dim(1), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_FREQUENCY"));
            stringBuffer.append("\"))\n");
            stringBuffer.append(" GUIDE: axis(dim(2), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_RECENCY"));
            stringBuffer.append("\"))\n");
            stringBuffer.append(" GUIDE: legend(aesthetic(aesthetic.color.saturation), label (\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_AVERAGE_MONETARY_VALUE"));
            stringBuffer.append("\"))\n");
            stringBuffer.append(" ELEMENT: polygon(position(frequency*recency),\n");
            stringBuffer.append(" color.interior(color.blue), color.exterior(color.navy), color.saturation(summary.mean(amount)))\n");
            stringBuffer.append(" PAGE: end()\n");
            stringBuffer.append("END GPL");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (this.mHistograms.isSelected()) {
            stringBuffer.append(SyntaxUtil.getCommand("DMGGRAPH"));
            stringBuffer.append(" /GRAPHDATASET NAME=\"graphdataset\" VARIABLES=");
            stringBuffer.append("\n");
            stringBuffer.append(" ");
            stringBuffer.append(string4);
            stringBuffer.append(" ");
            stringBuffer.append(string5);
            stringBuffer.append(" ");
            stringBuffer.append(string6);
            stringBuffer.append("\n");
            stringBuffer.append(" MISSING=LISTWISE");
            stringBuffer.append("\n");
            stringBuffer.append(" REPORTMISSING=NO");
            stringBuffer.append("\n");
            stringBuffer.append(" /GRAPHSPEC SOURCE=INLINE");
            stringBuffer.append("  label=\"");
            stringBuffer.append(this.getResString("IDS_RFM_HISTOGRAMS_CHART_TITLE"));
            stringBuffer.append("\"\n");
            stringBuffer.append(" /DESCRIPTION TEXT=HISTOGRAM");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getCommand("BEGIN GPL"));
            stringBuffer.append(" PAGE: begin(scale(550px,375px))\n");
            stringBuffer.append(" SOURCE: s=userSource(id(\"graphdataset\"))\n");
            stringBuffer.append(" DATA: recency=col(source(s), name(\"");
            stringBuffer.append(string4);
            stringBuffer.append("\"))\n");
            stringBuffer.append(" DATA: frequency=col(source(s), name(\"");
            stringBuffer.append(string5);
            stringBuffer.append("\"))\n");
            stringBuffer.append(" DATA: monetary=col(source(s), name(\"");
            stringBuffer.append(string6);
            stringBuffer.append("\"))\n");
            stringBuffer.append("GRAPH: begin(origin(5%, 10%), scale(23%, 80%))\n");
            stringBuffer.append("GUIDE: axis(dim(1), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_RECENCY"));
            stringBuffer.append("\"), ticks(null()))\n");
            stringBuffer.append("GUIDE: axis(dim(2), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_COUNT"));
            stringBuffer.append("\"), ticks(null()))\n");
            stringBuffer.append("ELEMENT: interval(position(summary.count(bin.rect(recency, binCount(10)))),");
            stringBuffer.append("color.interior(color.blue), color.exterior(color.white))\n");
            stringBuffer.append("GRAPH: end()\n");
            stringBuffer.append("GRAPH: begin(origin(28%, 10%), scale(23%, 80%))\n");
            stringBuffer.append("GUIDE: text.title(label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_HISTOGRAMS_CHART_TITLE"));
            stringBuffer.append("\"))\n");
            stringBuffer.append("GUIDE: axis(dim(1), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_FREQUENCY"));
            stringBuffer.append("\"), ticks(null()))\n");
            stringBuffer.append("GUIDE: axis(dim(2), null())\n");
            stringBuffer.append("ELEMENT: interval(position(summary.count(bin.rect(frequency, binCount(10)))),");
            stringBuffer.append("color.interior(color.blue), color.exterior(color.white))\n");
            stringBuffer.append("GRAPH: end()\n");
            stringBuffer.append("GRAPH: begin(origin(51%, 10%), scale(23%, 80%))\n");
            stringBuffer.append("GUIDE: axis(dim(1), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_MONETARY"));
            stringBuffer.append("\"), ticks(null()))\n");
            stringBuffer.append("GUIDE: axis(dim(2), null())\n");
            stringBuffer.append("ELEMENT: interval(position(summary.count(bin.rect(monetary, binCount(10)))),");
            stringBuffer.append("color.interior(color.blue), color.exterior(color.white))\n");
            stringBuffer.append("GRAPH: end()\n");
            stringBuffer.append(" PAGE: end()\n");
            stringBuffer.append("END GPL");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (this.mScatterplots.isSelected()) {
            stringBuffer.append(SyntaxUtil.getCommand("DMGGRAPH"));
            stringBuffer.append(" /GRAPHDATASET NAME=\"graphdataset\" VARIABLES=");
            stringBuffer.append("\n");
            stringBuffer.append(" ");
            stringBuffer.append(string6);
            stringBuffer.append(" ");
            stringBuffer.append(string4);
            stringBuffer.append(" ");
            stringBuffer.append(string5);
            stringBuffer.append("\n");
            stringBuffer.append(" MISSING=LISTWISE");
            stringBuffer.append("\n");
            stringBuffer.append(" REPORTMISSING=NO");
            stringBuffer.append("\n");
            stringBuffer.append(" /GRAPHSPEC SOURCE=INLINE");
            stringBuffer.append("  label=\"");
            stringBuffer.append(this.getResString("IDS_RFM_SCATTERPLOTS_CHART_TITLE"));
            stringBuffer.append("\"\n");
            stringBuffer.append(" /DESCRIPTION TEXT=SCATTER");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getCommand("BEGIN GPL"));
            stringBuffer.append(" PAGE: begin(scale(550px,500px))\n");
            stringBuffer.append(" SOURCE: s=userSource(id(\"graphdataset\"))\n");
            stringBuffer.append(" DATA: monetary=col(source(s), name(\"");
            stringBuffer.append(string6);
            stringBuffer.append("\"))\n");
            stringBuffer.append(" DATA: recency=col(source(s), name(\"");
            stringBuffer.append(string4);
            stringBuffer.append("\"))\n");
            stringBuffer.append(" DATA: frequency=col(source(s), name(\"");
            stringBuffer.append(string5);
            stringBuffer.append("\"))\n");
            stringBuffer.append(" GRAPH: begin(origin(10%,5%),scale(83%,26%))\n");
            stringBuffer.append(" GUIDE: text.title(label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_SCATTERPLOTS_CHART_TITLE"));
            stringBuffer.append("\"))\n");
            stringBuffer.append(" GUIDE: axis(dim(1),ticks(null()), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_MONETARY"));
            stringBuffer.append("\"))\n");
            stringBuffer.append(" GUIDE: axis(dim(2),ticks(null()), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_RECENCY"));
            stringBuffer.append("\"))\n");
            stringBuffer.append(" ELEMENT: point(position(monetary*recency),color.interior(color.blue),color.exterior(color.white))\n");
            stringBuffer.append(" GRAPH: end()\n");
            stringBuffer.append(" GRAPH: begin(origin(10%,36%),scale(83%,26%))\n");
            stringBuffer.append(" GUIDE: axis(dim(1),ticks(null()), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_MONETARY"));
            stringBuffer.append("\"))\n");
            stringBuffer.append(" GUIDE: axis(dim(2),ticks(null()), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_FREQUENCY"));
            stringBuffer.append("\"))\n");
            stringBuffer.append(" ELEMENT: point(position(monetary*frequency),color.interior(color.blue),color.exterior(color.white))\n");
            stringBuffer.append(" GRAPH: end()\n");
            stringBuffer.append(" GRAPH: begin(origin(10%,67%),scale(83%,26%))\n");
            stringBuffer.append(" GUIDE: axis(dim(1),ticks(null()), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_FREQUENCY"));
            stringBuffer.append("\"))\n");
            stringBuffer.append(" GUIDE: axis(dim(2),ticks(null()), label(\"");
            stringBuffer.append(this.getResString("IDS_RFM_GGRAPH_LABEL_RECENCY"));
            stringBuffer.append("\"))\n");
            stringBuffer.append(" ELEMENT: point(position(frequency*recency),color.interior(color.blue),color.exterior(color.white))\n");
            stringBuffer.append(" GRAPH: end()\n");
            stringBuffer.append(" PAGE: end()\n");
            stringBuffer.append("END GPL");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mHeatMap.setSelected(true);
        this.mChartBinCounts.setSelected(true);
        this.mTableBinCounts.setSelected(false);
        this.mHistograms.setSelected(false);
        this.mScatterplots.setSelected(false);
    }

    private void initVars() {
        this.mChartBinCounts = DialogUtil.createCheckBox(this.mParent, "IDS_RFM_CHART_BIN_COUNT", (ActionListener)this);
        this.mTableBinCounts = DialogUtil.createCheckBox(this.mParent, "IDS_RFM_TABLE_BIN_COUNT", (ActionListener)this);
        this.mHeatMap = DialogUtil.createCheckBox(this.mParent, "IDS_RFM_HEATMAP", (ActionListener)this);
        this.mHistograms = DialogUtil.createCheckBox(this.mParent, "IDS_RFM_HISTOGRAMS", (ActionListener)this);
        this.mScatterplots = DialogUtil.createCheckBox(this.mParent, "IDS_RFM_SCATTERPLOTS", (ActionListener)this);
        this.mHeatMap.setSelected(true);
        this.mChartBinCounts.setSelected(true);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_RFM_BINNED_DATA_TITLE")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mHeatMap, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mChartBinCounts, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mTableBinCounts, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_RFM_UNBINNED_DATA_TITLE")));
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, this.mHistograms, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mScatterplots, gridBagConstraints, 0, 1, 1, 1, n, insets);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n2, 0, 0, 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mHeatMap);
        vector.add(this.mChartBinCounts);
        vector.add(this.mTableBinCounts);
        vector.add(this.mHistograms);
        vector.add(this.mScatterplots);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return ((RFMBaseDialog)this.mParent).mIsTransactions ? "idh_rfm_output_transactions" : "idh_rfm_output_customers";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mHeatMap;
    }
}

