/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.rfm_analysis;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineLabel;
import com.spss.java_client.ui.controls.SpssMultiLineRadioButton;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.rfm_analysis.RFMBaseDialog;
import com.spss.uitools.controls.TypeAheadCombo;
import com.spss.uitools.util.AccessibilityUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class BinningTab
extends BaseProcedureTab
implements ActionListener {
    static final int DEFAULT_MAX_WIDTH = 420;
    private SpssMultiLineRadioButton mNestedButton;
    private JLabel mNestedLabel;
    private SpssMultiLineRadioButton mIndependentButton;
    private JLabel mIndependentLabel;
    private JLabel mRecencyNumBinsLabel;
    private TypeAheadCombo mRecencyCombo;
    private JLabel mFrequencyNumBinsLabel;
    private TypeAheadCombo mFrequencyCombo;
    private JLabel mAmountNumBinsLabel;
    private TypeAheadCombo mAmountCombo;
    private static final Integer DEFBINLIMIT = 5;
    private static final Integer[] sDefaultBins = new Integer[]{2, 3, 4, 5, 6, 7, 8, 9};
    private static final int sNumberOfBins = 8;
    private JRadioButton mSameTiesButton;
    private JRadioButton mRandomTiesButton;
    private SpssButtonGroup mBinningButtonGrp;
    private SpssButtonGroup mTiesButtonGrp;

    public BinningTab(RFMBaseDialog rFMBaseDialog) {
        super(rFMBaseDialog, true);
    }

    @Override
    public void reset() {
        super.reset();
        this.mNestedButton.setSelected(true);
        this.mRecencyCombo.setSelectedItem((Object)DEFBINLIMIT);
        this.mFrequencyCombo.setSelectedItem((Object)DEFBINLIMIT);
        this.mAmountCombo.setSelectedItem((Object)DEFBINLIMIT);
        this.mSameTiesButton.setSelected(true);
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_RFM_NESTED_BINNING");
        this.mNestedButton = new SpssMultiLineRadioButton(toggleButtonAction);
        this.mNestedButton.getAccessibleContext().setAccessibleName(this.getResString("IDS_RFM_NESTED_BINNING"));
        this.mNestedLabel = DialogUtil.createMultiLineLabel(this.mParent, "IDS_RFM_NESTED_BINNING_DESCRIPTION", 420);
        AccessibilityUtil.setAccessibleText((Component)this.mNestedLabel, (Object)((SpssMultiLineLabel)this.mNestedLabel).getLabelText());
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_RFM_INDEPENDENT_BINNING");
        this.mIndependentButton = new SpssMultiLineRadioButton(toggleButtonAction, 420);
        this.mIndependentButton.getAccessibleContext().setAccessibleName(this.getResString("IDS_RFM_INDEPENDENT_BINNING"));
        this.mIndependentLabel = DialogUtil.createMultiLineLabel(this.mParent, "IDS_RFM_INDEPENDENT_BINNING_DESCRIPTION", 420);
        AccessibilityUtil.setAccessibleText((Component)this.mIndependentLabel, (Object)((SpssMultiLineLabel)this.mIndependentLabel).getLabelText());
        this.mBinningButtonGrp = new SpssButtonGroup();
        this.mBinningButtonGrp.add(this.mNestedButton);
        this.mBinningButtonGrp.add(this.mIndependentButton);
        this.mNestedButton.setSelected(true);
        this.mRecencyNumBinsLabel = DialogUtil.createLabel(this.mParent, "IDS_RFM_RECENCY_BIN_LABEL");
        this.mRecencyCombo = new TypeAheadCombo((Object[])sDefaultBins);
        this.mRecencyCombo.setMaximumRowCount(8);
        this.mRecencyCombo.setSelectedItem((Object)DEFBINLIMIT);
        this.mRecencyCombo.setEnabled(true);
        this.mRecencyCombo.setPreferredSize(new Dimension(60, 20));
        this.mRecencyNumBinsLabel.setLabelFor((Component)this.mRecencyCombo);
        this.mFrequencyNumBinsLabel = DialogUtil.createLabel(this.mParent, "IDS_RFM_FREQUENCY_BIN_LABEL");
        this.mFrequencyCombo = new TypeAheadCombo((Object[])sDefaultBins);
        this.mFrequencyCombo.setMaximumRowCount(8);
        this.mFrequencyCombo.setSelectedItem((Object)DEFBINLIMIT);
        this.mFrequencyCombo.setEnabled(true);
        this.mFrequencyCombo.setPreferredSize(new Dimension(60, 20));
        this.mFrequencyNumBinsLabel.setLabelFor((Component)this.mFrequencyCombo);
        this.mAmountNumBinsLabel = DialogUtil.createLabel(this.mParent, "IDS_RFM_AMOUNT_BIN_LABEL");
        this.mAmountCombo = new TypeAheadCombo((Object[])sDefaultBins);
        this.mAmountCombo.setMaximumRowCount(8);
        this.mAmountCombo.setSelectedItem((Object)DEFBINLIMIT);
        this.mAmountCombo.setEnabled(true);
        this.mAmountCombo.setPreferredSize(new Dimension(60, 20));
        this.mAmountNumBinsLabel.setLabelFor((Component)this.mAmountCombo);
        this.mSameTiesButton = DialogUtil.createRadioButton(this.mParent, "IDS_RFM_SAME_TIES", (ActionListener)this);
        this.mRandomTiesButton = DialogUtil.createRadioButton(this.mParent, "IDS_RFM_RANDOM_TIES", (ActionListener)this);
        this.mTiesButtonGrp = new SpssButtonGroup();
        this.mTiesButtonGrp.add(this.mSameTiesButton);
        this.mTiesButtonGrp.add(this.mRandomTiesButton);
        this.mSameTiesButton.setSelected(true);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_RFM_BINNING_BORDER_TITLE")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        int n4 = DialogUtil.getGroupingIndent();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n2, 0, 0, 0);
        Insets insets3 = new Insets(n2, n3 + n4, insets.bottom, insets.right);
        Insets insets4 = new Insets(insets.top, n3 - 4, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mNestedButton, gridBagConstraints, 0, 0, 1, 1, n, insets4);
        insets4.set(insets.top, n3 + n4, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mNestedLabel, gridBagConstraints, 0, 1, 1, 1, n, insets4);
        insets4.set(insets.top, n3 - 4, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mIndependentButton, gridBagConstraints, 0, 2, 1, 1, n, insets4);
        insets4.set(insets.top, n3 + n4, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mIndependentLabel, gridBagConstraints, 0, 3, 1, 1, n, insets4);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_RFM_NUM_OF_BINS_BORDER_TITLE")));
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 22;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, this.mRecencyNumBinsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel2, this.mFrequencyNumBinsLabel, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel2, this.mAmountNumBinsLabel, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 21;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mRecencyCombo, gridBagConstraints, 1, 0, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mFrequencyCombo, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mAmountCombo, gridBagConstraints, 1, 2, 1, 1, n, insets3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_RFM_TIES_BORDER_TITLE")));
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel3, this.mSameTiesButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel3, this.mRandomTiesButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mNestedButton);
        vector.add(this.mNestedLabel);
        vector.add(this.mIndependentButton);
        vector.add(this.mIndependentLabel);
        vector.add(this.mRecencyCombo);
        vector.add(this.mFrequencyCombo);
        vector.add(this.mAmountCombo);
        vector.add(this.mSameTiesButton);
        vector.add(this.mRandomTiesButton);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    @Override
    public void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        dialogDataModel.putInteger("IDS_RFM_BINNING_RECENCY_NUM_OF_BINS", (Integer)this.mRecencyCombo.getSelectedItem());
        dialogDataModel.putInteger("IDS_RFM_BINNING_FREQUENCY_NUM_OF_BINS", (Integer)this.mFrequencyCombo.getSelectedItem());
        dialogDataModel.putInteger("IDS_RFM_BINNING_AMOUNT_NUM_OF_BINS", (Integer)this.mAmountCombo.getSelectedItem());
    }

    @Override
    public void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
        Integer n = dialogDataModel.getInteger("IDS_RFM_BINNING_RECENCY_NUM_OF_BINS");
        if (n != null) {
            this.mRecencyCombo.getModel().setSelectedItem(n);
        }
        if ((n = dialogDataModel.getInteger("IDS_RFM_BINNING_FREQUENCY_NUM_OF_BINS")) != null) {
            this.mFrequencyCombo.getModel().setSelectedItem(n);
        }
        if ((n = dialogDataModel.getInteger("IDS_RFM_BINNING_AMOUNT_NUM_OF_BINS")) != null) {
            this.mAmountCombo.getModel().setSelectedItem(n);
        }
    }

    protected boolean isNestedBinning() {
        return this.mNestedButton.isSelected();
    }

    protected boolean isRandomTies() {
        return this.mRandomTiesButton.isSelected();
    }

    protected String getRecencyNumberOfBins() {
        return this.mRecencyCombo.getSelectedItem().toString();
    }

    protected String getFrequencyNumberOfBins() {
        return this.mFrequencyCombo.getSelectedItem().toString();
    }

    protected String getAmountNumberOfBins() {
        return this.mAmountCombo.getSelectedItem().toString();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return ((RFMBaseDialog)this.mParent).mIsTransactions ? "idh_rfm_binning_transactions" : "idh_rfm_binning_customers";
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mNestedButton;
    }
}

