/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.wt_estimate;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.pro_stats.wt_estimate.WeightEstimationDlg;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class WeightEstimationOptions
extends BaseSubDialog {
    private JRadioButton mBestPowerRadio;
    private JRadioButton mAllPowerRadio;
    private SpssButtonGroup mDisplayAnovaButtonGrp;
    private JCheckBox mSaveBestWeightCheckBox;
    private GridBagConstraints mGridConstraints;

    public WeightEstimationOptions(WeightEstimationDlg weightEstimationDlg) {
        super(weightEstimationDlg, weightEstimationDlg.getResString("IDS_WEIGHT_ESTIMATION_OPTIONS_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_wlsq_opt";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mSaveBestWeightCheckBox.setEnabled(false);
        }
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_WEIGHT_ESTIMATION_OPTIONS_SAVE_BEST_WEIGHT");
        this.mSaveBestWeightCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_WEIGHT_ESTIMATION_OPTIONS_BEST_POWER");
        this.mBestPowerRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_WEIGHT_ESTIMATION_OPTIONS_EACH_POWER_VALUE");
        this.mAllPowerRadio = new JRadioButton(toggleButtonAction);
        this.mDisplayAnovaButtonGrp = new SpssButtonGroup();
        this.mDisplayAnovaButtonGrp.add(this.mBestPowerRadio);
        this.mDisplayAnovaButtonGrp.add(this.mAllPowerRadio);
        this.mGridConstraints = new GridBagConstraints();
        this.mBestPowerRadio.setSelected(true);
    }

    private void setupMainPanel(JPanel jPanel) {
        JPanel jPanel2 = this.setupDisplayAnovaEstimatesPanel();
        JPanel jPanel3 = this.setupSaveBestWeightPanel();
        int n = 23;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mGridConstraints, 0, 0, 1, 1, n, null);
        this.mGridConstraints.weighty = 1.0;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mGridConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel setupDisplayAnovaEstimatesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_WEIGHT_ESTIMATION_DISPLAY_ANOVA_TITLE")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 0;
        Insets insets2 = new Insets(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mBestPowerRadio, this.mGridConstraints, 0, 0, 1, 1, n, insets2);
        this.mGridConstraints.weighty = 1.0;
        insets2.set(insets.top, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mAllPowerRadio, this.mGridConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupSaveBestWeightPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 23;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSaveBestWeightCheckBox, this.mGridConstraints, 0, 0, 1, 1, n, null);
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSaveBestWeightCheckBox);
        vector.add(this.mDisplayAnovaButtonGrp);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

