/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.wt_estimate;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.pro_stats.res.ProStatsResBundle;
import com.spss.java_client.ui.dialogs.pro_stats.wt_estimate.WeightEstimationOptions;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Formatter;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class WeightEstimationDlg
extends BaseProcedureDialog
implements FocusListener,
ListDataListener,
DocumentListener,
IVarMoveHandler {
    private static final double MIN_VAL = -6.5;
    private static final double MAX_VAL = 7.5;
    private static final int PRECISION_VAL = 4;
    private static final double BY_MIN_VAL = 0.0;
    private static final double BY_MAX_VAL = 7.5;
    private static final int BY_PRECISION_VAL = 4;
    private static final String DEF_POWER_RANGE_VAL = "-2";
    private static final String DEF_THROUGH_VAL = "2";
    private static final String DEF_BY_VAL = "0.5";
    private boolean mCheckOKPressed = false;
    private JButton mOptionsButton;
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private TargetVariableList mDependentTargetList;
    private TargetVariableList mIndependentTargetList;
    private TargetVariableList mWeightTargetList;
    private JScrollPane mDependentTargetListScrollPane;
    private JScrollPane mIndependentTargetListScrollPane;
    private JScrollPane mWeightTargetListScrollPane;
    private ArrowButton mDependentArrowButton;
    private ArrowButton mIndependentArrowButton;
    private ArrowButton mWeightArrowButton;
    private JLabel mDependentLabel;
    private JLabel mIndependentLabel;
    private JLabel mWeightLabel;
    private JLabel mPowerRangeLabel;
    private JLabel mThroughLabel;
    private JLabel mByLabel;
    private JCheckBox mIncludeConstantCheckbox;
    private FloatTextField mPowerRangeTextField;
    private FloatTextField mThroughTextField;
    private FloatTextField mByTextField;
    private GridBagConstraints mGridConstraints;
    private VariableList mSourceList;

    public WeightEstimationDlg(JFrame jFrame) {
        super(jFrame, false, ProStatsResBundle.getDefaultResourceBundleName(), ProStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_WEIGHT_ESTIMATION_TITLE"));
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* ").append(this.getResString("IDS_WEIGHT_ESTIMATION_SYNTAX_TITLE")).append(".");
        stringBuffer.append("\n");
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_WEIGHT_ESTIMATION_OPTIONS_SAVE_BEST_WEIGHT");
        if (bl != null && bl.booleanValue() && !dialogDataModel.getString("IDS_WEIGHT_ESTIMATION_BY").equals("0")) {
            if (this.mCheckOKPressed) {
                stringBuffer.append(SyntaxUtil.getMainCommand("TSET"));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("MXNEWVAR=1"));
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            } else {
                return null;
            }
        }
        if (bl == null || !bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("TSET"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("NEWVAR=NONE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("WLS"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mDependentTargetList.getVariablesStringList()));
        stringBuffer.append(" WITH ");
        stringBuffer.append(this.mIndependentTargetList.getVariablesStringList()).append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/SOURCE "));
        stringBuffer.append(this.mWeightTargetList.getVariablesStringList()).append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/POWER "));
        stringBuffer.append(dialogDataModel.getString("IDS_WEIGHT_ESTIMATION_POWER_RANGE")).append(" ");
        stringBuffer.append("TO ");
        stringBuffer.append(dialogDataModel.getString("IDS_WEIGHT_ESTIMATION_THROUGH")).append(" ");
        stringBuffer.append("BY ");
        stringBuffer.append(dialogDataModel.getString("IDS_WEIGHT_ESTIMATION_BY")).append("\n");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_WEIGHT_ESTIMATION_INCLUDE_CONSTANT");
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/CONSTANT "));
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/NOCONSTANT "));
        }
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SAVE WEIGHT"));
        }
        Boolean bl3 = dialogDataModel.getBoolean("IDS_WEIGHT_ESTIMATION_OPTIONS_BEST_POWER");
        Boolean bl4 = dialogDataModel.getBoolean("IDS_WEIGHT_ESTIMATION_OPTIONS_EACH_POWER_VALUE");
        if (bl3 == null || bl3.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT BEST"));
        } else if (bl4 != null && bl4.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT ALL"));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        this.mCheckOKPressed = false;
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_regression_weight";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mDependentTargetList.getModel() || listDataEvent.getSource() == this.mWeightTargetList.getModel()) {
            this.mSrcVarList.clearSelection();
        }
        if (listDataEvent.getSource() == this.mIndependentTargetList.getModel()) {
            this.mSrcVarList.clearSelection();
        }
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void reset() {
        super.reset();
        this.mDependentTargetList.removeAll();
        this.mIndependentTargetList.removeAll();
        this.mWeightTargetList.removeAll();
        this.setDefaults();
        this.enableOkPaste(false);
    }

    @Override
    public boolean okPastePressed() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_WEIGHT_ESTIMATION_OPTIONS_SAVE_BEST_WEIGHT");
        if (Float.parseFloat(this.mPowerRangeTextField.getText()) > Float.parseFloat(this.mThroughTextField.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_WEIGHT_ESTIMATION_ERR_MESSAGE_ASSOCIATED_TEXTVAL_SMALLER"), VersionInfo.getAppVersionString());
            this.mPowerRangeTextField.requestFocus();
            this.mPowerRangeTextField.selectAll();
            return false;
        }
        float f = Float.parseFloat(this.mThroughTextField.getText()) - Float.parseFloat(this.mPowerRangeTextField.getText());
        if (Float.parseFloat(this.mByTextField.getText()) > f) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_WEIGHT_ESTIMATION_ERR_MESSAGE_BY_TEXTVAL_SMALLER"), VersionInfo.getAppVersionString());
            this.mByTextField.requestFocus();
            this.mByTextField.selectAll();
            return false;
        }
        float f2 = (Float.parseFloat(this.mThroughTextField.getText()) - Float.parseFloat(this.mPowerRangeTextField.getText())) / Float.parseFloat(this.mByTextField.getText()) + 1.0f;
        if (Float.parseFloat(this.mByTextField.getText()) != 0.0f && f2 > 150.0f) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_WEIGHT_ESTIMATION_ERR_MESSAGE_RANGE_LIMIT"), VersionInfo.getAppVersionString());
            this.mByTextField.requestFocus();
            this.mByTextField.selectAll();
            return false;
        }
        if (bl != null && bl.booleanValue() && !this.mByTextField.getText().equals("0")) {
            if (0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_WEIGHT_ESTIMATION_ERR_MESSAGE_SPECIFICATION"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                this.mCheckOKPressed = true;
            } else {
                return false;
            }
        }
        return super.okPastePressed();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mPowerRangeTextField) {
            this.mPowerRangeTextField.selectAll();
        }
        if (focusEvent.getSource() == this.mThroughTextField) {
            this.mThroughTextField.selectAll();
        }
        if (focusEvent.getSource() == this.mByTextField) {
            this.mByTextField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_wlsq";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mPowerRangeTextField.getText().length() > 0 && this.mThroughTextField.getText().length() > 0 && this.mByTextField.getText().length() > 0 && this.mDependentTargetList.getModel().getSize() > 0 && this.mIndependentTargetList.getModel().getSize() > 0 && this.mWeightTargetList.getModel().getSize() > 0) {
            this.enableOkPaste(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mPowerRangeTextField.getText().length() == 0 || this.mThroughTextField.getText().length() == 0 || this.mByTextField.getText().length() == 0) {
            this.enableOkPaste(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        boolean bl;
        block6: {
            block9: {
                block8: {
                    block7: {
                        bl = true;
                        if (!variableList.equals(this.mDependentTargetList)) break block7;
                        if (this.mSourceList != null && this.mSourceList.equals(this.mIndependentTargetList) && !this.mSourceList.equals(this.mWeightTargetList)) break block6;
                        ISpssVariable iSpssVariable = iSpssVariableArray[0];
                        String string = iSpssVariable.getName();
                        for (int i = 0; i < this.mIndependentTargetList.getModel().getSize(); ++i) {
                            if (!string.equals(this.mIndependentTargetList.getModel().getElementAt(i).getName())) continue;
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_WEIGHT_ESTIMATION_DEPENDENT_INDEPENDENT_MESSAGE"), VersionInfo.getAppVersionString());
                            bl = false;
                            break block6;
                        }
                        break block6;
                    }
                    if (!variableList.equals(this.mIndependentTargetList)) break block8;
                    if (this.mSourceList != null && this.mSourceList.equals(this.mDependentTargetList) && !this.mSourceList.equals(this.mWeightTargetList)) break block6;
                    ISpssVariable iSpssVariable = null;
                    if (this.mDependentTargetList.getModel().getSize() > 0) {
                        iSpssVariable = this.mDependentTargetList.getModel().getElementAt(0);
                    }
                    for (ISpssVariable iSpssVariable2 : iSpssVariableArray) {
                        if (iSpssVariable == null || !iSpssVariable2.getName().equals(iSpssVariable.getName())) continue;
                        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_WEIGHT_ESTIMATION_DEPENDENT_INDEPENDENT_MESSAGE"), VersionInfo.getAppVersionString());
                        bl = false;
                    }
                    break block6;
                }
                if (!variableList.equals(this.mWeightTargetList)) break block6;
                if (this.mSourceList == null || !this.mSourceList.equals(this.mIndependentTargetList)) break block9;
                if (this.mWeightTargetList.getModel().getSize() <= 0) break block6;
                ISpssVariable iSpssVariable = this.mWeightTargetList.getModel().getElementAt(0);
                ISpssVariable iSpssVariable3 = null;
                if (this.mDependentTargetList.getModel().getSize() > 0) {
                    iSpssVariable3 = this.mDependentTargetList.getModel().getElementAt(0);
                }
                if (iSpssVariable3 == null || !iSpssVariable.getName().equals(iSpssVariable3.getName())) break block6;
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_WEIGHT_ESTIMATION_DEPENDENT_INDEPENDENT_MESSAGE"), VersionInfo.getAppVersionString());
                bl = false;
                break block6;
            }
            if (this.mSourceList != null && this.mSourceList.equals(this.mDependentTargetList) && this.mWeightTargetList.getModel().getSize() > 0) {
                ISpssVariable iSpssVariable = this.mWeightTargetList.getModel().getElementAt(0);
                String string = iSpssVariable.getName();
                for (int i = 0; i < this.mIndependentTargetList.getModel().getSize(); ++i) {
                    if (!string.equals(this.mIndependentTargetList.getModel().getElementAt(i).getName())) continue;
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_WEIGHT_ESTIMATION_DEPENDENT_INDEPENDENT_MESSAGE"), VersionInfo.getAppVersionString());
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            DialogUtil.removeDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this));
            this.addDragAdapters();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        ListDragAdapter listDragAdapter = new ListDragAdapter(this.mSrcVarList, dragPane, "SrcVariableList");
        DialogUtil.modifyMouseInputListeners(this.mSrcVarList, listDragAdapter);
        dragPane.addDropListener((IDropListener)new WeightEstimationDropListener(this.mSrcVarList, this));
        listDragAdapter = new ListDragAdapter(this.mDependentTargetList, dragPane, "DependentTargetList");
        DialogUtil.modifyMouseInputListeners(this.mDependentTargetList, listDragAdapter);
        dragPane.addDropListener((IDropListener)new WeightEstimationDropListener(this.mDependentTargetList, this));
        listDragAdapter = new ListDragAdapter(this.mIndependentTargetList, dragPane, "IndependentTargetList");
        DialogUtil.modifyMouseInputListeners(this.mIndependentTargetList, listDragAdapter);
        dragPane.addDropListener((IDropListener)new WeightEstimationDropListener(this.mIndependentTargetList, this));
        listDragAdapter = new ListDragAdapter(this.mWeightTargetList, dragPane, "WeightTargetList");
        DialogUtil.modifyMouseInputListeners(this.mWeightTargetList, listDragAdapter);
        dragPane.addDropListener((IDropListener)new WeightEstimationDropListener(this.mWeightTargetList, this));
    }

    private boolean canEnableOkPaste() {
        return this.mDependentTargetList.getModel().getSize() > 0 && this.mIndependentTargetList.getModel().getSize() > 0 && this.mWeightTargetList.getModel().getSize() > 0 && this.mPowerRangeTextField.getText().length() > 0 && this.mThroughTextField.getText().length() > 0 && this.mByTextField.getText().length() > 0;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eKeepOriginal);
        this.mSrcVarList.setIdentifier("SourceListIdentifier");
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.getModel().addListDataListener(this);
        this.mDependentTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item, VariableList.VarMoveType.eKeepOriginal);
        this.mDependentTargetList.addVarFilter(new SpssVarFilter(8, false));
        this.mDependentTargetList.setIdentifier("DependentListIdentifier");
        this.mDependentTargetListScrollPane = new JScrollPane(this.mDependentTargetList);
        this.mDependentTargetListScrollPane.setPreferredSize(this.mDependentTargetList.getMinimumSize());
        this.mDependentTargetListScrollPane.setVerticalScrollBarPolicy(21);
        this.mDependentTargetListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mDependentTargetList.getModel().addListDataListener(this);
        this.mIndependentTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eKeepOriginal);
        this.mIndependentTargetList.addVarFilter(new SpssVarFilter(8, false));
        this.mIndependentTargetList.setIdentifier("IndependentListIdentifier");
        this.mIndependentTargetListScrollPane = new JScrollPane(this.mIndependentTargetList);
        this.mIndependentTargetListScrollPane.setPreferredSize(this.mIndependentTargetList.getMinimumSize());
        this.mIndependentTargetList.getModel().addListDataListener(this);
        this.mWeightTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item, VariableList.VarMoveType.eKeepOriginal);
        this.mWeightTargetList.addVarFilter(new SpssVarFilter(8, false));
        this.mWeightTargetList.setIdentifier("WeightListIdentifier");
        this.mWeightTargetListScrollPane = new JScrollPane(this.mWeightTargetList);
        this.mWeightTargetListScrollPane.setPreferredSize(this.mWeightTargetList.getMinimumSize());
        this.mWeightTargetListScrollPane.setVerticalScrollBarPolicy(21);
        this.mWeightTargetListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mWeightTargetList.getModel().addListDataListener(this);
        this.mVarMoveHandler = this;
        this.mDependentArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDependentArrowButton.setVarMoveHandler(this.mVarMoveHandler);
        this.mDependentArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDependentArrowButton.registerVariableList(this.mDependentTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mVarMoveHandler = this;
        this.mIndependentArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mIndependentArrowButton.setVarMoveHandler(this.mVarMoveHandler);
        this.mIndependentArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mIndependentArrowButton.registerVariableList(this.mIndependentTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mVarMoveHandler = this;
        this.mWeightArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWeightArrowButton.setVarMoveHandler(this.mVarMoveHandler);
        this.mWeightArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mWeightArrowButton.registerVariableList(this.mWeightTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mDependentLabel = DialogUtil.createLabel(this, "IDS_WEIGHT_ESTIMATION_DEPENDENT");
        this.mDependentLabel.setLabelFor(this.mDependentTargetList);
        this.mIndependentLabel = DialogUtil.createLabel(this, "IDS_WEIGHT_ESTIMATION_INDEPENDENT");
        this.mIndependentLabel.setLabelFor(this.mIndependentTargetList);
        this.mWeightLabel = DialogUtil.createLabel(this, "IDS_WEIGHT_ESTIMATION_WEIGHT_VARIABLE");
        this.mWeightLabel.setLabelFor(this.mWeightTargetList);
        this.mPowerRangeTextField = new FloatTextField(-6.5, 7.5, 4, false);
        this.mPowerRangeLabel = DialogUtil.createLabel(this, "IDS_WEIGHT_ESTIMATION_POWER_RANGE");
        this.mPowerRangeLabel.setLabelFor((Component)this.mPowerRangeTextField);
        TextFieldAction textFieldAction = new TextFieldAction(this, "IDS_WEIGHT_ESTIMATION_POWER_RANGE");
        this.mPowerRangeTextField.setAction((Action)textFieldAction);
        this.mPowerRangeTextField.getDocument().addDocumentListener(this);
        this.mPowerRangeTextField.addFocusListener((FocusListener)this);
        this.mThroughTextField = new FloatTextField(-6.5, 7.5, 4, false);
        this.mThroughLabel = DialogUtil.createLabel(this, "IDS_WEIGHT_ESTIMATION_THROUGH");
        this.mThroughLabel.setLabelFor((Component)this.mThroughTextField);
        textFieldAction = new TextFieldAction(this, "IDS_WEIGHT_ESTIMATION_THROUGH");
        this.mThroughTextField.setAction((Action)textFieldAction);
        this.mThroughTextField.getDocument().addDocumentListener(this);
        this.mThroughTextField.addFocusListener((FocusListener)this);
        this.mByTextField = new FloatTextField(0.0, 7.5, 4, true);
        this.mByLabel = DialogUtil.createLabel(this, "IDS_WEIGHT_ESTIMATION_BY");
        this.mByLabel.setLabelFor((Component)this.mByTextField);
        textFieldAction = new TextFieldAction(this, "IDS_WEIGHT_ESTIMATION_BY");
        this.mByTextField.setAction((Action)textFieldAction);
        this.mByTextField.getDocument().addDocumentListener(this);
        this.mByTextField.addFocusListener((FocusListener)this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_WEIGHT_ESTIMATION_INCLUDE_CONSTANT");
        this.mIncludeConstantCheckbox = new JCheckBox(toggleButtonAction);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WeightEstimationDlg.this.runSubDialog(new WeightEstimationOptions(WeightEstimationDlg.this));
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction2);
        this.mGridConstraints = new GridBagConstraints();
    }

    private void setDefaults() {
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mPowerRangeTextField.setText(DEF_POWER_RANGE_VAL);
        this.mThroughTextField.setText(DEF_THROUGH_VAL);
        Formatter formatter = new Formatter().format(ResUtil.getLocale(), DEF_BY_VAL, new Object[0]);
        this.mByTextField.setText(formatter.toString());
        this.mIncludeConstantCheckbox.setSelected(true);
    }

    private void setupMainPanel(JPanel jPanel) {
        JPanel jPanel2 = this.setupWeightFunctionPanel();
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        int n = 23;
        this.mGridConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getArrowButtonInsets();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_WEIGHT_ESTIMATION_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mGridConstraints, 0, 0, 1, 1, n, null);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, this.mGridConstraints, 0, 1, 1, 4, n, null);
        this.mGridConstraints.weighty = 0.0;
        Insets insets2 = new Insets(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDependentLabel, this.mGridConstraints, 3, 0, 1, 1, n, insets2);
        this.mGridConstraints.fill = 0;
        this.mGridConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mDependentArrowButton, this.mGridConstraints, 2, 0, 1, 2, 20, insets2);
        this.mGridConstraints.fill = 2;
        insets2.set(0, insets.left, 0, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, this.mDependentTargetListScrollPane, this.mGridConstraints, 3, 1, 1, 1, n, insets2);
        insets2.set(n2, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mIndependentLabel, this.mGridConstraints, 3, 2, 1, 1, n, insets2);
        this.mGridConstraints.fill = 0;
        insets2.set(insets.top, insets.left, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, this.mIndependentArrowButton, this.mGridConstraints, 2, 3, 1, 1, 10, insets2);
        this.mGridConstraints.fill = 1;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        insets2.set(0, insets.left, 0, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, this.mIndependentTargetListScrollPane, this.mGridConstraints, 3, 3, 1, 1, n, insets2);
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        insets2.set(n2, DialogUtil.getComponentGroupGap() - 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mGridConstraints, 2, 4, 3, 1, n, insets2);
        this.mGridConstraints.fill = 0;
        insets2.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeConstantCheckbox, this.mGridConstraints, 0, 5, 2, 1, n, insets2);
        n = 24;
        insets2.set(n2, n2 * 4, 0, n2 * 9);
        DialogUtil.addUsingGBL(jPanel, this.mOptionsButton, this.mGridConstraints, 3, 5, 2, 1, n, insets2);
    }

    private JPanel setupWeightFunctionPanel() {
        int n = 23;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = DialogUtil.getStandardControlInsets();
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets3 = new Insets(0, insets.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mWeightLabel, this.mGridConstraints, 1, 0, 1, 1, n, insets3);
        this.mGridConstraints.weightx = 0.0;
        insets3.set(0, insets2.bottom * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mWeightArrowButton, this.mGridConstraints, 0, 0, 1, 2, 20, insets3);
        this.mGridConstraints.fill = 2;
        this.mGridConstraints.weightx = 1.0;
        insets3.set(0, insets.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mWeightTargetListScrollPane, this.mGridConstraints, 1, 1, 1, 1, n, insets3);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 1.0;
        insets3.set(n2, n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel2, this.mPowerRangeLabel, this.mGridConstraints, 0, 0, 1, 1, n, insets3);
        this.mGridConstraints.fill = 0;
        this.mGridConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mPowerRangeTextField, this.mGridConstraints, 1, 0, 1, 1, n, insets3);
        this.mGridConstraints.fill = 2;
        this.mGridConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mThroughLabel, this.mGridConstraints, 2, 0, 1, 1, n, insets3);
        this.mGridConstraints.fill = 0;
        this.mGridConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mThroughTextField, this.mGridConstraints, 3, 0, 1, 1, n, insets3);
        this.mGridConstraints.fill = 2;
        this.mGridConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mByLabel, this.mGridConstraints, 4, 0, 1, 1, n, insets3);
        this.mGridConstraints.fill = 0;
        this.mGridConstraints.weightx = 1.0;
        insets3.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mByTextField, this.mGridConstraints, 5, 0, 1, 1, n, insets3);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.mGridConstraints.fill = 2;
        this.mGridConstraints.weighty = 0.0;
        jPanel3.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_WEIGHT_ESTIMATION_WEIGHT_FUNCTION_TITLE")));
        insets3.set(n2, n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel3, jPanel, this.mGridConstraints, 0, 0, 1, 1, n, insets3);
        this.mGridConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, jPanel2, this.mGridConstraints, 0, 1, 1, 1, n, insets3);
        return jPanel3;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDependentArrowButton);
        vector.add(this.mIndependentArrowButton);
        vector.add(this.mWeightArrowButton);
        vector.add(this.mDependentTargetList);
        vector.add(this.mIndependentTargetList);
        vector.add(this.mWeightTargetList);
        vector.add(this.mPowerRangeTextField);
        vector.add(this.mThroughTextField);
        vector.add(this.mByTextField);
        vector.add(this.mIncludeConstantCheckbox);
        vector.add(this.mOptionsButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    class WeightEstimationDropListener
    extends VarListDropListener {
        WeightEstimationDropListener(VariableList variableList, IVarMoveHandler iVarMoveHandler) {
            super(variableList, iVarMoveHandler);
        }

        @Override
        public void itemDropped(DropEvent dropEvent) {
            Component component = dropEvent.getSource();
            WeightEstimationDlg.this.mSourceList = (VariableList)component;
            super.itemDropped(dropEvent);
        }
    }
}

