/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.two_st_least_squares;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.pro_stats.res.ProStatsResBundle;
import com.spss.java_client.ui.dialogs.pro_stats.two_st_least_squares.TwoStageLeastSquaresOptions;
import com.spss.java_client.ui.dialogs.pro_stats.two_st_least_squares.TwoStageLinearVarMoveHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class TwoStageLeastSquaresDlg
extends BaseProcedureDialog
implements ListDataListener {
    public static final String INCLUDE_CONSTANT_CHECK = "IDS_INCLUDE_CONSTANT_CHECK";
    private static final String DEPENDENT_TARGET_VARIABLE_LIST_IDENTIFIER = "DEPENDENT_TARGET_VARIABLE_LIST";
    private static final String EXPLANATORY_TARGET_VARIABLE_LIST_IDENTIFIER = "EXPLANATORY_TARGET_VARIABLE_LIST";
    private static final String INSTRUMENTAL_TARGET_VARIABLE_LIST_IDENTIFIER = "INSTRUMENTAL_TARGET_VARIABLE_LIST";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mExplanatoryListVarList;
    private TargetVariableList mInstrumentalListVarList;
    private TargetVariableList mDependentVarList;
    private JCheckBox mIncludeConstCheckBox;
    private JButton optionButton;
    private Vector<Object> mTabOrder;

    public TwoStageLeastSquaresDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, ProStatsResBundle.getDefaultResourceBundleName(), ProStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_TWO_STAGE_LEAST_SQUARES"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* " + this.getResString("IDS_TWO_STAGE_LEAST_SQUARES_SYNTAX_TITLE") + ".");
        Boolean bl = dialogDataModel.getBoolean("IDS_PREDICTED_CHECK");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_RESIDUALS_CHECK");
        if (bl == null) {
            bl = false;
        }
        if (bl2 == null) {
            bl2 = false;
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getMainCommand("TSET "));
        if (bl.booleanValue() || bl2.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("MXNEWVAR="));
            stringBuffer.append((bl != false ? 1 : 0) + (bl2 != false ? 1 : 0));
        } else {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("NEWVAR=NONE"));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(SyntaxUtil.getMainCommand("2SLS"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mDependentVarList.getVariablesStringList()));
        stringBuffer.append(" WITH " + this.mExplanatoryListVarList.getVariablesStringList() + "\n");
        TargetVariableList targetVariableList = this.mInstrumentalListVarList;
        stringBuffer.append(SyntaxUtil.getSubCommand("/INSTRUMENTS "));
        stringBuffer.append(targetVariableList.getVariablesStringList() + "\n");
        Boolean bl3 = dialogDataModel.getBoolean(INCLUDE_CONSTANT_CHECK);
        if (bl3 != null) {
            if (bl3.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/CONSTANT"));
            } else {
                stringBuffer.append(SyntaxUtil.getSubCommand("/NOCONSTANT"));
            }
            stringBuffer.append("\n");
        }
        if (bl != null && bl.booleanValue() || bl2 != null && bl2.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/SAVE"));
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append(" PRED");
            }
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append(" RESID");
            }
            stringBuffer.append("\n");
        }
        if ((bl3 = dialogDataModel.getBoolean("IDS_COVARIANCE_CHECK")) != null && bl3.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT COV"));
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax().toString());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mExplanatoryListVarList.removeAll();
        this.mDependentVarList.removeAll();
        this.mInstrumentalListVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mIncludeConstCheckBox.setSelected(true);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateOkAndPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateOkAndPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateOkAndPaste();
    }

    @Override
    public boolean okPastePressed() {
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_PREDICTED_CHECK");
        Boolean bl2 = this.getDialogDataModel().getBoolean("IDS_RESIDUALS_CHECK");
        if (bl != null && bl2 != null && (bl.booleanValue() || bl2.booleanValue())) {
            boolean bl3;
            int n = (bl != false ? 1 : 0) + (bl2 != false ? 1 : 0);
            String string = String.format(ComponentState.getSPSSLocale(), this.getResString("ERR_CONFIRM_MSG_NEW_VARS"), n, n);
            boolean bl4 = bl3 = 0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (bl3 && this.mInstrumentalListVarList.getModel().getSize() < this.mExplanatoryListVarList.getModel().getSize()) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_WARNING_MSG_FOR_LISTS"), VersionInfo.getAppVersionString());
                return false;
            }
            return bl3;
        }
        if (this.mInstrumentalListVarList.getModel().getSize() < this.mExplanatoryListVarList.getModel().getSize()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_WARNING_MSG_FOR_LISTS"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_tsls";
    }

    @Override
    public String getIActionKey() {
        return "analyze_regression_least_squares";
    }

    @Override
    protected void validateSerializableLists() {
        this.validateSerializableLists1(this.mDependentVarList);
        this.validateSerializableLists1(this.mExplanatoryListVarList);
        this.validateSerializableLists1(this.mInstrumentalListVarList);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.mTabOrder.add(this.mSrcVarList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TWO_STAGE_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 6, n, null);
        this.mIncludeConstCheckBox.setSelected(true);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mIncludeConstCheckBox, gridBagConstraints, 0, 7, 1, 1, n, null);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n2, 0);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_DEPENDENT_COLON");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        n = 20;
        jScrollPane = new JScrollPane(this.mDependentVarList);
        jScrollPane.setPreferredSize(this.mDependentVarList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        jLabel2.setLabelFor(this.mDependentVarList);
        jLabel2 = DialogUtil.createLabel(this, "IDS_EXPLANATORY_COLON");
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mExplanatoryListVarList);
        this.mExplanatoryListVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mExplanatoryListVarList.getFixedCellHeight() * 3 + 2));
        jScrollPane.setPreferredSize(this.mExplanatoryListVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 3, 1, 1, n, insets);
        jLabel2.setLabelFor(this.mExplanatoryListVarList);
        jLabel2 = DialogUtil.createLabel(this, "IDS_INSTRUMENTAL_COLON");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 4, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mInstrumentalListVarList);
        this.mInstrumentalListVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mInstrumentalListVarList.getFixedCellHeight() * 3 + 2));
        jScrollPane.setPreferredSize(this.mInstrumentalListVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 5, 1, 1, n, insets);
        jLabel2.setLabelFor(this.mInstrumentalListVarList);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = new Insets(0, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.getDependentArrowButton(), gridBagConstraints, 1, 0, 1, 2, n, insets3);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.getExplanatoryArrowButton(), gridBagConstraints, 1, 3, 1, 1, n, insets2);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.getInstrumentalArrowButton(), gridBagConstraints, 1, 5, 1, 1, n, insets2);
        this.pack();
        this.updateOkAndPaste();
        this.mSrcVarList.requestFocus();
        this.mTabOrder.add(this.mDependentVarList);
        this.mTabOrder.add(this.mExplanatoryListVarList);
        this.mTabOrder.add(this.mInstrumentalListVarList);
        this.mTabOrder.add(this.mIncludeConstCheckBox);
        this.mTabOrder.add(this.optionButton);
        this.setTabTraversalOrder();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TwoStageLeastSquaresDlg.this.runOptionsSubDialog();
            }
        };
        this.optionButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.optionButton);
        return jPanel;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new TwoStageLeastSquaresOptions(this));
    }

    private void updateOkAndPaste() {
        this.enableOkPaste(this.mExplanatoryListVarList.getModel().getSize() > 0 && this.mDependentVarList.getModel().getSize() > 0);
    }

    private void validateSerializableLists1(VariableList variableList) {
        for (int i = variableList.getModel().getSize() - 1; i >= 0; --i) {
            boolean bl;
            ISpssVariable iSpssVariable = variableList.getModel().getElementAt(i);
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.findVarIndex(iSpssVariable.getId());
            if (iSpssVariable == null || n != -1 || (bl = iSpssDataSrc.isVariableInCurrentSet(iSpssVariable))) continue;
            variableList.getModel().removeElementAt(i);
        }
        variableList.repaint();
        this.enableOkPaste(variableList.getModel().getSize() > 0);
    }

    private void initVars() {
        this.mTabOrder = new Vector();
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(2048, false));
        TargetVariableList.TargetListType targetListType = TargetVariableList.TargetListType.single_item;
        this.mDependentVarList = new TargetVariableList(targetListType);
        this.mDependentVarList.setIdentifier(DEPENDENT_TARGET_VARIABLE_LIST_IDENTIFIER);
        this.mExplanatoryListVarList = new TargetVariableList();
        this.mDependentVarList.setIdentifier(EXPLANATORY_TARGET_VARIABLE_LIST_IDENTIFIER);
        this.mInstrumentalListVarList = new TargetVariableList();
        this.mInstrumentalListVarList.setIdentifier(INSTRUMENTAL_TARGET_VARIABLE_LIST_IDENTIFIER);
        this.mIncludeConstCheckBox = new JCheckBox(new ToggleButtonAction(this, INCLUDE_CONSTANT_CHECK));
        this.mSrcVarList.loadFromActiveDataset();
        this.mDependentVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDependentVarList.addVarFilter(new SpssVarFilter(2048, false));
        this.mDependentVarList.getModel().addListDataListener(this);
        this.mExplanatoryListVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mExplanatoryListVarList.getModel().addListDataListener(this);
        this.mExplanatoryListVarList.addVarFilter(new SpssVarFilter(2048, false));
        this.mInstrumentalListVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mInstrumentalListVarList.addVarFilter(new SpssVarFilter(2048, false));
        this.mInstrumentalListVarList.getModel().addListDataListener(this);
        if (this.mSrcVarList.getModel().getSize() > 0) {
            this.mSrcVarList.setSelectedIndex(0);
        }
    }

    private ArrowButton getInstrumentalArrowButton() {
        ArrowButton arrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTabOrder.add(arrowButton);
        arrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        arrowButton.registerVariableList(this.mInstrumentalListVarList, SpssArrowButton.ButtonOrientation.left);
        return arrowButton;
    }

    private ArrowButton getExplanatoryArrowButton() {
        ArrowButton arrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTabOrder.add(arrowButton);
        arrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        arrowButton.registerVariableList(this.mExplanatoryListVarList, SpssArrowButton.ButtonOrientation.left);
        return arrowButton;
    }

    private ArrowButton getDependentArrowButton() {
        ArrowButton arrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTabOrder.add(arrowButton);
        arrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        arrowButton.registerVariableList(this.mDependentVarList, SpssArrowButton.ButtonOrientation.left);
        TwoStageLinearVarMoveHandler twoStageLinearVarMoveHandler = new TwoStageLinearVarMoveHandler(this, this.mDependentVarList, new VarListModel[]{this.mExplanatoryListVarList.getModel(), this.mInstrumentalListVarList.getModel()});
        arrowButton.setVarMoveHandler(twoStageLinearVarMoveHandler);
        this.mVarMoveHandler = twoStageLinearVarMoveHandler;
        return arrowButton;
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            this.mTabOrder.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

