/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.quantile_reg;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.uitools.controls.ContextEnabledTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.font.TextAttribute;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class SaveSubDlg
extends BaseSubDialog {
    private static final String[] SAVE_TABLE_SYNTAX = new String[]{"PRED", "RESID", "CIPREDL", "CIPREDU"};
    private static final String[] DEFAULT_VAR_NAMES = new String[]{"Predicted", "Residual", "CIPredictedLower", "CIPredictedUpper"};
    private static final String QUANTILE_SAVE_TABLE_DATA_KEY = "IDS_QUANTILE_SAVE_TABLE_DATA_KEY";
    private PlainTable mSaveTable;
    private Vector<SaveTableItem> mSaveTableDataVector;

    SaveSubDlg(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, string, true);
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.setDefaults();
        this.pack();
        this.setFocusTraversalPolicy();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_quantile_save";
    }

    static String getSaveDlgSyntax(DialogDataModel dialogDataModel) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        Vector vector = (Vector)dialogDataModel.getObject(QUANTILE_SAVE_TABLE_DATA_KEY);
        String string = SaveSubDlg.getSaveTableSyntax(vector);
        boolean bl2 = bl = string.length() > 0;
        if (bl) {
            stringBuilder.append("\n");
            stringBuilder.append(SyntaxUtil.getSubCommand("/SAVE "));
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String getSaveTableSyntax(Vector<SaveTableItem> vector) {
        if (vector == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < vector.size(); ++i) {
            SaveTableItem saveTableItem = vector.get(i);
            if (!saveTableItem.getSave()) continue;
            stringBuilder.append(" ").append(SAVE_TABLE_SYNTAX[i]);
            String string = saveTableItem.getVariableName();
            if (string.length() <= 0 || string.equals(DEFAULT_VAR_NAMES[i])) continue;
            stringBuilder.append("(").append(string).append(")");
        }
        return stringBuilder.toString();
    }

    protected void initVars() {
        this.initTable();
    }

    private void initTable() {
        this.mSaveTable = new PlainTable(){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                final Component component = this.getEditorComponent();
                if (component instanceof JTextComponent) {
                    if (ComponentState.isBtdRtlOrLtr() && n2 == 2 && ((JTextComponent)component).getDocument() != null) {
                        if (ComponentState.getBTD() == 1) {
                            ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                        } else {
                            ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                        }
                    }
                    if (eventObject == null) {
                        ((JTextComponent)component).selectAll();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)component).selectAll();
                            }
                        });
                    }
                }
                return bl;
            }
        };
        SaveTableModel saveTableModel = this.getSaveTableModel();
        saveTableModel.mColumnNames[0] = this.getResString("IDS_QUANTILE_STATIS_COLUMN0_NAME");
        saveTableModel.mColumnNames[1] = this.getResString("IDS_QUANTILE_STATIS_COLUMN1_NAME");
        saveTableModel.mColumnNames[2] = this.getResString("IDS_QUANTILE_STATIS_COLUMN2_NAME");
        this.mSaveTable.setModel(saveTableModel);
        this.mSaveTable.setRowHeight(this.mSaveTable.getRowHeight() + 6);
        this.mSaveTable.setColumnSelectionAllowed(true);
        this.mSaveTable.setSelectionMode(0);
        this.mSaveTable.setRowSelectionAllowed(true);
        this.mSaveTable.setCellSelectionEnabled(true);
        this.mSaveTable.setDefaultRenderer(Object.class, new SaveTableRenderer());
        JTableHeader jTableHeader = this.mSaveTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = null;
                jLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 0) {
                    jLabel.setHorizontalAlignment(0);
                } else {
                    jLabel.setHorizontalAlignment(2);
                }
                jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                jLabel.setBackground(jTable.getTableHeader().getBackground());
                jLabel.setForeground(jTable.getTableHeader().getForeground());
                return jLabel;
            }
        });
        TableColumnModel tableColumnModel = this.mSaveTable.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer(new CheckBoxRenderer());
        tableColumnModel.getColumn(1).setPreferredWidth(280);
        tableColumnModel.getColumn(1).setMinWidth(200);
        tableColumnModel.getColumn(2).setCellEditor(new ValueCellEditor(new StringTextField()));
        tableColumnModel.getColumn(2).setPreferredWidth(300);
        tableColumnModel.getColumn(2).setMinWidth(200);
    }

    @Override
    public boolean continuePressed() {
        return this.isValidate();
    }

    private void setDefaults() {
        if (this.mSaveTableDataVector != null) {
            this.mSaveTableDataVector.clear();
        }
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        this.mSaveTableDataVector = (Vector)dialogDataModel.getObject(QUANTILE_SAVE_TABLE_DATA_KEY);
        super.loadState(dialogDataModel);
        this.reloadTable(this.mSaveTable, this.mSaveTableDataVector);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        if (this.mSaveTable != null) {
            this.mSaveTableDataVector = ((SaveTableModel)this.mSaveTable.getModel()).getTableData();
            dialogDataModel.putObject(QUANTILE_SAVE_TABLE_DATA_KEY, this.mSaveTableDataVector);
        }
        return super.saveState(dialogDataModel);
    }

    private void reloadTable(PlainTable plainTable, Vector<SaveTableItem> vector) {
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                SaveTableItem saveTableItem = vector.get(i);
                plainTable.setValueAt(saveTableItem.getSave(), i, 0);
                plainTable.setValueAt(saveTableItem.getItemToSave(), i, 1);
                plainTable.setValueAt(saveTableItem.getVariableName(), i, 2);
            }
        }
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.mSaveTable);
        jScrollPane.setPreferredSize(new Dimension(600, 200));
        jPanel2.add((Component)jScrollPane, "Center");
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSaveTable);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private SaveTableModel getSaveTableModel() {
        Vector<SaveTableItem> vector = new Vector<SaveTableItem>();
        SaveTableItem saveTableItem = new SaveTableItem(false, this.getResString("IDS_QUANTILE_SAVE_PREDICTED"), DEFAULT_VAR_NAMES[0]);
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(false, this.getResString("IDS_QUANTILE_SAVE_RESIDUAL"), DEFAULT_VAR_NAMES[1]);
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(false, this.getResString("IDS_QUANTILE_SAVE_LOWER"), DEFAULT_VAR_NAMES[2]);
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(false, this.getResString("IDS_QUANTILE_SAVE_UPPER"), DEFAULT_VAR_NAMES[3]);
        vector.addElement(saveTableItem);
        return new SaveTableModel(vector, this.mSaveTable);
    }

    private boolean existsInDataset(String string) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        return iSpssDataSrc.findVarIndex(string) >= 0;
    }

    public boolean isValidate() {
        boolean bl = true;
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        try {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.mSaveTable.getModel().getRowCount(); ++i) {
                SaveTableItem saveTableItem = (SaveTableItem)saveTableModel.getValue(i);
                if (!saveTableItem.getSave()) continue;
                for (int j = 0; j < this.mSaveTable.getModel().getColumnCount(); ++j) {
                    String string;
                    if (j != 2) continue;
                    TableCellEditor tableCellEditor = this.mSaveTable.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.stopCellEditing();
                        this.mSaveTable.getSelectionModel().clearSelection();
                    }
                    if ((string = this.mSaveTable.getModel().getValueAt(i, j).toString()).length() == 0) continue;
                    if (!this.isLegalValue(string)) {
                        this.changeSelection(i, j);
                        return false;
                    }
                    vector.add(string);
                    if (this.isDuplicateValue(vector)) {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_QUANTILE_SAVE_DUPLICATE_VALUE_MSG"), VersionInfo.getAppVersionString());
                        this.changeSelection(i, j);
                        return false;
                    }
                    if (!this.existsInDataset(string)) continue;
                    String string2 = MessageFormat.format(this.getResString("ERR_QUANTILE_SAVE_EXIST_VALUE_MSG"), string);
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
                    this.changeSelection(i, j);
                    return false;
                }
            }
        }
        catch (Exception exception) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_QUANTILE_SAVE_VALID_VALUE_MSG"), VersionInfo.getAppVersionString());
            bl = false;
        }
        return bl;
    }

    private void changeSelection(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SaveSubDlg.this.mSaveTable.changeSelection(n, n2, false, false);
                SaveSubDlg.this.mSaveTable.editCellAt(n, n2, null);
                SaveSubDlg.this.mSaveTable.requestFocusInWindow();
            }
        });
    }

    private boolean isLegalValue(String string) {
        boolean bl;
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        if (n > 0 && n != 100) {
            DialogUtil.showBadSpssVarNameWarning(n, this);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isDuplicateValue(Vector<String> vector) {
        Object[] objectArray = vector.toArray();
        for (int i = 0; i <= vector.toArray().length - 1; ++i) {
            for (int j = i + 1; j <= vector.toArray().length - 1; ++j) {
                if (!objectArray[i].toString().equals(objectArray[j].toString())) continue;
                return true;
            }
        }
        return false;
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        Border mEmptyBorder = BorderFactory.createEmptyBorder();
        Border mHighLightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");

        CheckBoxRenderer() {
            this.setBorder(null);
            this.setLayout(new FlowLayout(1, 0, 0));
            this.setBorder(this.mHighLightBorder);
            this.setBorderPainted(true);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(0);
            if (bl2) {
                this.setBorder(this.mHighLightBorder);
            } else {
                this.setBorder(this.mEmptyBorder);
            }
            this.setSelected(object != null && (Boolean)object != false);
            boolean bl3 = jTable.isCellEditable(n, n2);
            this.setEnabled(bl3);
            return this;
        }
    }

    class SaveTableRenderer
    extends DefaultTableCellRenderer {
        boolean mSave;
        Border mEmptyBorder = BorderFactory.createEmptyBorder();
        Border mHighLightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");

        SaveTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 1) {
                component.setForeground(Color.black);
                if (component.hasFocus() && component instanceof JLabel) {
                    ((JLabel)component).setBorder(this.mHighLightBorder);
                }
            } else if (n2 == 2) {
                Object object2 = jTable.getValueAt(n, 0);
                if (object2 instanceof Boolean) {
                    this.mSave = (Boolean)object2;
                }
                if (this.mSave) {
                    component.setForeground(Color.black);
                    if (component.hasFocus() && component instanceof JLabel) {
                        ((JLabel)component).setBorder(this.mHighLightBorder);
                    }
                } else {
                    component.setForeground(Color.gray);
                    if (component instanceof JLabel) {
                        ((JLabel)component).setBorder(this.mEmptyBorder);
                    }
                }
            } else {
                component.setForeground(Color.black);
            }
            if (bl) {
                if (component.hasFocus()) {
                    component.setBackground(jTable.getSelectionBackground());
                }
            } else {
                component.setBackground(jTable.getBackground());
            }
            return component;
        }
    }

    static class SaveTableItem {
        boolean mSave = false;
        String mItemToSave = "";
        String mVariableName = "";

        SaveTableItem(boolean bl, String string, String string2) {
            this.mSave = bl;
            this.mItemToSave = string;
            this.mVariableName = string2;
        }

        boolean getSave() {
            return this.mSave;
        }

        void setSave(boolean bl) {
            this.mSave = bl;
        }

        String getItemToSave() {
            return this.mItemToSave;
        }

        void setItemToSave(String string) {
            this.mItemToSave = string;
        }

        String getVariableName() {
            return this.mVariableName;
        }

        void setVariableName(String string) {
            this.mVariableName = string;
        }
    }

    class SaveTableModel
    extends AbstractTableModel {
        public String[] mColumnNames = new String[3];
        private Vector<SaveTableItem> mData;
        private JTable mTable;

        SaveTableModel(Vector<SaveTableItem> vector, JTable jTable) {
            this.mData = vector;
            this.mTable = jTable;
        }

        @Override
        public int getRowCount() {
            return 4;
        }

        public int getSize() {
            return this.mData.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        public Object getValue(int n) {
            if (n < 0 || n >= this.getSize()) {
                return null;
            }
            return this.mData.get(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SaveTableItem saveTableItem = this.mData.get(n);
            switch (n2) {
                case 0: {
                    return saveTableItem.getSave();
                }
                case 1: {
                    return saveTableItem.getItemToSave();
                }
                case 2: {
                    return saveTableItem.getVariableName();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SaveTableItem saveTableItem = this.mData.get(n);
            if (n2 == 0) {
                Boolean bl = (Boolean)object;
                saveTableItem.setSave(bl);
                this.mTable.repaint();
            } else if (n2 == 2) {
                saveTableItem.setVariableName(object.toString());
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            SaveTableItem saveTableItem = this.mData.get(n);
            if (n2 == 0) {
                return true;
            }
            if (n2 == 2) {
                return saveTableItem.getSave();
            }
            return false;
        }

        @Override
        public String getColumnName(int n) {
            return this.mColumnNames[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        public Vector<SaveTableItem> getTableData() {
            return this.mData;
        }

        public void setTableData(Vector<SaveTableItem> vector) {
            this.mData = vector;
        }
    }

    static class ValueCellEditor
    extends DefaultCellEditor {
        ValueCellEditor(ContextEnabledTextField contextEnabledTextField) {
            super((JTextField)contextEnabledTextField);
            final ContextEnabledTextField contextEnabledTextField2 = (ContextEnabledTextField)this.getComponent();
            this.setClickCountToStart(1);
            contextEnabledTextField2.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    contextEnabledTextField2.selectAll();
                }
            });
        }
    }
}

