/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.quantile_reg;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.AbstractModelSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.pro_stats.quantile_reg.CriteriaSubDlg;
import com.spss.java_client.ui.dialogs.pro_stats.quantile_reg.DisplaySubDlg;
import com.spss.java_client.ui.dialogs.pro_stats.quantile_reg.ExportSubDlg;
import com.spss.java_client.ui.dialogs.pro_stats.quantile_reg.ModelSubDlg;
import com.spss.java_client.ui.dialogs.pro_stats.quantile_reg.SaveSubDlg;
import com.spss.java_client.ui.dialogs.pro_stats.res.ProStatsResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class QuantileRegressionDlg
extends BaseProcedureDialog
implements ListDataListener {
    private TargetVariableList mTargetList;
    private TargetVariableList mFactorsList;
    private TargetVariableList mCovariatesList;
    private TargetVariableList mWeightList;
    private JCheckBox mConserveCheckBox;
    private SrcVariableList mSrcVariableList;
    private ArrowButton mTargetArrowButton;
    private ArrowButton mFactorArrowButton;
    private ArrowButton mCovariateArrowButton;
    private ArrowButton mWeightArrowButton;

    public QuantileRegressionDlg(JFrame jFrame) {
        super(jFrame, false, ProStatsResBundle.getDefaultResourceBundleName(), ProStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_QUANTILE_REGRESSION_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        String string;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(this.generateTopmostSyntaxCommandAsNeeded(dialogDataModel));
        stringBuffer.append(SyntaxUtil.getMainCommand("QUANTILE REGRESSION "));
        stringBuffer.append(this.mTargetList.getVariablesStringList());
        String string2 = this.mFactorsList.getVariablesStringList();
        if (string2.length() > 0) {
            stringBuffer.append(" BY ");
            stringBuffer.append(string2);
        }
        if ((string = this.mCovariatesList.getVariablesStringList()).length() > 0) {
            stringBuffer.append(" WITH ");
            stringBuffer.append(string);
        }
        stringBuffer.append("\n");
        this.generateCriteriaSyntax(stringBuffer, dialogDataModel);
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING "));
        Boolean bl = dialogDataModel.getBoolean("IDS_MISSING_EXCLUDE");
        stringBuffer.append("CLASSMISSING=").append(bl == null || bl != false ? "EXCLUDE" : "INCLUDE");
        stringBuffer.append("\n");
        stringBuffer.append(this.generateModelSyntax(dialogDataModel));
        stringBuffer.append(DisplaySubDlg.generateDisplaySyntax(dialogDataModel, this.mFactorsList.getModel(), this.mCovariatesList.getModel()));
        stringBuffer.append(SaveSubDlg.getSaveDlgSyntax(dialogDataModel));
        stringBuffer.append(this.generateExportDlgSyntax(dialogDataModel));
        if (this.mConserveCheckBox.isSelected()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/EXTERNAL"));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mSrcVariableList.loadFromActiveDataset();
        this.mCovariatesList.getModel().removeAll();
        this.mTargetList.getModel().removeAll();
        this.mFactorsList.getModel().removeAll();
        this.mWeightList.getModel().removeAll();
        this.mConserveCheckBox.setSelected(false);
        this.mSrcVariableList.setSelectedIndex(0);
        this.mSrcVariableList.requestFocus();
    }

    @Override
    public String getIActionKey() {
        return "analyze_regression_quantile";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_quantile";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateOKPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateOKPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateOKPaste();
    }

    @Override
    public boolean okPastePressed() {
        ResourceBundle resourceBundle;
        String string;
        boolean bl = this.mFactorsList.getModel().getSize() == 0 && this.mCovariatesList.getModel().getSize() == 0;
        boolean bl2 = this.isInterceptAtModelChecked();
        if (bl && bl2 && SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string = (resourceBundle = ResUtil.getBundle(AnalyzeResBundle1.getDefaultResourceBundleName(), Locale.getDefault())).getString("ERR_MODEL_NO_EFFECTS_SPECIFIED_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION) == 2) {
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVariableList.setSelectedIndex(0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVariableList);
        this.mSrcVariableList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth() + 20, this.mSrcVariableList.getFixedCellHeight() * 4));
        jScrollPane.setPreferredSize(this.mSrcVariableList.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_QUANTILE_REGRESSION_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVariableList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel, gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.getViewPanel(), jScrollPane, gridBagConstraints, 0, 1, 1, 9, 10, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_QUANTILE_TARGET");
        jLabel2.setLabelFor(this.mTargetList);
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel2, gridBagConstraints, 2, 0, 1, 1, 23, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jScrollPane = new JScrollPane(this.mTargetList);
        jScrollPane.setPreferredSize(this.mTargetList.getPreferredSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        DialogUtil.addUsingGBL(this.getViewPanel(), jScrollPane, gridBagConstraints, 2, 1, 1, 1, 20, insets);
        this.mTargetArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mTargetArrowButton.registerVariableList(this.mTargetList, SpssArrowButton.ButtonOrientation.left);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mTargetArrowButton, gridBagConstraints, 1, 0, 1, 2, 20, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jLabel2 = DialogUtil.createLabel(this, "IDS_FACTORS");
        jLabel2.setLabelFor(this.mFactorsList);
        jScrollPane = new JScrollPane(this.mFactorsList);
        this.mFactorsList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFactorsList.getFixedCellHeight() * 5 + 2));
        jScrollPane.setPreferredSize(this.mFactorsList.getMinimumSize());
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel2, gridBagConstraints, 2, 3, 1, 1, 21, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.getViewPanel(), jScrollPane, gridBagConstraints, 2, 4, 1, 1, 21, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.mFactorArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mFactorArrowButton.registerVariableList(this.mFactorsList, SpssArrowButton.ButtonOrientation.left);
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mFactorArrowButton, gridBagConstraints, 1, 3, 1, 2, 21, DialogUtil.getArrowButtonInsets());
        jLabel2 = DialogUtil.createLabel(this, "IDS_MULTINOMIAL_LOGISTIC_REGRESSION_COVARIATE");
        jLabel2.setLabelFor(this.mCovariatesList);
        jScrollPane = new JScrollPane(this.mCovariatesList);
        this.mCovariatesList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mCovariatesList.getFixedCellHeight() * 5 + 2));
        jScrollPane.setPreferredSize(this.mCovariatesList.getMinimumSize());
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel2, gridBagConstraints, 2, 5, 1, 1, 21, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.getViewPanel(), jScrollPane, gridBagConstraints, 2, 6, 1, 1, 21, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.mCovariateArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mCovariateArrowButton.registerVariableList(this.mCovariatesList, SpssArrowButton.ButtonOrientation.left);
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mCovariateArrowButton, gridBagConstraints, 1, 5, 1, 2, 21, DialogUtil.getArrowButtonInsets());
        jScrollPane = new JScrollPane(this.mWeightList);
        jScrollPane.setPreferredSize(this.mWeightList.getPreferredSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.getViewPanel(), jScrollPane, gridBagConstraints, 2, 8, 1, 1, 20, insets);
        this.mWeightArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mWeightArrowButton.registerVariableList(this.mWeightList, SpssArrowButton.ButtonOrientation.left);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mWeightArrowButton, gridBagConstraints, 1, 7, 1, 2, 20, insets);
        jLabel2 = DialogUtil.createLabel(this, "IDS_QUANTILE_WEIGHT");
        jLabel2.setLabelFor(this.mWeightList);
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel2, gridBagConstraints, 2, 7, 1, 1, 23, insets);
        Insets insets2 = (Insets)insets.clone();
        insets2.left -= 5;
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mConserveCheckBox, gridBagConstraints, 2, 9, 1, 1, 23, insets2);
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_QUANTILE_CRITERIA_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QuantileRegressionDlg.this.runSubDialog(new CriteriaSubDlg(QuantileRegressionDlg.this, QuantileRegressionDlg.this.getResString("IDS_QUANTILE_REGRESSION_CRITERIA_TITLE")));
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_MODEL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VarListModel varListModel = QuantileRegressionDlg.this.mFactorsList.getModel();
                VarListModel varListModel2 = QuantileRegressionDlg.this.mCovariatesList.getModel();
                QuantileRegressionDlg.this.runSubDialog(new ModelSubDlg(QuantileRegressionDlg.this, QuantileRegressionDlg.this.getResString("IDS_QUANTILE_REGRESSION_MODEL_TITLE"), varListModel, varListModel2));
                QuantileRegressionDlg.this.updateOKPaste();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        toggleButtonAction = new ToggleButtonAction(this, "IDS_QUANTILE_DISPLAY_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QuantileRegressionDlg.this.runSubDialog(new DisplaySubDlg(QuantileRegressionDlg.this, QuantileRegressionDlg.this.getResString("IDS_QUANTILE_REGRESSION_DISPLAY_TITLE"), QuantileRegressionDlg.this.mFactorsList.getModel(), QuantileRegressionDlg.this.mCovariatesList.getModel()));
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_SAVE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QuantileRegressionDlg.this.runSubDialog(new SaveSubDlg(QuantileRegressionDlg.this, QuantileRegressionDlg.this.getResString("IDS_QUANTILE_REGRESSION_SAVE_TITLE")));
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        toggleButtonAction = new ToggleButtonAction(this, "IDS_QUANTILE_EXPORT_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QuantileRegressionDlg.this.runSubDialog(new ExportSubDlg(QuantileRegressionDlg.this, QuantileRegressionDlg.this.getResString("IDS_QUANTILE_REGRESSION_EXPORT_TITLE")));
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        return jPanel;
    }

    private void updateOKPaste() {
        boolean bl = false;
        if (this.mTargetList.getModel().getSize() > 0) {
            bl = true;
            if (this.mFactorsList.getModel().getSize() == 0 && this.mCovariatesList.getModel().getSize() == 0 && !this.isInterceptAtModelChecked()) {
                bl = false;
            }
        }
        this.enableOkPaste(bl);
    }

    private boolean isInterceptAtModelChecked() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_QUANTILE_INCLUDE_INTERCEPT");
        return bl != null ? bl : true;
    }

    private void setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVariableList);
        vector.add(this.mTargetArrowButton);
        vector.add(this.mFactorArrowButton);
        vector.add(this.mCovariateArrowButton);
        vector.add(this.mWeightArrowButton);
        vector.add(this.mTargetList);
        vector.add(this.mFactorsList);
        vector.add(this.mCovariatesList);
        vector.add(this.mWeightList);
        vector.add(this.mConserveCheckBox);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private String generateTopmostSyntaxCommandAsNeeded(DialogDataModel dialogDataModel) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = dialogDataModel.containsBooleanKey("IDS_QUANTILE_MATRIX_CHECK0") ? dialogDataModel.getBoolean("IDS_QUANTILE_MATRIX_CHECK0") : false;
        boolean bl3 = dialogDataModel.containsBooleanKey("IDS_QUANTILE_MATRIX_CHECK1") ? dialogDataModel.getBoolean("IDS_QUANTILE_MATRIX_CHECK1") : false;
        boolean bl4 = dialogDataModel.containsBooleanKey("IDS_QUANTILE_DATASET_RADIO0") ? dialogDataModel.getBoolean("IDS_QUANTILE_DATASET_RADIO0") : true;
        boolean bl5 = dialogDataModel.containsBooleanKey("IDS_QUANTILE_DATASET_RADIO1") ? dialogDataModel.getBoolean("IDS_QUANTILE_DATASET_RADIO1") : true;
        boolean bl6 = bl = dialogDataModel.containsBooleanKey("IDS_QUANTILE_FILESAVE_SINGLE_CHECK") ? dialogDataModel.getBoolean("IDS_QUANTILE_FILESAVE_SINGLE_CHECK") : true;
        if (bl2 && bl4 || bl3 && bl5) {
            String string = dialogDataModel.getString("IDS_QUANTILE_DATASET_NAME0");
            String string2 = dialogDataModel.getString("IDS_QUANTILE_DATASET_NAME1");
            Object[] objectArray = dialogDataModel.getArray("LIST_ACTION");
            if (objectArray == null) {
                objectArray = new Object[]{"0.5"};
            }
            if (objectArray.length == 1 || bl) {
                if (bl2 && bl4) {
                    stringBuilder.append(this.getSingleDatasetDeclareSyntax(string));
                }
                if (bl3 && bl5) {
                    stringBuilder.append(this.getSingleDatasetDeclareSyntax(string2));
                }
            } else if (objectArray.length > 1) {
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
                char c = decimalFormatSymbols.getDecimalSeparator();
                for (Object object : objectArray) {
                    int n = object.toString().indexOf(c);
                    String string3 = object.toString().substring(n + 1);
                    if (bl2 && bl4) {
                        stringBuilder.append(this.getSingleDatasetDeclareSyntax(string + "_" + string3));
                    }
                    if (!bl3 || !bl5) continue;
                    stringBuilder.append(this.getSingleDatasetDeclareSyntax(string2 + "_" + string3));
                }
            }
        }
        return stringBuilder.toString();
    }

    private String getSingleDatasetDeclareSyntax(String string) {
        String string2 = SyntaxUtil.getCommand("DATASET DECLARE ", false).toString();
        string2 = string2 + string;
        string2 = string2 + SyntaxUtil.terminateSyntax();
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private void generateCriteriaSyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        void var6_12;
        Object object2;
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA "));
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = dialogDataModel.getArray("LIST_ACTION");
        if (objectArray != null) {
            for (Object object2 : objectArray) {
                stringBuilder.append(object2.toString()).append(" ");
            }
        } else {
            stringBuilder.append("0.5");
        }
        stringBuffer.append("QUANTILE=");
        stringBuffer.append((CharSequence)stringBuilder);
        String string = "AUTO";
        Boolean bl = dialogDataModel.getBoolean("IDS_ESTIMATION_AUTO_RADIO");
        if (bl != null && bl.booleanValue()) {
            String string2 = "AUTO";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ESTIMATION_SIMPLEX_RADIO")) != null && bl.booleanValue()) {
            String string3 = "SIMPLEX";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ESTIMATION_INTERIOR_POINT_RADIO")) != null && bl.booleanValue()) {
            String string4 = "INTERIOR_POINT";
        }
        stringBuffer.append(" METHOD=").append((String)var6_12);
        bl = dialogDataModel.getBoolean("IDS_POSTESTIMATION_IID") != null ? dialogDataModel.getBoolean("IDS_POSTESTIMATION_IID") : true;
        stringBuffer.append(" IID=").append(bl != false ? "TRUE" : "FALSE");
        bl = dialogDataModel.getBoolean("IDS_POSTESTIMATION_BOFINGER_RADIO") != null ? dialogDataModel.getBoolean("IDS_POSTESTIMATION_BOFINGER_RADIO") : true;
        stringBuffer.append(" BANDWIDTH=").append(bl != false ? "BOFINGER" : "HALL_SHEATHER");
        String string5 = dialogDataModel.getString("IDS_NUMERIC_METHOD_TOLERANCE");
        stringBuffer.append(" TOL=").append(string5 != null && string5.length() > 0 ? string5 : "0.000000000001");
        String string6 = dialogDataModel.getString("IDS_NUMERIC_METHOD_CONVERGENCE");
        stringBuffer.append(" CONV=").append(string6 != null && string6.length() > 0 ? string6 : "0.000001");
        object2 = dialogDataModel.getString("IDS_NUMERIC_METHOD_MAXITERATION");
        stringBuffer.append(" MAXITER=").append((String)(object2 != null && ((String)object2).length() > 0 ? object2 : "2000"));
        String string7 = dialogDataModel.getString("IDS_QUANTILE_CONFIDENCE_INTERVAL");
        stringBuffer.append(" CILEVEL=").append(string7 != null && string7.length() > 0 ? string7 : "95");
    }

    private String generateModelSyntax(DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
        boolean bl = dialogDataModel.getBoolean("IDS_MODEL_MAINEFFECTS") != null ? dialogDataModel.getBoolean("IDS_MODEL_MAINEFFECTS") : true;
        boolean bl2 = objectArray != null && objectArray.length > 0;
        stringBuilder.append(SyntaxUtil.getSubCommand("/MODEL "));
        StringBuilder stringBuilder2 = new StringBuilder();
        if (!bl && bl2 || this.mWeightList.getModel().getSize() > 0) {
            if (objectArray != null && objectArray.length > 0) {
                for (Object object : objectArray) {
                    if (!QuantileRegressionDlg.existInTargetLists(object.toString(), this.mFactorsList.getModel(), this.mCovariatesList.getModel())) continue;
                    stringBuilder2.append(object).append(" ");
                }
                if (stringBuilder2.length() > 0) {
                    stringBuilder.append(stringBuilder2.toString());
                }
            }
            if (this.mWeightList.getModel().getSize() > 0) {
                stringBuilder.append("REGWGT=").append(this.mWeightList.getVariablesStringList());
                stringBuilder.append(" ");
            }
        }
        boolean bl3 = dialogDataModel.getBoolean("IDS_QUANTILE_INCLUDE_INTERCEPT") != null ? dialogDataModel.getBoolean("IDS_QUANTILE_INCLUDE_INTERCEPT") : true;
        stringBuilder.append("INTERCEPT=");
        stringBuilder.append(bl3 ? "TRUE" : "FALSE");
        return stringBuilder.toString();
    }

    static boolean existInTargetLists(String string, VarListModel varListModel, VarListModel varListModel2) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("\\*|\\(|\\)")) {
            if (varListModel.findElementIndexesByName(string2).length != 0 || varListModel2.findElementIndexesByName(string2).length != 0) continue;
            return false;
        }
        return true;
    }

    private String generateExportDlgSyntax(DialogDataModel dialogDataModel) {
        String string;
        String string2;
        boolean bl;
        boolean bl2;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = dialogDataModel.containsBooleanKey("IDS_QUANTILE_MATRIX_CHECK0") ? dialogDataModel.getBoolean("IDS_QUANTILE_MATRIX_CHECK0") : false;
        boolean bl4 = bl2 = dialogDataModel.containsBooleanKey("IDS_QUANTILE_MATRIX_CHECK1") ? dialogDataModel.getBoolean("IDS_QUANTILE_MATRIX_CHECK1") : false;
        if (bl3) {
            bl = dialogDataModel.containsBooleanKey("IDS_QUANTILE_DATASET_RADIO0") ? dialogDataModel.getBoolean("IDS_QUANTILE_DATASET_RADIO0") : true;
            string2 = dialogDataModel.getString("IDS_QUANTILE_DATASET_NAME0");
            string = CharacterUtil.smartQuote((String)dialogDataModel.getString("IDS_QUANTILE_DATAFILE_PATH0"));
            stringBuilder2.append("COVB=").append(bl ? string2 : string);
            stringBuilder2.append(" ");
        }
        if (bl2) {
            bl = dialogDataModel.containsBooleanKey("IDS_QUANTILE_DATASET_RADIO1") ? dialogDataModel.getBoolean("IDS_QUANTILE_DATASET_RADIO1") : true;
            string2 = dialogDataModel.getString("IDS_QUANTILE_DATASET_NAME1");
            string = CharacterUtil.smartQuote((String)dialogDataModel.getString("IDS_QUANTILE_DATAFILE_PATH1"));
            stringBuilder2.append("CORB=").append(bl ? string2 : string);
            stringBuilder2.append(" ");
        }
        if (bl3 || bl2) {
            bl = dialogDataModel.containsBooleanKey("IDS_QUANTILE_FILESAVE_SINGLE_CHECK") ? dialogDataModel.getBoolean("IDS_QUANTILE_FILESAVE_SINGLE_CHECK") : true;
            stringBuilder2.append("FILE_SEPARATE=").append(bl ? "FALSE" : "TRUE");
            stringBuilder2.append(" ");
        }
        boolean bl5 = bl = dialogDataModel.containsBooleanKey("IDS_QUANTILE_EXPORTMODEL_CHECK") ? dialogDataModel.getBoolean("IDS_QUANTILE_EXPORTMODEL_CHECK") : false;
        if (bl) {
            boolean bl6 = dialogDataModel.containsBooleanKey("IDS_QUANTILE_MODEL_RADIO") ? dialogDataModel.getBoolean("IDS_QUANTILE_MODEL_RADIO") : true;
            string = CharacterUtil.smartQuote((String)dialogDataModel.getString("IDS_QUANTILE_XMLFIlE_PATH"));
            stringBuilder2.append(bl6 ? "MODEL=" : "PARAMETER=");
            stringBuilder2.append(string);
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder.append("\n");
            stringBuilder.append(SyntaxUtil.getSubCommand("/OUTFILE "));
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        return stringBuilder.toString();
    }

    private void initVars() {
        this.mSrcVariableList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVariableList.loadFromActiveDataset();
        this.mSrcVariableList.setSelectedIndex(0);
        this.mTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mTargetList.setIdentifier("IDS_QUANTILE_TARGET");
        this.mTargetList.getModel().addListDataListener(this);
        this.mFactorsList = new TargetVariableList();
        this.mFactorsList.setIdentifier("IDS_QUANTILE_FACTORS");
        this.mFactorsList.addVarFilter(new SpssVarFilter(4, true, false));
        this.mFactorsList.getModel().addListDataListener(this);
        this.mCovariatesList = new TargetVariableList();
        this.mCovariatesList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mCovariatesList.setIdentifier("IDS_QUANTILE_COVARIATE");
        this.mCovariatesList.getModel().addListDataListener(this);
        this.mWeightList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mWeightList.setIdentifier("IDS_QUANTILE_WEIGHT");
        this.mWeightList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mWeightList.getModel().addListDataListener(this);
        this.mConserveCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_QUANTILE_REGRESSION_CONSERVE"));
        this.mTargetArrowButton = new ArrowButton();
        this.mFactorArrowButton = new ArrowButton();
        this.mCovariateArrowButton = new ArrowButton();
        this.mWeightArrowButton = new ArrowButton();
        this.setTabTraversal();
    }
}

