/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.quantile_reg;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class ExportSubDlg
extends BaseSubDialog
implements ActionListener,
ItemListener {
    private static int sLatestIdx = -1;
    private static String[] sDSNames = new String[2];
    private JCheckBox[] mMatrixChecks = new JCheckBox[2];
    private TitledBorder[] mDestinationPanelBorders = new TitledBorder[2];
    private JRadioButton[] mDatasetRadios = new JRadioButton[2];
    private JRadioButton[] mDataFileRadios = new JRadioButton[2];
    private SpssButtonGroup[] mDestButtonGroups = new SpssButtonGroup[2];
    private JLabel[] mDatasetNameLabels = new JLabel[2];
    private StringTextField[] mDatasetNames = new StringTextField[2];
    private FileTextField[] mDataFilePaths = new FileTextField[2];
    private JButton[] mDataFileButtons = new JButton[2];
    private JCheckBox mFileSaveSingleCheck;
    private JCheckBox mExportModelCheck;
    private FileTextField mXmlFilePath;
    private JButton mXMLFileButton;
    private JRadioButton mModelRadio;
    private JRadioButton mParamRadio;
    private SpssButtonGroup mModelParamGroup;

    ExportSubDlg(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, string, true);
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setDefaults();
        this.addListeners();
        this.setFocusTraversalPolicy();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_quantile_export";
    }

    @Override
    public boolean continuePressed() {
        return this.doValidate();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        int n = 0;
        for (StringTextField stringTextField : this.mDatasetNames) {
            String string = dialogDataModel.getString("IDS_QUANTILE_DATASET_NAME" + n);
            if (string == null) {
                string = sDSNames[n];
            }
            if (string == null || DatasetNameValidator.validateDatasetName((String)string, (Component)((Object)this)) == 0) {
                string = this.getUniqueDatasetname((short)n);
            }
            stringTextField.setText(string);
            ++n;
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        int n = 0;
        for (StringTextField stringTextField : this.mDatasetNames) {
            String string = stringTextField.getText();
            dialogDataModel.putString("IDS_QUANTILE_DATASET_NAME" + n, string);
            ++n;
        }
        return super.saveState(dialogDataModel);
    }

    private void initVars() {
        for (int i = 0; i < 2; ++i) {
            this.mMatrixChecks[i] = new JCheckBox(new ToggleButtonAction(this.mParentDlg, "IDS_QUANTILE_MATRIX_CHECK" + i));
            this.mDestinationPanelBorders[i] = new TitledBorder(this.getResString("IDS_QUANTILE_DESTINATION_TITLE"));
            this.mDatasetRadios[i] = new JRadioButton(new ToggleButtonAction((BaseDialog)this.mParentDlg, "IDS_QUANTILE_DATASET_RADIO", i));
            this.mDataFileRadios[i] = new JRadioButton(new ToggleButtonAction((BaseDialog)this.mParentDlg, "IDS_QUANTILE_DATAFILE_RADIO", i));
            this.mDestButtonGroups[i] = new SpssButtonGroup();
            this.mDestButtonGroups[i].add(this.mDatasetRadios[i]);
            this.mDestButtonGroups[i].add(this.mDataFileRadios[i]);
            this.mDatasetNames[i] = new StringTextField(20);
            this.mDatasetNames[i].setAction(new TextFieldAction(this.mParentDlg, "IDS_QUANTILE_DATASET_NAME" + i));
            this.mDatasetNameLabels[i] = DialogUtil.createLabel(this.mParentDlg, "IDS_QUANTILE_DATASET_LABEL", i);
            this.mDatasetNameLabels[i].setLabelFor((Component)((Object)this.mDatasetNames[i]));
            this.mDataFilePaths[i] = new FileTextField();
            this.mDataFilePaths[i].setEditable(false);
            this.mDataFilePaths[i].setOpaque(false);
            this.mDataFilePaths[i].setBorder(BorderFactory.createEmptyBorder());
            this.mDataFilePaths[i].setAction(new TextFieldAction(this.mParentDlg, "IDS_QUANTILE_DATAFILE_PATH" + i));
            this.mDataFileButtons[i] = DialogUtil.createButton(this.mParentDlg, "IDS_BROWSE", i, this);
        }
        this.mFileSaveSingleCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, "IDS_QUANTILE_FILESAVE_SINGLE_CHECK"));
        this.mExportModelCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, "IDS_QUANTILE_EXPORTMODEL_CHECK"));
        this.mXmlFilePath = new FileTextField();
        this.mXmlFilePath.setEditable(false);
        this.mXmlFilePath.setOpaque(false);
        this.mXmlFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mXmlFilePath.setAction(new TextFieldAction(this.mParentDlg, "IDS_QUANTILE_XMLFIlE_PATH"));
        this.mXMLFileButton = DialogUtil.createButton(this.mParentDlg, "IDS_BROWSE", 2, this);
        this.mModelRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_QUANTILE_MODEL_RADIO"));
        this.mParamRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_QUANTILE_PARAM_RADIO"));
        this.mModelParamGroup = new SpssButtonGroup();
        this.mModelParamGroup.add(this.mModelRadio);
        this.mModelParamGroup.add(this.mParamRadio);
    }

    private void addListeners() {
        for (int i = 0; i < 2; ++i) {
            this.mMatrixChecks[i].addItemListener(this);
            this.mDatasetRadios[i].addItemListener(this);
            this.mDataFileRadios[i].addItemListener(this);
        }
        this.mExportModelCheck.addItemListener(this);
    }

    private void setDefaults() {
        for (int i = 0; i < 2; ++i) {
            this.mMatrixChecks[i].setSelected(false);
            this.mDatasetRadios[i].setEnabled(false);
            this.mDataFileRadios[i].setEnabled(false);
            this.mDataFileButtons[i].setEnabled(false);
            this.mDataFilePaths[i].setEnabled(false);
            this.mDatasetNames[i].setEnabled(false);
            this.mDatasetNames[i].setOpaque(false);
            this.mDatasetNameLabels[i].setEnabled(false);
            DialogUtil.enableTitledBorder(this.mDestinationPanelBorders[i], false);
            this.mDatasetRadios[i].setSelected(true);
        }
        this.mFileSaveSingleCheck.setSelected(true);
        this.mFileSaveSingleCheck.setEnabled(false);
        this.mModelRadio.setSelected(true);
        this.mModelRadio.setEnabled(false);
        this.mParamRadio.setEnabled(false);
        this.mXMLFileButton.setEnabled(false);
        this.mXmlFilePath.setEnabled(false);
    }

    private String getUniqueDatasetname(short s) {
        String string = "QRDataset";
        String string2 = "";
        for (int i = 0; i < 100; ++i) {
            String string3 = string + ExportSubDlg.generateIdx();
            int n = DatasetNameValidator.validateDatasetName((String)string3, (Component)((Object)this));
            if (n == 0) continue;
            string2 = string3;
            ExportSubDlg.sDSNames[s] = string3;
            break;
        }
        return string2;
    }

    private static int generateIdx() {
        return ++sLatestIdx;
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 0.5;
        DialogUtil.addUsingGBL(jPanel, this.mMatrixChecks[0], gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMatrixChecks[1], gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel2 = this.createDestinationPanel(0);
        JPanel jPanel3 = this.createDestinationPanel(1);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets);
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 24;
        DialogUtil.addUsingGBL(jPanel, this.mFileSaveSingleCheck, gridBagConstraints, 0, 2, 2, 1, n, insets);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_QUANTILE_EXPORTASXML_TITLE")));
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel4, this.mExportModelCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel4, (JComponent)((Object)this.mXmlFilePath), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel4, this.mXMLFileButton, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel4, this.mModelRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel4, this.mParamRadio, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 3, 2, 1, n, insets);
    }

    private JPanel createDestinationPanel(int n) {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(this.mDestinationPanelBorders[n]);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mDatasetRadios[n], gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDataFileRadios[n], gridBagConstraints, 0, 2, 1, 1, n2, insets);
        Insets insets2 = (Insets)insets.clone();
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        jPanel2.add(this.mDatasetNameLabels[n]);
        jPanel2.add((Component)((Object)this.mDatasetNames[n]));
        insets2.left += 24;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDataFilePaths[n]), gridBagConstraints, 0, 3, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDataFileButtons[n], gridBagConstraints, 0, 4, 1, 1, n2, insets2);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMatrixChecks[0]);
        vector.add(this.mDestButtonGroups[0]);
        vector.add(this.mDatasetNames[0]);
        vector.add(this.mDataFileButtons[0]);
        vector.add(this.mMatrixChecks[1]);
        vector.add(this.mDestButtonGroups[1]);
        vector.add(this.mDatasetNames[1]);
        vector.add(this.mDataFileButtons[1]);
        vector.add(this.mFileSaveSingleCheck);
        vector.add(this.mExportModelCheck);
        vector.add(this.mXMLFileButton);
        vector.add(this.mModelParamGroup);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void enableDestinationGroup(int n) {
        boolean bl = this.mMatrixChecks[n].isSelected();
        this.mDatasetRadios[n].setEnabled(bl);
        this.mDataFileRadios[n].setEnabled(bl);
        this.mDataFileButtons[n].setEnabled(this.mDataFileRadios[n].isEnabled() && this.mDataFileRadios[n].isSelected());
        this.mDataFilePaths[n].setEnabled(this.mDataFileButtons[n].isEnabled());
        this.mDatasetNames[n].setEnabled(this.mDatasetRadios[n].isEnabled() && this.mDatasetRadios[n].isSelected());
        this.mDatasetNames[n].setOpaque(this.mDatasetNames[n].isEnabled());
        this.mDatasetNameLabels[n].setEnabled(this.mDatasetRadios[n].isEnabled() && this.mDatasetRadios[n].isSelected());
        DialogUtil.enableTitledBorder(this.mDestinationPanelBorders[n], bl);
        this.repaint();
    }

    private void showSaveDialog(int n) {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), true);
        if (n == 0 || n == 1) {
            remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_QUANTILE_SPSS_DATA_FILE_FILTER"), this.getResString("IDS_QUANTILE_SPSS_DATA_FILE_FILTER_EXTN")));
        } else {
            remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_QUANTILE_EXPORT_XML_FILE_FILTER"), this.getResString("IDS_QUANTILE_EXPORT_XML_FILE_FILTER_EXTN")));
        }
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n2 = remoteFileChooser.showSaveDialog((Component)((Object)this));
        if (n2 == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string = remoteFileChooser.getSelectedFilePath();
            if (n == 0 || n == 1) {
                if (!string.endsWith(this.getResString("IDS_QUANTILE_SPSS_DATA_FILE_FILTER_EXTN"))) {
                    string = string + this.getResString("IDS_QUANTILE_SPSS_DATA_FILE_FILTER_EXTN");
                }
                this.mDataFilePaths[n].setText(string);
            } else {
                if (!string.endsWith(this.getResString("IDS_QUANTILE_EXPORT_XML_FILE_FILTER_EXTN"))) {
                    string = string + this.getResString("IDS_QUANTILE_EXPORT_XML_FILE_FILTER_EXTN");
                }
                this.mXmlFilePath.setText(string);
            }
        }
    }

    private boolean doValidate() {
        String string;
        for (int i = 0; i < 2; ++i) {
            String string2;
            int n;
            if (!this.mMatrixChecks[i].isSelected()) continue;
            int n2 = n = i == 0 ? 1 : 0;
            if (this.mDatasetRadios[i].isSelected()) {
                string2 = this.mDatasetNames[i].getText();
                if (string2.trim().length() == 0) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_QUANTILE_EXPORT_SPECIFY_DATASET_MSG"), VersionInfo.getAppVersionString());
                    return false;
                }
                if (this.mDatasetNames[n].isEnabled() && string2.equals(this.mDatasetNames[n].getText())) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_QUANTILE_EXPORT_SAME_DATASET_MSG"), VersionInfo.getAppVersionString());
                    return false;
                }
                int n3 = DatasetNameValidator.validateDatasetName((String)string2, (Component)((Object)this));
                if (n3 != 0) continue;
                return false;
            }
            string2 = this.mDataFilePaths[i].getText();
            if (string2.trim().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_QUANTILE_EXPORT_SPECIFY_DATAFILE_MSG"), VersionInfo.getAppVersionString());
                return false;
            }
            if (!this.mDataFilePaths[n].isEnabled() || !string2.equals(this.mDataFilePaths[n].getText())) continue;
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_QUANTILE_EXPORT_SAME_DATAFILE_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        if (this.mExportModelCheck.isSelected() && (string = this.mXmlFilePath.getText()).trim().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_QUANTILE_EXPORT_SPECIFY_XMLFILE_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        Object object = itemEvent.getSource();
        if (object == this.mMatrixChecks[0] || object == this.mMatrixChecks[1]) {
            n = itemEvent.getSource() == this.mMatrixChecks[0] ? 0 : 1;
            this.enableDestinationGroup(n);
            this.mFileSaveSingleCheck.setEnabled(this.mMatrixChecks[0].isSelected() || this.mMatrixChecks[1].isSelected());
        }
        if (object == this.mExportModelCheck) {
            this.mXMLFileButton.setEnabled(this.mExportModelCheck.isSelected());
            this.mXmlFilePath.setEnabled(this.mXMLFileButton.isEnabled());
            this.mModelRadio.setEnabled(this.mExportModelCheck.isSelected());
            this.mParamRadio.setEnabled(this.mExportModelCheck.isSelected());
            this.repaint();
        }
        if (object == this.mDatasetRadios[0] || object == this.mDatasetRadios[1]) {
            n = itemEvent.getSource() == this.mDatasetRadios[0] ? 0 : 1;
            this.mDatasetNameLabels[n].setEnabled(this.mDatasetRadios[n].isSelected());
            this.mDatasetNames[n].setEnabled(this.mDatasetRadios[n].isSelected());
            this.mDatasetNames[n].setOpaque(this.mDatasetRadios[n].isSelected());
        }
        if (object == this.mDataFileRadios[0] || object == this.mDataFileRadios[1]) {
            n = itemEvent.getSource() == this.mDataFileRadios[0] ? 0 : 1;
            this.mDataFileButtons[n].setEnabled(this.mDataFileRadios[n].isSelected());
            this.mDataFilePaths[n].setEnabled(this.mDataFileRadios[n].isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mDataFileButtons[0] || actionEvent.getSource() == this.mDataFileButtons[1]) {
            int n = actionEvent.getSource() == this.mDataFileButtons[0] ? 0 : 1;
            this.showSaveDialog(n);
        }
        if (actionEvent.getSource() == this.mXMLFileButton) {
            this.showSaveDialog(2);
        }
    }
}

