/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.quantile_reg;

import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainListArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.common.AbstractModelSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.pro_stats.quantile_reg.QuantileRegressionDlg;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DisplaySubDlg
extends BaseSubDialog
implements ListDataListener,
DocumentListener,
ItemListener {
    private JCheckBox mPestimateCheck;
    private JCheckBox mCovmatrixCheck;
    private JCheckBox mCormatrixCheck;
    private JCheckBox mPlotCheck;
    private SpssButtonGroup mParamEstGroup;
    private JRadioButton mParamEstPartRadio;
    private JRadioButton mParamEstAllRadio;
    private IntTextField mPartEdit;
    private JLabel mPartEffectsLabel;
    private JCheckBox mObservedCheck;
    private JCheckBox mPredictModelCheck;
    private SpssButtonGroup mModelGroup;
    private JRadioButton mModelTopRadio;
    private JRadioButton mModelUserRadio;
    private IntTextField mTopEdit;
    private JLabel mTopEffectsLabel;
    private JLabel mPlotMaximumLabel1;
    private JLabel mPlotMaximumLabel2;
    private IntTextField mPlotMaximumEdit;
    private PlainList mModelEffectsSrcList;
    private JLabel mModelEffectsLabel;
    private PlainList mLinesTargetList;
    private JLabel mLinesTargetLabel;
    private PlainListArrowButton mLinesArrowButton;
    private PlainList mTablesTargetList;
    private JLabel mTablesTargetLabel;
    private PlainListArrowButton mTablesArrowButton;
    protected VarListModel mFactorsModel;
    protected VarListModel mCovModel;

    DisplaySubDlg(BaseProcedureDialog baseProcedureDialog, String string, VarListModel varListModel, VarListModel varListModel2) {
        super(baseProcedureDialog, string, true);
        this.mCovModel = varListModel2;
        this.mFactorsModel = varListModel;
        this.setDefaults();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_quantile_display";
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.addListeners();
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.mPestimateCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_QUANTILE_PESTIMATE"));
        this.mCovmatrixCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_QUANTILE_COVMATRIX"));
        this.mCormatrixCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_QUANTILE_CORMATRIX"));
        this.mPlotCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_QUANTILE_PLOTCHECK"));
        this.mParamEstAllRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_QUANTILE_PARAMEST_ALL"));
        this.mParamEstPartRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_QUANTILE_PARAMEST_PART"));
        this.mParamEstGroup = new SpssButtonGroup();
        this.mParamEstGroup.add(this.mParamEstAllRadio);
        this.mParamEstGroup.add(this.mParamEstPartRadio);
        this.mPartEdit = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mPartEdit.setAction((Action)new TextFieldAction(this, "IDS_QUANTILE_PART_EDIT"));
        this.mPartEdit.setColumns(4);
        this.mPartEdit.setAllowMinMax(true, false);
        this.mPartEffectsLabel = DialogUtil.createLabel(this, "IDS_QUANTILE_EFFECTS_LABEL", 1);
        this.mPartEffectsLabel.setLabelFor((Component)this.mPartEdit);
        this.mObservedCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_QUANTILE_OBSERVED"));
        this.mPredictModelCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_QUANTILE_PREDICTMODEL"));
        this.mModelTopRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_QUANTILE_MODEL_TOP"));
        this.mModelUserRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_QUANTILE_MODEL_USER"));
        this.mModelGroup = new SpssButtonGroup();
        this.mModelGroup.add(this.mModelTopRadio);
        this.mModelGroup.add(this.mModelUserRadio);
        this.mTopEdit = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mTopEdit.setAction((Action)new TextFieldAction(this, "IDS_QUANTILE_TOP_EDIT"));
        this.mTopEdit.setColumns(4);
        this.mTopEdit.setAllowMinMax(false, false);
        this.mTopEffectsLabel = DialogUtil.createLabel(this, "IDS_QUANTILE_EFFECTS_LABEL", 2);
        this.mTopEffectsLabel.setLabelFor((Component)this.mTopEdit);
        this.mPlotMaximumEdit = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mPlotMaximumEdit.setAction((Action)new TextFieldAction(this, "IDS_QUANTILE_MAXIMUM_EDIT"));
        this.mPlotMaximumEdit.setColumns(4);
        this.mPlotMaximumEdit.setAllowMinMax(true, false);
        this.mPlotMaximumLabel1 = DialogUtil.createLabel(this, "IDS_QUANTILE_PLOT_MAXIMUM1");
        this.mPlotMaximumLabel2 = DialogUtil.createLabel(this, "IDS_QUANTILE_PLOT_MAXIMUM2");
        this.mPlotMaximumLabel1.setLabelFor((Component)this.mPlotMaximumEdit);
        this.mPlotMaximumLabel1.getAccessibleContext().setAccessibleName(this.getResString("IDS_QUANTILE_PLOT_MAXIMUM1") + " " + this.getResString("IDS_QUANTILE_PLOT_MAXIMUM2"));
        this.mModelEffectsSrcList = new PlainList("QUANTILE_MODEL_EFFECTS_SRC_LIST_KEY", PlainList.DragType.eAutoDragCopy);
        this.mModelEffectsSrcList.setDataSource(true);
        this.mModelEffectsLabel = DialogUtil.createLabel(this, "IDS_QUANTILE_MODEL_EFFECTS_LABEL");
        this.mModelEffectsLabel.setLabelFor(this.mModelEffectsSrcList);
        this.mLinesTargetList = new PlainList("QUANTILE_LINES_TARGET_LIST_KEY", PlainList.DragType.eAutoDragCopy);
        this.mLinesTargetList.getModel().addListDataListener(this);
        this.mLinesTargetLabel = DialogUtil.createLabel(this, "IDS_QUANTILE_LINES_LABEL");
        this.mLinesTargetLabel.setLabelFor(this.mLinesTargetList);
        this.mLinesTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mLinesTargetList.getFixedCellHeight() * 5 + 2));
        this.mLinesArrowButton = new PlainListArrowButton();
        this.mLinesArrowButton.registerVariableList(this.mModelEffectsSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mLinesArrowButton.registerVariableList(this.mLinesTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mTablesTargetList = new PlainList("QUANTILE_TABLES_TARGET_LIST_KEY", PlainList.DragType.eAutoDragCopy);
        this.mTablesTargetList.getModel().addListDataListener(this);
        this.mTablesTargetLabel = DialogUtil.createLabel(this, "IDS_QUANTILE_TABLES_LABEL");
        this.mTablesTargetLabel.setLabelFor(this.mTablesTargetList);
        this.mTablesTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTablesTargetList.getFixedCellHeight() * 5 + 2));
        this.mTablesArrowButton = new PlainListArrowButton();
        this.mTablesArrowButton.registerVariableList(this.mModelEffectsSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mTablesArrowButton.registerVariableList(this.mTablesTargetList, SpssArrowButton.ButtonOrientation.left);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        DefaultListModel defaultListModel;
        Object e;
        int n;
        Object object2;
        int n2;
        int n3;
        super.loadState(dialogDataModel);
        DefaultListModel defaultListModel2 = (DefaultListModel)this.mModelEffectsSrcList.getModel();
        defaultListModel2.removeAllElements();
        Object[] objectArray = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            Object[] objectArray2 = objectArray;
            n3 = objectArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object2 = objectArray2[n2];
                if (!QuantileRegressionDlg.existInTargetLists(object2.toString(), this.mFactorsModel, this.mCovModel)) continue;
                arrayList.add(object2);
            }
        }
        boolean bl = arrayList.size() > 0;
        int n4 = n3 = dialogDataModel.getBoolean("IDS_MODEL_MAINEFFECTS") != null ? (int)(dialogDataModel.getBoolean("IDS_MODEL_MAINEFFECTS").booleanValue() ? 1 : 0) : 1;
        if (n3 == 0 && bl) {
            for (Object object2 : arrayList) {
                if (!this.canFilterThrough(object2.toString())) continue;
                defaultListModel2.addElement(object2);
            }
        } else {
            for (n2 = 0; n2 < this.mFactorsModel.getSize(); ++n2) {
                object2 = this.mFactorsModel.getElementAt(n2);
                if (defaultListModel2.contains(object2.getName())) continue;
                defaultListModel2.addElement(object2.getName());
            }
            for (n2 = 0; n2 < this.mCovModel.getSize(); ++n2) {
                object2 = this.mCovModel.getElementAt(n2);
                if (defaultListModel2.contains(object2.getName())) continue;
                defaultListModel2.addElement(object2.getName());
            }
        }
        DefaultListModel defaultListModel3 = (DefaultListModel)this.mLinesTargetList.getModel();
        object2 = (DefaultListModel)this.mTablesTargetList.getModel();
        for (n = defaultListModel3.getSize() - 1; n >= 0; --n) {
            e = defaultListModel3.getElementAt(n);
            defaultListModel = (DefaultListModel)this.mModelEffectsSrcList.getModel();
            if (defaultListModel.contains(e)) continue;
            defaultListModel3.remove(n);
        }
        for (n = ((DefaultListModel)object2).getSize() - 1; n >= 0; --n) {
            e = ((DefaultListModel)object2).getElementAt(n);
            defaultListModel = (DefaultListModel)this.mModelEffectsSrcList.getModel();
            if (defaultListModel.contains(e)) continue;
            ((DefaultListModel)object2).remove(n);
        }
        if (defaultListModel2.getSize() > 0) {
            this.mModelEffectsSrcList.setSelectedIndex(0);
        }
    }

    static String generateDisplaySyntax(DialogDataModel dialogDataModel, VarListModel varListModel, VarListModel varListModel2) {
        Object object;
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append(SyntaxUtil.getSubCommand("/PRINT "));
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl2 = dialogDataModel.containsBooleanKey("IDS_QUANTILE_PESTIMATE") ? dialogDataModel.getBoolean("IDS_QUANTILE_PESTIMATE") : true;
        boolean bl3 = dialogDataModel.containsBooleanKey("IDS_QUANTILE_COVMATRIX") ? dialogDataModel.getBoolean("IDS_QUANTILE_COVMATRIX") : false;
        boolean bl4 = dialogDataModel.containsBooleanKey("IDS_QUANTILE_CORMATRIX") ? dialogDataModel.getBoolean("IDS_QUANTILE_CORMATRIX") : false;
        stringBuilder2.append(bl2 ? "PARAMETER " : "");
        stringBuilder2.append(bl3 ? "COVB " : "");
        stringBuilder2.append(bl4 ? "CORB " : "");
        stringBuilder2.trimToSize();
        if (stringBuilder2.length() == 0) {
            stringBuilder2.append("NONE");
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("\n");
        boolean bl5 = dialogDataModel.containsBooleanKey("IDS_QUANTILE_PLOTCHECK") ? dialogDataModel.getBoolean("IDS_QUANTILE_PLOTCHECK") : true;
        stringBuilder.append(SyntaxUtil.getSubCommand("/PLOT "));
        stringBuilder2.setLength(0);
        String string = "";
        if (bl5) {
            bl = dialogDataModel.containsBooleanKey("IDS_QUANTILE_PARAMEST_PART") ? dialogDataModel.getBoolean("IDS_QUANTILE_PARAMEST_PART") : true;
            String string2 = dialogDataModel.getString("IDS_QUANTILE_PART_EDIT") != null ? dialogDataModel.getString("IDS_QUANTILE_PART_EDIT") : "50";
            string = bl ? string2 : "ALL";
            stringBuilder2.append("PARAM_EST=").append(string);
        }
        bl = dialogDataModel.containsBooleanKey("IDS_QUANTILE_OBSERVED") ? dialogDataModel.getBoolean("IDS_QUANTILE_OBSERVED") : false;
        boolean bl6 = dialogDataModel.containsBooleanKey("IDS_QUANTILE_PREDICTMODEL") ? dialogDataModel.getBoolean("IDS_QUANTILE_PREDICTMODEL") : true;
        String string3 = dialogDataModel.getString("IDS_QUANTILE_MAXIMUM_EDIT") != null ? dialogDataModel.getString("IDS_QUANTILE_MAXIMUM_EDIT") : "10";
        stringBuilder2.append(" PREDICTED_BY_OBSERVED=").append(bl ? "TRUE" : "FALSE");
        if (bl6) {
            stringBuilder2.append(" MAX_CATEGORIES=").append(string3);
        }
        if (stringBuilder2.length() == 0) {
            stringBuilder2.append("NONE");
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        boolean bl7 = dialogDataModel.containsBooleanKey("IDS_QUANTILE_MODEL_TOP") ? dialogDataModel.getBoolean("IDS_QUANTILE_MODEL_TOP") : true;
        String string4 = dialogDataModel.getString("IDS_QUANTILE_TOP_EDIT") != null ? dialogDataModel.getString("IDS_QUANTILE_TOP_EDIT") : "3";
        string = bl6 && bl7 ? string4 : "0";
        stringBuilder.append("\n");
        stringBuilder.append(SyntaxUtil.getSubCommand("/PREDICT_EFFECTS "));
        stringBuilder.append("NUM_TOP_EFFECTS=").append(string);
        Object[] objectArray = dialogDataModel.getArray("QUANTILE_LINES_TARGET_LIST_KEY");
        stringBuilder2.setLength(0);
        if (bl6 && !bl7 && objectArray.length > 0) {
            for (Object object2 : objectArray) {
                if (!QuantileRegressionDlg.existInTargetLists(object2.toString(), varListModel, varListModel2)) continue;
                stringBuilder2.append(object2).append(" ");
            }
            object = stringBuilder2.toString().trim();
            if (((String)object).length() > 0) {
                stringBuilder.append("\n");
                stringBuilder.append(SyntaxUtil.getSubCommand("/PREDICTION_LINES "));
                stringBuilder.append((String)object);
            }
        }
        stringBuilder2.setLength(0);
        object = dialogDataModel.getArray("QUANTILE_TABLES_TARGET_LIST_KEY");
        if (bl6 && !bl7 && ((Object[])object).length > 0) {
            for (Object object3 : object) {
                if (!QuantileRegressionDlg.existInTargetLists(object3.toString(), varListModel, varListModel2)) continue;
                stringBuilder2.append(object3).append(" ");
            }
            String string5 = stringBuilder2.toString().trim();
            if (string5.length() > 0) {
                stringBuilder.append("\n");
                stringBuilder.append(SyntaxUtil.getSubCommand("/PREDICTION_TABLES "));
                stringBuilder.append(string5);
            }
        }
        return stringBuilder.toString();
    }

    private boolean canFilterThrough(String string) {
        boolean bl = false;
        boolean bl2 = string.indexOf(40) > -1;
        String[] stringArray = string.split("\\*|\\(|\\)");
        int n = 0;
        int n2 = 0;
        String string2 = stringArray[0];
        boolean bl3 = true;
        for (String string3 : stringArray) {
            if (!string2.equals(string3)) {
                bl3 = false;
            }
            if (this.mFactorsModel.findElementIndexesByName(string3).length > 0) {
                n = (short)(n + 1);
            }
            if (this.mCovModel.findElementIndexesByName(string3).length <= 0) continue;
            n2 = (short)(n2 + 1);
        }
        if (n == 1 && n2 == 0 || n == 2 && n2 == 0 || n2 == 1 && (n == 1 || n == 2)) {
            bl = true;
        }
        if (!bl2 && bl3 && n == 0 && n2 > 0) {
            bl = true;
        }
        return bl;
    }

    private void setDefaults() {
        this.mPestimateCheck.setSelected(true);
        this.mCovmatrixCheck.setSelected(false);
        this.mCormatrixCheck.setSelected(false);
        this.mPlotCheck.setSelected(true);
        this.mParamEstPartRadio.setSelected(true);
        this.mObservedCheck.setSelected(false);
        this.mPredictModelCheck.setSelected(true);
        this.mModelTopRadio.setSelected(true);
        this.mPartEdit.setText("50");
        this.mTopEdit.setText("3");
        this.mPartEdit.setEnabled(true);
        this.mTopEdit.setEnabled(true);
        this.mPlotMaximumEdit.setText("10");
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.createPrintPanel();
        JPanel jPanel3 = this.createPlotTabulatePanel();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel createListsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        JScrollPane jScrollPane = new JScrollPane(this.mModelEffectsSrcList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(new Dimension(250, 200));
        jScrollPane.setMinimumSize(new Dimension(250, 100));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        int n = 16;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 3, n, insets);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets3 = new Insets(0, insets2.left, 0, insets2.right);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLinesArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mTablesArrowButton, gridBagConstraints, 1, 3, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        n = 16;
        Insets insets4 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mModelEffectsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets4);
        DialogUtil.addUsingGBL(jPanel, this.mLinesTargetLabel, gridBagConstraints, 2, 0, 1, 1, n, insets4);
        DialogUtil.addUsingGBL(jPanel, this.mTablesTargetLabel, gridBagConstraints, 2, 2, 1, 1, n, insets4);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.weightx = 0.5;
        JScrollPane jScrollPane2 = new JScrollPane(this.mLinesTargetList);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setPreferredSize(new Dimension(250, 180));
        jScrollPane2.setMinimumSize(new Dimension(250, 180));
        n = 18;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, insets);
        JScrollPane jScrollPane3 = new JScrollPane(this.mTablesTargetList);
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(20);
        jScrollPane3.setPreferredSize(new Dimension(250, 180));
        jScrollPane3.setMinimumSize(new Dimension(250, 180));
        n = 18;
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 3, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createPrintPanel() {
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_QUANTILE_PRINT_TITLE")));
        jPanel.add(this.mPestimateCheck);
        jPanel.add(Box.createVerticalStrut(3));
        jPanel.add(this.mCovmatrixCheck);
        jPanel.add(Box.createVerticalStrut(3));
        jPanel.add(this.mCormatrixCheck);
        jPanel.add(Box.createVerticalStrut(3));
        return jPanel;
    }

    private JPanel createPlotTabulatePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_QUANTILE_PLOT_TABULATE_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 18;
        DialogUtil.addUsingGBL(jPanel, this.mPlotCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 15;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(3));
        jPanel2.add(this.mParamEstPartRadio);
        jPanel2.add((Component)this.mPartEdit);
        jPanel2.add(this.mPartEffectsLabel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(3));
        jPanel3.add(this.mModelTopRadio);
        jPanel3.add((Component)this.mTopEdit);
        jPanel3.add(this.mTopEffectsLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        insets2.left += 5;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mParamEstAllRadio, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mObservedCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPredictModelCheck, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mModelUserRadio, gridBagConstraints, 0, 6, 1, 1, n, insets2);
        JPanel jPanel4 = this.createListsPanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets2.left += 10;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 7, 1, 1, n, insets2);
        JPanel jPanel5 = new JPanel(new FlowLayout(3));
        jPanel5.add(this.mPlotMaximumLabel1);
        jPanel5.add((Component)this.mPlotMaximumEdit);
        jPanel5.add(this.mPlotMaximumLabel2);
        n = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 8, 1, 1, n, insets2);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPestimateCheck);
        vector.add(this.mCovmatrixCheck);
        vector.add(this.mCormatrixCheck);
        vector.add(this.mPlotCheck);
        vector.add(this.mParamEstGroup);
        vector.add(this.mObservedCheck);
        vector.add(this.mPredictModelCheck);
        vector.add(this.mModelGroup);
        vector.add(this.mModelEffectsSrcList);
        vector.add(this.mLinesArrowButton);
        vector.add(this.mTablesArrowButton);
        vector.add(this.mLinesTargetList);
        vector.add(this.mTablesTargetList);
        vector.add(this.mPlotMaximumEdit);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mModelEffectsSrcList.getModel()) {
            this.mLinesArrowButton.setEnabled(false);
        }
        if (listDataEvent.getSource() == this.mTablesTargetList.getModel()) {
            this.mTablesArrowButton.setEnabled(false);
        }
        this.enableContinueButton();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mLinesTargetList.getModel()) {
            this.mLinesArrowButton.setEnabled(true);
        }
        if (listDataEvent.getSource() == this.mTablesTargetList.getModel()) {
            this.mTablesArrowButton.setEnabled(true);
        }
        this.enableContinueButton();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mPlotCheck || object == this.mParamEstPartRadio || object == this.mParamEstAllRadio) {
            boolean bl = this.mPlotCheck.isSelected();
            this.mParamEstPartRadio.setEnabled(bl);
            this.mParamEstAllRadio.setEnabled(bl);
            this.mPartEdit.setEnabled(bl && this.mParamEstPartRadio.isSelected());
            this.mPartEffectsLabel.setEnabled(bl);
        } else if (object == this.mPredictModelCheck || object == this.mModelUserRadio || object == this.mModelTopRadio) {
            boolean bl = this.mPredictModelCheck.isSelected();
            this.onModelUserRadio(bl && this.mModelUserRadio.isSelected());
            this.mModelTopRadio.setEnabled(bl);
            this.mModelUserRadio.setEnabled(bl);
            this.mTopEdit.setEnabled(bl && this.mModelTopRadio.isSelected());
            this.mTopEffectsLabel.setEnabled(bl);
            this.mPlotMaximumLabel1.setEnabled(bl);
            this.mPlotMaximumLabel2.setEnabled(bl);
            this.mPlotMaximumEdit.setEnabled(bl);
            this.mPlotMaximumEdit.setEditable(bl);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    private void onModelUserRadio(boolean bl) {
        this.mModelEffectsSrcList.setEnabled(bl);
        this.mModelEffectsLabel.setEnabled(bl);
        this.mLinesArrowButton.setEnabled(bl);
        this.mTablesArrowButton.setEnabled(bl);
        this.mLinesTargetLabel.setEnabled(bl);
        this.mLinesTargetList.setEnabled(bl);
        this.mTablesTargetList.setEnabled(bl);
        this.mTablesTargetLabel.setEnabled(bl);
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(this.mModelEffectsSrcList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mModelEffectsSrcList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mModelEffectsSrcList, this.mPlainListVarMoveHandler));
        plainListDragAdapter = new PlainListDragAdapter(this.mLinesTargetList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mLinesTargetList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mLinesTargetList, this.mPlainListVarMoveHandler));
        plainListDragAdapter = new PlainListDragAdapter(this.mTablesTargetList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mTablesTargetList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mTablesTargetList, this.mPlainListVarMoveHandler));
    }

    private void addListeners() {
        this.mPlotCheck.addItemListener(this);
        this.mPredictModelCheck.addItemListener(this);
        this.mParamEstPartRadio.addItemListener(this);
        this.mParamEstAllRadio.addItemListener(this);
        this.mModelUserRadio.addItemListener(this);
        this.mModelTopRadio.addItemListener(this);
        this.mPartEdit.getDocument().addDocumentListener(this);
        this.mTopEdit.getDocument().addDocumentListener(this);
        this.mPlotMaximumEdit.getDocument().addDocumentListener(this);
    }

    private void enableContinueButton() {
        boolean bl = true;
        if (this.mPlotCheck.isSelected() && this.mParamEstPartRadio.isSelected() && this.mPartEdit.getText().trim().length() == 0) {
            bl = false;
        }
        if (this.mPredictModelCheck.isSelected() && this.mModelTopRadio.isSelected() && this.mTopEdit.getText().trim().length() == 0) {
            bl = false;
        }
        if (this.mPlotMaximumEdit.getText().trim().length() == 0) {
            bl = false;
        }
        this.enableContinue(bl);
    }
}

