/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.quantile_reg;

import com.spss.java_client.ui.controls.ACREvent;
import com.spss.java_client.ui.controls.ACRWidget;
import com.spss.java_client.ui.controls.IACRListener;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CriteriaSubDlg
extends BaseSubDialog
implements DocumentListener,
IACRListener {
    private FloatTextField mQuantilesField;
    private QuantileWidget mACRWidget;
    private SpssButtonGroup mEstimationRadioGroup;
    private JRadioButton mAutoRadio;
    private JRadioButton mSimplexRadio;
    private JRadioButton mInteriorPointRadio;
    private FloatTextField mToleranceField;
    private FloatTextField mConvergenceField;
    private IntTextField mMaxIterationField;
    private JCheckBox mIidCheck;
    private SpssButtonGroup mBandwidthRadioGroup;
    private JRadioButton mBofingerRadio;
    private JRadioButton mHallSheatherRadio;
    private SpssButtonGroup mMissingRadioGroup;
    private JRadioButton mExcludeRadio;
    private JRadioButton mIncludeRadio;
    private FloatTextField mIntervalField;

    CriteriaSubDlg(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, string, true);
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setDefaults();
        this.addListeners();
        this.setFocusTraversalPolicy();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_quantile_criteria";
    }

    private void initVars() {
        this.mQuantilesField = new FloatTextField(0.0, 1.0, 4, true);
        this.mQuantilesField.setColumns(10);
        this.mQuantilesField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_QUANTILE_VALUES_FIELD"));
        this.mACRWidget = new QuantileWidget((JTextField)this.mQuantilesField);
        this.mAutoRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_ESTIMATION_AUTO_RADIO"));
        this.mSimplexRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_ESTIMATION_SIMPLEX_RADIO"));
        this.mInteriorPointRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_ESTIMATION_INTERIOR_POINT_RADIO"));
        this.mEstimationRadioGroup = new SpssButtonGroup();
        this.mEstimationRadioGroup.add(this.mAutoRadio);
        this.mEstimationRadioGroup.add(this.mSimplexRadio);
        this.mEstimationRadioGroup.add(this.mInteriorPointRadio);
        this.mIidCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, "IDS_POSTESTIMATION_IID"));
        this.mBofingerRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_POSTESTIMATION_BOFINGER_RADIO"));
        this.mHallSheatherRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_POSTESTIMATION_HALLSHEATHER_RADIO"));
        this.mBandwidthRadioGroup = new SpssButtonGroup();
        this.mBandwidthRadioGroup.add(this.mBofingerRadio);
        this.mBandwidthRadioGroup.add(this.mHallSheatherRadio);
        this.mToleranceField = new FloatTextField(0.0, 0.001, 3, true);
        this.mToleranceField.setIncludeMinRange(false);
        this.mToleranceField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_NUMERIC_METHOD_TOLERANCE"));
        this.mToleranceField.setColumns(6);
        this.mConvergenceField = new FloatTextField(0.0, 0.001, 3, true);
        this.mConvergenceField.setIncludeMinRange(false);
        this.mConvergenceField.setIncludeMaxRange(true);
        this.mConvergenceField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_NUMERIC_METHOD_CONVERGENCE"));
        this.mConvergenceField.setColumns(6);
        this.mMaxIterationField = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mMaxIterationField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_NUMERIC_METHOD_MAXITERATION"));
        this.mMaxIterationField.setColumns(6);
        this.mExcludeRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_MISSING_EXCLUDE"));
        this.mIncludeRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_MISSING_INCLUDE"));
        this.mMissingRadioGroup = new SpssButtonGroup();
        this.mMissingRadioGroup.add(this.mExcludeRadio);
        this.mMissingRadioGroup.add(this.mIncludeRadio);
        this.mIntervalField = new FloatTextField(0.0, 100.0, 3, true);
        this.mIntervalField.setIncludeMinRange(false);
        this.mIntervalField.setIncludeMaxRange(false);
        this.mIntervalField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_QUANTILE_CONFIDENCE_INTERVAL"));
    }

    private void addListeners() {
        this.mQuantilesField.getDocument().addDocumentListener(this);
        this.mToleranceField.getDocument().addDocumentListener(this);
        this.mConvergenceField.getDocument().addDocumentListener(this);
        this.mMaxIterationField.getDocument().addDocumentListener(this);
        this.mIntervalField.getDocument().addDocumentListener(this);
    }

    private void setDefaults() {
        this.mQuantilesField.setText("");
        ((DefaultListModel)this.mACRWidget.getList().getModel()).removeAllElements();
        ((DefaultListModel)this.mACRWidget.getList().getModel()).add(0, "0.5");
        this.mAutoRadio.setSelected(true);
        this.mIidCheck.setSelected(true);
        this.mBofingerRadio.setSelected(true);
        this.mToleranceField.setText("0.000000000001");
        this.mConvergenceField.setText("0.000001");
        this.mIntervalField.setText("95");
        this.mExcludeRadio.setSelected(true);
        this.mMaxIterationField.setText("2000");
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n / 2, 0, n / 2, 0);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = 23;
        JPanel jPanel2 = this.createQuantilePanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        JPanel jPanel3 = this.createEstimationPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        JPanel jPanel4 = this.createPostestimationPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        JPanel jPanel5 = this.createNumericMethodPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        JPanel jPanel6 = this.createMissingPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel6, gridBagConstraints, 0, 2, 2, 1, n2, insets);
        JPanel jPanel7 = new JPanel(new FlowLayout(3, 20, 0));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_QUANTILE_INTEVAL_LABEL");
        jPanel7.add(jLabel);
        jPanel7.add((Component)this.mIntervalField);
        DialogUtil.addUsingGBL(jPanel, jPanel7, gridBagConstraints, 0, 3, 2, 1, n2, insets);
    }

    private JPanel createQuantilePanel() {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_QUANTILE_VALUES_TITLE")));
        this.mQuantilesField.setPreferredSize(new Dimension(100, 26));
        this.mQuantilesField.setMinimumSize(new Dimension(70, 26));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_QUANTILE_VALUES_LABEL");
        jLabel.setLabelFor((Component)this.mQuantilesField);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mQuantilesField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(insets.top, 20, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mACRWidget, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        this.mACRWidget.addACRListener(this);
        this.addListDataListenerToACRList();
        return jPanel;
    }

    private JPanel createEstimationPanel() {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ESTIMATION_TITLE")));
        DialogUtil.addUsingGBL(jPanel, this.mAutoRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSimplexRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mInteriorPointRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createPostestimationPanel() {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_POSTESTIMATION_TITLE")));
        DialogUtil.addUsingGBL(jPanel, this.mIidCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 10, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_BANDWIDTH_TITLE")));
        jPanel2.add(this.mBofingerRadio);
        jPanel2.add(this.mHallSheatherRadio);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createNumericMethodPanel() {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        this.mToleranceField.setPreferredSize(new Dimension(100, 26));
        this.mToleranceField.setMinimumSize(new Dimension(70, 26));
        this.mConvergenceField.setPreferredSize(new Dimension(100, 26));
        this.mConvergenceField.setMinimumSize(new Dimension(70, 26));
        this.mMaxIterationField.setPreferredSize(new Dimension(100, 26));
        this.mMaxIterationField.setMinimumSize(new Dimension(70, 26));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_QUANTILE_NUMERICAL_TITLE")));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_QUANTILE_TOLERANCE_LABEL");
        jLabel.setLabelFor((Component)this.mToleranceField);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        jLabel = DialogUtil.createLabel(this, "IDS_QUANTILE_CONVERGENCE_LABEL");
        jLabel.setLabelFor((Component)this.mConvergenceField);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jLabel = DialogUtil.createLabel(this, "IDS_QUANTILE_ITERATION_LABEL");
        jLabel.setLabelFor((Component)this.mMaxIterationField);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mToleranceField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConvergenceField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterationField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createMissingPanel() {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_QUANTILE_MISSING_TITLE")));
        DialogUtil.addUsingGBL(jPanel, this.mExcludeRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeRadio, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void addListDataListenerToACRList() {
        this.mACRWidget.getList().getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                if (listDataEvent.getSource() instanceof DefaultListModel) {
                    DefaultListModel defaultListModel = (DefaultListModel)listDataEvent.getSource();
                    defaultListModel.removeListDataListener(this);
                    Object[] objectArray = defaultListModel.toArray();
                    float[] fArray = new float[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        fArray[i] = Float.parseFloat((String)objectArray[i]);
                    }
                    Arrays.sort(fArray);
                    defaultListModel.removeAllElements();
                    for (float f : fArray) {
                        defaultListModel.addElement(Float.toString(f));
                    }
                    defaultListModel.addListDataListener(this);
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        });
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mQuantilesField);
        Component[] componentArray = new Component[3];
        for (n = 0; n < this.mACRWidget.getComponentCount() - 1; ++n) {
            componentArray[n] = this.mACRWidget.getComponent(n);
        }
        vector.add(componentArray[0]);
        vector.add(componentArray[1]);
        vector.add(componentArray[2]);
        vector.add(this.mACRWidget.getList());
        vector.add(this.mEstimationRadioGroup);
        vector.add(this.mIidCheck);
        vector.add(this.mBandwidthRadioGroup);
        vector.add(this.mToleranceField);
        vector.add(this.mConvergenceField);
        vector.add(this.mMaxIterationField);
        vector.add(this.mMissingRadioGroup);
        vector.add(this.mIntervalField);
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private boolean canEnableContinue() {
        return this.mToleranceField.getText().length() > 0 && this.mIntervalField.getText().length() > 0 && this.mConvergenceField.getText().length() > 0 && this.mMaxIterationField.getText().length() > 0 && this.mACRWidget.getList().getModel().getSize() > 0;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void listChanged(ACREvent aCREvent) {
        this.canEnableContinue();
    }

    class QuantileWidget
    extends ACRWidget {
        public QuantileWidget(JTextField jTextField) {
            super(jTextField);
        }

        @Override
        public boolean isDuplicate(String string) {
            boolean bl = false;
            if (!this.mAllowDuplicates) {
                for (int i = 0; i < this.mItemList.getModel().getSize(); ++i) {
                    Object e = this.mItemList.getModel().getElementAt(i);
                    if (!Float.valueOf(e.toString()).equals(Float.valueOf(string))) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }
    }
}

