/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.probit;

import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.pro_stats.probit.ProbitAnalysisDlg;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormatSymbols;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ProbitAnalysisOptions
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    public static final String FREQUENCIES_KEY = "IDS_PROBIT_FREQUECIES";
    public static final String REL_MEDIAN_KEY = "IDS_PROBIT_MEDIAN";
    public static final String PARALLELISM_KEY = "IDS_PROBIT_PARALLELISM";
    public static final String FIDUCIAL_KEY = "IDS_PROBIT_FIDUCIAL";
    public static final String CAL_FRM_DATA_KEY = "IDS_PROBIT_CAL_DATA";
    public static final String VALUE_KEY = "IDS_PROBIT_VALUE";
    public static final String VALUE_TEXT_KEY = "IDS_PA_VALUE_TEXT";
    public static final String MAX_ITERATION_KEY = "IDS_PA_MAX_ITR";
    public static final String STEP_LIMIT_KEY = "IDS_PA_STEP_LIM";
    public static final String OPTIMALITY_KEY = "IDS_PA_OPT_TOL";
    public static final String SIGNIFICANCE_KEY = "IDS_PA_SIGNIFICANCE";
    public static String[] STEP_LIMIT_COMBO = new String[]{"1", ".1", ".01", ".001    "};
    private static final String MAX_ITERATION_VALUE = "20";
    private static final String SIGNIFICANCE_VALUE = ".15";
    private JCheckBox mFrequencyCheck;
    private JCheckBox mRelativeMedianCheck;
    private JCheckBox mParallelismCheck;
    private JCheckBox mFiducialCheck;
    private JRadioButton mNoneRadio;
    private JRadioButton mCalculateRadio;
    private JRadioButton mValueRadio;
    private IntTextField mMaxIterationField;
    private FloatTextField mValueField;
    private FloatTextField mSignificanceField;
    private JLabel mSignificanceLabel;
    private JComboBox mOptimalityCombo;
    private JComboBox mStepLimitCombo;
    private SpssButtonGroup mGrpStatistics;
    private SpssButtonGroup mGrpNaturalResponse;

    public ProbitAnalysisOptions(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_5440";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateContinueButton();
        this.mValueField.setEnabled(this.mValueRadio.isSelected());
        this.mValueField.setOpaque(this.mValueRadio.isSelected());
        this.mSignificanceLabel.setEnabled(this.mFiducialCheck.isSelected() && ((ProbitAnalysisDlg)this.mParentDlg).isCovariateHasOneElement());
        this.mSignificanceField.setEnabled(this.mFiducialCheck.isSelected() && ((ProbitAnalysisDlg)this.mParentDlg).isCovariateHasOneElement());
        this.mSignificanceField.setOpaque(this.mFiducialCheck.isSelected() && ((ProbitAnalysisDlg)this.mParentDlg).isCovariateHasOneElement());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setUpUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpStatisticsPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setUpNatrualResponsePanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setUpCriteriaPanel(), gridBagConstraints, 0, 2, 1, 1, n, null);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mFrequencyCheck);
        vector.add(this.mRelativeMedianCheck);
        vector.add(this.mParallelismCheck);
        vector.add(this.mFiducialCheck);
        vector.add(this.mSignificanceField);
        vector.add(this.mGrpNaturalResponse);
        vector.add(this.mValueField);
        vector.add(this.mMaxIterationField);
        vector.add(this.mStepLimitCombo);
        vector.add(this.mOptimalityCombo);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void updateContinueButton() {
        boolean bl = true;
        boolean bl2 = true;
        if (this.mValueRadio.isSelected()) {
            boolean bl3 = bl = this.mValueField.getText().length() > 0;
        }
        if (this.mFiducialCheck.isSelected()) {
            bl2 = this.mSignificanceField.getText().length() > 0;
        }
        this.enableContinue(this.mMaxIterationField.getText().length() > 0 && bl && bl2);
    }

    private JPanel setUpStatisticsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PROBIT_STATISTICS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mFrequencyCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRelativeMedianCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mParallelismCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mFiducialCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap() + 2, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mSignificanceLabel, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap() + 2, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSignificanceField, gridBagConstraints, 1, 4, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setUpNatrualResponsePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PROBIT_NATURAL_RESPONSE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mNoneRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCalculateRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mValueRadio, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Insets insets2 = new Insets(insets.top + 3, DialogUtil.getComponentGroupGap() - 5, insets.bottom, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValueField, gridBagConstraints, 3, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setUpCriteriaPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PROBIT_CRITERIA")));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PROBIT_MAX_ITERATIONS");
        jLabel.setLabelFor((Component)this.mMaxIterationField);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PROBIT_STEP_LIMIT");
        jLabel2.setLabelFor(this.mStepLimitCombo);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_PROBIT_OPTIMALITY");
        jLabel3.setLabelFor(this.mOptimalityCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = 23;
        Insets insets = new Insets(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.set(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterationField, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        insets.set(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        insets.set(n, n, 0, 0);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mStepLimitCombo, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        insets.set(n, n, n, n);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n, n, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.mOptimalityCombo, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        return jPanel;
    }

    private void setDefaults() {
        this.mFrequencyCheck.setSelected(true);
        this.mRelativeMedianCheck.setEnabled(((ProbitAnalysisDlg)this.mParentDlg).isCovariateHasOneElement() && ((ProbitAnalysisDlg)this.mParentDlg).isFactorHasElement());
        this.mFiducialCheck.setEnabled(((ProbitAnalysisDlg)this.mParentDlg).isCovariateHasOneElement());
        this.mSignificanceField.setEnabled(false);
        this.mSignificanceLabel.setEnabled(((ProbitAnalysisDlg)this.mParentDlg).isCovariateHasOneElement());
        this.mParallelismCheck.setEnabled(((ProbitAnalysisDlg)this.mParentDlg).isFactorHasElement());
        this.mRelativeMedianCheck.setSelected(true);
        this.mFiducialCheck.setSelected(true);
        this.mNoneRadio.setSelected(true);
        this.mValueField.setEnabled(false);
        this.mValueField.setOpaque(false);
        this.mOptimalityCombo.setSelectedIndex(0);
        this.mStepLimitCombo.setSelectedIndex(1);
        this.mMaxIterationField.setText(MAX_ITERATION_VALUE);
        this.mSignificanceField.setText(SIGNIFICANCE_VALUE);
        this.enableContinue(true);
    }

    private void initVars() {
        this.mFrequencyCheck = new JCheckBox(new ToggleButtonAction(this, FREQUENCIES_KEY));
        this.mRelativeMedianCheck = new JCheckBox(new ToggleButtonAction(this, REL_MEDIAN_KEY));
        this.mParallelismCheck = new JCheckBox(new ToggleButtonAction(this, PARALLELISM_KEY));
        this.mFiducialCheck = new JCheckBox(new ToggleButtonAction(this, FIDUCIAL_KEY));
        this.mNoneRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_PROBIT_NONE"));
        this.mCalculateRadio = new JRadioButton(new ToggleButtonAction(this, CAL_FRM_DATA_KEY));
        this.mValueRadio = new JRadioButton(new ToggleButtonAction(this, VALUE_KEY));
        this.mMaxIterationField = new IntTextField(1, 999, true);
        this.mMaxIterationField.setColumns(4);
        this.mSignificanceField = new FloatTextField(0.0, 1.0, 3, true);
        this.mValueField = new FloatTextField(1.0E-4, 0.9999, 4, true);
        this.mSignificanceField.setColumns(4);
        this.mValueField.setColumns(5);
        this.mValueField.setDocument((Document)new FixedLengthNumericDocument(5, true, true));
        this.mSignificanceLabel = DialogUtil.createLabel(this, "IDS_PROBIT_SIGNIFICANCE");
        this.mSignificanceLabel.setLabelFor((Component)this.mSignificanceField);
        this.mOptimalityCombo = new JComboBox<String>(this.getResStringArray("IDS_PROBIT_OPT_TOLERANCE_VALUES"));
        this.mOptimalityCombo.setAction(new ComboboxAction(this.mParentDlg, OPTIMALITY_KEY));
        Vector<String> vector = new Vector<String>();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
        String string = null;
        String[] stringArray = STEP_LIMIT_COMBO;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            string = string2 = stringArray[i];
            if (decimalFormatSymbols.getDecimalSeparator() != '.') {
                string = string2.replace('.', decimalFormatSymbols.getDecimalSeparator());
            }
            vector.add(string);
        }
        this.mStepLimitCombo = new JComboBox(vector);
        this.mOptimalityCombo.setMaximumRowCount(17);
        this.mGrpStatistics = new SpssButtonGroup();
        this.mGrpStatistics.add(this.mFrequencyCheck);
        this.mGrpStatistics.add(this.mRelativeMedianCheck);
        this.mGrpStatistics.add(this.mParallelismCheck);
        this.mGrpStatistics.add(this.mFiducialCheck);
        this.mGrpNaturalResponse = new SpssButtonGroup();
        this.mGrpNaturalResponse.add(this.mValueRadio);
        this.mGrpNaturalResponse.add(this.mNoneRadio);
        this.mGrpNaturalResponse.add(this.mCalculateRadio);
        this.mStepLimitCombo.setAction(new ComboboxAction(this.mParentDlg, STEP_LIMIT_KEY));
        this.mValueField.setAction((Action)new TextFieldAction(this.mParentDlg, VALUE_TEXT_KEY));
        this.mMaxIterationField.setAction((Action)new TextFieldAction(this.mParentDlg, MAX_ITERATION_KEY));
        this.mSignificanceField.setAction((Action)new TextFieldAction(this.mParentDlg, SIGNIFICANCE_KEY));
        this.mValueField.getDocument().addDocumentListener(this);
        this.mSignificanceField.getDocument().addDocumentListener(this);
        this.mMaxIterationField.getDocument().addDocumentListener(this);
        this.mValueRadio.addItemListener(this);
        this.mFiducialCheck.addItemListener(this);
        this.mCalculateRadio.addItemListener(this);
    }
}

