/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.probit;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.CustomVarListModel;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SpssVarFormatter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.AnalyzeDefineRange;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.pro_stats.probit.ProbitAnalysisOptions;
import com.spss.java_client.ui.dialogs.pro_stats.res.ProStatsResBundle;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ProbitAnalysisDlg
extends BaseProcedureDialog
implements ListDataListener,
ActionListener {
    private static final String TARGET_RES_FREQ_VAR_LIST_KEY = "IDS_PROBIT_RES_FREQ_KEY";
    private static final String TARGET_TOTAL_VAR_LIST_KEY = "IDS_PROBIT_TOTAL_KEY";
    private static final String TARGET_FACTOR_VAR_LIST_KEY = "IDS_PROBIT_FACTOR_KEY";
    private static final String TARGET_COV_VAR_LIST_KEY = "IDS_PROBIT_COV_KEY";
    private static final String TRANSFORM_COMBO_KEY = "IDS_PROBIT_TRANS_VALUE";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mResFreqTargetVarList;
    private TargetVariableList mTotalTargetVarList;
    private TargetVariableList mFactorTargetVarList;
    private TargetVariableList mCovariateTargetVarList;
    private ArrowButton mFactorArrowButton;
    private ArrowButton mResFreqArrowButton;
    private ArrowButton mTotalArrowButton;
    private ArrowButton mCovariateArrowButton;
    private JComboBox mTransformComboBox;
    private SpssButtonGroup mModelGroup;
    private JRadioButton mProbitRadioButton;
    private JButton mDefineButton;
    private FactorSpssVarFormatter mFactorFormatter;

    public ProbitAnalysisDlg(JFrame jFrame) {
        super(jFrame, false, ProStatsResBundle.getDefaultResourceBundleName(), ProStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_PROBIT_ANALYSIS"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prob";
    }

    @Override
    public String generateSyntax() {
        int n;
        Object object;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string = "";
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("PROBIT"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResFreqTargetVarList.getModel().getElementAt(0).getName()));
        stringBuffer.append(" OF ").append(this.mTotalTargetVarList.getModel().getElementAt(0).getName());
        if (this.mFactorTargetVarList.getModel().getSize() == 1) {
            String string2 = dialogDataModel.getString("IDS_DEFINE_RANGE_MINIMUM");
            object = dialogDataModel.getString("IDS_DEFINE_RANGE_MAXIMUM");
            stringBuffer.append(" BY ").append(this.mFactorTargetVarList.getModel().getElementAt(0).getName()).append("(").append(string2).append(" ").append((String)object).append(")");
        }
        for (n = 0; n < this.mCovariateTargetVarList.getModel().getSize(); ++n) {
            string = string + " " + this.mCovariateTargetVarList.getModel().getElementAt(n).getName();
        }
        stringBuffer.append(" WITH").append(string);
        n = dialogDataModel.getInteger(TRANSFORM_COMBO_KEY);
        object = ProbitAnalysisDlg.getTransformMap();
        String string3 = (String)object.get(n);
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/LOG"));
        stringBuffer.append(string3);
        stringBuffer.append("\n");
        if (this.mProbitRadioButton.isSelected()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/MODEL PROBIT"));
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/MODEL LOGIT"));
        }
        Vector<String> vector = new Vector<String>();
        Boolean bl = dialogDataModel.getBoolean("IDS_PROBIT_FREQUECIES");
        if (bl == null || bl.booleanValue()) {
            vector.add("FREQ");
        }
        if (((bl = dialogDataModel.getBoolean("IDS_PROBIT_FIDUCIAL")) == null || bl.booleanValue()) && this.isCovariateHasOneElement()) {
            vector.add("CI");
        }
        if (((bl = dialogDataModel.getBoolean("IDS_PROBIT_MEDIAN")) == null || bl.booleanValue()) && this.isCovariateHasOneElement() && this.isFactorHasElement()) {
            vector.add("RMP");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_PROBIT_PARALLELISM")) != null && bl.booleanValue() && this.isFactorHasElement()) {
            vector.add("PARALLEL");
        }
        string = "";
        for (n = 0; n < vector.size(); ++n) {
            string = string + " " + (String)vector.get(n);
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT"));
        if (vector.size() > 0) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(" NONE");
        }
        bl = dialogDataModel.getBoolean("IDS_PROBIT_CAL_DATA");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/NATRES"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_PROBIT_VALUE")) != null && bl.booleanValue()) {
            string = dialogDataModel.getString("IDS_PA_VALUE_TEXT");
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/NATRES="));
            stringBuffer.append(string);
        }
        vector.removeAllElements();
        String string4 = "0.15";
        bl = dialogDataModel.getBoolean("IDS_PROBIT_FIDUCIAL");
        if ((bl == null || bl.booleanValue()) && this.isCovariateHasOneElement()) {
            if (dialogDataModel.getString("IDS_PA_SIGNIFICANCE") != null) {
                string4 = dialogDataModel.getString("IDS_PA_SIGNIFICANCE");
            }
            vector.add("P(" + string4 + ")");
        }
        String string5 = "20";
        if (dialogDataModel.getString("IDS_PA_MAX_ITR") != null) {
            string5 = dialogDataModel.getString("IDS_PA_MAX_ITR");
        }
        vector.add("ITERATE(" + string5 + ")");
        Integer n2 = 1;
        if (dialogDataModel.getInteger("IDS_PA_STEP_LIM") != null) {
            n2 = dialogDataModel.getInteger("IDS_PA_STEP_LIM");
        }
        String[] stringArray = ProbitAnalysisOptions.STEP_LIMIT_COMBO;
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
        String string6 = stringArray[n2].trim();
        if (string6.indexOf(decimalFormatSymbols.getDecimalSeparator()) != -1) {
            string6 = string6.replace(decimalFormatSymbols.getDecimalSeparator(), '.');
        }
        vector.add("STEPLIMIT(" + string6 + ")");
        n2 = dialogDataModel.getInteger("IDS_PA_OPT_TOL");
        if (dialogDataModel.getInteger("IDS_PA_OPT_TOL") != null && n2 > 0) {
            stringArray = this.getResStringArray("IDS_PROBIT_OPT_TOLERANCE_VALUES");
            vector.add("OPTOLERANCE(" + stringArray[n2] + ")");
        }
        string = "";
        for (n = 0; n < vector.size(); ++n) {
            string = string + " " + (String)vector.get(n);
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA"));
        stringBuffer.append(string);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_regression_probit";
    }

    @Override
    public void reset() {
        super.reset();
        this.mCovariateTargetVarList.removeAll();
        this.mFactorTargetVarList.removeAll();
        this.mResFreqTargetVarList.removeAll();
        this.mTotalTargetVarList.removeAll();
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.setEnabledDefineRange();
        this.updateOKPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateOKPaste();
        this.setEnabledDefineRange();
        if (listDataEvent.getSource().equals(this.mFactorTargetVarList.getModel())) {
            this.resetFactorRange();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.setEnabledDefineRange();
        this.updateOKPaste();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.runSubDialog(new AnalyzeDefineRange(this, this.getResString("IDS_PROBIT_DEFINE_RANGE"), "idh_5430", -999, 9999, false, false, false));
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (AnalyzeDefineRange.isContinueButtonPressed) {
            this.setFactorRange(dialogDataModel.getString("IDS_DEFINE_RANGE_MINIMUM"), dialogDataModel.getString("IDS_DEFINE_RANGE_MAXIMUM"));
        }
    }

    public boolean isCovariateHasOneElement() {
        return this.mCovariateTargetVarList.getModel().getSize() <= 1;
    }

    public boolean isFactorHasElement() {
        return this.mFactorTargetVarList.getModel().getSize() == 1;
    }

    public void setFactorRange(String string, String string2) {
        if (string != null && string2 != null) {
            String string3 = "(" + string + " " + string2 + ")";
            ((FactorListModel)this.mFactorTargetVarList.getModel()).setElementPropertyAt(0, string3);
        }
        this.enableOkPaste(this.mResFreqTargetVarList.getModel().getSize() == 1 && this.mTotalTargetVarList.getModel().getSize() == 1 && this.mCovariateTargetVarList.getModel().getSize() >= 1 && this.isFactorContainsRange());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupComponents(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mFactorFormatter.setVarMap(this.getDialogDataModel().getMap(this.mFactorTargetVarList.getIdentifier()));
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putMap(this.mFactorTargetVarList.getIdentifier(), this.mFactorFormatter.getVarMapForSerialization());
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProbitAnalysisDlg.this.runOptionsSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Component component;
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mResFreqArrowButton);
        vector.add(this.mTotalArrowButton);
        vector.add(this.mFactorArrowButton);
        vector.add(this.mCovariateArrowButton);
        vector.add(this.mResFreqTargetVarList);
        vector.add(this.mTotalTargetVarList);
        vector.add(this.mFactorTargetVarList);
        vector.add(this.mDefineButton);
        vector.add(this.mCovariateTargetVarList);
        vector.add(this.mTransformComboBox);
        vector.add(this.mModelGroup);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        n2 = this.mCmdButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            component = this.mCmdButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private static Map<Integer, String> getTransformMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, " NONE");
        hashMap.put(1, " 10");
        hashMap.put(2, "");
        return hashMap;
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new ProbitAnalysisOptions(this, this.getResString("IDS_PROBIT_OPT_TITLE"), true));
    }

    private void updateOKPaste() {
        this.enableOkPaste(this.mResFreqTargetVarList.getModel().getSize() == 1 && this.mTotalTargetVarList.getModel().getSize() == 1 && this.mCovariateTargetVarList.getModel().getSize() >= 1 && this.isFactorContainsRange());
    }

    private void setEnabledDefineRange() {
        this.mDefineButton.setEnabled(this.mFactorTargetVarList.getModel().getSize() == 1);
    }

    private void resetFactorRange() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putString("IDS_DEFINE_RANGE_MINIMUM", null);
        dialogDataModel.putString("IDS_DEFINE_RANGE_MAXIMUM", null);
    }

    private boolean isFactorContainsRange() {
        if (this.mFactorTargetVarList.getModel().getSize() == 1) {
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            String string = dialogDataModel.getString("IDS_DEFINE_RANGE_MAXIMUM");
            String string2 = dialogDataModel.getString("IDS_DEFINE_RANGE_MAXIMUM");
            if (string == null && string2 == null) {
                return false;
            }
        }
        return true;
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.enableOkPaste(false);
        this.mProbitRadioButton.setSelected(true);
        this.mTransformComboBox.setSelectedIndex(0);
        this.mDefineButton.setEnabled(false);
    }

    private void setupComponents(JPanel jPanel) {
        JScrollPane jScrollPane = new JScrollPane(this.mResFreqTargetVarList);
        jScrollPane.setPreferredSize(this.mResFreqTargetVarList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        JScrollPane jScrollPane2 = new JScrollPane(this.mTotalTargetVarList);
        jScrollPane2.setPreferredSize(this.mTotalTargetVarList.getMinimumSize());
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        JScrollPane jScrollPane3 = new JScrollPane(this.mFactorTargetVarList);
        jScrollPane3.setPreferredSize(this.mFactorTargetVarList.getMinimumSize());
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(21);
        JScrollPane jScrollPane4 = new JScrollPane(this.mSrcVarList);
        jScrollPane4.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PROBIT_RES_FREQ");
        jLabel.setLabelFor(this.mResFreqTargetVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PROBIT_TOTAL");
        jLabel2.setLabelFor(this.mTotalTargetVarList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_PROBIT_FACTOR");
        jLabel3.setLabelFor(this.mFactorTargetVarList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_PROBIT_SOURCE_LABEL");
        jLabel4.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 0, 1, 1, 7, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        Insets insets2 = new Insets(0, DialogUtil.getArrowButtonInsets().left + 3, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mResFreqArrowButton, gridBagConstraints, 1, 0, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets.set(0, 0, 0, n2 + 9);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap() + 13);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        insets2 = new Insets(0, DialogUtil.getArrowButtonInsets().left + 3, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mTotalArrowButton, gridBagConstraints, 1, 2, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets.set(n2, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets);
        insets.set(0, 0, 0, n2 + 13);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        insets2 = new Insets(0, DialogUtil.getArrowButtonInsets().left + 3, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mFactorArrowButton, gridBagConstraints, 1, 4, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 4, 1, 1, n, insets);
        insets.set(0, 0, 0, n2 + 13);
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 5, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        insets.set(n2 - 2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDefineButton, gridBagConstraints, 2, 6, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        insets.set(n2, 5, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpCovariatePanel(), gridBagConstraints, 1, 7, 2, 1, n, insets);
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpModelPanel(), gridBagConstraints, 0, 8, 1, 1, n, insets);
    }

    private JPanel setUpCovariatePanel() {
        JScrollPane jScrollPane = new JScrollPane(this.mCovariateTargetVarList);
        Dimension dimension = this.mCovariateTargetVarList.getMinimumSize();
        dimension.height += 30;
        dimension.width += 20;
        jScrollPane.setPreferredSize(dimension);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PROBIT_TRANSFORM");
        jLabel.setLabelFor(this.mTransformComboBox);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PROBIT_COVARIATE");
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(" ");
        jLabel2.setOpaque(true);
        jLabel2.setFont(titledBorder.getTitleFont());
        jLabel2.setForeground(titledBorder.getTitleColor());
        jLabel2.setLabelFor(this.mCovariateTargetVarList);
        JPanel jPanel2 = new JPanel();
        jPanel.setBorder(titledBorder);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 10;
        Insets insets = new Insets(0, 5, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mCovariateArrowButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        Insets insets2 = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap() + 9);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 0, 2, 1, n, insets2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mTransformComboBox, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        jPanel2.add((Component)jPanel, "North");
        insets2.set(0, 8, 0, 0);
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, jPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
        return jPanel3;
    }

    private JPanel setUpModelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PROBIT_MODEL")));
        JRadioButton jRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_PROBIT_LOGIT"));
        this.mModelGroup.add(this.mProbitRadioButton);
        this.mModelGroup.add(jRadioButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mProbitRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mResFreqTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mResFreqTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mResFreqTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTotalTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTotalTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTotalTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mFactorTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mFactorTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFactorTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mCovariateTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mCovariateTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mResFreqArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mResFreqArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mResFreqArrowButton.registerVariableList(this.mResFreqTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTotalArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTotalArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTotalArrowButton.registerVariableList(this.mTotalTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mFactorArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFactorArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFactorArrowButton.registerVariableList(this.mFactorTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mCovariateArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCovariateArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCovariateArrowButton.registerVariableList(this.mCovariateTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mProbitRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_PROBIT_PROBIT"));
        this.mTransformComboBox = new JComboBox<String>(this.getResStringArray("IDS_PROBIT_MODEL_VALUES"));
        this.mTransformComboBox.setAction(new ComboboxAction(this, TRANSFORM_COMBO_KEY));
        this.mModelGroup = new SpssButtonGroup();
        this.mDefineButton = new JButton(new ToggleButtonAction(this, "IDS_PROBIT_DEFINE"));
        this.mDefineButton.addActionListener(this);
        this.mResFreqTargetVarList.getModel().addListDataListener(this);
        this.mTotalTargetVarList.getModel().addListDataListener(this);
        this.mCovariateTargetVarList.getModel().addListDataListener(this);
        this.mResFreqTargetVarList.setIdentifier(TARGET_RES_FREQ_VAR_LIST_KEY);
        this.mTotalTargetVarList.setIdentifier(TARGET_TOTAL_VAR_LIST_KEY);
        this.mFactorTargetVarList.setIdentifier(TARGET_FACTOR_VAR_LIST_KEY);
        this.mCovariateTargetVarList.setIdentifier(TARGET_COV_VAR_LIST_KEY);
        this.mFactorFormatter = new FactorSpssVarFormatter(this.mFactorTargetVarList);
        this.mFactorTargetVarList.setModel(new FactorListModel(this.mFactorFormatter));
        this.mFactorTargetVarList.setCellRenderer(new CustomVarListCellRenderer(this.mFactorFormatter));
        this.mFactorTargetVarList.getModel().addListDataListener(this);
    }

    private class FactorSpssVarFormatter
    extends SpssVarFormatter {
        public FactorSpssVarFormatter(TargetVariableList targetVariableList) {
            super(targetVariableList);
        }

        @Override
        public String getDisplayText(ISpssVariable iSpssVariable) {
            return iSpssVariable.getName() + this.getVarMap().get(iSpssVariable.getId().asInt());
        }
    }

    private class FactorListModel
    extends CustomVarListModel {
        public FactorListModel(SpssVarFormatter spssVarFormatter) {
            super(spssVarFormatter);
        }

        @Override
        public boolean insertElementAt(ISpssVariable iSpssVariable, int n) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "(? ?)");
            return super.insertElementAt(iSpssVariable, n);
        }

        @Override
        public boolean addElement(ISpssVariable iSpssVariable) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "(? ?)");
            return super.addElement(iSpssVariable);
        }

        public void setElementPropertyAt(int n, String string) {
            if (n < 0 || n >= this.mVariables.size()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            ISpssVariable iSpssVariable = this.getElementAt(n);
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), string);
            this.fireContentsChanged(iSpssVariable, n, n);
        }

        @Override
        public void fireContentsChanged(Object object, int n, int n2) {
            super.fireContentsChanged(object, n, n2);
        }
    }
}

