/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.RemoteFileStatus;
import com.spss.java_client.core.comp_util.RemoteFileSysUtil;
import com.spss.java_client.ui.controls.BasicACREvent;
import com.spss.java_client.ui.controls.BasicACRWidget;
import com.spss.java_client.ui.controls.IBasicACRListener;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.WidgetListNumericCellRenderer;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.NonlinearRegressionDlg;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.NonlinearRegressionUtil;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.RegressionConstraint;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.RegressionParam;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NonlinearRegressionParameters
extends BaseSubDialog
implements DocumentListener,
IBasicACRListener {
    static final String NONLINEAR_PARAM_NAME_EDIT_KEY = "IDS_NONLINEAR_PARAM_NAME_EDIT";
    static final String NONLINEAR_PARAM_PARAM_LIST_KEY = "IDS_NONLINEAR_PARAM_PARAM_LIST";
    static final String NONLINEAR_PARAM_VALUE_EDIT_KEY = "IDS_NONLINEAR_PARAM_VALUE_EDIT";
    static final String NONLINEAR_PARAM_USE_START_VALUE_PREV_ANA_CHECK_KEY = "IDS_NONLINEAR_PARAM_USE_START_VALUE_PREV_ANA_CHECK";
    private BasicACRWidget mParamACRWidget;
    private StringTextField mNameEdit;
    private FloatTextField mValueEdit;
    private JCheckBox mUseStartCheck;
    private boolean mIsContinueEnabled = false;
    private Vector<Object> mComponentsVector;

    public NonlinearRegressionParameters(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_NONLINEAR_PARAM_TITLE"), true);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_NLRE_PAR";
    }

    @Override
    public boolean continuePressed() {
        boolean bl = super.continuePressed();
        if (bl) {
            Object object;
            Object[] objectArray;
            if (this.mParamACRWidget.isAddEnabled() && this.mParamACRWidget.isChangeEnabled() ? 0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), ResUtil.getCommonDlgString("ERR_ACR_CONTINUE_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) : (this.mParamACRWidget.isChangeEnabled() ? 0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_NONLINEAR_PARAM_CHANGES_PENDING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) : this.mParamACRWidget.isAddEnabled() && 0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), (String)(objectArray = ((ResourceBundle)(object = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()))).getString("ERR_DEFINE_SETS_ERR_MESSAGE_PENDING_OPERATIONS_WILL_BE_LOST")), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION))) {
                return false;
            }
            object = (DefaultListModel)((NonlinearRegressionDlg)this.mParentDlg).getParamList().getModel();
            ((DefaultListModel)object).clear();
            for (Object object2 : objectArray = this.mParamACRWidget.getListItems()) {
                ((DefaultListModel)object).addElement(object2);
            }
        }
        return bl;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.doTextChange(documentEvent.getDocument());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.doTextChange(documentEvent.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.doTextChange(documentEvent.getDocument());
    }

    @Override
    public void acrEventOccured(BasicACREvent basicACREvent) {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        Object object2;
        String string;
        Object object3;
        BasicACREvent.EventType eventType = basicACREvent.getEventType();
        if (eventType == BasicACREvent.EventType.addButtonPress) {
            object3 = this.mNameEdit.getText();
            string = this.mValueEdit.getText();
            if (((String)object3).length() > 0 && string.length() > 0 && this.isNotAVarName((String)object3)) {
                object2 = new RegressionParam((String)object3, string);
                n4 = this.mParamACRWidget.getListItemCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    object = this.mParamACRWidget.getListItemAt(n3);
                    if (this.mParamACRWidget.getAllowDuplicates() || !((RegressionParam)object2).equals(object)) continue;
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_NONLINEAR_DUPLICATE_NAME"), VersionInfo.getAppVersionString());
                    this.mNameEdit.requestFocus();
                    this.mNameEdit.selectAll();
                    return;
                }
                this.mParamACRWidget.clearItemListSelection();
                this.mParamACRWidget.addListItemAt(n4, object2);
                this.mParamACRWidget.setAddEnabled(false);
                this.mParamACRWidget.setChangeEnabled(false);
                this.mNameEdit.setText("");
                this.mValueEdit.setText("");
                this.mIsContinueEnabled = true;
                this.enableContinue(true);
                this.mNameEdit.requestFocus();
            }
        }
        if (eventType == BasicACREvent.EventType.changeButtonPress && (n2 = this.mParamACRWidget.getListSelectedIndex()) > -1) {
            string = this.mNameEdit.getText();
            object2 = this.mValueEdit.getText();
            if (string.length() > 0 && ((String)object2).length() > 0 && this.isNotAVarName(string)) {
                object = new RegressionParam(string, (String)object2);
                n4 = this.mParamACRWidget.getListItemCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    Object object4 = this.mParamACRWidget.getListItemAt(n3);
                    if (this.mParamACRWidget.getAllowDuplicates() || !((RegressionParam)object).equals(object4) || n3 == this.mParamACRWidget.getListSelectedIndex()) continue;
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_NONLINEAR_DUPLICATE_NAME"), VersionInfo.getAppVersionString());
                    this.mNameEdit.requestFocus();
                    this.mNameEdit.selectAll();
                    return;
                }
                this.mParamACRWidget.removeListItemAt(n2);
                this.mParamACRWidget.addListItemAt(n2, object);
                this.mParamACRWidget.setAddEnabled(false);
                this.mParamACRWidget.setChangeEnabled(false);
                this.mNameEdit.setText("");
                this.mValueEdit.setText("");
            }
        }
        if (eventType == BasicACREvent.EventType.removeButtonPress && (n = this.mParamACRWidget.getListSelectedIndex()) > -1) {
            this.removeParameter(n);
            this.mNameEdit.requestFocus();
        }
        if (eventType == BasicACREvent.EventType.listSelectionValueChange) {
            object3 = (ListSelectionEvent)basicACREvent.getEvent();
            if (((ListSelectionEvent)object3).getValueIsAdjusting()) {
                return;
            }
            int n5 = this.mParamACRWidget.getListSelectedIndex();
            this.mParamACRWidget.setRemoveEnabled(n5 > -1);
            this.mNameEdit.getDocument().removeDocumentListener(this);
            this.mValueEdit.getDocument().removeDocumentListener(this);
            if (n5 > -1) {
                object2 = (RegressionParam)this.mParamACRWidget.getListItemAt(n5);
                this.mNameEdit.setText(((RegressionParam)object2).getParamName());
                this.mValueEdit.setText(((RegressionParam)object2).getParamValue());
            } else {
                this.mNameEdit.setText("");
                this.mValueEdit.setText("");
            }
            this.mNameEdit.getDocument().addDocumentListener(this);
            this.mValueEdit.getDocument().addDocumentListener(this);
        }
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (dialogDataModel.getBoolean("ENABLE_CONTINUE") == null) {
            this.enableContinue(false);
        }
        this.mNameEdit.setText("");
        this.mValueEdit.setText("");
        this.checkUseStartEnable();
    }

    private void checkUseStartEnable() {
        String string = ((NonlinearRegressionDlg)this.mParentDlg).getOutfileLocation();
        RemoteFileSysUtil remoteFileSysUtil = RemoteFileSysUtil.getRemoteFileSysUtil();
        RemoteFileStatus remoteFileStatus = remoteFileSysUtil.validateFile(string);
        if (!remoteFileStatus.errorOccurred() && remoteFileStatus.getFileStatus() != RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST) {
            this.mUseStartCheck.setEnabled(true);
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        Object[] objectArray;
        boolean bl = super.saveState(dialogDataModel);
        if (bl && (objectArray = this.mParamACRWidget.getListItems()) != null && objectArray.length > 0 && objectArray[0] instanceof SerializableObject) {
            SerializableObject[] serializableObjectArray = new SerializableObject[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                serializableObjectArray[i] = (SerializableObject)objectArray[i];
            }
            dialogDataModel.putSerializableArray("IDS_NON_LINEAR_PARAMS", serializableObjectArray);
        }
        dialogDataModel.putBoolean("ENABLE_CONTINUE", this.mIsContinueEnabled);
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_NONLINEAR_PARAM_NAME_COLON");
        jLabel.setLabelFor((Component)((Object)this.mNameEdit));
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_NONLINEAR_PARAM_VALUE_COLON");
        jLabel2.setLabelFor((Component)this.mValueEdit);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNameEdit), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValueEdit, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets2 = DialogUtil.getStandardControlInsets();
        insets2.left = 0;
        DialogUtil.addUsingGBL(jPanel, this.mParamACRWidget, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mUseStartCheck, gridBagConstraints, 0, 3, 2, 1, n, insets);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    private void removeParameter(int n) {
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        String string = ((RegressionParam)this.mParamACRWidget.getListItemAt(n)).getParamName();
        String string2 = dialogDataModel.getString("IDS_NONLINEAR_LOSS_EXPRESSION_TEXT");
        boolean bl = false;
        if (string2 != null && string2.length() > 0) {
            bl = NonlinearRegressionUtil.checkContainsParam(string2, string);
        }
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("IDS_NONLINEAR_PARAM_CONSTRAINT_LIST");
        ArrayList<RegressionConstraint> arrayList = new ArrayList<RegressionConstraint>();
        boolean bl2 = false;
        if (serializableObjectArray != null && serializableObjectArray.length > 0) {
            for (SerializableObject serializableObject : serializableObjectArray) {
                RegressionConstraint regressionConstraint = (RegressionConstraint)serializableObject;
                if (regressionConstraint.getConstraint().indexOf(string) != -1) {
                    bl2 = true;
                    continue;
                }
                arrayList.add(regressionConstraint);
            }
        }
        if (bl && 0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_NONLINEAR_PARAM_DELETE_LOSS_OPTION"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
            return;
        }
        if (bl2 && 0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_NONLINEAR_PARAM_DELETE_CONS_OPTION"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
            return;
        }
        if (bl) {
            dialogDataModel.putString("IDS_NONLINEAR_LOSS_EXPRESSION_TEXT", "");
        }
        if (bl2) {
            dialogDataModel.putSerializableArray("IDS_NONLINEAR_PARAM_CONSTRAINT_LIST", arrayList.toArray(new SerializableObject[arrayList.size()]));
        }
        this.mParamACRWidget.removeListItemAt(n);
    }

    private void doTextChange(Document document) {
        boolean bl = this.mNameEdit.getText().length() > 0;
        boolean bl2 = this.mValueEdit.getText().length() > 0;
        boolean bl3 = this.mParamACRWidget.getListSelectedIndex() > -1;
        boolean bl4 = true;
        if (document == this.mValueEdit.getDocument()) {
            if (bl3) {
                this.mParamACRWidget.setChangeEnabled(bl && bl2 && bl3);
            } else {
                this.mParamACRWidget.setChangeEnabled(bl && bl2 && bl3);
                this.mParamACRWidget.setAddEnabled(bl && bl2);
            }
        }
        if (document == this.mNameEdit.getDocument()) {
            this.mParamACRWidget.setChangeEnabled(bl && bl2 && bl3);
            if (this.mParamACRWidget.getListItemCount() > 0) {
                for (int i = 0; i < this.mParamACRWidget.getListItemCount(); ++i) {
                    if (this.mParamACRWidget.getListSelectedIndex() <= -1) continue;
                    Object object = this.mParamACRWidget.getListItemAt(this.mParamACRWidget.getListSelectedIndex());
                    if (!this.mNameEdit.getText().equals(object.toString().substring(0, object.toString().indexOf("(")))) continue;
                    bl4 = false;
                    break;
                }
            }
            this.mParamACRWidget.setAddEnabled(bl && bl2 && bl4);
        }
        this.mParamACRWidget.setRemoveEnabled(false);
    }

    private void initVars() {
        this.mComponentsVector = new Vector();
        this.mNameEdit = new StringTextField();
        this.mNameEdit.setDocument(new NameDocument());
        this.mNameEdit.setAction(new TextFieldAction(this.mParentDlg, NONLINEAR_PARAM_NAME_EDIT_KEY));
        this.mValueEdit = new FloatTextField(-99999.0, 999999.0, 0, false);
        this.mValueEdit.setAction((Action)new TextFieldAction(this.mParentDlg, NONLINEAR_PARAM_VALUE_EDIT_KEY));
        this.mValueEdit.setColumns(6);
        this.mParamACRWidget = new BasicACRWidget(NONLINEAR_PARAM_PARAM_LIST_KEY);
        this.mParamACRWidget.getList().setCellRenderer(new WidgetListNumericCellRenderer());
        this.mUseStartCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, NONLINEAR_PARAM_USE_START_VALUE_PREV_ANA_CHECK_KEY));
        this.mUseStartCheck.setEnabled(false);
        this.mNameEdit.getDocument().addDocumentListener(this);
        this.mValueEdit.getDocument().addDocumentListener(this);
        this.mParamACRWidget.addBasicACRListener(this);
    }

    private boolean isNotAVarName(String string) {
        boolean bl = false;
        if (((NonlinearRegressionDlg)this.mParentDlg).findSpssVaribleByName(string) == null) {
            bl = true;
        }
        if (string.equals("PRED_") || string.equals("RESID_")) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_NONLINEAR_PARAM_NAME_INVALID"), VersionInfo.getAppVersionString());
            this.mNameEdit.requestFocus();
            this.mNameEdit.selectAll();
            bl = false;
        }
        return bl;
    }

    private Vector<Object> setTabTraversal() {
        this.mComponentsVector.add(this.mNameEdit);
        this.mComponentsVector.add(this.mValueEdit);
        this.mComponentsVector.add(this.mParamACRWidget.getAddButton());
        this.mComponentsVector.add(this.mParamACRWidget.getChangeButton());
        this.mComponentsVector.add(this.mParamACRWidget.getList());
        this.mComponentsVector.add(this.mParamACRWidget.getRemoveButton());
        this.mComponentsVector.add(this.mUseStartCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mComponentsVector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return this.mComponentsVector;
    }

    private class NameDocument
    extends PlainDocument {
        private NameDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || string.length() == 0) {
                return;
            }
            if (this.getLength() > 64) {
                return;
            }
            char[] cArray = string.toCharArray();
            boolean bl = true;
            if (n == 0 && !Character.isLetter(cArray[0]) && cArray[0] != '@' && cArray[0] != '#' && cArray[0] != '$') {
                bl = false;
            }
            for (char c : cArray) {
                if (Character.isLetter(c) || c == '@' || c == '#' || c == '$' || c == '_' || Character.isDigit(c)) continue;
                bl = false;
                break;
            }
            if (bl) {
                super.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

