/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class NonlinearRegressionOptions
extends BaseSubDialog
implements ActionListener,
ItemListener {
    private static final int DEFAULT_STEP_LIMIT = 2;
    static final String NONLINEAR_OPTIONS_BOOTSTRAP_CHECK_KEY = "IDS_NONLINEAR_OPTIONS_BOOTSTRAP_CHECK";
    static final String NONLINEAR_OPTIONS_SEQ_PROGRA_RADIO_KEY = "IDS_NONLINEAR_OPTIONS_SEQ_PROGRA_RADIO";
    static final String NONLINEAR_OPTIONS_LEVEN_MARQ_RADIO_KEY = "IDS_NONLINEAR_OPTIONS_LEVEN_MARQ_RADIO";
    static final String NONLINEAR_OPTIONS_SEQ_MAX_ITER_EDIT_KEY = "IDS_NONLINEAR_OPTIONS_SEQ_MAX_ITER_EDIT";
    static final String NONLINEAR_OPTIONS_STEP_LIMIT_EDIT_KEY = "IDS_NONLINEAR_OPTIONS_STEP_LIMIT_EDIT";
    static final String NONLINEAR_OPTIONS_LEVEN_MAX_ITER_EDIT_KEY = "IDS_NONLINEAR_OPTIONS_LEVEN_MAX_ITER_EDIT";
    static final String OPTIONS_FUNCT_PREC_COMBO_SELECTED_VAL = "IDS_NONLINEAR_OPTIONS_FUNCT_PREC_COMBO";
    static final String OPTIONS_INFINITE_STEP_COMBO_SELECTED_VAL = "IDS_NONLINEAR_OPTIONS_INFINITE_STEP_COMBO";
    static final String OPTIONS_OPT_TOL_COMBO_SELECTED_VAL = "IDS_NONLINEAR_OPTIONS_OPT_TOL_COMBO";
    static final String OPTIONS_PARAM_CONV_COMBO_SELECTED_VAL = "IDS_NONLINEAR_OPTIONS_PARAM_CONV_COMBO";
    static final String OPTIONS_SUM_SQR_COMBO_SELECTED_VAL = "IDS_NONLINEAR_OPTIONS_SUM_SQR_COMBO";
    static final String NONLINEAR_OPTIONS_OPT_TOL_COMBO_KEY = "IDS_NONLINEAR_OPTIONS_OPT_TOL_COMBO_KEY";
    static final String NONLINEAR_OPTIONS_FUNCT_PREC_COMBO_KEY = "IDS_NONLINEAR_OPTIONS_FUNCT_PREC_COMBO";
    static final String NONLINEAR_OPTIONS_INFINITE_STEP_COMBO_KEY = "IDS_NONLINEAR_OPTIONS_INFINITE_STEP_COMBO";
    static final String NONLINEAR_OPTIONS_SUM_SQR_COMBO_KEY = "IDS_NONLINEAR_OPTIONS_SUM_SQR_COMBO_KEY";
    static final String NONLINEAR_OPTIONS_PARAM_CONV_COMBO_KEY = "IDS_NONLINEAR_OPTIONS_PARAM_CONV_COLON_COMBO_KEY";
    private JCheckBox mBootstrapCheck;
    private JRadioButton mSeqProgRadio;
    private JRadioButton mLevenMarqRadio;
    private JComboBox mOptimalityCombo;
    private JComboBox mFunctPrecCombo;
    private JComboBox mInfiniteStepCombo;
    private JComboBox mSumSqrCombo;
    private JComboBox mParamConvCombo;
    private JPanel mEstimationPanel;
    private JPanel mLevenMarqPanel;
    private JPanel mSeqProgPanel;
    private String[] sumSqrConvCmds = new String[]{"1E-2", "1E-3", "1E-4", "1E-5", "1E-6", "1E-7", "1E-8", "1E-9", "1E-10", "0"};
    private String[] paramConvCmds = new String[]{"1E-2", "1E-3", "1E-4", "1E-5", "1E-6", "1E-7", "1E-8", "1E-9", "1E-10", "0"};
    private String[] optTolCmds = new String[]{null, "1", "1E-1", "1E-2", "1E-3", "1E-4", "1E-5", "1E-6", "1E-7", "1E-8", "1E-9", "1E-10", "1E-11", "1E-12", "1E-13", "1E-14", "1E-15"};
    private String[] funPrecCmds = new String[]{null, "1E-1", "1E-2", "1E-3", "1E-4", "1E-5", "1E-6", "1E-7", "1E-8", "1E-9", "1E-10", "1E-11", "1E-12", "1E-13", "1E-14", "1E-15", "0"};
    private String[] infinteStepCmds = new String[]{"1E+20", "1E+19", "1E+18", "1E+17", "1E+16", "1E+15", "1E+14", "1E+13", "1E+12", "1E+11", "1E+10"};
    private Vector<Object> mComponentsVector;
    SpssButtonGroup mButtonGroup;
    IntTextField mMaxIterEdit;
    FloatTextField mStepLimitEdit;
    IntTextField mSeqMaxIterEdit;

    public NonlinearRegressionOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_NONLINEAR_OPTIONS_TITLE"), true);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_NLRE_OPT";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mBootstrapCheck) {
            this.mSeqProgRadio.setSelected(this.mBootstrapCheck.isSelected());
            this.mLevenMarqRadio.setEnabled(!this.mBootstrapCheck.isSelected());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mBootstrapCheck) {
            if (this.mBootstrapCheck.isSelected()) {
                this.mSeqProgRadio.setSelected(true);
                this.mLevenMarqRadio.setEnabled(false);
                this.setComponentEnableState(this.mSeqProgPanel, true);
            } else {
                this.mLevenMarqRadio.setEnabled(true);
            }
        }
        if (object == this.mSeqProgRadio) {
            this.setComponentEnableState(this.mSeqProgPanel, this.mSeqProgRadio.isSelected());
        }
        if (object == this.mLevenMarqRadio) {
            this.setComponentEnableState(this.mLevenMarqPanel, this.mLevenMarqRadio.isSelected());
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mBootstrapCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mEstimationPanel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSeqProgPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mLevenMarqPanel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        this.pack();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            dialogDataModel.putString(OPTIONS_OPT_TOL_COMBO_SELECTED_VAL, this.optTolCmds[this.mOptimalityCombo.getSelectedIndex()]);
            dialogDataModel.putString("IDS_NONLINEAR_OPTIONS_FUNCT_PREC_COMBO", this.funPrecCmds[this.mFunctPrecCombo.getSelectedIndex()]);
            dialogDataModel.putString("IDS_NONLINEAR_OPTIONS_INFINITE_STEP_COMBO", this.infinteStepCmds[this.mInfiniteStepCombo.getSelectedIndex()]);
            dialogDataModel.putString(OPTIONS_SUM_SQR_COMBO_SELECTED_VAL, this.sumSqrConvCmds[this.mSumSqrCombo.getSelectedIndex()]);
            dialogDataModel.putString(OPTIONS_PARAM_CONV_COMBO_SELECTED_VAL, this.paramConvCmds[this.mParamConvCombo.getSelectedIndex()]);
        }
        return bl;
    }

    private void initVars() {
        this.mComponentsVector = new Vector();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, NONLINEAR_OPTIONS_BOOTSTRAP_CHECK_KEY);
        this.mBootstrapCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, NONLINEAR_OPTIONS_SEQ_PROGRA_RADIO_KEY);
        this.mSeqProgRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, NONLINEAR_OPTIONS_LEVEN_MARQ_RADIO_KEY);
        this.mLevenMarqRadio = new JRadioButton(toggleButtonAction);
        this.mLevenMarqRadio.setSelected(true);
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mSeqProgRadio);
        this.mButtonGroup.add(this.mLevenMarqRadio);
        this.mButtonGroup.setSelected(this.mLevenMarqRadio.getModel(), true);
        this.mOptimalityCombo = new JComboBox<String>(this.setupOptTolItems());
        this.mOptimalityCombo.setAction(new ComboboxAction(this.mParentDlg, NONLINEAR_OPTIONS_OPT_TOL_COMBO_KEY));
        this.mOptimalityCombo.setSelectedIndex(0);
        this.mFunctPrecCombo = new JComboBox<String>(this.setupFunctionPrecItems());
        this.mFunctPrecCombo.setAction(new ComboboxAction(this.mParentDlg, "IDS_NONLINEAR_OPTIONS_FUNCT_PREC_COMBO"));
        this.mFunctPrecCombo.setSelectedIndex(0);
        this.mInfiniteStepCombo = new JComboBox<String>(this.setupInfinteStepItems());
        this.mInfiniteStepCombo.setAction(new ComboboxAction(this.mParentDlg, "IDS_NONLINEAR_OPTIONS_INFINITE_STEP_COMBO"));
        this.mInfiniteStepCombo.setSelectedIndex(0);
        this.mSumSqrCombo = new JComboBox<String>(this.setupSumSqrConvItems());
        this.mSumSqrCombo.setAction(new ComboboxAction(this.mParentDlg, NONLINEAR_OPTIONS_SUM_SQR_COMBO_KEY));
        this.mSumSqrCombo.setSelectedIndex(6);
        this.mParamConvCombo = new JComboBox<String>(this.setupParamConvItems());
        this.mParamConvCombo.setAction(new ComboboxAction(this.mParentDlg, NONLINEAR_OPTIONS_PARAM_CONV_COMBO_KEY));
        this.mParamConvCombo.setSelectedIndex(6);
        this.mEstimationPanel = this.setupEstimationPanel();
        this.mSeqProgPanel = this.setupSeqProgPanel();
        this.mLevenMarqPanel = this.setupLevenMarqPanel();
        this.mBootstrapCheck.addItemListener(this);
        this.mSeqProgRadio.addItemListener(this);
        this.mLevenMarqRadio.addItemListener(this);
        this.setTabTraversal();
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
    }

    private JPanel setupEstimationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_NONLINEAR_OPTIONS_EST_METHOD"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSeqProgRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mLevenMarqRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupLevenMarqPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_NONLINEAR_OPTIONS_LEVEN_MARQ"));
        jPanel.setBorder(titledBorder);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_NONLINEAR_OPTIONS_LEVEN_MAX_ITER_COLON_LABEL");
        this.mMaxIterEdit = new IntTextField(1, 999, true);
        TextFieldAction textFieldAction = new TextFieldAction(this.mParentDlg, NONLINEAR_OPTIONS_LEVEN_MAX_ITER_EDIT_KEY);
        this.mMaxIterEdit.setAction((Action)textFieldAction);
        jLabel.setLabelFor((Component)this.mMaxIterEdit);
        this.mMaxIterEdit.setColumns(3);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_NONLINEAR_OPTIONS_SUM_SQR_COLON_LABEL");
        jLabel2.setLabelFor(this.mSumSqrCombo);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_NONLINEAR_OPTIONS_PARAM_CONV_COLON_LABEL");
        jLabel3.setLabelFor(this.mParamConvCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSumSqrCombo, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mParamConvCombo, gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupSeqProgPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_NONLINEAR_OPTIONS_SEQ_PROGRA"));
        jPanel.setBorder(titledBorder);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_NONLINEAR_OPTIONS_SEQ_MAX_ITER_COLON_LABEL");
        this.mSeqMaxIterEdit = new IntTextField(1, 999, true);
        TextFieldAction textFieldAction = new TextFieldAction(this.mParentDlg, NONLINEAR_OPTIONS_SEQ_MAX_ITER_EDIT_KEY);
        this.mSeqMaxIterEdit.setAction((Action)textFieldAction);
        jLabel.setLabelFor((Component)this.mSeqMaxIterEdit);
        this.mSeqMaxIterEdit.setColumns(3);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_NONLINEAR_OPTIONS_STEP_LIMIT_COLON_LABEL");
        this.mStepLimitEdit = new FloatTextField(1.0, 999.0, 1);
        this.mStepLimitEdit.setColumns(3);
        textFieldAction = new TextFieldAction(this.mParentDlg, NONLINEAR_OPTIONS_STEP_LIMIT_EDIT_KEY);
        this.mStepLimitEdit.setAction((Action)textFieldAction);
        this.mStepLimitEdit.setText(Integer.toString(2));
        jLabel2.setLabelFor((Component)this.mStepLimitEdit);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_NONLINEAR_OPTIONS_OPT_TOL_COLON_LABEL");
        jLabel3.setLabelFor(this.mOptimalityCombo);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_NONLINEAR_OPTIONS_FUNCT_PREC_COLON_LABEL");
        jLabel4.setLabelFor(this.mFunctPrecCombo);
        JLabel jLabel5 = DialogUtil.createLabel(this, "IDS_NONLINEAR_OPTIONS_INFINITE_STEP_COLON_LABEL");
        jLabel5.setLabelFor(this.mInfiniteStepCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel5, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSeqMaxIterEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStepLimitEdit, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOptimalityCombo, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mFunctPrecCombo, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mInfiniteStepCombo, gridBagConstraints, 1, 4, 1, 1, n, insets);
        this.setComponentEnableState(jPanel, false);
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        this.mComponentsVector.add(this.mBootstrapCheck);
        this.mComponentsVector.add(this.mButtonGroup);
        this.mComponentsVector.add(this.mMaxIterEdit);
        this.mComponentsVector.add(this.mSumSqrCombo);
        this.mComponentsVector.add(this.mParamConvCombo);
        this.mComponentsVector.add(this.mSeqMaxIterEdit);
        this.mComponentsVector.add(this.mStepLimitEdit);
        this.mComponentsVector.add(this.mOptimalityCombo);
        this.mComponentsVector.add(this.mFunctPrecCombo);
        this.mComponentsVector.add(this.mInfiniteStepCombo);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            this.mComponentsVector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return this.mComponentsVector;
    }

    private String[] setupSumSqrConvItems() {
        String[] stringArray = new String[]{this.getResString("IDS_NONLINEAR_OPTIONS_SSC+1"), this.getResString("IDS_NONLINEAR_OPTIONS_SSC+2"), this.getResString("IDS_NONLINEAR_OPTIONS_SSC+3"), this.getResString("IDS_NONLINEAR_OPTIONS_SSC+4"), this.getResString("IDS_NONLINEAR_OPTIONS_SSC+5"), this.getResString("IDS_NONLINEAR_OPTIONS_SSC+6"), this.getResString("IDS_NONLINEAR_OPTIONS_SSC+7"), this.getResString("IDS_NONLINEAR_OPTIONS_SSC+8"), this.getResString("IDS_NONLINEAR_OPTIONS_SSC+9"), this.getResString("IDS_NONLINEAR_OPTIONS_SSC+10")};
        return stringArray;
    }

    private String[] setupParamConvItems() {
        String[] stringArray = new String[]{this.getResString("IDS_NONLINEAR_OPTIONS_PARC+1"), this.getResString("IDS_NONLINEAR_OPTIONS_PARC+2"), this.getResString("IDS_NONLINEAR_OPTIONS_PARC+3"), this.getResString("IDS_NONLINEAR_OPTIONS_PARC+4"), this.getResString("IDS_NONLINEAR_OPTIONS_PARC+5"), this.getResString("IDS_NONLINEAR_OPTIONS_PARC+6"), this.getResString("IDS_NONLINEAR_OPTIONS_PARC+7"), this.getResString("IDS_NONLINEAR_OPTIONS_PARC+8"), this.getResString("IDS_NONLINEAR_OPTIONS_PARC+9"), this.getResString("IDS_NONLINEAR_OPTIONS_PARC+10")};
        return stringArray;
    }

    private String[] setupOptTolItems() {
        String[] stringArray = new String[]{this.getResString("IDS_NONLINEAR_OPTIONS_OPT+1"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+2"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+3"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+4"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+5"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+6"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+7"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+8"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+9"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+10"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+11"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+12"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+13"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+14"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+15"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+16"), this.getResString("IDS_NONLINEAR_OPTIONS_OPT+17")};
        return stringArray;
    }

    private String[] setupFunctionPrecItems() {
        String[] stringArray = new String[]{this.getResString("IDS_NONLINEAR_OPTIONS_FUN+1"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+2"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+3"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+4"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+5"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+6"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+7"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+8"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+9"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+10"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+11"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+12"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+13"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+14"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+15"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+16"), this.getResString("IDS_NONLINEAR_OPTIONS_FUN+17")};
        return stringArray;
    }

    private String[] setupInfinteStepItems() {
        String[] stringArray = new String[]{this.getResString("IDS_NONLINEAR_OPTIONS_ISTEP+1"), this.getResString("IDS_NONLINEAR_OPTIONS_ISTEP+2"), this.getResString("IDS_NONLINEAR_OPTIONS_ISTEP+3"), this.getResString("IDS_NONLINEAR_OPTIONS_ISTEP+4"), this.getResString("IDS_NONLINEAR_OPTIONS_ISTEP+5"), this.getResString("IDS_NONLINEAR_OPTIONS_ISTEP+6"), this.getResString("IDS_NONLINEAR_OPTIONS_ISTEP+7"), this.getResString("IDS_NONLINEAR_OPTIONS_ISTEP+8"), this.getResString("IDS_NONLINEAR_OPTIONS_ISTEP+9"), this.getResString("IDS_NONLINEAR_OPTIONS_ISTEP+10"), this.getResString("IDS_NONLINEAR_OPTIONS_ISTEP+11")};
        return stringArray;
    }
}

