/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.ExpressionValidator;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CalcWidget;
import com.spss.java_client.ui.controls.ExpressionAreaArrowButton;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.FunctionListControls;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TextAreaKeyListener;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.WidgetListNumericCellRenderer;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ExpressionBuilderUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.NonlinearRegressionDlg;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NonlinearRegressionLoss
extends BaseSubDialog
implements ItemListener,
DocumentListener,
KeyListener,
ListSelectionListener {
    static final String NONLINEAR_LOSS_EXPRESSION_TEXT_KEY = "IDS_NONLINEAR_LOSS_EXPRESSION_TEXT";
    static final String NONLINEAR_LOSS_FUNCTION_RADIO_KEY = "IDS_NONLINEAR_LOSS_FUNCTION_COLON_RADIO";
    static final String NONLINEAR_SQRD_RESIDUAL_RADIO_KEY = "IDS_NONLINEAR_LOSS_SUM_SQRD_RES_RADIO";
    static final String NONLINEAR_LOSS_PARAM_LIST_KEY = "IDS_NONLINEAR_LOSS_PARAM_LIST";
    private ExpressionAreaArrowButton mArrowButton;
    private CalcWidget mCalcWidget;
    private ExpressionBuilderTextArea mExpressionTextArea;
    private JScrollPane mExpTextAreaScroll;
    private SerializableList mParamList;
    private JPanel mSourceListPanel;
    private SrcVariableList mSpssVarList;
    private JRadioButton mLossFunctRadio;
    private JRadioButton mSqrdResRadio;
    private SpssButtonGroup mGroup;
    private Vector<Object> mComponentsVector;
    private JTextArea mDescriptionTextArea;
    private JScrollPane mDescriptionTextAreaScrollPane;
    private JLabel mFunctionGrpLabel;
    private JList mFunctionGrpList;
    private JScrollPane mFunctionGrpListScrollPane;
    private JLabel mFunctionSpecialVarsLabel;
    private JList mFunctionSpecialVarsList;
    private JScrollPane mFunctionSpecialVarsListScrollPane;
    private ArrowButton mFunctionListArrowButton;
    private FunctionListControls mFunctionListControls;

    public NonlinearRegressionLoss(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_NONLINEAR_LOSS_TITLE"), true);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_NLRE_LOS";
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mSqrdResRadio || object == this.mLossFunctRadio) {
            this.enableComponents(this.mLossFunctRadio.isSelected());
            this.enableContinue(this.canEnableContinue());
        }
        this.mParamList.removeSelectionInterval(this.mParamList.getSelectedIndex(), this.mParamList.getSelectedIndex());
        this.mSpssVarList.removeSelectionInterval(this.mSpssVarList.getSelectedIndex(), this.mSpssVarList.getSelectedIndex());
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (this.mLossFunctRadio.isSelected() && this.mLossFunctRadio.isEnabled()) {
            if (object == this.mSpssVarList) {
                if (this.mSpssVarList.getSelectedIndex() > -1) {
                    this.mArrowButton.unRegisterVariableList(this.mParamList);
                    this.mParamList.removeSelectionInterval(this.mParamList.getSelectedIndex(), this.mParamList.getSelectedIndex());
                    this.mArrowButton.registerComponents(this.mSpssVarList, SpssArrowButton.ButtonOrientation.right);
                    this.mArrowButton.registerComponents((JComponent)((Object)this.mExpressionTextArea), SpssArrowButton.ButtonOrientation.left);
                    this.mArrowButton.setEnabled(true);
                    this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                }
            } else if (object == this.mParamList && this.mParamList.getSelectedIndex() > -1) {
                this.mArrowButton.unRegisterVariableList(this.mSpssVarList);
                this.mSpssVarList.removeSelectionInterval(this.mSpssVarList.getSelectedIndex(), this.mSpssVarList.getSelectedIndex());
                this.mArrowButton.registerComponents(this.mParamList, SpssArrowButton.ButtonOrientation.right);
                this.mArrowButton.registerComponents((JComponent)((Object)this.mExpressionTextArea), SpssArrowButton.ButtonOrientation.left);
                this.mArrowButton.setEnabled(true);
                this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            }
        } else {
            this.mArrowButton.setEnabled(false);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            DialogFocusTraversalPolicy dialogFocusTraversalPolicy = (DialogFocusTraversalPolicy)this.getFocusTraversalPolicy();
            Component component = (Component)keyEvent.getSource();
            Component component2 = keyEvent.isShiftDown() ? dialogFocusTraversalPolicy.getComponentBefore((Container)((Object)this), component) : dialogFocusTraversalPolicy.getComponentAfter((Container)((Object)this), component);
            keyEvent.consume();
            if (component2 != null) {
                component2.requestFocus();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public boolean continuePressed() {
        boolean bl = super.continuePressed();
        if (bl && this.mLossFunctRadio.isSelected()) {
            if (!this.isValidLossExpression()) {
                this.mExpressionTextArea.requestFocus();
                this.mExpressionTextArea.selectAll();
                return false;
            }
            DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
            Boolean bl2 = dialogDataModel.getBoolean("IDS_NONLINEAR_OPTIONS_SEQ_PROGRA_RADIO");
            if (bl2 == null || !bl2.booleanValue()) {
                boolean bl3;
                boolean bl4 = bl3 = 0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_NONLINEAR_USE_SEQUENTIAL_QUA_PROG_OPTION"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                if (bl3) {
                    dialogDataModel.putBoolean("IDS_NONLINEAR_OPTIONS_SEQ_PROGRA_RADIO", true);
                } else {
                    return false;
                }
            }
        }
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSourceListPanel, gridBagConstraints, 0, 0, 1, 9, n, new Insets(insets.top + 5, 0, 0, 0));
        gridBagConstraints.weighty = 0.0;
        insets.left = DialogUtil.getArrowButtonInsets().left;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSqrdResRadio, gridBagConstraints, 1, 0, 4, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mLossFunctRadio, gridBagConstraints, 1, 1, 4, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        insets = (Insets)DialogUtil.getArrowButtonInsets().clone();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        this.mExpTextAreaScroll.setPreferredSize(this.mExpressionTextArea.getMinimumSize());
        this.mExpTextAreaScroll.setHorizontalScrollBarPolicy(31);
        DialogUtil.addUsingGBL(jPanel, this.mExpTextAreaScroll, gridBagConstraints, 2, 2, 3, 1, n, null);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        insets.set(n2 * 2, insets2.left, 0, n2 * 3);
        n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDescriptionTextAreaScrollPane, gridBagConstraints, 1, 7, 3, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCalcWidget, gridBagConstraints, 2, 4, 1, 3, n, null);
        insets.set(n2 * 2, insets2.left, n2 * 3, n2 * 3);
        gridBagConstraints.fill = 0;
        n = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, new JLabel(""), gridBagConstraints, 3, 5, 1, 2, n, insets);
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionListArrowButton, gridBagConstraints, 4, 3, 1, 1, n, insets);
        n = 25;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionGrpLabel, gridBagConstraints, 4, 3, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionGrpListScrollPane, gridBagConstraints, 4, 4, 1, 1, n, null);
        insets.set(n2, 0, 0, 0);
        n = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionSpecialVarsLabel, gridBagConstraints, 4, 5, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionSpecialVarsListScrollPane, gridBagConstraints, 4, 6, 1, 2, n, null);
        this.enableComponents(false);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.mDescriptionTextArea.addKeyListener(new TextAreaKeyListener(this.mDescriptionTextArea, this, dialogFocusTraversalPolicy, false));
        if (this.getGlassPane() instanceof DragPane) {
            ExpressionBuilderUtil.addExpressionTextAreaDragAdapter((DragPane)this.getGlassPane(), this.mExpressionTextArea);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.getGlassPane(), this.mFunctionSpecialVarsList);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.getGlassPane(), this.mParamList);
        }
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        String string = this.mParentDlg.getDialogDataModel().getString(NONLINEAR_LOSS_EXPRESSION_TEXT_KEY);
        if (string != null) {
            this.mExpressionTextArea.setText(string);
        }
        this.populateParamList();
        this.populateSrcVarList();
        this.mFunctionListControls.loadFunctionState(dialogDataModel);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            dialogDataModel.putString(NONLINEAR_LOSS_EXPRESSION_TEXT_KEY, this.mExpressionTextArea.getText());
        }
        this.mFunctionListControls.saveFunctionState(dialogDataModel);
        return bl;
    }

    private Vector<Object> setTabTraversal() {
        this.mComponentsVector.add(this.mGroup);
        this.mComponentsVector.add(this.mSpssVarList);
        this.mComponentsVector.add(this.mParamList);
        this.mComponentsVector.add(this.mArrowButton);
        this.mComponentsVector.add((Object)this.mExpressionTextArea);
        this.mComponentsVector.add(this.mCalcWidget.getDefaultFocusButton());
        this.mComponentsVector.add(this.mFunctionGrpList);
        this.mComponentsVector.add(this.mFunctionSpecialVarsList);
        this.mComponentsVector.add(this.mFunctionListArrowButton);
        this.mComponentsVector.add(this.mDescriptionTextArea);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mComponentsVector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return this.mComponentsVector;
    }

    private boolean isValidLossExpression() {
        if (!this.mExpressionTextArea.validateContents()) {
            return false;
        }
        NonlinearRegressionDlg nonlinearRegressionDlg = (NonlinearRegressionDlg)this.mParentDlg;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(nonlinearRegressionDlg.getModelProgramStringForValidation(true));
        stringBuffer.append("_COMPUTE LOSS_=").append(this.mExpressionTextArea.getText()).append(".\n");
        stringBuffer.append(nonlinearRegressionDlg.getClearModelProgram());
        ExpressionValidator expressionValidator = new ExpressionValidator();
        boolean bl = expressionValidator.validateGeneralExpression(stringBuffer.toString());
        if (!bl) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), expressionValidator.checkError(), VersionInfo.getAppVersionString());
        }
        return bl;
    }

    private void enableComponents(boolean bl) {
        this.setComponentEnableState(this.mSourceListPanel, bl);
        this.mFunctionListArrowButton.setEnabled(bl && this.mFunctionListControls.getFunctionList().getSelectedIndex() > -1);
        this.mExpressionTextArea.setEnabled(bl);
        this.mExpressionTextArea.setOpaque(bl);
        this.mSpssVarList.setOpaque(bl);
        this.mSpssVarList.setEnabled(bl);
        this.mParamList.setOpaque(bl);
        this.mFunctionGrpLabel.setEnabled(bl);
        this.mFunctionGrpList.setEnabled(bl);
        this.mFunctionGrpList.setOpaque(bl);
        this.mFunctionSpecialVarsLabel.setEnabled(bl);
        this.mFunctionSpecialVarsList.setEnabled(bl);
        this.mFunctionSpecialVarsList.setOpaque(bl);
        this.mDescriptionTextArea.setEnabled(bl);
        this.mDescriptionTextArea.setOpaque(bl);
        this.mExpTextAreaScroll.getVerticalScrollBar().setEnabled(bl);
        this.mExpTextAreaScroll.getHorizontalScrollBar().setEnabled(bl);
        this.mExpTextAreaScroll.setWheelScrollingEnabled(bl);
        this.mExpTextAreaScroll.setOpaque(bl);
        this.mDescriptionTextAreaScrollPane.getVerticalScrollBar().setEnabled(bl);
        this.mDescriptionTextAreaScrollPane.getHorizontalScrollBar().setEnabled(bl);
        this.mDescriptionTextAreaScrollPane.setWheelScrollingEnabled(bl);
        this.mDescriptionTextAreaScrollPane.setOpaque(bl);
        this.setComponentEnableState(this.mCalcWidget, bl);
    }

    private boolean canEnableContinue() {
        boolean bl = false;
        if (this.mLossFunctRadio.isSelected() && this.mExpressionTextArea.getText() != null && this.mExpressionTextArea.getText().length() > 0 && !this.mExpressionTextArea.getText().contains("?")) {
            bl = true;
        }
        if (this.mSqrdResRadio.isSelected()) {
            bl = true;
        }
        return bl;
    }

    private void populateSrcVarList() {
        VarListModel varListModel = this.mSpssVarList.getModel();
        varListModel.removeAll();
        VarListModel varListModel2 = ((NonlinearRegressionDlg)this.mParentDlg).getSrcVarList().getModel();
        int n = varListModel2.getSize();
        for (int i = 0; i < n; ++i) {
            varListModel.addElement(varListModel2.getElementAt(i));
        }
        SpssVariable spssVariable = new SpssVariable();
        SPSS_Format sPSS_Format = new SPSS_Format(FormatType.PERCENT, 10, 0);
        spssVariable.setFormat(sPSS_Format);
        spssVariable.setName("PRED_");
        spssVariable.setLabel("Predicted Values");
        spssVariable.setMeasurementLevel(MeasurementLevel.scale);
        spssVariable.setType((short)0);
        varListModel.addElement((ISpssVariable)spssVariable, false);
        spssVariable = new SpssVariable();
        spssVariable.setFormat(sPSS_Format);
        spssVariable.setName("RESID_");
        spssVariable.setLabel("Residuals");
        spssVariable.setMeasurementLevel(MeasurementLevel.scale);
        spssVariable.setType((short)0);
        varListModel.addElement((ISpssVariable)spssVariable, false);
        this.mSpssVarList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof ISpssVariable) {
                    this.setText(((ISpssVariable)object).getName());
                    if (jList.isEnabled()) {
                        this.setOpaque(true);
                        if (bl) {
                            if (jList.hasFocus()) {
                                this.setBackground(jList.getSelectionBackground());
                                this.setForeground(jList.getSelectionForeground());
                            } else {
                                this.setBackground(Color.lightGray);
                                this.setForeground(Color.black);
                            }
                        } else {
                            this.setBackground(jList.getBackground());
                            this.setForeground(jList.getForeground());
                        }
                    } else {
                        this.setOpaque(false);
                    }
                }
                return this;
            }

            @Override
            public void setText(String string) {
                if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                    super.setText(ComponentState.prepareStringForBidiRendering((String)string));
                } else {
                    super.setText(string);
                }
            }

            @Override
            public void setToolTipText(String string) {
                if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                    super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
                } else {
                    super.setToolTipText(string);
                }
            }
        });
    }

    private void populateParamList() {
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("IDS_NON_LINEAR_PARAMS");
        DefaultListModel defaultListModel = (DefaultListModel)this.mParamList.getModel();
        defaultListModel.clear();
        for (SerializableObject serializableObject : serializableObjectArray) {
            defaultListModel.addElement(serializableObject);
        }
    }

    private void initVars() {
        this.mComponentsVector = new Vector();
        this.mSpssVarList = new SrcVariableList();
        this.mSpssVarList.setIdentifier("NonlinearRegressionLossSrcVarList");
        this.mSpssVarList.setContextMenuFlags(1);
        this.mParamList = new PlainList(NONLINEAR_LOSS_PARAM_LIST_KEY);
        this.mParamList.setModel(new DefaultListModel());
        this.mParamList.setCellRenderer(new WidgetListNumericCellRenderer());
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, NONLINEAR_SQRD_RESIDUAL_RADIO_KEY);
        this.mSqrdResRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, NONLINEAR_LOSS_FUNCTION_RADIO_KEY);
        this.mLossFunctRadio = new JRadioButton(toggleButtonAction);
        this.mGroup = new SpssButtonGroup();
        this.mGroup.add(this.mSqrdResRadio);
        this.mGroup.add(this.mLossFunctRadio);
        this.mGroup.setSelected(this.mSqrdResRadio.getModel(), true);
        this.mArrowButton = new ExpressionAreaArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mExpressionTextArea = new ExpressionBuilderTextArea();
        this.mExpressionTextArea.setLineWrap(true);
        this.mExpressionTextArea.setWrapStyleWord(true);
        this.mExpressionTextArea.setDocument(new PlainDocument(){

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string == null || string.length() == 0) {
                    return;
                }
                if (string.contains("\t")) {
                    string = string.replaceAll("\t", "");
                }
                super.insertString(n, string, attributeSet);
            }
        });
        this.mExpressionTextArea.addKeyListener(this);
        this.mExpTextAreaScroll = new JScrollPane((Component)((Object)this.mExpressionTextArea));
        this.mCalcWidget = new CalcWidget((JTextArea)((Object)this.mExpressionTextArea), CalcWidget.CalcType.eRelationalWithTilde);
        this.mFunctionListControls = new FunctionListControls(true, true);
        this.mFunctionListControls.setExpressionArea((JTextArea)((Object)this.mExpressionTextArea));
        this.mFunctionListControls.setFunctionGroupIdentifier("Function Grp in LOSS");
        this.mFunctionListArrowButton = this.mFunctionListControls.getFunctionArrow();
        this.mDescriptionTextArea = this.mFunctionListControls.getFunctionDescArea();
        this.mDescriptionTextArea.setLineWrap(true);
        this.mDescriptionTextArea.setWrapStyleWord(true);
        this.mDescriptionTextArea.setOpaque(false);
        this.mDescriptionTextAreaScrollPane = new JScrollPane(this.mDescriptionTextArea);
        this.mDescriptionTextAreaScrollPane.setVerticalScrollBarPolicy(20);
        this.mFunctionGrpList = this.mFunctionListControls.getFunctionGroupList();
        this.mFunctionGrpList.setSelectionMode(0);
        this.mFunctionGrpListScrollPane = new JScrollPane(this.mFunctionGrpList);
        this.mFunctionGrpListScrollPane.setVerticalScrollBarPolicy(20);
        this.mFunctionGrpListScrollPane.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight()));
        this.mFunctionSpecialVarsList = this.mFunctionListControls.getFunctionList();
        this.mFunctionSpecialVarsList.setSelectionMode(0);
        this.mFunctionSpecialVarsListScrollPane = new JScrollPane(this.mFunctionSpecialVarsList);
        this.mFunctionSpecialVarsListScrollPane.setVerticalScrollBarPolicy(20);
        this.mFunctionSpecialVarsListScrollPane.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight() * 2));
        this.mFunctionListControls.setFunctionListIdentifier("Function list in LOSS");
        this.mFunctionGrpLabel = DialogUtil.createLabel("IDS_FUNCTION_GROUP_LABEL");
        this.mFunctionGrpLabel.setLabelFor(this.mFunctionGrpList);
        this.mFunctionSpecialVarsLabel = DialogUtil.createLabel("IDS_FUNCTION_SPECIAL_VARIABLES_LABEL");
        this.mFunctionSpecialVarsLabel.setLabelFor(this.mFunctionSpecialVarsList);
        this.mSourceListPanel = this.setupSourcePanel();
        this.mLossFunctRadio.addItemListener(this);
        this.mSqrdResRadio.addItemListener(this);
        this.mExpressionTextArea.getDocument().addDocumentListener(this);
        this.mSpssVarList.addListSelectionListener(this);
        this.mParamList.addListSelectionListener(this);
        this.mArrowButton.registerComponents(this.mSpssVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents((JComponent)((Object)this.mExpressionTextArea), SpssArrowButton.ButtonOrientation.left);
    }

    private JPanel setupSourcePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder("");
        jPanel.setBorder(titledBorder);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_NONLINEAR_LOSS_PARAMETERS_COLON");
        jLabel.setLabelFor(this.mParamList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_NONLINEAR_LOSS_SOURCE_LIST_LABEL");
        jLabel2.setLabelFor(this.mSourceListPanel);
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSpssVarList);
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight());
        jScrollPane.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mParamList);
        dimension = new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight() / 2);
        jScrollPane.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 3, 1, 1, n, null);
        return jPanel;
    }
}

