/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.ExpressionValidator;
import com.spss.java_client.core.comp_util.UtilityProxy;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CalcWidget;
import com.spss.java_client.ui.controls.ExpressionAreaArrowButton;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.FunctionListControls;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.TextAreaKeyListener;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.WidgetListNumericCellRenderer;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ExpressionBuilderUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.NonlinearRegressionLoss;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.NonlinearRegressionOptions;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.NonlinearRegressionParameterConstraints;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.NonlinearRegressionParameters;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.NonlinearRegressionSave;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.NonlinearRegressionUtil;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.RegressionConstraint;
import com.spss.java_client.ui.dialogs.pro_stats.nonlinear_reg.RegressionParam;
import com.spss.java_client.ui.dialogs.pro_stats.res.ProStatsResBundle;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.util.CharacterUtil;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NonlinearRegressionDlg
extends BaseProcedureDialog
implements DocumentListener,
ListDataListener,
KeyListener,
ListSelectionListener {
    static final String NON_LINEAR_PARAMS_KEY = "IDS_NON_LINEAR_PARAMS";
    static final String NON_LINEAR_EXPRESSION_EDIT_KEY = "IDS_NON_LINEAR_EXPRESSION_EDIT";
    static final String NON_LINEAR_SRC_VAR_LIST_KEY = "NLRESrcVarList";
    static final String NON_LINEAR_TARGET_VAR_LIST_KEY = "NLREDepVarList";
    private SerializableList mParamList;
    private SrcVariableList mSrcVarList;
    private JButton mLossButton;
    private JButton mConstraintsButton;
    private JButton mSaveButton;
    private JButton mOptionButton;
    private CalcWidget mCalcPanel;
    private TargetVariableList mDependenVartList;
    private ExpressionBuilderTextArea mExpressionTextArea;
    private ExpressionAreaArrowButton mModelExpArrowButton;
    private ArrowButton mDependentArrowButton;
    private Vector<Object> mComponentsVector;
    private JButton mParamButton;
    private JTextArea mDescriptionTextArea;
    private JList mFunctionGrpList;
    private JList mFunctionSpecialVarsList;
    private ArrowButton mFunctionListArrowButton;
    private FunctionListControls mFunctionListControls;

    public NonlinearRegressionDlg(JFrame jFrame) {
        super(jFrame, false, ProStatsResBundle.getDefaultResourceBundleName(), ProStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_NONLINEAR_REGRESSION"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_NLRE";
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* " + this.getResString("IDS_NONLINEAR_REGRESSION_SYNTAX_TITLE") + ".");
        stringBuffer.append("\n");
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options");
        Preferences preferences3 = preferences2.node("viewer");
        String string = preferences3.get("printback", IOptionConstants.VIEWER_PRINTBACK_VALUES[0]);
        if (string.equals("Off")) {
            stringBuffer.append("Set Printback on.\n");
        }
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_NONLINEAR_PARAM_USE_START_VALUE_PREV_ANA_CHECK");
        boolean bl2 = false;
        if (bl != null && bl.booleanValue()) {
            bl2 = true;
        }
        stringBuffer.append(this.getModelProgramSyntax(bl2));
        stringBuffer.append(this.getComputePredSyntax());
        bl = dialogDataModel.getBoolean("IDS_NONLINEAR_OPTIONS_SEQ_PROGRA_RADIO");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(this.getCNLRSyntax(bl2, string));
        } else {
            if (string.equals("Off")) {
                stringBuffer.append("_set Printback off.\n");
            }
            stringBuffer.append(this.getNLRSyntax(bl2));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax().toString());
        return stringBuffer.toString();
    }

    @Override
    public final String getIActionKey() {
        return "analyze_regression_nonlinear";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkOkPaste();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkOkPaste();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkOkPaste();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.mSrcVarList) {
            if (this.mSrcVarList.getSelectedIndex() != -1) {
                this.mModelExpArrowButton.unRegisterVariableList(this.mParamList);
                this.mParamList.removeSelectionInterval(this.mParamList.getSelectedIndex(), this.mParamList.getSelectedIndex());
                this.mModelExpArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                this.mModelExpArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
                this.mModelExpArrowButton.registerComponents((JComponent)((Object)this.mExpressionTextArea), SpssArrowButton.ButtonOrientation.left);
            }
        } else if (object == this.mParamList) {
            if (this.mParamList.getSelectedIndex() != -1) {
                this.mModelExpArrowButton.unRegisterVariableList(this.mSrcVarList);
                this.mSrcVarList.removeSelectionInterval(this.mSrcVarList.getSelectedIndex(), this.mSrcVarList.getSelectedIndex());
                this.mModelExpArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                this.mModelExpArrowButton.registerComponents(this.mParamList, SpssArrowButton.ButtonOrientation.right);
                this.mModelExpArrowButton.registerComponents((JComponent)((Object)this.mExpressionTextArea), SpssArrowButton.ButtonOrientation.left);
            }
        } else if (object == this.mDependenVartList) {
            if (this.mParamList.getSelectedIndex() > -1) {
                this.mParamList.removeSelectionInterval(this.mParamList.getSelectedIndex(), this.mParamList.getSelectedIndex());
            }
            if (this.mSrcVarList.getSelectedIndex() > -1) {
                this.mSrcVarList.removeSelectionInterval(this.mSrcVarList.getSelectedIndex(), this.mSrcVarList.getSelectedIndex());
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableLossConstraint();
        this.checkOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableLossConstraint();
        this.checkOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableLossConstraint();
        this.checkOkPaste();
    }

    @Override
    public boolean okPastePressed() {
        if (!this.checkLossFunctAndParamConstraint()) {
            return false;
        }
        if (!this.isValidModelExpression()) {
            this.mExpressionTextArea.requestFocus();
            this.mExpressionTextArea.selectAll();
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.mDependenVartList.getModel().removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mExpressionTextArea.setText("");
        ((DefaultListModel)this.mParamList.getModel()).removeAllElements();
        this.mFunctionListControls.reset();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            Component component = null;
            DialogFocusTraversalPolicy dialogFocusTraversalPolicy = (DialogFocusTraversalPolicy)this.getFocusTraversalPolicy();
            Component component2 = (Component)keyEvent.getSource();
            component = keyEvent.isShiftDown() ? dialogFocusTraversalPolicy.getComponentBefore((Container)((Object)this), component2) : dialogFocusTraversalPolicy.getComponentAfter((Container)((Object)this), component2);
            keyEvent.consume();
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mExpressionTextArea.setText(this.getDialogDataModel().getString(NON_LINEAR_EXPRESSION_EDIT_KEY));
        this.mFunctionListControls.loadFunctionState(this.getDialogDataModel());
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putString(NON_LINEAR_EXPRESSION_EDIT_KEY, this.mExpressionTextArea.getText());
        this.mFunctionListControls.saveFunctionState(this.getDialogDataModel());
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setupViewPanel(jPanel);
        this.mSrcVarList.requestFocus();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.mDescriptionTextArea.addKeyListener(new TextAreaKeyListener(this.mDescriptionTextArea, this, dialogFocusTraversalPolicy, false));
        if (this.getGlassPane() instanceof DragPane) {
            ExpressionBuilderUtil.addExpressionTextAreaDragAdapter((DragPane)this.getGlassPane(), this.mExpressionTextArea);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.getGlassPane(), this.mFunctionSpecialVarsList);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.getGlassPane(), this.mParamList);
        }
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mSaveButton.setEnabled(false);
        }
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_NONLINEAR_LOSS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NonlinearRegressionDlg.this.runLossSubDialog();
            }
        };
        this.mLossButton = new JButton(toggleButtonAction);
        this.mLossButton.setEnabled(false);
        this.addOptionsPanelButton(jPanel, this.mLossButton);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_NONLINEAR_CONSTRAINTS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NonlinearRegressionDlg.this.runConstraintsSubDialog();
            }
        };
        this.mConstraintsButton = new JButton(toggleButtonAction);
        this.mConstraintsButton.setEnabled(false);
        this.addOptionsPanelButton(jPanel, this.mConstraintsButton);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_SAVE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NonlinearRegressionDlg.this.runSaveSubDialog();
            }
        };
        this.mSaveButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mSaveButton);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NonlinearRegressionDlg.this.runOptionsSubDialog();
            }
        };
        this.mOptionButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionButton);
        return jPanel;
    }

    ISpssVariable findSpssVaribleByName(String string) {
        VarListModel varListModel = this.mSrcVarList.getModel();
        int n = varListModel.getSize();
        ISpssVariable iSpssVariable = null;
        for (int i = 0; i < n; ++i) {
            iSpssVariable = varListModel.getElementAt(i);
            if (!iSpssVariable.getName().equals(string)) continue;
            return iSpssVariable;
        }
        return null;
    }

    SerializableList getParamList() {
        return this.mParamList;
    }

    SrcVariableList getSrcVarList() {
        return this.mSrcVarList;
    }

    String getOutfileLocation() {
        UtilityProxy utilityProxy = UtilityProxy.getUtilProxy();
        return utilityProxy.getServerTemporaryPath() + "SPSSFNLR.TMP";
    }

    String getModelProgramStringForValidation(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "_MODEL PROGRAM";
        String string2 = "RESID_";
        String string3 = "PRED_";
        stringBuffer.append(string);
        DefaultListModel defaultListModel = (DefaultListModel)this.mParamList.getModel();
        int n = defaultListModel.getSize();
        RegressionParam regressionParam = null;
        for (int i = 0; i < n; ++i) {
            regressionParam = (RegressionParam)defaultListModel.getElementAt(i);
            stringBuffer.append(" " + regressionParam.getParamName());
        }
        if (bl) {
            if (this.findSpssVaribleByName(string3) == null) {
                stringBuffer.append(" " + string2 + " " + string3);
            } else {
                stringBuffer.append(" " + string2);
            }
        }
        stringBuffer.append(".\n");
        return stringBuffer.toString();
    }

    String getClearModelProgram() {
        return "_CLEAR MODEL PROGRAM.\n";
    }

    private String getComputeModelVal() {
        return "_COMPUTE PRED_=" + this.mExpressionTextArea.getText() + ".\n";
    }

    private boolean isValidModelExpression() {
        if (!this.mExpressionTextArea.validateContents()) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getModelProgramStringForValidation(false));
        stringBuffer.append(this.getComputeModelVal());
        stringBuffer.append(this.getClearModelProgram());
        ExpressionValidator expressionValidator = new ExpressionValidator();
        boolean bl = expressionValidator.validateGeneralExpression(stringBuffer.toString());
        if (!bl) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), expressionValidator.checkError(), VersionInfo.getAppVersionString());
        }
        return bl;
    }

    private Collection<RegressionConstraint> getLinearConstraints() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ArrayList<RegressionConstraint> arrayList = new ArrayList<RegressionConstraint>();
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("IDS_NONLINEAR_PARAM_CONSTRAINT_LIST");
        if (serializableObjectArray != null && serializableObjectArray.length > 0) {
            int n = serializableObjectArray.length;
            for (int i = 0; i < n; ++i) {
                RegressionConstraint regressionConstraint;
                if (serializableObjectArray[i] == null || !NonlinearRegressionUtil.isLinearConstraint((regressionConstraint = (RegressionConstraint)serializableObjectArray[i]).getExpression())) continue;
                arrayList.add(regressionConstraint);
            }
        }
        return arrayList;
    }

    private Map<String, RegressionConstraint> getNonLinearConstraints() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ArrayList<RegressionConstraint> arrayList = new ArrayList<RegressionConstraint>();
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("IDS_NONLINEAR_PARAM_CONSTRAINT_LIST");
        if (serializableObjectArray != null && serializableObjectArray.length > 0) {
            int n = serializableObjectArray.length;
            RegressionConstraint regressionConstraint = null;
            for (int i = 0; i < n; ++i) {
                if (serializableObjectArray[i] == null || NonlinearRegressionUtil.isLinearConstraint((regressionConstraint = (RegressionConstraint)serializableObjectArray[i]).getExpression())) continue;
                arrayList.add(regressionConstraint);
            }
        }
        HashMap<String, RegressionConstraint> hashMap = new HashMap<String, RegressionConstraint>();
        if (arrayList.size() > 0) {
            int n = arrayList.size();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("CONSTRA_");
                String string = Integer.toString(i + 1) + "_";
                int n2 = stringBuffer.length();
                int n3 = string.length();
                stringBuffer.replace(n2 - n3, n2, string);
                hashMap.put(stringBuffer.toString(), (RegressionConstraint)arrayList.get(i));
            }
        }
        return hashMap;
    }

    private String getModelProgramSyntax(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getMainCommand("MODEL PROGRAM "));
        ListModel listModel = this.mParamList.getModel();
        int n = listModel.getSize();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (bl) {
            for (int i = 0; i < n; ++i) {
                RegressionParam regressionParam = (RegressionParam)listModel.getElementAt(i);
                stringBuffer2.append(regressionParam.getParamName());
                stringBuffer2.append(" ");
            }
        } else {
            for (int i = 0; i < n; ++i) {
                RegressionParam regressionParam = (RegressionParam)listModel.getElementAt(i);
                stringBuffer2.append(regressionParam.getParamName());
                stringBuffer2.append("=");
                stringBuffer2.append(regressionParam.getParamValue());
                stringBuffer2.append(" ");
            }
        }
        if (n > 0) {
            stringBuffer2.delete(stringBuffer2.length() - 1, stringBuffer2.length());
        }
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(stringBuffer2.toString()));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    private String getComputePredSyntax() {
        String string = new String();
        string = SyntaxUtil.getMainCommand("COMPUTE ").toString();
        string = string + SyntaxUtil.getMainCommandParamters("PRED_=").toString();
        string = string + this.mExpressionTextArea.getText().replace("\n", "");
        string = string + SyntaxUtil.terminateSyntax().toString();
        return string;
    }

    private String getSaveSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_NONLINEAR_SAVE_PREDICTED_CHECK");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(" PRED");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NONLINEAR_SAVE_RESIDUALS_CHECK")) != null && bl.booleanValue()) {
            stringBuffer.append(" RESID");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NONLINEAR_SAVE_DERIVATIVES_CHECK")) != null && bl.booleanValue()) {
            stringBuffer.append(" DERIVATIVES");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NONLINEAR_SAVE_LOSS_CHECK")) != null && bl.booleanValue()) {
            stringBuffer.append(" LOSS");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "\n" + SyntaxUtil.getSubCommand("/SAVE"));
        }
        return stringBuffer.toString();
    }

    private String getCNLRCriteriaSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA"));
        String string = dialogDataModel.getString("IDS_NONLINEAR_OPTIONS_SEQ_MAX_ITER_EDIT");
        if (string != null && string.length() > 0) {
            stringBuffer.append(" ITER ");
            stringBuffer.append(string);
        }
        if ((string = dialogDataModel.getString("IDS_NONLINEAR_OPTIONS_FUNCT_PREC_COMBO")) != null && string.length() > 0) {
            stringBuffer.append(" FPRECISION ");
            stringBuffer.append(string);
        }
        if ((string = dialogDataModel.getString("IDS_NONLINEAR_OPTIONS_OPT_TOL_COMBO")) != null && string.length() > 0) {
            stringBuffer.append(" OPTOLERANCE ");
            stringBuffer.append(string);
        }
        string = dialogDataModel.getString("IDS_NONLINEAR_OPTIONS_STEP_LIMIT_EDIT");
        stringBuffer.append(" STEPLIMIT ");
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("2");
        }
        string = dialogDataModel.getString("IDS_NONLINEAR_OPTIONS_INFINITE_STEP_COMBO");
        stringBuffer.append(" ISTEP ");
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("1E+20");
        }
        return stringBuffer.toString();
    }

    private String getLossFunctionSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getDialogDataModel().getString("IDS_NONLINEAR_LOSS_EXPRESSION_TEXT");
        if (string != null && string.length() > 0) {
            stringBuffer.append(SyntaxUtil.getMainCommand("COMPUTE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("RESID_="));
            stringBuffer.append(this.mDependenVartList.getVariablesStringList());
            stringBuffer.append("-(");
            String string2 = this.mExpressionTextArea.getText();
            string2 = string2.replace("\n", "");
            stringBuffer.append(string2);
            stringBuffer.append(")");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("COMPUTE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("LOSS_="));
            stringBuffer.append(string.replace("\n", ""));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    private String getNLRCriteriaSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA"));
        String string = dialogDataModel.getString("IDS_NONLINEAR_OPTIONS_LEVEN_MAX_ITER_EDIT");
        if (string != null && string.length() > 0) {
            stringBuffer.append(" ITER ");
            stringBuffer.append(string);
        }
        stringBuffer.append(" SSCONVERGENCE ");
        string = dialogDataModel.getString("IDS_NONLINEAR_OPTIONS_SUM_SQR_COMBO");
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("1E-8");
        }
        stringBuffer.append(" PCON ");
        string = dialogDataModel.getString("IDS_NONLINEAR_OPTIONS_PARAM_CONV_COMBO");
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("1E-8");
        }
        return stringBuffer.toString();
    }

    private String getComputeNonLinearConstraintsSyntax() {
        Map<String, RegressionConstraint> map = this.getNonLinearConstraints();
        StringBuffer stringBuffer = new StringBuffer();
        if (map != null && map.size() > 0) {
            stringBuffer.append(SyntaxUtil.getMainCommand("CONSTRAINED FUNCTION"));
            Set<String> set = map.keySet();
            RegressionConstraint regressionConstraint = null;
            for (String string : set) {
                regressionConstraint = map.get(string);
                stringBuffer.append(SyntaxUtil.getMainCommand("COMPUTE "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
                stringBuffer.append("=" + regressionConstraint.getExpression());
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
        }
        return stringBuffer.toString();
    }

    private String getBoundsSyntax() {
        Iterator<Object> iterator;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/BOUNDS"));
        Collection<RegressionConstraint> collection = this.getLinearConstraints();
        Map<String, RegressionConstraint> map = this.getNonLinearConstraints();
        if (collection.size() > 0) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(" " + ((RegressionConstraint)iterator.next()).toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(";");
            }
        }
        if (map.size() > 0) {
            if (collection.size() > 0) {
                stringBuffer.append(";");
            }
            iterator = map.keySet().iterator();
            RegressionConstraint regressionConstraint = null;
            String string = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                regressionConstraint = map.get(string);
                stringBuffer.append(" " + string + regressionConstraint.getOperator() + " " + regressionConstraint.getConstraint());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(";");
            }
        }
        return stringBuffer.toString();
    }

    private String getFileSyntax(boolean bl) {
        String string = null;
        string = "\n";
        if (bl) {
            string = string + SyntaxUtil.getSubCommand("/FILE=");
            string = string + CharacterUtil.smartQuote((String)this.getOutfileLocation());
        } else {
            string = string + SyntaxUtil.getSubCommand("/OUTFILE=");
            string = string + CharacterUtil.smartQuote((String)this.getOutfileLocation());
        }
        return string;
    }

    private String getCNLRSyntax(boolean bl, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl2 = dialogDataModel.getBoolean("IDS_NONLINEAR_LOSS_FUNCTION_COLON_RADIO");
        boolean bl3 = false;
        if (bl2 != null && bl2.booleanValue()) {
            bl3 = true;
            stringBuffer.append(this.getLossFunctionSyntax());
        }
        bl2 = dialogDataModel.getBoolean("IDS_NONLINEAR_PARAM_CONS_DEFINE_CONS_RADIO");
        boolean bl4 = false;
        if (bl2 != null && bl2.booleanValue()) {
            bl4 = true;
            stringBuffer.append(this.getComputeNonLinearConstraintsSyntax());
        }
        if (string.equals("Off")) {
            stringBuffer.append("_set Printback off.\n");
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("CNLR "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mDependenVartList.getVariablesStringList()));
        stringBuffer.append(this.getFileSyntax(bl));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/PRED PRED_"));
        if (bl3) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/LOSS LOSS_"));
        }
        if (bl4) {
            stringBuffer.append(this.getBoundsSyntax());
        }
        stringBuffer.append(this.getSaveSyntax());
        bl2 = dialogDataModel.getBoolean("IDS_NONLINEAR_OPTIONS_BOOTSTRAP_CHECK");
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/BOOTSTRAP"));
        }
        stringBuffer.append(this.getCNLRCriteriaSyntax());
        return stringBuffer.toString();
    }

    private String getNLRSyntax(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getMainCommand("NLR "));
        stringBuffer.append(SyntaxUtil.getMainCommand(this.mDependenVartList.getVariablesStringList()));
        stringBuffer.append(this.getFileSyntax(bl));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/PRED PRED_"));
        stringBuffer.append(this.getSaveSyntax());
        stringBuffer.append(this.getNLRCriteriaSyntax());
        return stringBuffer.toString();
    }

    private Vector<Object> setTabTraversal() {
        this.mComponentsVector.add(this.mSrcVarList);
        this.mComponentsVector.add(this.mParamButton);
        this.mComponentsVector.add(this.mParamList);
        this.mComponentsVector.add(this.mDependentArrowButton);
        this.mComponentsVector.add(this.mModelExpArrowButton);
        this.mComponentsVector.add(this.mDependenVartList);
        this.mComponentsVector.add((Object)this.mExpressionTextArea);
        this.mComponentsVector.add(this.mCalcPanel.getDefaultFocusButton());
        this.mComponentsVector.add(this.mFunctionGrpList);
        this.mComponentsVector.add(this.mFunctionSpecialVarsList);
        this.mComponentsVector.add(this.mFunctionListArrowButton);
        this.mComponentsVector.add(this.mDescriptionTextArea);
        this.mComponentsVector.add(this.mLossButton);
        this.mComponentsVector.add(this.mConstraintsButton);
        this.mComponentsVector.add(this.mSaveButton);
        this.mComponentsVector.add(this.mOptionButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            this.mComponentsVector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return this.mComponentsVector;
    }

    private void checkOkPaste() {
        String string = this.mExpressionTextArea.getText().trim();
        boolean bl = string != null && string.length() > 0 && !string.contains("?");
        boolean bl2 = ((DefaultListModel)this.mParamList.getModel()).getSize() > 0;
        boolean bl3 = this.mDependenVartList.getModel().getSize() > 0;
        this.enableOkPaste(bl && bl2 && bl3);
    }

    private boolean checkLossFunctAndParamConstraint() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_NONLINEAR_LOSS_FUNCTION_COLON_RADIO");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_NONLINEAR_PARAM_CONS_DEFINE_CONS_RADIO");
        if (bl != null && bl.booleanValue() || bl2 != null && bl2.booleanValue()) {
            Boolean bl3 = dialogDataModel.getBoolean("IDS_NONLINEAR_OPTIONS_SEQ_PROGRA_RADIO");
            boolean bl4 = false;
            if (bl3 == null || !bl3.booleanValue()) {
                boolean bl5 = bl4 = 0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_NONLINEAR_USE_SEQUENTIAL_QUA_PROG_OPTION"), "SPSS", SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                if (bl4) {
                    dialogDataModel.putBoolean("IDS_NONLINEAR_OPTIONS_SEQ_PROGRA_RADIO", new Boolean(true));
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    private void enableLossConstraint() {
        boolean bl = ((DefaultListModel)this.mParamList.getModel()).getSize() > 0;
        this.mLossButton.setEnabled(bl);
        this.mConstraintsButton.setEnabled(bl);
    }

    private void initVars() {
        this.mComponentsVector = new Vector();
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eKeepOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setIdentifier(NON_LINEAR_SRC_VAR_LIST_KEY);
        this.mSrcVarList.setSelectedIndex(0);
        this.mDependenVartList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDependenVartList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mDependenVartList.setIdentifier(NON_LINEAR_TARGET_VAR_LIST_KEY);
        this.mDependenVartList.addVarFilter(new SpssVarFilter(8, false));
        this.mExpressionTextArea = new ExpressionBuilderTextArea();
        this.mExpressionTextArea.setLineWrap(true);
        this.mExpressionTextArea.setWrapStyleWord(true);
        this.mExpressionTextArea.setDocument(new PlainDocument(){

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string == null || string.length() == 0) {
                    return;
                }
                if (string.contains("\t")) {
                    string = string.replaceAll("\t", "");
                }
                super.insertString(n, string, attributeSet);
            }
        });
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_NONLINEAR_PARAMETERS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NonlinearRegressionDlg.this.runParametersSubDialog();
            }
        };
        this.mParamButton = new JButton(toggleButtonAction);
        this.mParamList = new PlainList(NON_LINEAR_PARAMS_KEY);
        this.mParamList.setModel(new DefaultListModel());
        this.mDependentArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDependentArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDependentArrowButton.registerVariableList(this.mDependenVartList, SpssArrowButton.ButtonOrientation.left);
        this.mModelExpArrowButton = new ExpressionAreaArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCalcPanel = new CalcWidget((JTextArea)((Object)this.mExpressionTextArea));
        this.mFunctionListControls = new FunctionListControls(true, true);
        this.mFunctionListControls.setSrcList(this.mSrcVarList);
        this.mFunctionListControls.setExpressionArea((JTextArea)((Object)this.mExpressionTextArea));
        this.mFunctionListControls.setFunctionGroupIdentifier("Function Grp in NLRE");
        this.mFunctionListArrowButton = this.mFunctionListControls.getFunctionArrow();
        this.mDescriptionTextArea = this.mFunctionListControls.getFunctionDescArea();
        this.mDescriptionTextArea.setLineWrap(true);
        this.mDescriptionTextArea.setWrapStyleWord(true);
        this.mDescriptionTextArea.setOpaque(false);
        this.mFunctionGrpList = this.mFunctionListControls.getFunctionGroupList();
        this.mFunctionGrpList.setSelectionMode(0);
        this.mFunctionSpecialVarsList = this.mFunctionListControls.getFunctionList();
        this.mFunctionSpecialVarsList.setSelectionMode(0);
        this.mFunctionListControls.setFunctionListIdentifier("Function list in NLRE");
        this.mExpressionTextArea.getDocument().addDocumentListener(this);
        this.mExpressionTextArea.addKeyListener(this);
        this.mDependenVartList.getModel().addListDataListener(this);
        this.mParamList.getModel().addListDataListener(this);
        this.mParamList.setCellRenderer(new WidgetListNumericCellRenderer());
        this.mModelExpArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mModelExpArrowButton.registerComponents((JComponent)((Object)this.mExpressionTextArea), SpssArrowButton.ButtonOrientation.left);
        this.mSrcVarList.setDoubleClickEnabled(false);
        this.mSrcVarList.addListSelectionListener(this);
        this.mParamList.addListSelectionListener(this);
        this.mDependenVartList.addListSelectionListener(this);
    }

    private void runConstraintsSubDialog() {
        this.runSubDialog(new NonlinearRegressionParameterConstraints(this));
    }

    private void runLossSubDialog() {
        this.runSubDialog(new NonlinearRegressionLoss(this));
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new NonlinearRegressionOptions(this));
    }

    private void runParametersSubDialog() {
        this.runSubDialog(new NonlinearRegressionParameters(this));
    }

    private void runSaveSubDialog() {
        this.runSubDialog(new NonlinearRegressionSave(this));
    }

    private JPanel setupSourcePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder("");
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_NONLINEAR_REGRESSION_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mParamButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mParamList);
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth() / 3, DialogUtil.getVarListHeight() / 3 * 2);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        insets.top = DialogUtil.getGroupBoxInnerMargin();
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private void setupViewPanel(JPanel jPanel) {
        JPanel jPanel2 = this.setupSourcePanel();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_NONLINEAR_DEPENDENT_COLON");
        jLabel.setLabelFor(this.mDependenVartList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_NONLINEAR_MODEL_EXP_COLON");
        jLabel2.setLabelFor((Component)((Object)this.mExpressionTextArea));
        JScrollPane jScrollPane = new JScrollPane(this.mDescriptionTextArea);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(jScrollPane.getPreferredSize());
        JLabel jLabel3 = DialogUtil.createLabel("IDS_FUNCTION_GROUP_LABEL");
        jLabel3.setLabelFor(this.mFunctionGrpList);
        JLabel jLabel4 = DialogUtil.createLabel("IDS_FUNCTION_SPECIAL_VARIABLES_LABEL");
        jLabel4.setLabelFor(this.mFunctionSpecialVarsList);
        JScrollPane jScrollPane2 = new JScrollPane(this.mFunctionGrpList);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight()));
        JScrollPane jScrollPane3 = new JScrollPane(this.mFunctionSpecialVarsList);
        jScrollPane3.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight() * 2));
        jScrollPane3.setVerticalScrollBarPolicy(20);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 9, n, null);
        Insets insets = DialogUtil.getArrowButtonInsets();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 3, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDependentArrowButton, gridBagConstraints, 1, 0, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JScrollPane jScrollPane4 = new JScrollPane(this.mDependenVartList);
        jScrollPane4.setPreferredSize(this.mDependenVartList.getMinimumSize());
        jScrollPane4.setHorizontalScrollBarPolicy(31);
        jScrollPane4.setVerticalScrollBarPolicy(21);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 2, 1, 3, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 3, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mModelExpArrowButton, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mExpressionTextArea.setLineWrap(true);
        jScrollPane4 = new JScrollPane((Component)((Object)this.mExpressionTextArea));
        jScrollPane4.setHorizontalScrollBarPolicy(31);
        jScrollPane4.setPreferredSize(this.mExpressionTextArea.getPreferredSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 2, 3, 3, 1, n, null);
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        insets2 = new Insets(n2 * 2, insets3.left, 0, n2 * 3);
        n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 8, 3, 1, n, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCalcPanel, gridBagConstraints, 2, 5, 1, 3, n, null);
        insets2.set(n2, insets3.left, n2 + 10, n2 * 3);
        gridBagConstraints.fill = 0;
        n = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, new JLabel(""), gridBagConstraints, 3, 6, 1, 2, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mFunctionListArrowButton, gridBagConstraints, 4, 4, 1, 1, 10, insets2);
        n = 25;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 4, 4, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 4, 5, 1, 1, n, null);
        insets2.set(n2, 0, 0, 0);
        n = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 4, 6, 1, 1, n, insets2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 4, 7, 1, 2, n, null);
    }
}

