/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.multinomial_logistic;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssCovariateVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssFactorVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.pro_stats.multinomial_logistic.MultinomialLogisticRegressionDlg;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MultinomialLogisticRegressionStatistics
extends BaseSubDialog
implements ItemListener {
    public static String MULTINOMIAL_SUBPOPULATIONS_TARGET_LIST_KEY = "IDS_SUBPOPULATIONS1";
    static final String IDS_CONFIDENCE_INTERVAL = "IDS_CONFIDENCE_INTERVAL";
    static final String CONFILEVEL_TEXT = "95";
    static final String VAR_LIST_RADIO_BUTTON_KEY = "IDS_PATTERNS_BY_GIVEN_LIST";
    private ArrowButton mArrowButton;
    private JPanel mConfidenceFieldPanel;
    private FloatTextField mConfidenceIntervalField;
    private JCheckBox mConfidencePanelCheckBox;
    private SrcVariableList mSrcVariableList;
    private TargetVariableList mTargetVariableList;
    private JPanel mVarListsPanel;
    private JRadioButton mVarListsRadioButton;
    private JCheckBox mCaseProcessingCheckBox;
    private JCheckBox mLikelihoodCheckBox;
    private JCheckBox mCorrelationCheckBox;
    private JCheckBox mCovariancesCheckBox;
    private JCheckBox mPseudoCheckBox;
    private JCheckBox mStepSummaryCheckBox;
    private JCheckBox mModelFittingCheckBox;
    private JCheckBox mInformationCriteriaCheckBox;
    private JCheckBox mCellProbabilityCheckBox;
    private JCheckBox mClassificationCheckBox;
    private JCheckBox mGoodnessCheckBox;
    private JCheckBox mMonotonocityCheckBox;
    private JRadioButton mCoavriatesRadioButton;

    public MultinomialLogisticRegressionStatistics(MultinomialLogisticRegressionDlg multinomialLogisticRegressionDlg) {
        super(multinomialLogisticRegressionDlg, multinomialLogisticRegressionDlg.getResString("IDS_MULTINOMIAL_LOGISTIC_REGRESSION_STATISTICS_TITLE"), true);
        this.setLocationRelativeTo((Component)((Object)multinomialLogisticRegressionDlg));
    }

    public MultinomialLogisticRegressionDlg getParent() {
        return (MultinomialLogisticRegressionDlg)((Object)super.getParent());
    }

    public TargetVariableList getTargetVariableList() {
        return this.mTargetVariableList;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object == this.mVarListsRadioButton) {
            this.setComponentEnableState(this.mVarListsPanel, bl);
            if (bl) {
                this.mArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
                this.mArrowButton.registerVariableList(this.mTargetVariableList, SpssArrowButton.ButtonOrientation.left);
            } else {
                this.mArrowButton.unRegisterVariableList(this.mSrcVariableList);
                this.mArrowButton.unRegisterVariableList(this.mTargetVariableList);
            }
            this.mSrcVariableList.setOpaque(bl);
            this.mTargetVariableList.setOpaque(bl);
            this.checkConditionsAndEnableContinue();
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mnlr_stat";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.mCaseProcessingCheckBox.setSelected(true);
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mCaseProcessingCheckBox, gridBagConstraints, 0, 0, 1, 1, 10, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.getViewPanel(), this.setupModelPanel(), gridBagConstraints, 0, 1, 1, 1, 10, null);
        DialogUtil.addUsingGBL(this.getViewPanel(), this.setupParametersPanel(), gridBagConstraints, 0, 2, 1, 1, 10, null);
        DialogUtil.addUsingGBL(this.getViewPanel(), this.setupSubpopulationsPanel(), gridBagConstraints, 0, 3, 1, 1, 10, null);
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        dialogDataModel.putArray("IDS_FACTORS_AND_COVARIATES", null);
        dialogDataModel.putArray(MULTINOMIAL_SUBPOPULATIONS_TARGET_LIST_KEY, null);
        dialogDataModel.putVarArray(MULTINOMIAL_SUBPOPULATIONS_TARGET_LIST_KEY, null);
        super.loadState(dialogDataModel);
        this.loadSoursrTargetList(dialogDataModel);
    }

    public void loadSoursrTargetList(DialogDataModel dialogDataModel) {
        ISpssVariable[] iSpssVariableArray;
        int n;
        ISpssVariable[] iSpssVariableArray2;
        int n2;
        VarListModel varListModel = this.getParent().getFactorsList().getModel();
        VarListModel varListModel2 = this.getParent().getCovariatesList().getModel();
        for (n2 = 0; n2 < varListModel.getSize(); ++n2) {
            iSpssVariableArray2 = varListModel.getElementAt(n2);
            n = 0;
            iSpssVariableArray = dialogDataModel.getVarArray("IDS_SUBPOPULATIONS_VARIABLES");
            if (iSpssVariableArray != null) {
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    if (!iSpssVariable.getId().equals((Object)iSpssVariableArray2.getId())) continue;
                    this.mTargetVariableList.getModel().addElement((ISpssVariable)iSpssVariableArray2);
                    n = 1;
                    break;
                }
            }
            if (n != 0 || this.varListContains(this.mSrcVariableList, (ISpssVariable)iSpssVariableArray2)) continue;
            this.mSrcVariableList.getModel().addElement((ISpssVariable)new SpssFactorVariable((SpssVariable)iSpssVariableArray2));
        }
        for (n2 = 0; n2 < varListModel2.getSize(); ++n2) {
            iSpssVariableArray2 = varListModel2.getElementAt(n2);
            n = 0;
            iSpssVariableArray = dialogDataModel.getVarArray("IDS_SUBPOPULATIONS_VARIABLES");
            if (iSpssVariableArray != null) {
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    if (!iSpssVariable.getId().equals((Object)iSpssVariableArray2.getId())) continue;
                    this.mTargetVariableList.getModel().addElement((ISpssVariable)iSpssVariableArray2);
                    n = 1;
                    break;
                }
            }
            if (n != 0 || this.varListContains(this.mSrcVariableList, (ISpssVariable)iSpssVariableArray2)) continue;
            this.mSrcVariableList.getModel().addElement((ISpssVariable)new SpssCovariateVariable((SpssVariable)iSpssVariableArray2));
        }
        VarListModel varListModel3 = this.mTargetVariableList.getModel();
        iSpssVariableArray2 = new ISpssVariable[varListModel3.getSize()];
        for (n = 0; n < varListModel3.getSize(); ++n) {
            iSpssVariableArray2[n] = varListModel3.getElementAt(n);
        }
        dialogDataModel.putVarArray("IDS_SUBPOPULATIONS_VARIABLES", iSpssVariableArray2);
    }

    public VarListModel getModel() {
        return this.mTargetVariableList.getModel();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        int n;
        VarListModel varListModel = this.mTargetVariableList.getModel();
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[varListModel.getSize()];
        for (n = 0; n < varListModel.getSize(); n += 1) {
            iSpssVariableArray[n] = varListModel.getElementAt(n);
        }
        dialogDataModel.putVarArray("IDS_SUBPOPULATIONS_VARIABLES", iSpssVariableArray);
        n = super.saveState(dialogDataModel) ? 1 : 0;
        if (this.mVarListsRadioButton.isSelected()) {
            ((MultinomialLogisticRegressionDlg)this.mParentDlg).validateModelSubDialogDataModel();
        }
        return n != 0;
    }

    private boolean varListContains(SrcVariableList srcVariableList, ISpssVariable iSpssVariable) {
        boolean bl = false;
        VarListModel varListModel = srcVariableList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable2 = varListModel.getElementAt(i);
            if (!iSpssVariable2.getName().equals(iSpssVariable.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void checkConditionsAndEnableContinue() {
        boolean bl = !this.mConfidenceIntervalField.getText().equals("") || !this.mConfidencePanelCheckBox.isSelected();
        bl = bl && (!this.mVarListsRadioButton.isSelected() || this.mTargetVariableList.getModel().getSize() > 0);
        this.enableContinue(bl);
    }

    private void initVars() {
        this.mSrcVariableList = new SrcVariableList();
        this.mSrcVariableList.setOpaque(false);
        this.mSrcVariableList.setIdentifier("IDS_FACTORS_AND_COVARIATES");
        this.mTargetVariableList = new TargetVariableList();
        this.mTargetVariableList.setOpaque(false);
        this.mTargetVariableList.setIdentifier(MULTINOMIAL_SUBPOPULATIONS_TARGET_LIST_KEY);
        this.mTargetVariableList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                MultinomialLogisticRegressionStatistics.this.checkConditionsAndEnableContinue();
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                MultinomialLogisticRegressionStatistics.this.checkConditionsAndEnableContinue();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                MultinomialLogisticRegressionStatistics.this.checkConditionsAndEnableContinue();
            }
        });
        this.mArrowButton = new ArrowButton();
        this.mCoavriatesRadioButton = new JRadioButton(new ToggleButtonAction(this.getParent(), "IDS_PATTERNS_BY_FACTORS"));
        this.mVarListsRadioButton = new JRadioButton(new ToggleButtonAction(this.getParent(), VAR_LIST_RADIO_BUTTON_KEY));
        this.mVarListsRadioButton.addItemListener(this);
        this.mConfidenceIntervalField = new FloatTextField(0.0, 99.99999, 5);
        this.mConfidenceIntervalField.setText(CONFILEVEL_TEXT);
        this.mConfidenceIntervalField.setAction((Action)new TextFieldAction(this.getParent(), IDS_CONFIDENCE_INTERVAL));
        this.mConfidenceIntervalField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                MultinomialLogisticRegressionStatistics.this.checkConditionsAndEnableContinue();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                MultinomialLogisticRegressionStatistics.this.checkConditionsAndEnableContinue();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                MultinomialLogisticRegressionStatistics.this.checkConditionsAndEnableContinue();
            }
        });
        this.mConfidencePanelCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_PARAMETER_ESTIMATES"));
        this.mConfidencePanelCheckBox.setSelected(true);
        this.mConfidencePanelCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MultinomialLogisticRegressionStatistics.this.setComponentEnableState(MultinomialLogisticRegressionStatistics.this.mConfidenceFieldPanel, itemEvent.getStateChange() == 1);
                MultinomialLogisticRegressionStatistics.this.checkConditionsAndEnableContinue();
            }
        });
        this.mConfidenceFieldPanel = new JPanel(new GridBagLayout());
        this.mVarListsPanel = this.setupRestOfSubpopulationsPanel();
        this.setComponentEnableState(this.mVarListsPanel, false);
        this.mCaseProcessingCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_CASE_PROCESSING_SUMMARY"));
        this.mLikelihoodCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_LIKELIHOOD_RATIO_TESTS"));
        this.mCorrelationCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_ASMPTOTIC_CORRELATIONS"));
        this.mCovariancesCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_ASMPTOTIC_COVARIANCES"));
        this.mPseudoCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_PSEUDO_R_SQUARE"));
        this.mStepSummaryCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_STEP_SUMMARY"));
        this.mModelFittingCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_MODEL_FITTING_INFORMATION"));
        this.mInformationCriteriaCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_INFORMATION_CRITERIA"));
        this.mCellProbabilityCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_CELL_PROBABLITIES"));
        this.mClassificationCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_CLASSIFICATION_TABLE"));
        this.mGoodnessCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_GOODNESS_OF_FIT"));
        this.mMonotonocityCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_MONOTONICITY_MEASURE"));
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mPseudoCheckBox);
        spssButtonGroup.add(this.mStepSummaryCheckBox);
        spssButtonGroup.add(this.mModelFittingCheckBox);
        spssButtonGroup.add(this.mInformationCriteriaCheckBox);
        spssButtonGroup.add(this.mCellProbabilityCheckBox);
        spssButtonGroup.add(this.mClassificationCheckBox);
        spssButtonGroup.add(this.mGoodnessCheckBox);
        spssButtonGroup.add(this.mMonotonocityCheckBox);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mConfidencePanelCheckBox);
        spssButtonGroup2.add(this.mLikelihoodCheckBox);
        spssButtonGroup2.add(this.mCorrelationCheckBox);
        spssButtonGroup2.add(this.mCovariancesCheckBox);
        this.setFocusTraversalPolicy();
    }

    private JPanel setupModelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MULTINOMIAL_LOGISTIC_MODEL")));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.mPseudoCheckBox.setSelected(true);
        DialogUtil.addUsingGBL(jPanel, this.mPseudoCheckBox, gridBagConstraints, 0, 0, 1, 1, 10, DialogUtil.getStandardControlInsets());
        this.mStepSummaryCheckBox.setSelected(true);
        DialogUtil.addUsingGBL(jPanel, this.mStepSummaryCheckBox, gridBagConstraints, 0, 1, 1, 1, 10, DialogUtil.getStandardControlInsets());
        this.mModelFittingCheckBox.setSelected(true);
        DialogUtil.addUsingGBL(jPanel, this.mModelFittingCheckBox, gridBagConstraints, 0, 2, 1, 1, 10, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mInformationCriteriaCheckBox, gridBagConstraints, 0, 3, 1, 1, 10, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mCellProbabilityCheckBox, gridBagConstraints, 1, 0, 1, 1, 10, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mClassificationCheckBox, gridBagConstraints, 1, 1, 1, 1, 10, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mGoodnessCheckBox, gridBagConstraints, 1, 2, 1, 1, 10, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mMonotonocityCheckBox, gridBagConstraints, 1, 3, 1, 1, 10, DialogUtil.getStandardControlInsets());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 4, 1, 1, 10, DialogUtil.getStandardControlInsets());
        return jPanel;
    }

    private JPanel setupParametersPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MULTINOMIAL_LOGISTIC_PARAMETERS")));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mConfidencePanelCheckBox, gridBagConstraints, 0, 0, 1, 1, 10, DialogUtil.getStandardControlInsets());
        this.mLikelihoodCheckBox.setSelected(true);
        DialogUtil.addUsingGBL(jPanel, this.mLikelihoodCheckBox, gridBagConstraints, 0, 1, 1, 1, 10, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mCorrelationCheckBox, gridBagConstraints, 0, 2, 1, 1, 10, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mCovariancesCheckBox, gridBagConstraints, 0, 3, 1, 1, 10, DialogUtil.getStandardControlInsets());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PARAMETER_CONFIDENCE_INTERVAL");
        jLabel.setLabelFor((Component)this.mConfidenceIntervalField);
        DialogUtil.addUsingGBL(this.mConfidenceFieldPanel, jLabel, gridBagConstraints2, 0, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(this.mConfidenceFieldPanel, (JComponent)this.mConfidenceIntervalField, gridBagConstraints2, 1, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mConfidenceFieldPanel, gridBagConstraints, 1, 0, 1, 1, 10, DialogUtil.getStandardControlInsets());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 4, 1, 1, 10, DialogUtil.getStandardControlInsets());
        return jPanel;
    }

    private JPanel setupRestOfSubpopulationsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVariableList);
        jScrollPane.setPreferredSize(this.mSrcVariableList.getMinimumSize());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, 10, DialogUtil.getStandardControlInsets());
        jScrollPane = new JScrollPane(this.mTargetVariableList);
        jScrollPane.setPreferredSize(this.mTargetVariableList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, 10, DialogUtil.getStandardControlInsets());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, 10, DialogUtil.getArrowButtonInsets());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SUBPOPULATIONS");
        jLabel.setLabelFor(this.mTargetVariableList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        return jPanel;
    }

    private JPanel setupSubpopulationsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_DEFINE_SUBPOPULATIONS")));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.mCoavriatesRadioButton.setSelected(true);
        DialogUtil.addUsingGBL(jPanel, this.mCoavriatesRadioButton, gridBagConstraints, 0, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mVarListsRadioButton, gridBagConstraints, 0, 1, 1, 1, 21, DialogUtil.getStandardControlInsets());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mVarListsPanel, gridBagConstraints, 0, 2, 1, 1, 10, DialogUtil.getStandardControlInsets());
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mCaseProcessingCheckBox);
        vector.add(this.mPseudoCheckBox);
        vector.add(this.mStepSummaryCheckBox);
        vector.add(this.mModelFittingCheckBox);
        vector.add(this.mInformationCriteriaCheckBox);
        vector.add(this.mCellProbabilityCheckBox);
        vector.add(this.mClassificationCheckBox);
        vector.add(this.mGoodnessCheckBox);
        vector.add(this.mMonotonocityCheckBox);
        vector.add(this.mConfidencePanelCheckBox);
        vector.add(this.mConfidenceIntervalField);
        vector.add(this.mLikelihoodCheckBox);
        vector.add(this.mCorrelationCheckBox);
        vector.add(this.mCovariancesCheckBox);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mCoavriatesRadioButton);
        spssButtonGroup.add(this.mVarListsRadioButton);
        vector.add(spssButtonGroup);
        vector.add(this.mSrcVariableList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVariableList);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

