/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.multinomial_logistic;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.pro_stats.multinomial_logistic.MultinomialLogisticRegressionDlg;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class MultinomialLogisticRegressionSave
extends BaseSubDialog
implements ActionListener {
    private JButton mBrowseButton;
    private FileTextField mFileNameField;

    public MultinomialLogisticRegressionSave(MultinomialLogisticRegressionDlg multinomialLogisticRegressionDlg) {
        super(multinomialLogisticRegressionDlg, multinomialLogisticRegressionDlg.getResString("IDS_MULTINOMIAL_LOGISTIC_REGRESSION_SAVE_TITLE"), true);
        this.setLocationRelativeTo((Component)((Object)multinomialLogisticRegressionDlg));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = DataServerProxy.getDataProxy().isRemoteConnection();
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), bl);
        remoteFileChooser.setDialogTitle(this.getResString("IDS_MULTINOMIAL_LOGISTIC_REGRESSION_FILE_CHOOSER_TITLE"));
        String string = this.getResString("IDS_XML_FILE_FILTER_EXTENSION");
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_XML_FILE_FILTER"), string));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = string.lastIndexOf(46);
        String string2 = "";
        if (n >= 0) {
            string2 = string.substring(n + 1);
        }
        remoteFileChooser.setDefaultExt(string2);
        remoteFileChooser.setApproveButtonText(this.getResString("IDS_FILE_SAVE"));
        if (remoteFileChooser.showSaveDialog((Component)((Object)this.getParent())) == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string3 = remoteFileChooser.getSelectedFilePath();
            File file = remoteFileChooser.getSelectedFile();
            if (string3.length() > 0) {
                if (string.regionMatches(true, 0, string3, string3.length() - string.length(), string.length())) {
                    this.mFileNameField.setText(string3);
                    remoteFileChooser.setCurrentDirectory(file);
                } else {
                    this.mFileNameField.setText(string3 + string);
                    int n2 = string3.lastIndexOf(file.getName());
                    if (n2 == -1) {
                        remoteFileChooser.setCurrentDirectory(file);
                    } else {
                        remoteFileChooser.setCurrentDirectory(new File(string3.substring(0, n2)));
                    }
                }
            }
        }
    }

    @Override
    public boolean continuePressed() {
        if (!RemoteFileChooser.enableSaveInModeler()) {
            return true;
        }
        String string = this.mFileNameField.getText();
        boolean bl = FileValidator.validatePath((Component)((Object)this), string, true, DataServerProxy.getDataProxy().isRemoteConnection());
        if (!bl) {
            this.mFileNameField.requestFocus();
        }
        return bl;
    }

    public MultinomialLogisticRegressionDlg getParent() {
        return (MultinomialLogisticRegressionDlg)((Object)super.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mnlr_save";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.getViewPanel(), this.setupSavedVariablesPanel(), gridBagConstraints, 0, 0, 1, 1, 10, null);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.getViewPanel(), this.setupExportToXmlPanel(), gridBagConstraints, 0, 1, 1, 1, 10, null);
        this.pack();
    }

    private void initVars() {
        this.mFileNameField = new FileTextField();
        this.mFileNameField.setColumns(30);
        this.mFileNameField.setAction(new TextFieldAction(this.mParentDlg, "EXPORT_XML_FILE_PATH"));
        this.mFileNameField.setFocusable(true);
        this.mBrowseButton = new JButton(new ToggleButtonAction(this.getParent(), "IDS_BROWSE"));
        this.mBrowseButton.addActionListener(this);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mBrowseButton.setEnabled(false);
            this.mFileNameField.setEnabled(false);
        }
    }

    private JPanel setupExportToXmlPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXPORT_TO_XML_FILE")));
        JCheckBox jCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_INCLUDE_COVARIANCE_MATRIX"));
        jCheckBox.setSelected(true);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileNameField), gridBagConstraints, 0, 0, 1, 1, 10, DialogUtil.getStandardControlInsets());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 1, 0, 1, 1, 10, DialogUtil.getStandardControlInsets());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jCheckBox, gridBagConstraints, 0, 1, 2, 1, 10, DialogUtil.getStandardControlInsets());
        return jPanel;
    }

    private JPanel setupSavedVariablesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SAVED_VARIABLES")));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        JCheckBox jCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_ESTIMATED_RESPONSE_PROBABLITIES"));
        spssButtonGroup.add(jCheckBox);
        DialogUtil.addUsingGBL(jPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 1, 10, DialogUtil.getStandardControlInsets());
        jCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_PREDICTED_CATEGORY"));
        spssButtonGroup.add(jCheckBox);
        DialogUtil.addUsingGBL(jPanel, jCheckBox, gridBagConstraints, 0, 1, 1, 1, 10, DialogUtil.getStandardControlInsets());
        jCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_PREDICTED_CATEGORY_PROBABILITY"));
        spssButtonGroup.add(jCheckBox);
        DialogUtil.addUsingGBL(jPanel, jCheckBox, gridBagConstraints, 0, 2, 1, 1, 10, DialogUtil.getStandardControlInsets());
        jCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_ACTUAL_CATEGORY_PROBABILITY"));
        spssButtonGroup.add(jCheckBox);
        DialogUtil.addUsingGBL(jPanel, jCheckBox, gridBagConstraints, 0, 3, 1, 1, 10, DialogUtil.getStandardControlInsets());
        return jPanel;
    }
}

