/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.multinomial_logistic;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineRadioButton;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.pro_stats.multinomial_logistic.MultinomialLogisticRegressionDlg;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class MultinomialLogisticRegressionOptions
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    private JPanel mConstraintEntriesPanel;
    private JCheckBox mConstraintEntryCheckbox;
    private JTextField mEntryProbabilityField;
    private JTextField mMinimumSteppedEffectsField;
    private JTextField mRemovalProbabilityField;
    private JComboBox mScaleComboBox;
    private JTextField mScaleValueField;
    private JLabel mScaleValueLabel;
    private JComboBox mRemovalTestCombo;
    private JComboBox mEntryTestCombo;
    private IntTextField mMaxSteppedEffectsField;
    private SpssButtonGroup mButtonGroup;

    public MultinomialLogisticRegressionOptions(MultinomialLogisticRegressionDlg multinomialLogisticRegressionDlg) {
        super(multinomialLogisticRegressionDlg, multinomialLogisticRegressionDlg.getResString("IDS_MULTINOMIAL_LOGISTIC_REGRESSION_OPTIONS_TITLE"), true);
        this.setLocationRelativeTo((Component)((Object)multinomialLogisticRegressionDlg));
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkConditionsAndEnableContinue();
    }

    public MultinomialLogisticRegressionDlg getParent() {
        return (MultinomialLogisticRegressionDlg)((Object)super.getParent());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkConditionsAndEnableContinue();
    }

    @Override
    public boolean continuePressed() {
        Integer n = null;
        Integer n2 = null;
        Float f = null;
        Float f2 = null;
        if (this.mEntryProbabilityField.getText().length() > 0) {
            f = Float.valueOf(Float.parseFloat(this.mEntryProbabilityField.getText()));
        }
        if (this.mRemovalProbabilityField.getText().length() > 0) {
            f2 = Float.valueOf(Float.parseFloat(this.mRemovalProbabilityField.getText()));
        }
        if (this.mScaleComboBox.getSelectedIndex() == 1) {
            if (this.mScaleValueField.getText().length() > 0) {
                n = Integer.parseInt(this.mScaleValueField.getText());
            }
            if (n == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MULTINOMIAL_LOGISTIC_REGRESSION_CRITERIA_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
                this.mScaleValueField.requestFocus();
                return false;
            }
        }
        if (this.mMaxSteppedEffectsField.getText().length() > 0 && (n2 = Integer.valueOf(Integer.parseInt(this.mMaxSteppedEffectsField.getText()))) == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MULTINOMIAL_LOGISTIC_REGRESSION_CRITERIA_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
            this.mMaxSteppedEffectsField.requestFocus();
            return false;
        }
        if (f.intValue() == 1) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MULTINOMIAL_LOGISTIC_REGRESSION_CRITERIA_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
            this.mEntryProbabilityField.requestFocus();
            return false;
        }
        if (f2.intValue() == 1) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MULTINOMIAL_LOGISTIC_REGRESSION_CRITERIA_OUT_OF_RANGE"), VersionInfo.getAppVersionString());
            this.mRemovalProbabilityField.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object == this.mConstraintEntryCheckbox) {
            if (bl) {
                for (int i = 0; i < this.mConstraintEntriesPanel.getComponentCount(); ++i) {
                    this.mConstraintEntriesPanel.getComponent(i).setForeground(Color.BLACK);
                    this.mConstraintEntriesPanel.getComponent(i).setEnabled(true);
                }
            } else {
                for (int i = 0; i < this.mConstraintEntriesPanel.getComponentCount(); ++i) {
                    this.mConstraintEntriesPanel.getComponent(i).setForeground(Color.GRAY);
                    this.mConstraintEntriesPanel.getComponent(i).setEnabled(false);
                }
            }
        }
        if (itemEvent.getSource() == this.mScaleComboBox) {
            this.checkConditionsAndEnableContinue();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkConditionsAndEnableContinue();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mnlr_opts";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.getViewPanel(), this.setupDispersionScalePanel(), gridBagConstraints, 0, 0, 1, 1, 10, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.getViewPanel(), this.setupStepwiseOptionsPanel(), gridBagConstraints, 0, 1, 1, 1, 10, null);
        this.pack();
    }

    private void checkConditionsAndEnableContinue() {
        this.enableContinue(this.mMinimumSteppedEffectsField.getText().trim().length() > 0 && this.mEntryProbabilityField.getText().trim().length() > 0 && this.mRemovalProbabilityField.getText().trim().length() > 0 && (this.mScaleComboBox.getSelectedIndex() != 1 || this.mScaleValueField.getText().trim().length() > 0));
    }

    private void initVars() {
        this.mScaleValueField = new FloatTextField(true);
        this.mScaleValueField.setDocument(new FixedLengthNumericDocument(8, true, true));
        this.mScaleValueField.setAction(new TextFieldAction(this.getParent(), "IDS_SCALE_VALUE"));
        this.mScaleValueField.setEnabled(false);
        this.mScaleValueField.setOpaque(false);
        this.mScaleValueLabel = DialogUtil.createLabel(this, "IDS_SCALE_VALUE");
        this.mScaleValueLabel.setEnabled(false);
        this.mScaleValueLabel.setLabelFor(this.mScaleValueField);
        this.mScaleComboBox = new JComboBox();
        this.mScaleComboBox.setAction(new ComboboxAction(this.getParent(), "IDS_SCALE"));
        this.mScaleComboBox.addItem(this.getResString("IDS_SCALE_OPTION_NONE"));
        this.mScaleComboBox.addItem(this.getResString("IDS_SCALE_OPTION_USER_DEFINED"));
        this.mScaleComboBox.addItem(this.getResString("IDS_SCALE_OPTION_PEARSON"));
        this.mScaleComboBox.addItem(this.getResString("IDS_SCALE_OPTION_DEVIANCE"));
        this.mScaleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = MultinomialLogisticRegressionOptions.this.mScaleComboBox.getSelectedItem() == MultinomialLogisticRegressionOptions.this.getResString("IDS_SCALE_OPTION_USER_DEFINED");
                MultinomialLogisticRegressionOptions.this.mScaleValueField.setEnabled(bl);
                MultinomialLogisticRegressionOptions.this.mScaleValueField.setOpaque(bl);
                MultinomialLogisticRegressionOptions.this.mScaleValueLabel.setEnabled(bl);
            }
        });
        this.mScaleValueField.getDocument().addDocumentListener(this);
        this.mEntryTestCombo = new JComboBox();
        this.mRemovalTestCombo = new JComboBox();
        this.mMaxSteppedEffectsField = new IntTextField(0, Integer.MAX_VALUE);
        this.mButtonGroup = new SpssButtonGroup();
        this.mConstraintEntryCheckbox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_CONTRAINT_ENTRY"));
        this.mConstraintEntryCheckbox.setSelected(true);
        this.mConstraintEntryCheckbox.addItemListener(this);
        this.mScaleComboBox.addItemListener(this);
        this.mMinimumSteppedEffectsField = new IntTextField(true);
        this.mMinimumSteppedEffectsField.setAction(new TextFieldAction(this.getParent(), "IDS_MINIMUM_STEPPED_EFFECTS"));
        this.mMinimumSteppedEffectsField.setDocument(new FixedLengthNumericDocument(29, true, false));
        this.mMinimumSteppedEffectsField.setText("0");
        this.mMinimumSteppedEffectsField.getDocument().addDocumentListener(this);
        this.mEntryProbabilityField = new FloatTextField(0.0, 1.0, -1);
        this.mEntryProbabilityField.setAction(new TextFieldAction(this.getParent(), "IDS_ENTRY_PROBABLITY"));
        this.mEntryProbabilityField.setText(".05");
        this.mRemovalProbabilityField = new FloatTextField(0.0, 1.0, -1);
        this.mRemovalProbabilityField.setAction(new TextFieldAction(this.getParent(), "IDS_REMOVAL_PROBABLITY"));
        this.mRemovalProbabilityField.setText("0.1");
        this.mConstraintEntriesPanel = this.setupConstraintEntriesPanel();
        this.mRemovalProbabilityField.getDocument().addDocumentListener(this);
        this.mEntryProbabilityField.getDocument().addDocumentListener(this);
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mScaleComboBox);
        vector.add(this.mScaleValueField);
        vector.add(this.mEntryProbabilityField);
        vector.add(this.mRemovalProbabilityField);
        vector.add(this.mRemovalTestCombo);
        vector.add(this.mMinimumSteppedEffectsField);
        vector.add(this.mMaxSteppedEffectsField);
        vector.add(this.mConstraintEntryCheckbox);
        vector.add(this.mButtonGroup);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupConstraintEntriesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JRadioButton jRadioButton = new JRadioButton(new ToggleButtonAction(this.getParent(), "IDS_COVARIATES_LIKE_FACTORS"));
        jRadioButton.setSelected(true);
        this.mButtonGroup.add(jRadioButton);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        String string = "IDS_FACTORIAL_TERMS";
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.getParent(), string);
        SpssMultiLineRadioButton spssMultiLineRadioButton = new SpssMultiLineRadioButton(toggleButtonAction, 400);
        this.mButtonGroup.add(spssMultiLineRadioButton);
        DialogUtil.addUsingGBL(jPanel, spssMultiLineRadioButton, gridBagConstraints, 0, 1, 1, 1, 21, DialogUtil.getStandardControlInsets());
        String string2 = "IDS_COVARIATE_EFFECTS";
        toggleButtonAction = new ToggleButtonAction(this.getParent(), string2);
        spssMultiLineRadioButton = new SpssMultiLineRadioButton(toggleButtonAction, 350);
        this.mButtonGroup.add(spssMultiLineRadioButton);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, spssMultiLineRadioButton, gridBagConstraints, 0, 2, 1, 1, 23, DialogUtil.getStandardControlInsets());
        return jPanel;
    }

    private JPanel setupDispersionScalePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_DISPERSION_SCALE")));
        Insets insets = new Insets(DialogUtil.getStandardControlInsets().top, DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardDialogInsets().bottom, DialogUtil.getStandardControlInsets().right);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SCALE");
        jLabel.setLabelFor(this.mScaleComboBox);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 10, insets);
        DialogUtil.addUsingGBL(jPanel, this.mScaleComboBox, gridBagConstraints, 1, 0, 1, 1, 10, insets);
        DialogUtil.addUsingGBL(jPanel, this.mScaleValueLabel, gridBagConstraints, 2, 0, 1, 1, 10, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mScaleValueField, gridBagConstraints, 3, 0, 1, 1, 21, insets);
        return jPanel;
    }

    private JPanel setupProbablityPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ENTRY_PROBABLITY");
        jLabel.setLabelFor(this.mEntryProbabilityField);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mEntryProbabilityField, gridBagConstraints, 1, 0, 1, 1, 22, DialogUtil.getStandardControlInsets());
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getStandardControlInsets().left, DialogUtil.getComponentGroupGap(), DialogUtil.getStandardControlInsets().right);
        String string = "IDS_ENTRY_TEST";
        jLabel = DialogUtil.createLabel(this, string);
        jLabel.setLabelFor(this.mEntryTestCombo);
        this.mEntryTestCombo.setAction(new ComboboxAction(this.getParent(), "IDS_ENTRY_TEST"));
        this.mEntryTestCombo.addItem(this.getResString("IDS_ENTRY_TEST_OPTION1"));
        this.mEntryTestCombo.addItem(this.getResString("IDS_ENTRY_TEST_OPTION2"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel, this.mEntryTestCombo, gridBagConstraints, 1, 1, 1, 1, 22, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardControlInsets().bottom, DialogUtil.getStandardControlInsets().right);
        jLabel = DialogUtil.createLabel(this, "IDS_REMOVAL_PROBABLITY");
        jLabel.setLabelFor(this.mRemovalProbabilityField);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRemovalProbabilityField, gridBagConstraints, 1, 2, 1, 1, 22, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getStandardControlInsets().left, 2 * DialogUtil.getComponentGroupGap(), DialogUtil.getStandardControlInsets().right);
        String string2 = "IDS_REMOVAL_TEST";
        jLabel = DialogUtil.createLabel(this, string2);
        jLabel.setLabelFor(this.mRemovalTestCombo);
        this.mRemovalTestCombo.setAction(new ComboboxAction(this.getParent(), "IDS_REMOVAL_TEST"));
        this.mRemovalTestCombo.addItem(this.getResString("IDS_REMOVAL_TEST_OPTION1"));
        this.mRemovalTestCombo.addItem(this.getResString("IDS_REMOVAL_TEST_OPTION2"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 3, 1, 1, 21, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRemovalTestCombo, gridBagConstraints, 1, 3, 1, 1, 22, insets);
        return jPanel;
    }

    private JPanel setupSteppedEffectsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String string = "IDS_MINIMUM_STEPPED_EFFECTS";
        JLabel jLabel = DialogUtil.createMultiLineLabel(this, string, 180);
        jLabel.setLabelFor(this.mMinimumSteppedEffectsField);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 23, DialogUtil.getStandardControlInsets());
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMinimumSteppedEffectsField, gridBagConstraints, 1, 0, 1, 1, 23, DialogUtil.getStandardControlInsets());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        String string2 = "IDS_MAXIMUM_STEPPED_EFFECTS";
        jLabel = DialogUtil.createMultiLineLabel(this, string2, 180);
        this.mMaxSteppedEffectsField.setDocument((Document)new FixedLengthNumericDocument(29, true, false));
        jLabel.setLabelFor((Component)this.mMaxSteppedEffectsField);
        this.mMaxSteppedEffectsField.setAction((Action)new TextFieldAction(this.getParent(), "IDS_MAXIMUM_STEPPED_EFFECTS"));
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardControlInsets().bottom, DialogUtil.getStandardControlInsets().right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, 23, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxSteppedEffectsField, gridBagConstraints, 1, 1, 1, 1, 23, insets);
        return jPanel;
    }

    private JPanel setupStepwiseOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_STEPWISE_OPTIONS")));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupProbablityPanel(), gridBagConstraints, 0, 0, 1, 1, 23, DialogUtil.getStandardControlInsets());
        Insets insets = new Insets(DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardControlInsets().right, DialogUtil.getStandardControlInsets().right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, new JSeparator(1), gridBagConstraints, 1, 0, 1, 1, 10, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupSteppedEffectsPanel(), gridBagConstraints, 2, 0, 1, 1, 10, DialogUtil.getStandardControlInsets());
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardControlInsets().right, DialogUtil.getStandardControlInsets().right);
        DialogUtil.addUsingGBL(jPanel, new JSeparator(), gridBagConstraints, 0, 1, 3, 1, 10, insets);
        DialogUtil.addUsingGBL(jPanel, this.mConstraintEntryCheckbox, gridBagConstraints, 0, 2, 3, 1, 23, DialogUtil.getStandardControlInsets());
        gridBagConstraints.weighty = 1.0;
        insets = new Insets(0, DialogUtil.getStandardDialogInsets().left, DialogUtil.getStandardDialogInsets().bottom, DialogUtil.getStandardDialogInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mConstraintEntriesPanel, gridBagConstraints, 0, 3, 3, 1, 23, insets);
        return jPanel;
    }
}

