/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.multinomial_logistic;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.UniqueElementCombinationGenerator;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssCovariateVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssFactorVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.ModelTermsList;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.drag_drop.TermsListDragAdapter;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IModelTermsListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.pro_stats.multinomial_logistic.MultiLogisticModelDropListener;
import com.spss.java_client.ui.dialogs.pro_stats.multinomial_logistic.MultinomialLogisticRegressionDlg;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MultinomialLogisticRegressionModel
extends BaseSubDialog
implements ActionListener,
FocusListener,
ItemListener,
ListDataListener,
IModelTermsListVarMoveHandler {
    private static final String STEP_WISE_TERM_COMBO = "STEP_WISE_TERM_COMBO";
    private static final String FORCED_TERM_COMBO = "FORCED_TERM_COMBO";
    public static String MULTINOMIAL_MODEL_STEPWISE_TERMS_LIST_KEY = "IDS_STEPWISE_TERMS";
    public static String MULTINOMIAL_MODEL_FORCED_TERMS_LIST_KEY = "IDS_FORCED_ENTRY_TERMS";
    private JRadioButton mCustomStepwiseRadioButton;
    private JPanel mCustomTermsPanel;
    private ComponentsArrowButton mForcedTermsArrowButton;
    private JComboBox mForcedTermsComboBox;
    private ModelTermsList mForcedTermsList;
    private SrcVariableList mSrcVariableList;
    private JComboBox mStepwiseMethodComboBox;
    private JLabel mStepwiseMethodLabel;
    private ComponentsArrowButton mStepwiseTermsArrowButton;
    private JComboBox mStepwiseTermsComboBox;
    private ModelTermsList mStepwiseTermsList;
    private SpssButtonGroup mButtonGroup;
    private JCheckBox mIncludeCheckBox;

    public MultinomialLogisticRegressionModel(MultinomialLogisticRegressionDlg multinomialLogisticRegressionDlg) {
        super(multinomialLogisticRegressionDlg, multinomialLogisticRegressionDlg.getResString("IDS_MULTINOMIAL_LOGISTIC_REGRESSION_MODEL_TITLE"), true);
        this.setLocationRelativeTo((Component)((Object)multinomialLogisticRegressionDlg));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mForcedTermsArrowButton) {
            this.arrowButtonClicked(this.mForcedTermsArrowButton, this.mForcedTermsList, this.mForcedTermsComboBox);
        } else if (object == this.mStepwiseTermsArrowButton) {
            this.arrowButtonClicked(this.mStepwiseTermsArrowButton, this.mStepwiseTermsList, this.mStepwiseTermsComboBox);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.checkConditionsAndEnableContinue();
        this.checkConditionsAndEnableStepwiseMethod();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this.mSrcVariableList) {
            this.mForcedTermsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            this.mStepwiseTermsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        } else if (object == this.mForcedTermsList) {
            this.mForcedTermsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        } else if (object == this.mStepwiseTermsList) {
            this.mStepwiseTermsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public MultinomialLogisticRegressionDlg getParent() {
        return (MultinomialLogisticRegressionDlg)((Object)super.getParent());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.checkConditionsAndEnableContinue();
        this.checkConditionsAndEnableStepwiseMethod();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.checkConditionsAndEnableContinue();
        this.checkConditionsAndEnableStepwiseMethod();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getSource();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object == this.mCustomStepwiseRadioButton) {
            this.setComponentEnableState(this.mCustomTermsPanel, bl);
            this.mForcedTermsList.setOpaque(bl);
            this.mSrcVariableList.setOpaque(bl);
            this.mStepwiseTermsList.setOpaque(bl);
            this.checkConditionsAndEnableContinue();
            this.checkConditionsAndEnableStepwiseMethod();
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mnlr_modl";
    }

    @Override
    public void pack() {
        super.pack();
        this.addDragAdapters();
    }

    @Override
    public boolean isDragAllowed(JList jList, JList jList2, Object[] objectArray) {
        if (jList == jList2) {
            return true;
        }
        return !(jList instanceof ModelTermsList) || !(jList2 instanceof ModelTermsList);
    }

    @Override
    public boolean preMoveVariables(Object[] objectArray, ModelTermsList modelTermsList) {
        if (this.checkInLists(objectArray, modelTermsList)) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_UNIQUE_TERMS_ERROR"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    public Object[] getModifiedData(Object[] objectArray, JList jList, ModelTermsList modelTermsList) {
        JComboBox jComboBox = new JComboBox();
        if (modelTermsList == this.mStepwiseTermsList) {
            jComboBox = this.mStepwiseTermsComboBox;
        } else if (modelTermsList == this.mForcedTermsList) {
            jComboBox = this.mForcedTermsComboBox;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ISpssVariable[] iSpssVariableArray = (ISpssVariable[])jList.getSelectedValues();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            arrayList2.add(iSpssVariable.getName());
        }
        ArrayList arrayList3 = new ArrayList();
        switch (jComboBox.getSelectedIndex()) {
            case 0: {
                String string = "";
                for (int i = 0; i < iSpssVariableArray.length; ++i) {
                    string = i == iSpssVariableArray.length - 1 ? string + iSpssVariableArray[i].getName() : string + iSpssVariableArray[i].getName() + "*";
                }
                if (iSpssVariableArray.length <= 0) break;
                arrayList3.add(string);
                break;
            }
            case 1: {
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    arrayList3.add(iSpssVariable.getName());
                }
                break;
            }
            default: {
                if (arrayList2 == null || arrayList2.size() <= 0) break;
                arrayList3.addAll(this.getAllWayItems(arrayList2, jComboBox.getSelectedIndex()));
            }
        }
        Object object = arrayList3.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (!((DefaultListModel)this.mForcedTermsList.getModel()).contains(string) && !((DefaultListModel)this.mStepwiseTermsList.getModel()).contains(string)) continue;
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_UNIQUE_TERMS_ERROR"), VersionInfo.getAppVersionString());
            return null;
        }
        object = arrayList3.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            arrayList.add(string);
        }
        object = modelTermsList;
        SwingUtilities.invokeLater(new Runnable((ModelTermsList)object){
            final /* synthetic */ ModelTermsList val$list;
            {
                this.val$list = modelTermsList;
            }

            @Override
            public void run() {
                this.val$list.requestFocus();
            }
        });
        boolean bl = this.checkInLists(arrayList.toArray(), modelTermsList);
        if (arrayList.size() > 0 && !bl) {
            return arrayList.toArray();
        }
        return null;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.getViewPanel(), this.setupSpecifyModelPanel(), gridBagConstraints, 0, 0, 1, 1, 10, null);
        this.mIncludeCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_INSTERCEPT_IN_MODEL"));
        this.mIncludeCheckBox.setSelected(true);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mIncludeCheckBox, gridBagConstraints, 0, 1, 1, 1, 21, null);
        this.setTabTraversalOrder();
        this.pack();
        this.addListeners();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        ((MultinomialLogisticRegressionDlg)this.mParentDlg).validateModelSubDialogDataModel();
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        int n;
        dialogDataModel.putArray("IDS_FACTORS_AND_COVARIATES", null);
        super.loadState(dialogDataModel);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.getParent().getFactorsList().getModel().getSize(); ++n) {
            arrayList.add(this.getParent().getFactorsList().getModel().getElementAt(n).getName());
            this.mSrcVariableList.getModel().addElement((ISpssVariable)new SpssFactorVariable((SpssVariable)this.getParent().getFactorsList().getModel().getElementAt(n)));
        }
        for (n = 0; n < this.getParent().getCovariatesList().getModel().getSize(); ++n) {
            arrayList.add(this.getParent().getCovariatesList().getModel().getElementAt(n).getName());
            this.mSrcVariableList.getModel().addElement((ISpssVariable)new SpssCovariateVariable((SpssVariable)this.getParent().getCovariatesList().getModel().getElementAt(n)));
        }
        HashSet<String> hashSet = new HashSet<String>();
        DefaultListModel defaultListModel = (DefaultListModel)this.mForcedTermsList.getModel();
        block2: for (int i = 0; i < defaultListModel.getSize(); ++i) {
            String[] object2;
            for (String string : object2 = ((String)defaultListModel.getElementAt(i)).split("\\*")) {
                if (arrayList.contains(string)) continue;
                hashSet.add((String)defaultListModel.getElementAt(i));
                continue block2;
            }
        }
        for (String string : hashSet) {
            defaultListModel.removeElement(string);
        }
        defaultListModel = (DefaultListModel)this.mStepwiseTermsList.getModel();
        block5: for (int i = 0; i < defaultListModel.getSize(); ++i) {
            String[] stringArray;
            for (String string : stringArray = ((String)defaultListModel.getElementAt(i)).split("\\*")) {
                if (arrayList.contains(string)) continue;
                hashSet.add((String)defaultListModel.getElementAt(i));
                continue block5;
            }
        }
        for (String string : hashSet) {
            defaultListModel.removeElement(string);
        }
    }

    protected void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        dragPane.addDropListener((IDropListener)new MultiLogisticModelDropListener(this.mSrcVariableList, this.mModelListVarMoveHandler));
        TermsListDragAdapter termsListDragAdapter = new TermsListDragAdapter(this.mForcedTermsList, dragPane, "ForcedTermsList");
        DialogUtil.modifyMouseInputListeners(this.mForcedTermsList, termsListDragAdapter);
        dragPane.addDropListener((IDropListener)new MultiLogisticModelDropListener(this.mForcedTermsList, this.mModelListVarMoveHandler));
        termsListDragAdapter = new TermsListDragAdapter(this.mStepwiseTermsList, dragPane, "StepwiseTermsList");
        DialogUtil.modifyMouseInputListeners(this.mStepwiseTermsList, termsListDragAdapter);
        dragPane.addDropListener((IDropListener)new MultiLogisticModelDropListener(this.mStepwiseTermsList, this.mModelListVarMoveHandler));
    }

    private boolean checkInLists(Object[] objectArray, ModelTermsList modelTermsList) {
        DefaultListModel defaultListModel = new DefaultListModel();
        if (modelTermsList == this.mForcedTermsList) {
            defaultListModel = (DefaultListModel)this.mStepwiseTermsList.getModel();
        } else if (modelTermsList == this.mStepwiseTermsList) {
            defaultListModel = (DefaultListModel)this.mForcedTermsList.getModel();
        }
        if (defaultListModel.getSize() == 0) {
            return false;
        }
        for (Object object : objectArray) {
            if (!defaultListModel.contains(object)) continue;
            return true;
        }
        return false;
    }

    private void arrowButtonClicked(ComponentsArrowButton componentsArrowButton, SerializableList serializableList, JComboBox jComboBox) {
        if (componentsArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
            DefaultListModel defaultListModel = (DefaultListModel)serializableList.getModel();
            ISpssVariable[] iSpssVariableArray = this.mSrcVariableList.getSelectedValues();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                arrayList.add(iSpssVariable.getName());
            }
            ArrayList arrayList2 = new ArrayList();
            switch (jComboBox.getSelectedIndex()) {
                case 0: {
                    String string = "";
                    for (int i = 0; i < iSpssVariableArray.length; ++i) {
                        string = i == iSpssVariableArray.length - 1 ? string + iSpssVariableArray[i].getName() : string + iSpssVariableArray[i].getName() + "*";
                    }
                    if (iSpssVariableArray.length <= 0) break;
                    arrayList2.add(string);
                    break;
                }
                case 1: {
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        arrayList2.add(iSpssVariable.getName());
                    }
                    break;
                }
                default: {
                    if (arrayList == null || arrayList.size() <= 0) break;
                    arrayList2.addAll(this.getAllWayItems(arrayList, jComboBox.getSelectedIndex()));
                }
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!((DefaultListModel)this.mForcedTermsList.getModel()).contains(string) && !((DefaultListModel)this.mStepwiseTermsList.getModel()).contains(string)) continue;
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_UNIQUE_TERMS_ERROR"), VersionInfo.getAppVersionString());
                return;
            }
            serializableList.requestFocus();
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                defaultListModel.addElement(string);
            }
            if (defaultListModel.getSize() > 0) {
                componentsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                serializableList.setSelectionInterval(defaultListModel.getSize() - arrayList2.size(), defaultListModel.getSize() - 1);
            } else {
                defaultListModel.removeAllElements();
                componentsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                this.mSrcVariableList.requestFocus();
            }
        } else if (componentsArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.left) {
            Object[] objectArray;
            DefaultListModel defaultListModel = (DefaultListModel)serializableList.getModel();
            for (Object object : objectArray = serializableList.getSelectedValues()) {
                defaultListModel.removeElement(object);
            }
            componentsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultinomialLogisticRegressionModel.this.mSrcVariableList.requestFocus();
                }
            });
        }
    }

    private void checkConditionsAndEnableContinue() {
        this.enableContinue(!this.mCustomStepwiseRadioButton.isSelected() || this.mForcedTermsList.getModel().getSize() > 0 || this.mStepwiseTermsList.getModel().getSize() > 0);
    }

    private void checkConditionsAndEnableStepwiseMethod() {
        boolean bl = this.mStepwiseTermsList.getModel().getSize() > 0 && this.mCustomStepwiseRadioButton.isSelected();
        this.mStepwiseMethodLabel.setEnabled(bl);
        this.mStepwiseMethodComboBox.setEnabled(bl);
    }

    private List<String> getAllWayItems(List<String> list, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n <= list.size()) {
            UniqueElementCombinationGenerator uniqueElementCombinationGenerator = new UniqueElementCombinationGenerator(list.size(), n);
            while (uniqueElementCombinationGenerator.hasMore()) {
                StringBuffer stringBuffer = new StringBuffer();
                int[] nArray = uniqueElementCombinationGenerator.getNext();
                for (int i = 0; i < nArray.length; ++i) {
                    if (i < nArray.length - 1) {
                        stringBuffer.append(list.get(nArray[i])).append('*');
                        continue;
                    }
                    stringBuffer.append(list.get(nArray[i]));
                }
                arrayList.add(stringBuffer.toString());
            }
        }
        return arrayList;
    }

    private void initVars() {
        this.mCustomStepwiseRadioButton = new JRadioButton(new ToggleButtonAction(this.getParent(), "IDS_CUSTOM_STEPWISE"));
        this.mCustomStepwiseRadioButton.addItemListener(this);
        this.mSrcVariableList = new SrcVariableList();
        this.mSrcVariableList.setIdentifier("IDS_FACTORS_AND_COVARIATES");
        this.mSrcVariableList.setLoadFromPersistent(false);
        this.mSrcVariableList.setOpaque(false);
        this.mSrcVariableList.setShowVarLabels(false, false);
        this.mSrcVariableList.addFocusListener(this);
        this.mForcedTermsList = new ModelTermsList(MULTINOMIAL_MODEL_FORCED_TERMS_LIST_KEY);
        this.mForcedTermsList.setOpaque(false);
        this.mForcedTermsList.setModel(new DefaultListModel());
        this.mForcedTermsList.getModel().addListDataListener(this);
        this.mForcedTermsList.addFocusListener(this);
        this.mStepwiseTermsList = new ModelTermsList(MULTINOMIAL_MODEL_STEPWISE_TERMS_LIST_KEY);
        this.mStepwiseTermsList.setOpaque(false);
        this.mStepwiseTermsList.setModel(new DefaultListModel());
        this.mStepwiseTermsList.getModel().addListDataListener(this);
        this.mStepwiseTermsList.addFocusListener(this);
        this.mForcedTermsArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mForcedTermsArrowButton.registerComponents(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mForcedTermsArrowButton.registerComponents(this.mForcedTermsList, SpssArrowButton.ButtonOrientation.left);
        this.mForcedTermsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mForcedTermsArrowButton.addActionListener(this);
        String[] stringArray = new String[]{this.getResString("IDS_MULTINOMIAL_LOGISTIC_REGRESSION_MODEL_BUILD_TERMS_OPTION1"), this.getResString("IDS_MULTINOMIAL_LOGISTIC_REGRESSION_MODEL_BUILD_TERMS_OPTION2"), this.getResString("IDS_MULTINOMIAL_LOGISTIC_REGRESSION_MODEL_BUILD_TERMS_OPTION3"), this.getResString("IDS_MULTINOMIAL_LOGISTIC_REGRESSION_MODEL_BUILD_TERMS_OPTION4"), this.getResString("IDS_MULTINOMIAL_LOGISTIC_REGRESSION_MODEL_BUILD_TERMS_OPTION5"), this.getResString("IDS_MULTINOMIAL_LOGISTIC_REGRESSION_MODEL_BUILD_TERMS_OPTION6")};
        ComboboxAction comboboxAction = new ComboboxAction(this, FORCED_TERM_COMBO);
        this.mForcedTermsComboBox = new JComboBox<String>(stringArray);
        this.mForcedTermsComboBox.setAction(comboboxAction);
        comboboxAction = new ComboboxAction(this, STEP_WISE_TERM_COMBO);
        this.mStepwiseTermsComboBox = new JComboBox<String>(stringArray);
        this.mStepwiseTermsComboBox.setAction(comboboxAction);
        this.mStepwiseTermsArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mStepwiseTermsArrowButton.registerComponents(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mStepwiseTermsArrowButton.registerComponents(this.mStepwiseTermsList, SpssArrowButton.ButtonOrientation.left);
        this.mStepwiseTermsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mStepwiseTermsArrowButton.addActionListener(this);
        this.mStepwiseMethodLabel = DialogUtil.createLabel(this, "IDS_STEPWISE_METHOD");
        this.mStepwiseMethodComboBox = new JComboBox();
        this.mStepwiseMethodLabel.setLabelFor(this.mStepwiseMethodComboBox);
        this.mStepwiseMethodComboBox.setAction(new ComboboxAction(this.getParent(), "IDS_STEPWISE_METHOD"));
        this.mStepwiseMethodComboBox.addItem(this.getResString("IDS_STEPWISE_METHOD_OPTION1"));
        this.mStepwiseMethodComboBox.addItem(this.getResString("IDS_STEPWISE_METHOD_OPTION2"));
        this.mStepwiseMethodComboBox.addItem(this.getResString("IDS_STEPWISE_METHOD_OPTION3"));
        this.mStepwiseMethodComboBox.addItem(this.getResString("IDS_STEPWISE_METHOD_OPTION4"));
        this.mCustomTermsPanel = this.setupCustomTermsPanel();
        this.mModelListVarMoveHandler = this;
    }

    private JPanel setupBuildTermsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MULTINOMIAL_LOGISTIC_REGRESSION_MODEL_BUILD_TERMS")));
        Insets insets = new Insets(DialogUtil.getStandardControlInsets().top + 2, DialogUtil.getArrowButtonInsets().left, DialogUtil.getStandardControlInsets().bottom, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mForcedTermsComboBox, gridBagConstraints, 0, 0, 1, 1, 10, DialogUtil.getStandardButtonInsets());
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mForcedTermsArrowButton, gridBagConstraints, 0, 1, 1, 1, 19, insets);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mStepwiseTermsComboBox, gridBagConstraints, 0, 2, 1, 1, 10, DialogUtil.getStandardButtonInsets());
        insets.bottom += 2;
        DialogUtil.addUsingGBL(jPanel, this.mStepwiseTermsArrowButton, gridBagConstraints, 0, 3, 1, 1, 10, insets);
        return jPanel;
    }

    private JPanel setupCustomTermsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVariableList);
        jScrollPane.setPreferredSize(this.mSrcVariableList.getMinimumSize());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 5, 10, DialogUtil.getStandardControlInsets());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_FACTORS_AND_COVARIATES");
        jLabel.setLabelFor(this.mSrcVariableList);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        jScrollPane = new JScrollPane(this.mForcedTermsList);
        jScrollPane.setPreferredSize(new Dimension(2 * this.mSrcVariableList.getMinimumSize().width, this.mSrcVariableList.getMinimumSize().height));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, 21, DialogUtil.getStandardControlInsets());
        jLabel = DialogUtil.createLabel(this, "IDS_FORCED_ENTRY_TERMS");
        jLabel.setLabelFor(this.mForcedTermsList);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        jScrollPane = new JScrollPane(this.mStepwiseTermsList);
        jScrollPane.setPreferredSize(new Dimension(2 * this.mSrcVariableList.getMinimumSize().width, this.mSrcVariableList.getMinimumSize().height));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 3, 1, 1, 21, DialogUtil.getStandardControlInsets());
        jLabel = DialogUtil.createLabel(this, "IDS_STEPWISE_TERMS");
        jLabel.setLabelFor(this.mStepwiseTermsList);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 2, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mStepwiseMethodLabel, gridBagConstraints, 2, 4, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mStepwiseMethodComboBox, gridBagConstraints, 2, 5, 1, 1, 21, DialogUtil.getStandardControlInsets());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        DialogUtil.addUsingGBL(jPanel2, this.setupBuildTermsPanel(), gridBagConstraints, 0, 1, 1, 1, 10, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel2, new JPanel(), gridBagConstraints, 0, 0, 1, 1, 10, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel2, new JPanel(), gridBagConstraints, 0, 2, 1, 1, 10, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 1, 1, 3, 10, DialogUtil.getStandardControlInsets());
        return jPanel;
    }

    private JPanel setupSpecifyModelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SPECIFY_MODEL")));
        this.mButtonGroup = new SpssButtonGroup();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JRadioButton jRadioButton = new JRadioButton(new ToggleButtonAction(this.getParent(), "IDS_MAIN_EFFECTS"));
        jRadioButton.setSelected(true);
        this.mButtonGroup.add(jRadioButton);
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        jRadioButton = new JRadioButton(new ToggleButtonAction(this.getParent(), "IDS_FULL_FACTORIAL"));
        this.mButtonGroup.add(jRadioButton);
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 1, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        this.mButtonGroup.add(this.mCustomStepwiseRadioButton);
        DialogUtil.addUsingGBL(jPanel, this.mCustomStepwiseRadioButton, gridBagConstraints, 2, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, new JSeparator(), gridBagConstraints, 0, 1, 3, 1, 10, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.setComponentEnableState(this.mCustomTermsPanel, false);
        DialogUtil.addUsingGBL(jPanel, this.mCustomTermsPanel, gridBagConstraints, 0, 2, 3, 1, 21, null);
        return jPanel;
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mButtonGroup);
        vector.add(this.mSrcVariableList);
        vector.add(this.mForcedTermsComboBox);
        vector.add(this.mForcedTermsArrowButton);
        vector.add(this.mStepwiseTermsComboBox);
        vector.add(this.mStepwiseTermsArrowButton);
        vector.add(this.mForcedTermsList);
        vector.add(this.mStepwiseTermsList);
        vector.add(this.mStepwiseMethodComboBox);
        vector.add(this.mIncludeCheckBox);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void addListeners() {
        MouseHandler mouseHandler = new MouseHandler();
        this.mForcedTermsList.addMouseListener(mouseHandler);
        this.mStepwiseTermsList.addMouseListener(mouseHandler);
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == MultinomialLogisticRegressionModel.this.mForcedTermsList) {
                MultinomialLogisticRegressionModel.this.mForcedTermsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                if (mouseEvent.getClickCount() == 2) {
                    MultinomialLogisticRegressionModel.this.mForcedTermsArrowButton.doClick();
                }
            } else if (object == MultinomialLogisticRegressionModel.this.mStepwiseTermsList) {
                MultinomialLogisticRegressionModel.this.mStepwiseTermsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                if (mouseEvent.getClickCount() == 2) {
                    MultinomialLogisticRegressionModel.this.mStepwiseTermsArrowButton.doClick();
                }
            }
        }
    }
}

