/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.linear_reg;

import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonSyntaxUtils;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.pro_stats.linear_reg.LinearRegressionOptions;
import com.spss.java_client.ui.dialogs.pro_stats.linear_reg.LinearRegressionRule;
import com.spss.uitools.util.CharacterUtil;
import java.util.ArrayList;

public class LinearRegressionUtils {
    public static String generateStatisticsSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        if (dialogDataModel.getBoolean("IDS_REG_LINEAR_STATISTICS_ESTIMATES_CHECKBOX") == null) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS"));
            stringBuffer.append(" COEFF OUTS R ANOVA");
        } else {
            Boolean bl;
            Boolean bl2;
            Boolean bl3;
            Boolean bl4;
            Boolean bl5;
            Boolean bl6;
            int n = 0;
            stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS"));
            Boolean bl7 = dialogDataModel.getBoolean("IDS_REG_LINEAR_STATISTICS_ESTIMATES_CHECKBOX");
            if (bl7.booleanValue()) {
                ++n;
                stringBuffer.append(" COEFF OUTS");
            }
            if ((bl6 = dialogDataModel.getBoolean("IDS_REG_LINEAR_STATISTICS_CONFIDENCE_INTERVALS_CHECKBOX")).booleanValue()) {
                ++n;
                stringBuffer.append(" CI(").append(ComplexSamplesCommonSyntaxUtils.formattedSyntaxString(dialogDataModel.getString("IDS_REG_LINEAR_STATISTICS_LEVEL_LABEL"))).append(")");
            }
            if ((bl5 = dialogDataModel.getBoolean("IDS_REG_LINEAR_STATISTICS_COVARIANCE_MATRIX_CHECKBOX")).booleanValue()) {
                ++n;
                stringBuffer.append(" BCOV");
            }
            if ((bl4 = dialogDataModel.getBoolean("IDS_REG_LINEAR_STATISTICS_MODEL_FIT_CHECKBOX")).booleanValue()) {
                ++n;
                stringBuffer.append(" R ANOVA");
            }
            if ((bl3 = dialogDataModel.getBoolean("IDS_REG_LINEAR_STATISTICS_COLLINEARITY_CHECKBOX")).booleanValue()) {
                ++n;
                stringBuffer.append(" COLLIN TOL");
            }
            if ((bl2 = dialogDataModel.getBoolean("IDS_REG_LINEAR_STATISTICS_R_SQUARED_CHECKBOX")).booleanValue()) {
                ++n;
                stringBuffer.append(" CHANGE");
            }
            if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_STATISTICS_PART_AND_PARTIAL_CHECKBOX")).booleanValue()) {
                ++n;
                stringBuffer.append(" ZPP");
            }
            if (n == 0) {
                stringBuffer.delete(0, stringBuffer.length());
            }
        }
        return stringBuffer.toString();
    }

    public static String generateDescriptiveStatisticsSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_STATISTICS_DESCRIPTIVES_CHECKBOX");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/DESCRIPTIVES"));
            stringBuffer.append(" MEAN STDDEV CORR SIG N");
        }
        return stringBuffer.toString();
    }

    public static String generateResidualStatisticsSyntax(DialogDataModel dialogDataModel) {
        Boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl2 = dialogDataModel.getBoolean("IDS_REG_LINEAR_STATISTICS_DURBIN_WATSON_CHECKBOX");
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/RESIDUALS DURBIN"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_PLOTS_HISTOGRAM_CHECKBOX")) != null) {
            Boolean bl3;
            if (bl.booleanValue()) {
                if (stringBuffer.toString().equals("")) {
                    stringBuffer.append(SyntaxUtil.getSubCommand("/RESIDUALS HISTOGRAM(ZRESID)"));
                } else {
                    stringBuffer.append(" HISTOGRAM(ZRESID)");
                }
            }
            if ((bl3 = dialogDataModel.getBoolean("IDS_REG_LINEAR_PLOTS_NORMAL_CHECKBOX")).booleanValue()) {
                if (stringBuffer.toString().equals("")) {
                    stringBuffer.append(SyntaxUtil.getSubCommand("/RESIDUALS NORMPROB(ZRESID)"));
                } else {
                    stringBuffer.append(" NORMPROB(ZRESID)");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String generateCasewiseStatisticsSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_STATISTICS_CASEWISE_DIAGNOSTICS_CHECKBOX");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/CASEWISE"));
            Boolean bl2 = dialogDataModel.getBoolean("IDS_REG_LINEAR_STATISTICS_OUTLIERS_OUTSIDE_RADIOBUTTON");
            if (bl2.booleanValue()) {
                stringBuffer.append(" PLOT(ZRESID) OUTLIERS(").append(dialogDataModel.getString("IDS_REG_LINEAR_STATISTICS_STD_DEVIATION_LABEL")).append(")");
            } else {
                stringBuffer.append(" PLOT(ZRESID) ALL");
            }
        }
        return stringBuffer.toString();
    }

    public static String generateScatterPlotSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = (ArrayList)dialogDataModel.getObject("DATA_OF_LAYERS");
        if (arrayList != null && arrayList.size() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/SCATTERPLOT="));
            for (ArrayList arrayList2 : arrayList) {
                ISpssVariable iSpssVariable;
                String string = (String)arrayList2.get(1);
                String string2 = (String)arrayList2.get(0);
                if (string.equals("DEPENDNT")) {
                    iSpssVariable = dialogDataModel.getVarArray("IDS_DEPENDENT_KEY")[0];
                    string = iSpssVariable.getName();
                }
                if (string2.equals("DEPENDNT")) {
                    iSpssVariable = dialogDataModel.getVarArray("IDS_DEPENDENT_KEY")[0];
                    string2 = iSpssVariable.getName();
                }
                stringBuffer.append("(").append(string).append(" ,").append(string2).append(") ");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static String generatePartialPlotSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_PLOTS_PRODUCE_CHECKBOX");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PARTIALPLOT ALL"));
        }
        return stringBuffer.toString();
    }

    public static String generateSaveSyntax(DialogDataModel dialogDataModel) {
        ArrayList<String> arrayList = new ArrayList<String>(20);
        Boolean bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_UNSTANDARD_PREDICTED_CHECK");
        if (bl != null && bl.booleanValue()) {
            arrayList.add("PRED");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_STANDARD_PREDICTED_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("ZPRED");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_ADJUSTED_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("ADJPRED");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_SE_OF_MEAN_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("SEPRED");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_MAHALANOBIS_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("MAHAL");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_COOKS_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("COOK");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_LEVERAGE_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("LEVER");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_MEAN_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("MCIN");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_INDIVIDUAL_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("ICIN");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_UNSTANDARD_RESIDUALS_CHECK")) != null && bl.booleanValue()) {
            arrayList.add("RESID");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_STANDARD_RESIDUALS_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("ZRESID");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_STUDENTIZED_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("SRESID");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_DELETED_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("DRESID");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_STUDENTIZED_DELETED_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("SDRESID");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_DFBETA_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("DFBETA");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_STANDARD_DFBETA_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("SDBETA");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_DFFIT_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("DFFIT");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_STANDARD_DFFIT_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("SDFIT");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_COVARIANCE_CKECK")) != null && bl.booleanValue()) {
            arrayList.add("COVRATIO");
        }
        if (arrayList.size() != 0) {
            return "\n" + SyntaxUtil.getSubCommand(SyntaxUtil.getMultiParameterSubCommand("SAVE", arrayList, false).toString());
        }
        return "";
    }

    public static StringBuffer generateOutFileSyntax(DialogDataModel dialogDataModel) {
        String string = "";
        Boolean bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_CREATE_COEFFICIENT_STAT_CKECK");
        if (bl != null && bl.booleanValue() && (bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_CREATE_DATASET_RADIO")) != null && bl.booleanValue()) {
            string = string + "COVB(" + dialogDataModel.getString("DATASET_NAME_KEY") + ")";
        }
        bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_INCLUDE_CKECK");
        if (!RemoteFileChooser.enableSaveInModeler() && bl == null) {
            bl = true;
        }
        String string2 = dialogDataModel.getString("EXPORT_XML_FILE_PATH");
        if (bl != null && string2 != null) {
            if (bl.booleanValue() && string2.length() > 0) {
                if (!string.equals("")) {
                    string = string + " ";
                }
                string = string + "MODEL(" + CharacterUtil.smartQuote((String)string2) + ")";
            } else if (string2.length() > 0) {
                string = string + "PARAMETER(" + CharacterUtil.smartQuote((String)string2) + ")";
            }
        }
        if (!string.equals("")) {
            return SyntaxUtil.getSingleValueSubCommand("OUTFILE", string, false);
        }
        return null;
    }

    public static StringBuffer generateOutFileTwoSyntax(DialogDataModel dialogDataModel) {
        String string = "";
        Boolean bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_CREATE_COEFFICIENT_STAT_CKECK");
        if (bl != null && bl.booleanValue() && (bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_WRITE_DATASET_RADIO")) != null && bl.booleanValue()) {
            string = string + "COVB(" + CharacterUtil.smartQuote((String)dialogDataModel.getString("FILE_NAME_LABEL_KEY")) + ")";
        }
        bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_INCLUDE_CKECK");
        if (!RemoteFileChooser.enableSaveInModeler() && bl == null) {
            bl = true;
        }
        String string2 = dialogDataModel.getString("EXPORT_XML_FILE_PATH");
        if (bl != null && string2 != null) {
            if (bl.booleanValue() && string2.length() > 0) {
                if (!string.equals("")) {
                    string = string + " ";
                }
                string = string + "MODEL(" + CharacterUtil.smartQuote((String)string2) + ")";
            } else if (string2.length() > 0) {
                string = string + "PARAMETER(" + CharacterUtil.smartQuote((String)string2) + ")";
            }
        }
        if (!string.equals("")) {
            return SyntaxUtil.getSingleValueSubCommand("OUTFILE", string, false);
        }
        return null;
    }

    public static StringBuffer generatePerAttributeSyntax(DialogDataModel dialogDataModel) {
        String string;
        String string2 = null;
        String string3 = null;
        Boolean bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_CREATE_COEFFICIENT_STAT_CKECK");
        if (bl != null && bl.booleanValue() && (bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_WRITE_DATASET_RADIO")) != null && bl.booleanValue()) {
            string2 = dialogDataModel.getString("FILE_NAME_LABEL_KEY");
        }
        bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_INCLUDE_CKECK");
        String string4 = dialogDataModel.getString("EXPORT_XML_FILE_PATH");
        if (bl != null && bl.booleanValue() && string4 != null && string4.length() > 0) {
            string3 = string4;
        } else if (bl != null && string4 != null && string4.length() > 0) {
            string3 = string4;
        }
        String string5 = null;
        PesFile pesFile = PES_Repository.getPesFile((String)string2);
        if (pesFile != null) {
            string5 = pesFile.getPerAttributesSyntax();
        }
        if ((pesFile = PES_Repository.getPesFile((String)string3)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            string5 = string5 == null ? string : string5 + string;
        }
        if (string5 == null) {
            return null;
        }
        return new StringBuffer(string5);
    }

    public static StringBuffer generateSelectSyntax(DialogDataModel dialogDataModel, TargetVariableList targetVariableList) {
        String string = dialogDataModel.getString(LinearRegressionRule.RULE_KEY);
        if (dialogDataModel.getString(LinearRegressionRule.RULE_KEY) != null) {
            if (string.contains("~=")) {
                string = string.replaceAll("~=", " NE ");
            }
            if (string.contains("<=")) {
                string = string.replaceAll("<=", " LE ");
            }
            if (string.contains("<")) {
                string = string.replaceAll("<", " LT ");
            }
            if (string.contains(">=")) {
                string = string.replaceAll(">=", " GE ");
            }
            if (string.contains(">")) {
                string = string.replaceAll(">", " GT ");
            }
            if (string.contains("=")) {
                string = string.replaceAll("=", " EQ ");
            }
            if (targetVariableList.getModel().getSize() > 0) {
                string = targetVariableList.getModel().getElementAt(0).getName() + string;
            }
        }
        return SyntaxUtil.getSingleValueSubCommand("SELECT", string, true);
    }

    public static StringBuffer generateMissingSyntax(DialogDataModel dialogDataModel) {
        String string = "";
        Boolean bl = dialogDataModel.getBoolean(LinearRegressionOptions.EXCLUDE_LISTWISE_KEY);
        if (bl != null) {
            if (bl.booleanValue()) {
                string = string + "LISTWISE";
            }
            if ((bl = dialogDataModel.getBoolean(LinearRegressionOptions.EXCLUDE_PAIRWISE_KEY)) != null && bl.booleanValue()) {
                string = string + "PAIRWISE";
            }
            if ((bl = dialogDataModel.getBoolean(LinearRegressionOptions.REPLACE_MEAN_KEY)) != null && bl.booleanValue()) {
                string = string + "MEANSUBSTITUTION";
            }
        } else {
            string = string + "LISTWISE";
        }
        return SyntaxUtil.getSingleParameterSubCommand("MISSING", string, true);
    }

    public static StringBuffer generateOriginOrNoOriginSyntax(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("  /");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        if (bl) {
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer generateCriteriaSyntax(DialogDataModel dialogDataModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Boolean bl = dialogDataModel.getBoolean(LinearRegressionOptions.USE_PROBABILITY_KEY);
        if (bl != null) {
            if (bl.booleanValue()) {
                arrayList2.add(dialogDataModel.getString(LinearRegressionOptions.USE_PROBABILITY_ENTRY_KEY));
                arrayList2.add(dialogDataModel.getString(LinearRegressionOptions.USE_PROBABILITY_REMOVAL_KEY));
                arrayList.add("PIN");
                arrayList.add("POUT");
            } else {
                arrayList2.add(dialogDataModel.getString(LinearRegressionOptions.USE_F_VALUE_ENTRY_KEY));
                arrayList2.add(dialogDataModel.getString(LinearRegressionOptions.USE_F_VALUE_REMOVAL_KEY));
                arrayList.add("FIN");
                arrayList.add("FOUT");
            }
        } else {
            arrayList2.add(".05");
            arrayList2.add(".10");
            arrayList.add("PIN");
            arrayList.add("POUT");
        }
        bl = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_MEAN_CKECK");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_REG_LINEAR_SAVE_INDIVIDUAL_CKECK");
        if (bl != null && (bl.booleanValue() || bl2.booleanValue())) {
            arrayList2.add(dialogDataModel.getString("IDS_CONFIDENCE_INTERVAL_KEY"));
            arrayList.add("CIN");
        }
        return SyntaxUtil.getBracedMultiValueSubCommand("CRITERIA", arrayList, arrayList2, true);
    }
}

