/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.linear_reg;

import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class LinearRegressionStatistics
extends BaseSubDialog
implements ItemListener,
DocumentListener,
FocusListener {
    static final String LEVEL_PER_TEXT = "IDS_REG_LINEAR_STATISTICS_LEVEL_LABEL";
    private static final double MIN_VALUE = 0.01;
    private static final double MAX_VALUE = 999.0;
    private static final int MAX_PRECISION = 3;
    private static final String DEFAULT_LEVEL_VALUE = "95";
    private static final double MIN_LEVEL_VALUE = 50.0;
    private static final double MAX_LEVEL_VALUE = 100.0;
    private GridBagConstraints mConstraints;
    private int mAnchor;
    private Insets mInsets;
    private JCheckBox mEstimatesCheckBox;
    private JCheckBox mModelFitCheckBox;
    private JCheckBox mCasewiseCheckBox;
    private JRadioButton mOutliersRadioButton;
    private JRadioButton mAllCasesRadioButton;
    private FloatTextField mOutliersTextField;
    private JLabel mStdDevLabel;
    private Vector<Object> mFocus;
    private JCheckBox mConfIntervalCheck;
    private JLabel mLevelPerLabel;
    private JTextField mLevelPerText;
    private JCheckBox mCovarianceMatrixCheck;

    public LinearRegressionStatistics(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_REG_LINEAR_STATISTICS_DLG_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_regr_sta";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setEnableContinue();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setEnableContinue();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mCasewiseCheckBox) {
            if (this.mCasewiseCheckBox.isSelected()) {
                this.mOutliersRadioButton.setEnabled(true);
                if (this.mOutliersRadioButton.isSelected()) {
                    this.mOutliersTextField.setEnabled(true);
                    this.mOutliersTextField.setOpaque(true);
                } else {
                    this.mOutliersTextField.setEnabled(false);
                    this.mOutliersTextField.setOpaque(false);
                }
                this.mStdDevLabel.setEnabled(true);
                this.mAllCasesRadioButton.setEnabled(true);
            } else {
                this.mOutliersRadioButton.setEnabled(false);
                this.mOutliersTextField.setEnabled(false);
                this.mOutliersTextField.setOpaque(false);
                this.mStdDevLabel.setEnabled(false);
                this.mAllCasesRadioButton.setEnabled(false);
            }
        } else if (itemEvent.getSource() == this.mAllCasesRadioButton) {
            this.mOutliersTextField.setEnabled(false);
            this.mOutliersTextField.setOpaque(false);
        } else if (itemEvent.getSource() == this.mOutliersRadioButton) {
            this.mOutliersTextField.setEnabled(true);
            this.mOutliersTextField.setOpaque(true);
        } else if (itemEvent.getSource() == this.mConfIntervalCheck) {
            this.enableConfInterval(this.mConfIntervalCheck.isSelected());
        }
        this.setEnableContinue();
    }

    private void enableConfInterval(boolean bl) {
        this.mLevelPerLabel.setEnabled(bl);
        this.mLevelPerText.setEnabled(bl);
        if (this.mLevelPerText.getText().length() < 1) {
            this.mLevelPerText.setText(DEFAULT_LEVEL_VALUE);
        }
        this.mLevelPerText.setOpaque(bl);
    }

    @Override
    protected void init() {
        Component[] componentArray;
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupUI(jPanel);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            if (!(component instanceof JButton)) continue;
            this.mFocus.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mFocus, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        this.mConstraints = new GridBagConstraints();
        this.mAnchor = 23;
        this.mInsets = new Insets(0, 0, 0, 0);
        this.mEstimatesCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_REG_LINEAR_STATISTICS_ESTIMATES_CHECKBOX"));
        this.mModelFitCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_REG_LINEAR_STATISTICS_MODEL_FIT_CHECKBOX"));
        this.mCasewiseCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_REG_LINEAR_STATISTICS_CASEWISE_DIAGNOSTICS_CHECKBOX"));
        this.mCasewiseCheckBox.addItemListener(this);
        this.mOutliersRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_REG_LINEAR_STATISTICS_OUTLIERS_OUTSIDE_RADIOBUTTON"));
        this.mOutliersRadioButton.addItemListener(this);
        this.mAllCasesRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_REG_LINEAR_STATISTICS_ALL_CASES_RADIOBUTTON"));
        this.mAllCasesRadioButton.addItemListener(this);
        this.mOutliersTextField = new FloatTextField(0.01, 999.0, 3, true);
        this.mOutliersTextField.setAction((Action)new TextFieldAction(this, "IDS_REG_LINEAR_STATISTICS_STD_DEVIATION_LABEL"));
        this.mOutliersTextField.setDocument((Document)new FixedLengthNumericDocument(3, true, true));
        this.mOutliersTextField.getDocument().addDocumentListener(this);
        this.mStdDevLabel = new JLabel(this.getResString("IDS_REG_LINEAR_STATISTICS_STD_DEVIATION_LABEL"));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_REG_LINEAR_STATISTICS_CONFIDENCE_INTERVALS_CHECKBOX");
        this.mConfIntervalCheck = new JCheckBox(toggleButtonAction);
        this.mConfIntervalCheck.addItemListener(this);
        this.mLevelPerLabel = DialogUtil.createLabel(this, LEVEL_PER_TEXT);
        this.mLevelPerText = new FloatTextField(50.0, 100.0, -1, true);
        ((FloatTextField)this.mLevelPerText).setIncludeMaxRange(false);
        ((FloatTextField)this.mLevelPerText).setIncludeMinRange(true);
        this.mLevelPerText.setAction(new TextFieldAction(this, LEVEL_PER_TEXT));
        this.mLevelPerLabel.setLabelFor(this.mLevelPerText);
        this.mLevelPerText.addFocusListener(this);
        this.mLevelPerText.getDocument().addDocumentListener(this);
        this.mCovarianceMatrixCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_REG_LINEAR_STATISTICS_COVARIANCE_MATRIX_CHECKBOX"));
    }

    private void setDefaults() {
        this.enableConfInterval(false);
        this.mEstimatesCheckBox.setSelected(true);
        this.mModelFitCheckBox.setSelected(true);
        this.mOutliersRadioButton.setSelected(true);
        this.mOutliersRadioButton.setEnabled(false);
        this.mAllCasesRadioButton.setEnabled(false);
        this.mOutliersTextField.setText("3");
        this.mOutliersTextField.setEnabled(false);
        this.mOutliersTextField.setOpaque(false);
        this.mStdDevLabel.setEnabled(false);
        this.mFocus = new Vector();
    }

    private void setupUI(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = this.setupRegressionCoefficientsPanel();
        JPanel jPanel4 = this.setupCheckboxPanel();
        JPanel jPanel5 = this.setupResidualsPanel();
        int n = DialogUtil.getGroupBoxInnerMargin();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, jPanel3, this.mConstraints, 0, 0, 1, 1, this.mAnchor, null);
        this.mInsets.set(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, jPanel4, this.mConstraints, 1, 0, 1, 1, this.mAnchor, this.mInsets);
        DialogUtil.addUsingGBL(jPanel2, jPanel5, this.mConstraints, 0, 1, 2, 1, this.mAnchor, null);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 0, 1, 1, this.mAnchor, null);
    }

    private JPanel setupRegressionCoefficientsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_REG_LINEAR_STATISTICS_REG_COEFF_PANEL")));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mEstimatesCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mConfIntervalCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top, insets.left * 8, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.setupLabelTextPanel(this.mLevelPerLabel, this.mLevelPerText), gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCovarianceMatrixCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.mFocus.add(this.mEstimatesCheckBox);
        this.mFocus.add(this.mConfIntervalCheck);
        this.mFocus.add(this.mLevelPerText);
        this.mFocus.add(this.mCovarianceMatrixCheck);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mEstimatesCheckBox);
        spssButtonGroup.add(this.mConfIntervalCheck);
        spssButtonGroup.add(this.mCovarianceMatrixCheck);
        return jPanel;
    }

    private JPanel setupLabelTextPanel(JLabel jLabel, JTextField jTextField) {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupResidualsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_REG_LINEAR_STATISTICS_RESIDUALS_PANEL")));
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        JCheckBox jCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_REG_LINEAR_STATISTICS_DURBIN_WATSON_CHECKBOX"));
        this.mInsets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jCheckBox, this.mConstraints, 0, 0, 1, 1, this.mAnchor, this.mInsets);
        this.mInsets.set(insets.bottom, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mCasewiseCheckBox, this.mConstraints, 0, 1, 1, 1, this.mAnchor, this.mInsets);
        this.mInsets.set(insets.top, n + n, 0, 0);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mOutliersRadioButton, this.mConstraints, 0, 2, 1, 1, this.mAnchor, this.mInsets);
        this.mInsets.set(insets.top, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mOutliersTextField, this.mConstraints, 1, 2, 1, 1, this.mAnchor, this.mInsets);
        this.mInsets.set(insets.top, n2, 0, n2);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mStdDevLabel, this.mConstraints, 2, 2, 1, 1, this.mAnchor, this.mInsets);
        this.mInsets.set(insets.top, n + n, n2, n2);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.fill = 0;
        this.mConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mAllCasesRadioButton, this.mConstraints, 0, 3, 1, 1, this.mAnchor, this.mInsets);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mOutliersRadioButton);
        spssButtonGroup.add(this.mAllCasesRadioButton);
        this.mFocus.add(jCheckBox);
        this.mFocus.add(this.mCasewiseCheckBox);
        this.mFocus.add(spssButtonGroup);
        this.mFocus.add(this.mOutliersTextField);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(jCheckBox);
        spssButtonGroup2.add(this.mCasewiseCheckBox);
        return jPanel;
    }

    private JPanel setupCheckboxPanel() {
        JCheckBox jCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_REG_LINEAR_STATISTICS_R_SQUARED_CHECKBOX"));
        JCheckBox jCheckBox2 = new JCheckBox(new ToggleButtonAction(this, "IDS_REG_LINEAR_STATISTICS_DESCRIPTIVES_CHECKBOX"));
        JCheckBox jCheckBox3 = new JCheckBox(new ToggleButtonAction(this, "IDS_REG_LINEAR_STATISTICS_PART_AND_PARTIAL_CHECKBOX"));
        JCheckBox jCheckBox4 = new JCheckBox(new ToggleButtonAction(this, "IDS_REG_LINEAR_STATISTICS_COLLINEARITY_CHECKBOX"));
        JPanel jPanel = PanelFactory.getBasicPanel(new JComponent[]{this.mModelFitCheckBox, jCheckBox, jCheckBox2, jCheckBox3, jCheckBox4}, PanelFactory.PanelType.yaxis, null);
        this.mFocus.add(this.mModelFitCheckBox);
        this.mFocus.add(jCheckBox);
        this.mFocus.add(jCheckBox2);
        this.mFocus.add(jCheckBox3);
        this.mFocus.add(jCheckBox4);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mModelFitCheckBox);
        spssButtonGroup.add(jCheckBox);
        spssButtonGroup.add(jCheckBox2);
        spssButtonGroup.add(jCheckBox3);
        spssButtonGroup.add(jCheckBox4);
        return jPanel;
    }

    private void setEnableContinue() {
        if (!this.getOutliersTextStatus() || !this.getLevelTextStatus()) {
            this.enableContinue(false);
        } else {
            this.enableContinue(true);
        }
    }

    private boolean getOutliersTextStatus() {
        boolean bl = true;
        if (this.mCasewiseCheckBox.isSelected() && this.mOutliersRadioButton.isSelected()) {
            bl = this.mOutliersTextField.getText().length() > 0;
        }
        return bl;
    }

    private boolean getLevelTextStatus() {
        boolean bl = true;
        if (this.mConfIntervalCheck.isSelected()) {
            bl = this.mLevelPerText.getText().length() > 0;
        }
        return bl;
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JTextField jTextField = (JTextField)focusEvent.getSource();
        jTextField.setSelectionStart(0);
        jTextField.setSelectionEnd(jTextField.getText().length());
    }
}

