/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.linear_reg;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

class LinearRegressionSave
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    static final String UNSTANDARD_PREDICTED_KEY = "IDS_REG_LINEAR_SAVE_UNSTANDARD_PREDICTED_CHECK";
    static final String STANDARD_PREDICTED_KEY = "IDS_REG_LINEAR_SAVE_STANDARD_PREDICTED_CKECK";
    static final String ADJUSTED_KEY = "IDS_REG_LINEAR_SAVE_ADJUSTED_CKECK";
    static final String SE_OF_MEAN_KEY = "IDS_REG_LINEAR_SAVE_SE_OF_MEAN_CKECK";
    static final String UNSTANDARD_RESIDUALS_KEY = "IDS_REG_LINEAR_SAVE_UNSTANDARD_RESIDUALS_CHECK";
    static final String STANDARD_RESIDUALS_KEY = "IDS_REG_LINEAR_SAVE_STANDARD_RESIDUALS_CKECK";
    static final String STUDENTIZED_KEY = "IDS_REG_LINEAR_SAVE_STUDENTIZED_CKECK";
    static final String DELETED_KEY = "IDS_REG_LINEAR_SAVE_DELETED_CKECK";
    static final String STUDENTIZED_DELETED_KEY = "IDS_REG_LINEAR_SAVE_STUDENTIZED_DELETED_CKECK";
    static final String MAHALANOBIS_KEY = "IDS_REG_LINEAR_SAVE_MAHALANOBIS_CKECK";
    static final String COOKS_KEY = "IDS_REG_LINEAR_SAVE_COOKS_CKECK";
    static final String LEVERAGE_KEY = "IDS_REG_LINEAR_SAVE_LEVERAGE_CKECK";
    static final String DFBETA_KEY = "IDS_REG_LINEAR_SAVE_DFBETA_CKECK";
    static final String STANDARD_DFBETA_KEY = "IDS_REG_LINEAR_SAVE_STANDARD_DFBETA_CKECK";
    static final String DFFIT_KEY = "IDS_REG_LINEAR_SAVE_DFFIT_CKECK";
    static final String STANDARD_DFFIT_KEY = "IDS_REG_LINEAR_SAVE_STANDARD_DFFIT_CKECK";
    static final String COVARIANCE_KEY = "IDS_REG_LINEAR_SAVE_COVARIANCE_CKECK";
    static final String MEAN_KEY = "IDS_REG_LINEAR_SAVE_MEAN_CKECK";
    static final String INDIVIDUAL_KEY = "IDS_REG_LINEAR_SAVE_INDIVIDUAL_CKECK";
    static final String INCLUDE_KEY = "IDS_REG_LINEAR_SAVE_INCLUDE_CKECK";
    static final String CREATE_COEFFICIENT_STAT_KEY = "IDS_REG_LINEAR_SAVE_CREATE_COEFFICIENT_STAT_CKECK";
    static final String CREATE_DATSET_KEY = "IDS_REG_LINEAR_SAVE_CREATE_DATASET_RADIO";
    static final String WRITE_DATSET_KEY = "IDS_REG_LINEAR_SAVE_WRITE_DATASET_RADIO";
    static final String FILE_NAME_LABEL_KEY = "FILE_NAME_LABEL_KEY";
    static final String DATASET_NAME_KEY = "DATASET_NAME_KEY";
    static final String CONFIDENCE_INTERVAL_KEY = "IDS_CONFIDENCE_INTERVAL_KEY";
    static final double MAX_VALUE = 99.99;
    static final double MIN_VALUE = 1.0E-4;
    static final int PRECISION = 4;
    static final String DEFAULT_VALUE = "95";
    private FileTextField mFileTextField;
    private JCheckBox mUnStdPredictedvaluesCheck;
    private JCheckBox mStdPredictedvaluesCheck;
    private JCheckBox mAdjustedCheck;
    private JCheckBox mSEOfMeanCheck;
    private JCheckBox mUnStdResidualsCheck;
    private JCheckBox mStdResidualsCheck;
    private JCheckBox mStudenttizedCheck;
    private JCheckBox mDeletedCheck;
    private JCheckBox mStudenttizedDeletedCheck;
    private JCheckBox mMahalanobisCheck;
    private JCheckBox mCooksCheck;
    private JCheckBox mLeveragevaluesCheck;
    private JCheckBox mDfBetaCheck;
    private JCheckBox mStandardizedDfBetaCheck;
    private JCheckBox mDfFitCheck;
    private JCheckBox mStandardizedDfFitCheck;
    private JCheckBox mCovarianceRatioCheck;
    private JCheckBox mMeanCheck;
    private JCheckBox mIndividualCheck;
    private FloatTextField mConfidenceIntervalText;
    private JCheckBox mCreateCoefficientCheck;
    private JButton mBrowseButton;
    private JCheckBox mIncludeCovarianceCheck;
    private JRadioButton mCreateDatasetRadio;
    private JRadioButton mWriteDatasetRadio;
    private JButton mFileButton;
    private JLabel mDataSetLabel;
    private StringTextField mDataSetText;
    private SpssButtonGroup mGroup;
    private FileTextField mFileField;

    public LinearRegressionSave(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_REG_LINEAR_SAVE_TITLE"), true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setEnableContinue();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setEnableContinue();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mCreateCoefficientCheck)) {
            this.mCreateDatasetRadio.setEnabled(this.mCreateCoefficientCheck.isSelected());
            this.mWriteDatasetRadio.setEnabled(this.mCreateCoefficientCheck.isSelected());
            this.mDataSetLabel.setEnabled(this.mCreateDatasetRadio.isEnabled() && this.mCreateDatasetRadio.isSelected());
            this.mDataSetText.setEnabled(this.mCreateDatasetRadio.isEnabled() && this.mCreateDatasetRadio.isSelected());
            this.mDataSetText.setOpaque(this.mCreateDatasetRadio.isEnabled() && this.mCreateDatasetRadio.isSelected());
            this.mFileButton.setEnabled(this.mWriteDatasetRadio.isEnabled() && this.mWriteDatasetRadio.isSelected());
            this.mFileField.setEnabled(this.mWriteDatasetRadio.isEnabled() && this.mWriteDatasetRadio.isSelected());
        }
        if (itemEvent.getSource().equals(this.mCreateDatasetRadio)) {
            this.mDataSetLabel.setEnabled(this.mCreateDatasetRadio.isSelected());
            this.mDataSetText.setEnabled(this.mCreateDatasetRadio.isSelected());
            this.mDataSetText.setOpaque(this.mCreateDatasetRadio.isSelected());
        }
        if (itemEvent.getSource().equals(this.mWriteDatasetRadio)) {
            this.mFileButton.setEnabled(this.mWriteDatasetRadio.isSelected());
            this.mFileField.setEnabled(this.mWriteDatasetRadio.isSelected());
        }
        if ((itemEvent.getSource().equals(this.mMeanCheck) || itemEvent.getSource().equals(this.mIndividualCheck)) && (this.mMeanCheck.isSelected() || this.mIndividualCheck.isSelected())) {
            this.mConfidenceIntervalText.setEnabled(true);
            this.mConfidenceIntervalText.setOpaque(true);
        }
        if (!this.mIndividualCheck.isSelected() && !this.mMeanCheck.isSelected()) {
            this.mConfidenceIntervalText.setEnabled(false);
            this.mConfidenceIntervalText.setOpaque(false);
        }
        this.setEnableContinue();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_regr_sav";
    }

    @Override
    public boolean continuePressed() {
        if (!this.isValidateText()) {
            return false;
        }
        return !RemoteFileChooser.enableSaveInModeler() || FileValidator.validatePath((Component)((Object)this), this.mFileTextField.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection());
    }

    public void paint(Graphics graphics) {
        this.mFileField.setText(this.mFileField.getText());
        super.paint(graphics);
        super.validate();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putString(FILE_NAME_LABEL_KEY, this.mFileField.getText());
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        if (dialogDataModel.getString(FILE_NAME_LABEL_KEY) != null) {
            this.mFileField.setText(dialogDataModel.getString(FILE_NAME_LABEL_KEY));
        }
        super.loadState(dialogDataModel);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupPredictedValuesPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        jPanel2 = this.setupDistancesPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, null);
        jPanel2 = this.setupPredictionIntervalsPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, null);
        jPanel2 = this.setupResidualsPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, null);
        jPanel2 = this.setupInfluencePanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 1, 1, 2, n, null);
        jPanel2 = this.setupCoefficientPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 2, 1, n, null);
        jPanel2 = this.setupExportPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 4, 2, 1, n, null);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mUnStdPredictedvaluesCheck);
        vector.add(this.mStdPredictedvaluesCheck);
        vector.add(this.mAdjustedCheck);
        vector.add(this.mSEOfMeanCheck);
        vector.add(this.mMahalanobisCheck);
        vector.add(this.mCooksCheck);
        vector.add(this.mLeveragevaluesCheck);
        vector.add(this.mMeanCheck);
        vector.add(this.mIndividualCheck);
        vector.add(this.mConfidenceIntervalText);
        vector.add(this.mCreateCoefficientCheck);
        vector.add(this.mGroup);
        vector.add(this.mDataSetText);
        vector.add(this.mFileButton);
        vector.add(this.mUnStdResidualsCheck);
        vector.add(this.mStdResidualsCheck);
        vector.add(this.mStudenttizedCheck);
        vector.add(this.mDeletedCheck);
        vector.add(this.mStudenttizedDeletedCheck);
        vector.add(this.mDfBetaCheck);
        vector.add(this.mStandardizedDfBetaCheck);
        vector.add(this.mDfFitCheck);
        vector.add(this.mStandardizedDfFitCheck);
        vector.add(this.mCovarianceRatioCheck);
        vector.add(this.mFileTextField);
        vector.add(this.mBrowseButton);
        vector.add(this.mIncludeCovarianceCheck);
        Component[] componentArray = this.mCmdButtonPanel.getComponents();
        vector.addAll(Arrays.asList(componentArray));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupPredictedValuesPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mUnStdPredictedvaluesCheck, this.mStdPredictedvaluesCheck, this.mAdjustedCheck, this.mSEOfMeanCheck};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_REG_LINEAR_SAVE_PROBABILITIES_BORDER_TITLE"));
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupInfluencePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mDfBetaCheck, this.mStandardizedDfBetaCheck, this.mDfFitCheck, this.mStandardizedDfFitCheck, this.mCovarianceRatioCheck};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_REG_LINEAR_SAVE_INFLUENECE_BORDER_TITLE"));
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupResidualsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mUnStdResidualsCheck, this.mStdResidualsCheck, this.mStudenttizedCheck, this.mDeletedCheck, this.mStudenttizedDeletedCheck};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_REG_LINEAR_SAVE_RESIDUAL_BORDER_TITLE"));
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupDistancesPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mMahalanobisCheck, this.mCooksCheck, this.mLeveragevaluesCheck};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_REG_LINEAR_SAVE_DISTANCES_BORDER_TITLE"));
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupPredictionIntervalsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_REG_LINEAR_SAVE_PREDICTION_INTERVAL_BORDER_TITLE")));
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, n, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        JComponent[] jComponentArray = new JComponent[]{this.mMeanCheck, this.mIndividualCheck};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.xaxis, "");
        DialogUtil.createButtonGroup(jPanel2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 3, 1, n2, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_REG_LINEAR_SAVE_CONFIDENCE_LABEL");
        jLabel.setLabelFor((Component)this.mConfidenceIntervalText);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConfidenceIntervalText, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(0, 5, n, 0);
        JLabel jLabel2 = new JLabel(this.getResString("IDS_REG_LINEAR_SAVE_PERCENTAGE_LABEL"));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 1, 1, 1, n2, insets2);
        return jPanel;
    }

    private JPanel setupCoefficientPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_REG_LINEAR_SAVE_COEFFICIENT_STAT_TITLE")));
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, n, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCreateCoefficientCheck, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCreateDatasetRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        insets2.set(0, 7 * n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDataSetLabel, gridBagConstraints, 0, 2, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(0, 0, 0, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDataSetText), gridBagConstraints, 1, 2, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.set(0, n, 0, 0);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mWriteDatasetRadio, gridBagConstraints, 0, 3, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.set(0, 7 * n, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFileButton, gridBagConstraints, 0, 4, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(0, n, 0, n);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileField), gridBagConstraints, 1, 4, 1, 1, n2, insets2);
        return jPanel;
    }

    private JPanel setupExportPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_REG_LINEAR_SAVE_EXPORT_TO_XML_FILE")));
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, n, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileTextField), gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        insets2.top = n;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mIncludeCovarianceCheck, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        return jPanel;
    }

    private void saveSavFile() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(this.getResString("IDS_REG_LINEAR_SAVE_FILE_TITLE"));
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_REG_LINEAR_SAVE_FILE_DESC_SAV"), this.getResString("IDS_REG_LINEAR_SAVE_FILE_EXT_SAV"));
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showSaveDialog(this.getParent());
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string = remoteFileChooser.getSelectedFilePath();
            String string2 = this.getResString("IDS_REG_LINEAR_SAVE_FILE_EXT_SAV");
            if (!string2.regionMatches(true, 0, string, string.length() - string2.length(), string2.length())) {
                this.mFileField.setText(string + string2);
            } else {
                this.mFileField.setText(string);
            }
            this.setEnableContinue();
        }
    }

    private void saveXmlFile() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(this.getResString("IDS_REG_LINEAR_SAVE_FILE_TITLE"));
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_REG_LINEAR_SAVE_FILE_DESC"), this.getResString("IDS_REG_LINEAR_SAVE_FILE_EXT"));
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showSaveDialog(this.getParent());
        if (n == 0) {
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string = remoteFileChooser.getSelectedFilePath();
            String string2 = this.getResString("IDS_REG_LINEAR_SAVE_FILE_EXT");
            if (!string2.regionMatches(true, 0, string, string.length() - string2.length(), string2.length())) {
                this.mFileTextField.setText(string + string2);
            } else {
                this.mFileTextField.setText(string);
            }
        }
    }

    private void initVars() {
        ControlAction controlAction = new TextFieldAction(this, "EXPORT_XML_FILE_PATH");
        this.mFileTextField = new FileTextField();
        this.mFileTextField.setAction(controlAction);
        FixedLengthDocument fixedLengthDocument = new FixedLengthDocument(255);
        this.mFileTextField.setDocument(fixedLengthDocument);
        this.mFileTextField.setFocusable(true);
        this.mUnStdPredictedvaluesCheck = new JCheckBox(new ToggleButtonAction(this, UNSTANDARD_PREDICTED_KEY));
        this.mStdPredictedvaluesCheck = new JCheckBox(new ToggleButtonAction(this, STANDARD_PREDICTED_KEY));
        this.mAdjustedCheck = new JCheckBox(new ToggleButtonAction(this, ADJUSTED_KEY));
        this.mSEOfMeanCheck = new JCheckBox(new ToggleButtonAction(this, SE_OF_MEAN_KEY));
        this.mUnStdResidualsCheck = new JCheckBox(new ToggleButtonAction(this, UNSTANDARD_RESIDUALS_KEY));
        this.mStdResidualsCheck = new JCheckBox(new ToggleButtonAction(this, STANDARD_RESIDUALS_KEY));
        this.mStudenttizedCheck = new JCheckBox(new ToggleButtonAction(this, STUDENTIZED_KEY));
        this.mDeletedCheck = new JCheckBox(new ToggleButtonAction(this, DELETED_KEY));
        this.mStudenttizedDeletedCheck = new JCheckBox(new ToggleButtonAction(this, STUDENTIZED_DELETED_KEY));
        this.mMahalanobisCheck = new JCheckBox(new ToggleButtonAction(this, MAHALANOBIS_KEY));
        this.mCooksCheck = new JCheckBox(new ToggleButtonAction(this, COOKS_KEY));
        this.mLeveragevaluesCheck = new JCheckBox(new ToggleButtonAction(this, LEVERAGE_KEY));
        this.mDfBetaCheck = new JCheckBox(new ToggleButtonAction(this, DFBETA_KEY));
        this.mStandardizedDfBetaCheck = new JCheckBox(new ToggleButtonAction(this, STANDARD_DFBETA_KEY));
        this.mDfFitCheck = new JCheckBox(new ToggleButtonAction(this, DFFIT_KEY));
        this.mStandardizedDfFitCheck = new JCheckBox(new ToggleButtonAction(this, STANDARD_DFFIT_KEY));
        this.mCovarianceRatioCheck = new JCheckBox(new ToggleButtonAction(this, COVARIANCE_KEY));
        this.mMeanCheck = new JCheckBox(new ToggleButtonAction(this, MEAN_KEY));
        this.mMeanCheck.addItemListener(this);
        this.mIndividualCheck = new JCheckBox(new ToggleButtonAction(this, INDIVIDUAL_KEY));
        this.mIndividualCheck.addItemListener(this);
        controlAction = new ToggleButtonAction(this, "IDS_REG_LINEAR_SAVE_BROWSE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinearRegressionSave.this.saveXmlFile();
            }
        };
        this.mBrowseButton = new JButton(controlAction);
        controlAction = new ToggleButtonAction(this, INCLUDE_KEY);
        this.mIncludeCovarianceCheck = new JCheckBox(controlAction);
        controlAction = new TextFieldAction(this, CONFIDENCE_INTERVAL_KEY);
        this.mConfidenceIntervalText = new FloatTextField(1.0E-4, 99.99, 4, true);
        this.mConfidenceIntervalText.setColumns(4);
        this.mConfidenceIntervalText.setAction((Action)controlAction);
        this.mConfidenceIntervalText.setHorizontalAlignment(4);
        this.mCreateCoefficientCheck = new JCheckBox(new ToggleButtonAction(this, CREATE_COEFFICIENT_STAT_KEY));
        this.mCreateCoefficientCheck.addItemListener(this);
        this.mCreateDatasetRadio = new JRadioButton(new ToggleButtonAction(this, CREATE_DATSET_KEY));
        this.mCreateDatasetRadio.addItemListener(this);
        this.mWriteDatasetRadio = new JRadioButton(new ToggleButtonAction(this, WRITE_DATSET_KEY));
        this.mWriteDatasetRadio.addItemListener(this);
        this.mGroup = new SpssButtonGroup();
        this.mGroup.add(this.mCreateDatasetRadio);
        this.mGroup.add(this.mWriteDatasetRadio);
        controlAction = new TextFieldAction(this, DATASET_NAME_KEY);
        this.mDataSetText = new StringTextField(20);
        this.mDataSetText.setAction(controlAction);
        this.mDataSetText.getDocument().addDocumentListener(this);
        this.mDataSetLabel = DialogUtil.createLabel(this, "IDS_REG_LINEAR_SAVE_DATASET_NAME_LABEL");
        this.mDataSetLabel.setLabelFor((Component)((Object)this.mDataSetText));
        controlAction = new ToggleButtonAction(this, "IDS_REG_LINEAR_SAVE_FILE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinearRegressionSave.this.saveSavFile();
            }
        };
        this.mFileButton = new JButton(controlAction);
        this.mFileField = new FileTextField();
        this.mFileField.setBorder(BorderFactory.createEmptyBorder());
        this.SetDefaults();
    }

    private void SetDefaults() {
        this.mIncludeCovarianceCheck.setSelected(true);
        this.mConfidenceIntervalText.setText(DEFAULT_VALUE);
        this.mConfidenceIntervalText.setOpaque(false);
        this.mConfidenceIntervalText.setEnabled(false);
        this.mCreateDatasetRadio.setSelected(true);
        this.mCreateDatasetRadio.setEnabled(false);
        this.mWriteDatasetRadio.setEnabled(false);
        this.mDataSetLabel.setEnabled(false);
        this.mDataSetText.setEnabled(false);
        this.mDataSetText.setOpaque(false);
        this.mFileButton.setEnabled(false);
        this.mFileField.setEditable(false);
        this.mFileField.setOpaque(false);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mCreateCoefficientCheck.setSelected(false);
            this.mCreateCoefficientCheck.setEnabled(false);
            this.mFileTextField.setEnabled(false);
            this.mBrowseButton.setEnabled(false);
        }
    }

    private boolean isValidateText() {
        if (this.mCreateDatasetRadio.isEnabled() && this.mCreateDatasetRadio.isSelected()) {
            return this.isValidDatasetName((JTextField)((Object)this.mDataSetText));
        }
        return super.continuePressed();
    }

    private boolean isValidDatasetName(JTextField jTextField) {
        boolean bl = false;
        int n = DatasetNameValidator.validateDatasetName((String)jTextField.getText(), (Component)((Object)this));
        if (n == 0) {
            jTextField.selectAll();
            jTextField.requestFocus();
        } else {
            bl = true;
        }
        return bl;
    }

    private void setEnableContinue() {
        if (this.mCreateCoefficientCheck.isSelected()) {
            if (this.mCreateDatasetRadio.isSelected()) {
                this.enableContinue(this.mDataSetText.getText().length() > 0);
            }
            if (this.mWriteDatasetRadio.isSelected() && this.mFileField.getText() != null) {
                this.enableContinue(this.mFileField.getText().length() > 0);
            }
        } else {
            this.enableContinue(true);
        }
    }
}

