/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.linear_reg;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.pro_stats.linear_reg.LinearRegressionDlg;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class LinearRegressionRule
extends BaseSubDialog
implements DocumentListener,
FocusListener {
    public static String RULE_KEY = "IDS_LINEAR_REG_RULE_KEY";
    private JComboBox mRuleCombo;
    private ContextEnabledTextField mValueText;
    private String mVarNameStr;
    private String[] mComboItems;
    private short mType;

    public LinearRegressionRule(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_REG_LINEAR_RULES_TITLE"), true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.mValueText.selectAll();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mValueText.select(0, 0);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_regr_nrule";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mValueText.getText().length() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mValueText.getText().length() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mValueText.getText().length() > 0);
    }

    @Override
    public boolean continuePressed() {
        if (this.mRuleCombo.getItemCount() > 2) {
            if (this.mValueText.getText().equals(".") || this.mValueText.getText().equals("-") || this.mValueText.getText().equals("+")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_REG_LINEAR_RULES_INVALID_VAL_MSG"), VersionInfo.getAppVersionString());
                this.mValueText.requestFocus();
                this.mValueText.selectAll();
                return false;
            }
            double d = Double.parseDouble(this.mValueText.getText());
            if (d < -99999.0 || d > 999999.0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_REG_LINEAR_RULES_INVALID_VAL_MSG"), VersionInfo.getAppVersionString());
                this.mValueText.requestFocus();
                this.mValueText.selectAll();
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        super.saveState(dialogDataModel);
        if (this.mRuleCombo.getSelectedItem().equals(this.mComboItems[0])) {
            if (this.mType > 0) {
                dialogDataModel.putString(RULE_KEY, "=" + CharacterUtil.smartQuote((String)this.mValueText.getText()));
            } else {
                dialogDataModel.putString(RULE_KEY, "=" + this.mValueText.getText());
            }
        }
        if (this.mRuleCombo.getSelectedItem().equals(this.mComboItems[1])) {
            if (this.mType > 0) {
                dialogDataModel.putString(RULE_KEY, "~=" + CharacterUtil.smartQuote((String)this.mValueText.getText()));
            } else {
                dialogDataModel.putString(RULE_KEY, "~=" + this.mValueText.getText());
            }
        }
        if (this.mRuleCombo.getItemCount() > 2) {
            if (this.mRuleCombo.getSelectedItem().equals(this.mComboItems[2])) {
                dialogDataModel.putString(RULE_KEY, "<" + this.mValueText.getText());
            }
            if (this.mRuleCombo.getSelectedItem().equals(this.mComboItems[3])) {
                dialogDataModel.putString(RULE_KEY, "<=" + this.mValueText.getText());
            }
            if (this.mRuleCombo.getSelectedItem().equals(this.mComboItems[4])) {
                dialogDataModel.putString(RULE_KEY, ">" + this.mValueText.getText());
            }
            if (this.mRuleCombo.getSelectedItem().equals(this.mComboItems[5])) {
                dialogDataModel.putString(RULE_KEY, ">=" + this.mValueText.getText());
            }
        }
        return true;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (dialogDataModel.getString(RULE_KEY) != null) {
            String[] stringArray;
            String string = dialogDataModel.getString(RULE_KEY);
            if (string.contains("=")) {
                this.mRuleCombo.setSelectedItem(this.mComboItems[0]);
                stringArray = string.split("=");
                this.mVarNameStr = stringArray[0];
                String string2 = stringArray[1];
                if (string2.contains("'")) {
                    this.mValueText.setText(string2.substring(1, string2.length() - 1));
                } else {
                    this.mValueText.setText(stringArray[1]);
                }
            } else if (string.contains("~=")) {
                this.mRuleCombo.setSelectedItem(this.mComboItems[1]);
                stringArray = string.split("~=");
                this.mVarNameStr = stringArray[0];
                String string3 = stringArray[1];
                if (string3.contains("'")) {
                    this.mValueText.setText(string3.substring(1, string3.length() - 1));
                } else {
                    this.mValueText.setText(stringArray[1]);
                }
            }
            if (string.contains("<")) {
                this.mRuleCombo.setSelectedItem(this.mComboItems[2]);
                stringArray = string.split("<");
                this.mVarNameStr = stringArray[0];
                this.mValueText.setText(stringArray[1]);
            }
            if (string.contains("<=")) {
                this.mRuleCombo.setSelectedItem(this.mComboItems[3]);
                stringArray = string.split("<=");
                this.mVarNameStr = stringArray[0];
                this.mValueText.setText(stringArray[1]);
            }
            if (string.contains(">")) {
                this.mRuleCombo.setSelectedItem(this.mComboItems[4]);
                stringArray = string.split(">");
                this.mVarNameStr = stringArray[0];
                this.mValueText.setText(stringArray[1]);
            }
            if (string.contains(">=")) {
                this.mRuleCombo.setSelectedItem(this.mComboItems[5]);
                stringArray = string.split(">=");
                this.mVarNameStr = stringArray[0];
                this.mValueText.setText(stringArray[1]);
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(this.getResString("IDS_REG_LINEAR_RULES_DEFINE_LABEL"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 22;
        JLabel jLabel2 = new JLabel(this.mVarNameStr);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        n = 23;
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_REG_LINEAR_RULES_VALUE_LABEL");
        jLabel3.setLabelFor((Component)this.mValueText);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRuleCombo, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValueText, gridBagConstraints, 1, 3, 1, 1, n, insets);
        this.mRuleCombo.setSize(new Dimension(149, this.mRuleCombo.getMinimumSize().height));
        this.pack();
    }

    private void initVars() {
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_SELECTION_KEY");
        if (iSpssVariableArray != null && iSpssVariableArray.length != 0) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                this.mType = iSpssVariable.getType();
            }
        }
        if (this.mType != 0) {
            this.mValueText = new StringTextField();
            this.mComboItems = this.getResStringArray("IDS_REG_LINEAR_RULES_RULES_STRING_COMBO");
            this.mRuleCombo = new JComboBox<String>(this.mComboItems);
        } else {
            this.mValueText = new ContextEnabledTextField();
            this.mComboItems = this.getResStringArray("IDS_REG_LINEAR_RULES_RULES_COMBO");
            this.mRuleCombo = new JComboBox<String>(this.mComboItems);
            FixedLengthNumericDocument fixedLengthNumericDocument = new FixedLengthNumericDocument(5, false, true);
            this.mValueText.setDocument((Document)fixedLengthNumericDocument);
        }
        this.mValueText.getDocument().addDocumentListener(this);
        this.mValueText.addFocusListener((FocusListener)this);
        this.mVarNameStr = ((LinearRegressionDlg)this.mParentDlg).getVarName();
        this.setDefaults();
    }

    private void setDefaults() {
        this.enableContinue(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LinearRegressionRule.this.mValueText.requestFocusInWindow();
            }
        });
    }
}

