/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.linear_reg;

import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainListArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class LinearRegressionPlots
extends BaseSubDialog
implements ListDataListener {
    private PlainList mPlainSourceList;
    private PlainList mPlainYList;
    private PlainList mPlainXList;
    private JButton mPreviousButton;
    private JButton mNextButton;
    private JCheckBox mHistogramCheckBox;
    private JCheckBox mNormalCheckBox;
    private JCheckBox mProduceCheckBox;
    private PlainListArrowButton mYArrowButton;
    private PlainListArrowButton mXArrowButton;
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private int mAnchor;
    private int mCurrentLayer;
    private int mTotalLayers;
    private int mMaxNoOfLayers;
    private ArrayList<ArrayList<String>> mTotalLayerList;
    private ScatterLayer mScatterLayer;
    private Vector<Object> mFocus;

    public LinearRegressionPlots(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_REG_LINEAR_PLOTS_DLG_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_regr_plo";
    }

    @Override
    public boolean continuePressed() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mPlainXList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)this.mPlainYList.getModel();
        if (defaultListModel.getSize() > 0 && defaultListModel2.getSize() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add((String)defaultListModel.getElementAt(0));
            arrayList.add((String)defaultListModel2.getElementAt(0));
            if (this.mCurrentLayer < this.mTotalLayerList.size()) {
                this.mTotalLayerList.set(this.mCurrentLayer, arrayList);
            } else {
                this.mTotalLayerList.add(arrayList);
            }
        }
        return true;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mPlainXList.getModel()) {
            this.mXArrowButton.setEnabled(false);
        }
        if (listDataEvent.getSource() == this.mPlainYList.getModel()) {
            this.mYArrowButton.setEnabled(false);
        }
        this.manipulateScatterLayerButtons();
        this.enableContinueButton();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mPlainXList.getModel()) {
            this.mXArrowButton.setEnabled(true);
        }
        if (listDataEvent.getSource() == this.mPlainYList.getModel()) {
            this.mYArrowButton.setEnabled(true);
        }
        this.manipulateScatterLayerButtons();
        this.enableContinueButton();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    protected void init() {
        Component[] componentArray;
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupUI(jPanel);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            if (!(component instanceof JButton)) continue;
            this.mFocus.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mFocus, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        if (dialogDataModel.getInteger("CURRENT_LAYER") != null) {
            this.mCurrentLayer = dialogDataModel.getInteger("CURRENT_LAYER");
            this.mTotalLayers = dialogDataModel.getInteger("TOTAL_LAYERS");
            this.mTotalLayerList = (ArrayList)dialogDataModel.getObject("DATA_OF_LAYERS");
            DefaultListModel defaultListModel = (DefaultListModel)this.mPlainXList.getModel();
            DefaultListModel defaultListModel2 = (DefaultListModel)this.mPlainYList.getModel();
            if (this.mCurrentLayer < this.mTotalLayerList.size()) {
                ArrayList<String> arrayList = this.mTotalLayerList.get(this.mCurrentLayer);
                defaultListModel.addElement(arrayList.get(0));
                defaultListModel2.addElement(arrayList.get(1));
            } else {
                this.manipulateScatterLayerButtons();
            }
            this.mScatterLayer.setLayerTitle(this.mCurrentLayer, this.mTotalLayers);
        }
        super.loadState(dialogDataModel);
        this.mPlainSourceList.setSelectedIndex(0);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putInteger("CURRENT_LAYER", this.mCurrentLayer);
        dialogDataModel.putInteger("TOTAL_LAYERS", this.mTotalLayers);
        dialogDataModel.putObject("DATA_OF_LAYERS", this.mTotalLayerList);
        return super.saveState(dialogDataModel);
    }

    private void enableContinueButton() {
        if (this.mPlainXList.getModel().getSize() == 0 && this.mPlainYList.getModel().getSize() == 0 || this.mPlainXList.getModel().getSize() > 0 && this.mPlainYList.getModel().getSize() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    private void initVars() {
        this.mPlainSourceList = new PlainList("LinearPlotsSourceList", PlainList.DragType.eAutoDragCopy);
        this.mPlainSourceList.setDataSource(true);
        DefaultListModel defaultListModel = (DefaultListModel)this.mPlainSourceList.getModel();
        String[] stringArray = this.getResStringArray("IDS_REG_LINEAR_PLOTS_SOURCE_LIST_CONTENTS");
        for (String string : stringArray) {
            defaultListModel.addElement(string);
        }
        this.mHistogramCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_REG_LINEAR_PLOTS_HISTOGRAM_CHECKBOX"));
        this.mNormalCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_REG_LINEAR_PLOTS_NORMAL_CHECKBOX"));
        this.mXArrowButton = new PlainListArrowButton();
        this.mYArrowButton = new PlainListArrowButton();
        this.mNextButton = new JButton(new LayerButtons("IDS_LAYER_WIDGET_NEXT"));
        this.mPreviousButton = new JButton(new LayerButtons("IDS_LAYER_WIDGET_PREVIOUS"));
        this.mPlainXList = new PlainList("LinearPlotsXList", PlainList.DragType.eAutoDragCopy);
        this.mPlainYList = new PlainList("LinearPlotsYList", PlainList.DragType.eAutoDragCopy);
        this.mPlainXList.getModel().addListDataListener(this);
        this.mPlainYList.getModel().addListDataListener(this);
        this.mPlainXList.setListType(PlainList.ListType.single_item);
        this.mPlainYList.setListType(PlainList.ListType.single_item);
        this.mProduceCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_REG_LINEAR_PLOTS_PRODUCE_CHECKBOX"));
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        this.mAnchor = 23;
        this.mXArrowButton.registerVariableList(this.mPlainSourceList, SpssArrowButton.ButtonOrientation.right);
        this.mXArrowButton.registerVariableList(this.mPlainXList, SpssArrowButton.ButtonOrientation.left);
        this.mYArrowButton.registerVariableList(this.mPlainSourceList, SpssArrowButton.ButtonOrientation.right);
        this.mYArrowButton.registerVariableList(this.mPlainYList, SpssArrowButton.ButtonOrientation.left);
        this.mCurrentLayer = 0;
        this.mTotalLayers = 0;
        this.mMaxNoOfLayers = 8;
        this.mTotalLayerList = new ArrayList(this.mMaxNoOfLayers);
        this.mFocus = new Vector();
        this.mFocus.add(this.mPlainSourceList);
        this.mFocus.add(this.mYArrowButton);
        this.mFocus.add(this.mXArrowButton);
        this.mFocus.add(this.mPlainYList);
        this.mFocus.add(this.mPlainXList);
        this.mFocus.add(this.mNextButton);
        this.mFocus.add(this.mPreviousButton);
        this.mFocus.add(this.mProduceCheckBox);
        this.mFocus.add(this.mHistogramCheckBox);
        this.mFocus.add(this.mNormalCheckBox);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mHistogramCheckBox);
        spssButtonGroup.add(this.mNormalCheckBox);
    }

    private void setDefaults() {
        this.mNextButton.setEnabled(false);
        this.mPreviousButton.setEnabled(false);
    }

    private void setupUI(JPanel jPanel) {
        JPanel jPanel2 = this.setupStdResidualPlotsPanel();
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.mInsets.set(n, n, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.mPlainSourceList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(new Dimension(this.mPlainSourceList.getMinimumSize().width, 20));
        DialogUtil.addUsingGBL(jPanel3, jScrollPane, this.mConstraints, 0, 0, 1, 1, this.mAnchor, null);
        this.mScatterLayer = new ScatterLayer();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(0, n2, 0, n);
        DialogUtil.addUsingGBL(jPanel3, this.mScatterLayer, this.mConstraints, 1, 0, 1, 1, this.mAnchor, this.mInsets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mConstraints, 0, 0, 1, 1, this.mAnchor, null);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        this.mInsets.set(n2, n, n, 0);
        DialogUtil.addUsingGBL(jPanel4, jPanel2, this.mConstraints, 0, 0, 1, 1, this.mAnchor, null);
        this.mInsets.set(n2, n2, n, n);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel4, this.mProduceCheckBox, this.mConstraints, 1, 0, 1, 1, this.mAnchor, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel4, this.mConstraints, 0, 1, 1, 1, this.mAnchor, null);
    }

    private JPanel setupStdResidualPlotsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_REG_LINEAR_PLOTS_STD_RESIDUALS_PANEL")));
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mInsets.set(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mHistogramCheckBox, this.mConstraints, 0, 0, 1, 1, this.mAnchor, this.mInsets);
        this.mInsets.set(insets.top, n, n, n);
        this.mConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mNormalCheckBox, this.mConstraints, 0, 1, 1, 1, this.mAnchor, this.mInsets);
        return jPanel;
    }

    private void manipulateScatterLayerButtons() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mPlainXList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)this.mPlainYList.getModel();
        if (defaultListModel.getSize() == 1 && defaultListModel2.getSize() == 1) {
            if (this.mCurrentLayer == this.mMaxNoOfLayers) {
                this.mNextButton.setEnabled(false);
                this.mPreviousButton.setEnabled(true);
            } else if (this.mCurrentLayer == 0) {
                this.mNextButton.setEnabled(true);
                this.mPreviousButton.setEnabled(false);
            } else {
                this.mNextButton.setEnabled(true);
                this.mPreviousButton.setEnabled(true);
            }
        } else if (defaultListModel.getSize() == 0 && defaultListModel2.getSize() == 0) {
            if (this.mTotalLayers == 0) {
                this.mNextButton.setEnabled(false);
                this.mPreviousButton.setEnabled(false);
            } else if (this.mCurrentLayer == 0) {
                this.mNextButton.setEnabled(true);
                this.mPreviousButton.setEnabled(false);
            } else if (this.mCurrentLayer == this.mTotalLayers) {
                this.mNextButton.setEnabled(false);
                this.mPreviousButton.setEnabled(true);
            } else {
                this.mNextButton.setEnabled(true);
                this.mPreviousButton.setEnabled(true);
            }
        } else {
            this.mNextButton.setEnabled(false);
            this.mPreviousButton.setEnabled(false);
        }
    }

    private void resetLayer() {
        ((DefaultListModel)this.mPlainXList.getModel()).removeAllElements();
        ((DefaultListModel)this.mPlainYList.getModel()).removeAllElements();
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(this.mPlainSourceList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mPlainSourceList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mPlainSourceList, this.mPlainListVarMoveHandler));
        plainListDragAdapter = new PlainListDragAdapter(this.mPlainXList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mPlainXList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mPlainXList, this.mPlainListVarMoveHandler));
        plainListDragAdapter = new PlainListDragAdapter(this.mPlainYList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mPlainYList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mPlainYList, this.mPlainListVarMoveHandler));
    }

    private class ScatterLayer
    extends JPanel {
        ScatterLayer() {
            this.setLayout(new GridBagLayout());
            this.setLayerTitle(LinearRegressionPlots.this.mCurrentLayer, LinearRegressionPlots.this.mTotalLayers);
            this.setupLayeredUI();
        }

        public void setLayerTitle(int n, int n2) {
            this.setBorder(BorderFactory.createTitledBorder(LinearRegressionPlots.this.getResString("IDS_REG_LINEAR_PLOTS_SCATTER_PANEL") + " " + (n + 1) + " " + LinearRegressionPlots.this.getResString("IDS_REG_LINEAR_PLOTS_SCATTER_OF_PANEL") + " " + (n2 + 1)));
        }

        private void setupLayeredUI() {
            ((LinearRegressionPlots)LinearRegressionPlots.this).mConstraints.weightx = 0.0;
            ((LinearRegressionPlots)LinearRegressionPlots.this).mConstraints.weighty = 0.0;
            ((LinearRegressionPlots)LinearRegressionPlots.this).mConstraints.fill = 0;
            int n = DialogUtil.getGroupBoxInnerMargin();
            int n2 = DialogUtil.getComponentGroupGap();
            Insets insets = DialogUtil.getArrowButtonInsets();
            LinearRegressionPlots.this.mInsets.set(n, n, 0, 0);
            DialogUtil.addUsingGBL(this, LinearRegressionPlots.this.mPreviousButton, LinearRegressionPlots.this.mConstraints, 0, 0, 1, 1, LinearRegressionPlots.this.mAnchor, LinearRegressionPlots.this.mInsets);
            LinearRegressionPlots.this.mInsets.set(n, insets.left, 0, n);
            DialogUtil.addUsingGBL(this, LinearRegressionPlots.this.mNextButton, LinearRegressionPlots.this.mConstraints, 1, 0, 1, 1, 24, LinearRegressionPlots.this.mInsets);
            DialogUtil.normalizeButtonWidths((JPanel)this);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder());
            DialogUtil.addUsingGBL(jPanel, LinearRegressionPlots.this.mYArrowButton, LinearRegressionPlots.this.mConstraints, 0, 0, 1, 2, 20, null);
            ((LinearRegressionPlots)LinearRegressionPlots.this).mConstraints.weightx = 1.0;
            ((LinearRegressionPlots)LinearRegressionPlots.this).mConstraints.fill = 2;
            JLabel jLabel = DialogUtil.createLabel(LinearRegressionPlots.this, "IDS_REG_LINEAR_PLOTS_Y_LABEL");
            jLabel.setLabelFor(LinearRegressionPlots.this.mPlainYList);
            LinearRegressionPlots.this.mInsets.set(n2, insets.left, 0, 0);
            DialogUtil.addUsingGBL(jPanel, jLabel, LinearRegressionPlots.this.mConstraints, 1, 0, 1, 1, LinearRegressionPlots.this.mAnchor, LinearRegressionPlots.this.mInsets);
            LinearRegressionPlots.this.mInsets.set(0, insets.left, 0, n);
            JScrollPane jScrollPane = new JScrollPane(LinearRegressionPlots.this.mPlainYList);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setVerticalScrollBarPolicy(21);
            jScrollPane.setPreferredSize(LinearRegressionPlots.this.mPlainYList.getMinimumSize());
            DialogUtil.addUsingGBL(jPanel, jScrollPane, LinearRegressionPlots.this.mConstraints, 1, 1, 1, 1, LinearRegressionPlots.this.mAnchor, LinearRegressionPlots.this.mInsets);
            ((LinearRegressionPlots)LinearRegressionPlots.this).mConstraints.weightx = 0.0;
            ((LinearRegressionPlots)LinearRegressionPlots.this).mConstraints.fill = 0;
            LinearRegressionPlots.this.mInsets.set(n, 0, n, 0);
            DialogUtil.addUsingGBL(jPanel, LinearRegressionPlots.this.mXArrowButton, LinearRegressionPlots.this.mConstraints, 0, 2, 1, 2, 20, LinearRegressionPlots.this.mInsets);
            ((LinearRegressionPlots)LinearRegressionPlots.this).mConstraints.fill = 2;
            JLabel jLabel2 = DialogUtil.createLabel(LinearRegressionPlots.this, "IDS_REG_LINEAR_PLOTS_X_LABEL");
            jLabel2.setLabelFor(LinearRegressionPlots.this.mPlainXList);
            LinearRegressionPlots.this.mInsets.set(n, insets.left, 0, n);
            ((LinearRegressionPlots)LinearRegressionPlots.this).mConstraints.weightx = 1.0;
            DialogUtil.addUsingGBL(jPanel, jLabel2, LinearRegressionPlots.this.mConstraints, 1, 2, 1, 1, LinearRegressionPlots.this.mAnchor, LinearRegressionPlots.this.mInsets);
            LinearRegressionPlots.this.mInsets.set(0, insets.left, n, n);
            JScrollPane jScrollPane2 = new JScrollPane(LinearRegressionPlots.this.mPlainXList);
            jScrollPane2.setHorizontalScrollBarPolicy(31);
            jScrollPane2.setVerticalScrollBarPolicy(21);
            jScrollPane2.setPreferredSize(LinearRegressionPlots.this.mPlainXList.getMinimumSize());
            DialogUtil.addUsingGBL(jPanel, jScrollPane2, LinearRegressionPlots.this.mConstraints, 1, 3, 1, 1, LinearRegressionPlots.this.mAnchor, LinearRegressionPlots.this.mInsets);
            ((LinearRegressionPlots)LinearRegressionPlots.this).mConstraints.weighty = 1.0;
            LinearRegressionPlots.this.mInsets.set(0, n, 0, 0);
            DialogUtil.addUsingGBL(this, jPanel, LinearRegressionPlots.this.mConstraints, 0, 1, 2, 1, LinearRegressionPlots.this.mAnchor, LinearRegressionPlots.this.mInsets);
        }
    }

    private class LayerButtons
    extends ToggleButtonAction {
        public LayerButtons(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            String string2 = null;
            ArrayList arrayList = new ArrayList();
            if (LinearRegressionPlots.this.mPlainXList.getModel().getSize() > 0 && LinearRegressionPlots.this.mPlainYList.getModel().getSize() > 0) {
                string = (String)LinearRegressionPlots.this.mPlainXList.getModel().getElementAt(0);
                string2 = (String)LinearRegressionPlots.this.mPlainYList.getModel().getElementAt(0);
                arrayList.add(string);
                arrayList.add(string2);
                if (LinearRegressionPlots.this.mCurrentLayer >= LinearRegressionPlots.this.mTotalLayerList.size()) {
                    LinearRegressionPlots.this.mTotalLayerList.add(LinearRegressionPlots.this.mCurrentLayer, arrayList);
                } else {
                    LinearRegressionPlots.this.mTotalLayerList.set(LinearRegressionPlots.this.mCurrentLayer, arrayList);
                }
                if (actionEvent.getSource() == LinearRegressionPlots.this.mPreviousButton) {
                    LinearRegressionPlots.this.resetLayer();
                    LinearRegressionPlots.this.mCurrentLayer--;
                    LinearRegressionPlots.this.mScatterLayer.setLayerTitle(LinearRegressionPlots.this.mCurrentLayer, LinearRegressionPlots.this.mTotalLayers);
                    arrayList = (ArrayList)LinearRegressionPlots.this.mTotalLayerList.get(LinearRegressionPlots.this.mCurrentLayer);
                    ((DefaultListModel)LinearRegressionPlots.this.mPlainXList.getModel()).addElement(arrayList.get(0));
                    ((DefaultListModel)LinearRegressionPlots.this.mPlainYList.getModel()).addElement(arrayList.get(1));
                } else {
                    LinearRegressionPlots.this.resetLayer();
                    LinearRegressionPlots.this.mCurrentLayer++;
                    if (LinearRegressionPlots.this.mCurrentLayer < LinearRegressionPlots.this.mTotalLayerList.size()) {
                        arrayList = (ArrayList)LinearRegressionPlots.this.mTotalLayerList.get(LinearRegressionPlots.this.mCurrentLayer);
                        ((DefaultListModel)LinearRegressionPlots.this.mPlainXList.getModel()).addElement(arrayList.get(0));
                        ((DefaultListModel)LinearRegressionPlots.this.mPlainYList.getModel()).addElement(arrayList.get(1));
                    } else {
                        LinearRegressionPlots.this.mTotalLayers++;
                    }
                    LinearRegressionPlots.this.mScatterLayer.setLayerTitle(LinearRegressionPlots.this.mCurrentLayer, LinearRegressionPlots.this.mTotalLayers);
                }
            } else if (LinearRegressionPlots.this.mCurrentLayer < LinearRegressionPlots.this.mTotalLayerList.size()) {
                LinearRegressionPlots.this.mTotalLayerList.remove(LinearRegressionPlots.this.mCurrentLayer);
                LinearRegressionPlots.this.mTotalLayers--;
                if (LinearRegressionPlots.this.mCurrentLayer >= LinearRegressionPlots.this.mTotalLayerList.size()) {
                    LinearRegressionPlots.this.mCurrentLayer--;
                } else if (actionEvent.getSource() == LinearRegressionPlots.this.mPreviousButton) {
                    LinearRegressionPlots.this.mCurrentLayer--;
                }
                arrayList = (ArrayList)LinearRegressionPlots.this.mTotalLayerList.get(LinearRegressionPlots.this.mCurrentLayer);
                ((DefaultListModel)LinearRegressionPlots.this.mPlainXList.getModel()).addElement(arrayList.get(0));
                ((DefaultListModel)LinearRegressionPlots.this.mPlainYList.getModel()).addElement(arrayList.get(1));
                LinearRegressionPlots.this.mScatterLayer.setLayerTitle(LinearRegressionPlots.this.mCurrentLayer, LinearRegressionPlots.this.mTotalLayers);
            } else {
                LinearRegressionPlots.this.mCurrentLayer--;
                LinearRegressionPlots.this.mTotalLayers--;
                arrayList = (ArrayList)LinearRegressionPlots.this.mTotalLayerList.get(LinearRegressionPlots.this.mCurrentLayer);
                ((DefaultListModel)LinearRegressionPlots.this.mPlainXList.getModel()).addElement(arrayList.get(0));
                ((DefaultListModel)LinearRegressionPlots.this.mPlainYList.getModel()).addElement(arrayList.get(1));
                LinearRegressionPlots.this.mScatterLayer.setLayerTitle(LinearRegressionPlots.this.mCurrentLayer, LinearRegressionPlots.this.mTotalLayers);
            }
            LinearRegressionPlots.this.manipulateScatterLayerButtons();
            LinearRegressionPlots.this.mPlainSourceList.requestFocus();
        }
    }
}

