/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.linear_reg;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class LinearRegressionOptions
extends BaseSubDialog
implements DocumentListener,
ItemListener {
    static final double MIN_ENTRY_USE_PROB = 0.001;
    static final double MAX_ENTRY_USE_PROB = 0.999;
    static final double MAX_REMOVAL_USE_PROB = 1.0;
    static final double MIN_REMOVAL_USE_PROB = 0.002;
    static final double MAX_ENTRY_USE_F = 99999.0;
    static final double MIN_ENTRY_USE_F = 2.0E-4;
    static final double MIN_REMOVAL_USE_F = 1.0E-4;
    static final double MAX_REMOVAL_USE_F = 99998.0;
    static final String DEFAULT_ENTRY_USE_PROB = ".05";
    static final String DEFAULT_REMOVAL_USE_PROB = ".10";
    static final String DEFAULT_ENTRY_USE_F = "3.84";
    static final String DEFAULT_REMOVAL_USE_F = "2.71";
    public static String USE_PROBABILITY_KEY = "IDS_LINEAR_REG_OPTIONS_USE_PROBAB_RADIO";
    public static String USE_F_VALUE_KEY = "IDS_LINEAR_REG_OPTIONS_USE_F_VALUE_RADIO";
    public static String USE_F_VALUE_ENTRY_KEY = "USE_F_VALUE_ENTRY_TEXT";
    public static String USE_PROBABILITY_ENTRY_KEY = "USE_PROBAB_ENTRY_TEXT";
    public static String USE_PROBABILITY_REMOVAL_KEY = "USE_PROBAB_REMOVAL_TEXT";
    public static String USE_F_VALUE_REMOVAL_KEY = "USE_F_VALUE_REMOVAL_TEXT";
    public static String INCLUDE_CONSTANT_KEY = "IDS_LINEAR_REG_OPTIONS_INCLUDE_CONSTANT_CHECK";
    public static String EXCLUDE_LISTWISE_KEY = "IDS_LINEAR_REG_OPTIONS_LISTWISE_RADIO";
    public static String EXCLUDE_PAIRWISE_KEY = "IDS_LINEAR_REG_OPTIONS_PAIRWISE_RADIO";
    public static String REPLACE_MEAN_KEY = "IDS_LINEAR_REG_OPTIONS_REPLACE_MEAN_RADIO";
    private JRadioButton mUseProbabilityRadio;
    private JRadioButton mUseFValueRadio;
    private JLabel mEntryUseProbLabel;
    private JLabel mEntryUseFValueLabel;
    private JLabel mRemovalUseProbLabel;
    private JLabel mRemovalUseFValueLabel;
    private FloatTextField mEntryUseProbText;
    private FloatTextField mRemovalUseProbText;
    private FloatTextField mEntryUseFValueText;
    private FloatTextField mRemovalUseFValueText;
    private JCheckBox mIncludeConstantCheck;
    private JRadioButton mExcludeCasesListwiseRadio;
    private JRadioButton mExcludeCasesPairwiseRadio;
    private JRadioButton mReplaceRadio;
    private SpssButtonGroup mSteppingGroup;
    private SpssButtonGroup mMissingValueGroup;

    public LinearRegressionOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_REG_LINEAR_OPTIONS_TITLE"), true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mUseProbabilityRadio)) {
            this.mEntryUseProbLabel.setEnabled(this.mUseProbabilityRadio.isSelected());
            this.mEntryUseProbText.setEnabled(this.mUseProbabilityRadio.isSelected());
            this.mEntryUseProbText.setOpaque(this.mUseProbabilityRadio.isSelected());
            this.mRemovalUseProbLabel.setEnabled(this.mUseProbabilityRadio.isSelected());
            this.mRemovalUseProbText.setEnabled(this.mUseProbabilityRadio.isSelected());
            this.mRemovalUseProbText.setOpaque(this.mUseProbabilityRadio.isSelected());
        }
        if (itemEvent.getSource().equals(this.mUseFValueRadio)) {
            this.mEntryUseFValueLabel.setEnabled(this.mUseFValueRadio.isSelected());
            this.mEntryUseFValueText.setEnabled(this.mUseFValueRadio.isSelected());
            this.mEntryUseFValueText.setOpaque(this.mUseFValueRadio.isSelected());
            this.mRemovalUseFValueLabel.setEnabled(this.mUseFValueRadio.isSelected());
            this.mRemovalUseFValueText.setEnabled(this.mUseFValueRadio.isSelected());
            this.mRemovalUseFValueText.setOpaque(this.mUseFValueRadio.isSelected());
        }
        this.setEnableContinue();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_regr_opt";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setEnableContinue();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setEnableContinue();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public boolean continuePressed() {
        return this.isValidate();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putString(USE_PROBABILITY_ENTRY_KEY, this.mEntryUseProbText.getText());
        dialogDataModel.putString(USE_PROBABILITY_REMOVAL_KEY, this.mRemovalUseProbText.getText());
        dialogDataModel.putString(USE_F_VALUE_ENTRY_KEY, this.mEntryUseFValueText.getText());
        dialogDataModel.putString(USE_F_VALUE_REMOVAL_KEY, this.mRemovalUseFValueText.getText());
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        if (dialogDataModel.getString(USE_PROBABILITY_ENTRY_KEY) != null) {
            this.mEntryUseProbText.setText(dialogDataModel.getString(USE_PROBABILITY_ENTRY_KEY));
        }
        if (dialogDataModel.getString(USE_PROBABILITY_REMOVAL_KEY) != null) {
            this.mRemovalUseProbText.setText(dialogDataModel.getString(USE_PROBABILITY_REMOVAL_KEY));
        }
        if (dialogDataModel.getString(USE_F_VALUE_ENTRY_KEY) != null) {
            this.mEntryUseFValueText.setText(dialogDataModel.getString(USE_F_VALUE_ENTRY_KEY));
        }
        if (dialogDataModel.getString(USE_F_VALUE_REMOVAL_KEY) != null) {
            this.mRemovalUseFValueText.setText(dialogDataModel.getString(USE_F_VALUE_REMOVAL_KEY));
        }
        super.loadState(dialogDataModel);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupSteppingMethodPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mIncludeConstantCheck, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupMissingVluesPanel(), gridBagConstraints, 0, 2, 1, 1, n, null);
        this.setFocusTraversalPolicy();
        this.setDefaults();
        this.pack();
    }

    private JPanel setupSteppingMethodPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_LINEAR_REG_OPTIONS_STEPPING_METHOD_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JComponent[] jComponentArray = new JComponent[]{this.mUseProbabilityRadio, this.mEntryUseProbLabel, this.mEntryUseProbText, this.mRemovalUseProbLabel, this.mRemovalUseProbText};
        JPanel jPanel2 = this.setupPanel(jComponentArray);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        JComponent[] jComponentArray2 = new JComponent[]{this.mUseFValueRadio, this.mEntryUseFValueLabel, this.mEntryUseFValueText, this.mRemovalUseFValueLabel, this.mRemovalUseFValueText};
        gridBagConstraints.weighty = 1.0;
        jPanel2 = this.setupPanel(jComponentArray2);
        Insets insets = new Insets(0, 0, 11, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupPanel(JComponent[] jComponentArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 0, 0, 4, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        insets.set(0, 2 * n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[2], gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[3], gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[4], gridBagConstraints, 3, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupMissingVluesPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mExcludeCasesListwiseRadio, this.mExcludeCasesPairwiseRadio, this.mReplaceRadio};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_LINEAR_REG_OPTIONS_MISSING_VALUE_TITLE"));
        this.mMissingValueGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private void initVars() {
        this.mUseProbabilityRadio = new JRadioButton(new ToggleButtonAction(this, USE_PROBABILITY_KEY));
        this.mUseProbabilityRadio.addItemListener(this);
        this.mUseFValueRadio = new JRadioButton(new ToggleButtonAction(this, USE_F_VALUE_KEY));
        this.mUseFValueRadio.addItemListener(this);
        this.mIncludeConstantCheck = new JCheckBox(new ToggleButtonAction(this, INCLUDE_CONSTANT_KEY));
        this.mExcludeCasesListwiseRadio = new JRadioButton(new ToggleButtonAction(this, EXCLUDE_LISTWISE_KEY));
        this.mExcludeCasesPairwiseRadio = new JRadioButton(new ToggleButtonAction(this, EXCLUDE_PAIRWISE_KEY));
        this.mReplaceRadio = new JRadioButton(new ToggleButtonAction(this, REPLACE_MEAN_KEY));
        this.mEntryUseProbText = new FloatTextField(0.001, 0.999, 3, true);
        this.mEntryUseProbText.getDocument().addDocumentListener(this);
        this.mRemovalUseProbText = new FloatTextField(0.002, 1.0, 3, true);
        this.mRemovalUseProbText.setText(DEFAULT_REMOVAL_USE_PROB);
        this.mRemovalUseProbText.getDocument().addDocumentListener(this);
        this.mEntryUseFValueText = new FloatTextField(2.0E-4, 99999.0, 4, true);
        this.mEntryUseFValueText.setText(DEFAULT_ENTRY_USE_F);
        this.mEntryUseFValueText.getDocument().addDocumentListener(this);
        this.mRemovalUseFValueText = new FloatTextField(1.0E-4, 99998.0, 4, true);
        this.mRemovalUseFValueText.setText(DEFAULT_REMOVAL_USE_F);
        this.mRemovalUseFValueText.getDocument().addDocumentListener(this);
        this.mEntryUseProbLabel = DialogUtil.createLabel(this, "IDS_LINEAR_REG_OPTIONS_USE_PROBAB_ENTRY_LBL");
        this.mEntryUseProbLabel.setLabelFor((Component)this.mEntryUseProbText);
        this.mRemovalUseProbLabel = DialogUtil.createLabel(this, "IDS_LINEAR_REG_OPTIONS_USE_PROBAB_REMOVAL_LBL");
        this.mRemovalUseProbLabel.setLabelFor((Component)this.mRemovalUseProbText);
        this.mEntryUseFValueLabel = DialogUtil.createLabel(this, "IDS_LINEAR_REG_OPTIONS_USE_F_VAL_ENTRY_LBL");
        this.mEntryUseFValueLabel.setLabelFor((Component)this.mEntryUseFValueText);
        this.mRemovalUseFValueLabel = DialogUtil.createLabel(this, "IDS_LINEAR_REG_OPTIONS_USE_F_VAL_REMOVAL_LBL");
        this.mRemovalUseFValueLabel.setLabelFor((Component)this.mRemovalUseFValueText);
        this.mSteppingGroup = new SpssButtonGroup();
        this.mSteppingGroup.add(this.mUseProbabilityRadio);
        this.mSteppingGroup.add(this.mUseFValueRadio);
    }

    private void setFocusTraversalPolicy() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSteppingGroup);
        vector.add(this.mEntryUseProbText);
        vector.add(this.mRemovalUseProbText);
        vector.add(this.mEntryUseFValueText);
        vector.add(this.mRemovalUseFValueText);
        vector.add(this.mIncludeConstantCheck);
        vector.add(this.mMissingValueGroup);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mIncludeConstantCheck.setSelected(true);
        this.mExcludeCasesListwiseRadio.setSelected(true);
        this.mEntryUseFValueLabel.setEnabled(false);
        this.mEntryUseFValueText.setEnabled(false);
        this.mEntryUseFValueText.setOpaque(false);
        this.mRemovalUseFValueLabel.setEnabled(false);
        this.mRemovalUseFValueText.setEnabled(false);
        this.mRemovalUseFValueText.setOpaque(false);
        this.mEntryUseProbText.setText(DEFAULT_ENTRY_USE_PROB);
        this.mUseProbabilityRadio.setSelected(true);
    }

    private void setEnableContinue() {
        if (this.mUseProbabilityRadio.isSelected()) {
            if (this.mEntryUseProbText.getText().length() < 1 || this.mRemovalUseProbText.getText().length() < 1) {
                this.enableContinue(false);
            } else {
                this.enableContinue(true);
            }
        }
        if (this.mUseFValueRadio.isSelected()) {
            if (this.mEntryUseFValueText.getText().length() < 1 || this.mRemovalUseFValueText.getText().length() < 1) {
                this.enableContinue(false);
            } else {
                this.enableContinue(true);
            }
        }
    }

    private boolean isValidate() {
        if (this.mUseProbabilityRadio.isSelected() && Double.valueOf(this.mEntryUseProbText.getText()) >= Double.valueOf(this.mRemovalUseProbText.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_LINEAR_REG_OPTIONS_ERR_MSG"), VersionInfo.getAppVersionString());
            this.mEntryUseProbText.setSelectionStart(0);
            this.mEntryUseProbText.setSelectionEnd(this.mEntryUseProbText.getText().length());
            this.mEntryUseProbText.requestFocus();
            return false;
        }
        if (this.mUseFValueRadio.isSelected() && Double.valueOf(this.mEntryUseFValueText.getText()) <= Double.valueOf(this.mRemovalUseFValueText.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_LINEAR_REG_OPTIONS_ERR_MSG"), VersionInfo.getAppVersionString());
            this.mRemovalUseFValueText.setSelectionStart(0);
            this.mRemovalUseFValueText.setSelectionEnd(this.mRemovalUseFValueText.getText().length());
            this.mRemovalUseFValueText.requestFocus();
            return false;
        }
        return true;
    }
}

