/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.pro_stats.linear_reg;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.LayeredListWidget;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.dialogs.post_processing_output.TableStyleDlg;
import com.spss.java_client.ui.dialogs.pro_stats.linear_reg.LinearListCellRenderer;
import com.spss.java_client.ui.dialogs.pro_stats.linear_reg.LinearRegressionOptions;
import com.spss.java_client.ui.dialogs.pro_stats.linear_reg.LinearRegressionPlots;
import com.spss.java_client.ui.dialogs.pro_stats.linear_reg.LinearRegressionRule;
import com.spss.java_client.ui.dialogs.pro_stats.linear_reg.LinearRegressionSave;
import com.spss.java_client.ui.dialogs.pro_stats.linear_reg.LinearRegressionStatistics;
import com.spss.java_client.ui.dialogs.pro_stats.linear_reg.LinearRegressionUtils;
import com.spss.java_client.ui.dialogs.pro_stats.res.ProStatsResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LinearRegressionDlg
extends BaseProcedureDialog
implements ItemListener,
ListDataListener,
ListSelectionListener,
FocusListener,
IVarMoveHandler {
    public static final String LAYERED_LIST_IDENTIFIER = "LINEAR_LAYERED_LIST";
    static final int MAX_NUMBER_OF_LAYER = 9;
    static final String DEPENDENT_KEY = "IDS_DEPENDENT_KEY";
    static final String SELECTION_KEY = "IDS_SELECTION_KEY";
    static final String CASELABELS_KEY = "IDS_CASELABELS_KEY";
    static final String WLSWEIGHT_KEY = "IDS_WLSWEIGHT_KEY";
    static final String RULE_KEY = "IDS_REG_LINEAR_RULE_BUTTON";
    static final String COUNT_KEY = "IDS_REG_LINEAR_COUNT_KEY";
    protected int mCount;
    private static Set<ISpssVariable> mSet;
    private String mVarName;
    private boolean mRuleSelected;
    private JButton mStatButton;
    private JButton mPlotsButton;
    private JButton mSaveButton;
    private JButton mOptionsButton;
    private JButton mBootstrappingButton;
    private JButton mTableStyleButton;
    private TargetVariableList mDependentTargetList;
    private TargetVariableList mSelectionVarTargetList;
    private TargetVariableList mCaseLabelsTargetList;
    private TargetVariableList mWlsWeightTargetList;
    private JButton mRuleButton;
    private SrcVariableList mSrcVarList;
    private ArrowButton mDependentVarArrowButton;
    private ArrowButton mSelectionVarArrowButton;
    private ArrowButton mCaseLabelsArrowButton;
    private ArrowButton mWlsWeightArrowButton;
    private LayeredListWidget mLayerWidget;
    private JComboBox mMethodCombo;
    private String[] mMethodComboitem;
    private String[] mMethodStr;
    private Insets mArrowInsets;
    private TargetVariableList mLayerList;
    private boolean mIsBootstrapOK;

    public LinearRegressionDlg(JFrame jFrame) {
        super(jFrame, false, ProStatsResBundle.getDefaultResourceBundleName(), ProStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_REG_LINEAR_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_regs";
    }

    @Override
    public boolean okPastePressed() {
        if (this.mIsBootstrapOK && this.mBootstrappingButton.isEnabled() && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runSubDialog(new BootstrapDlg(this));
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String generateSyntax() {
        CharSequence charSequence;
        String string;
        CharSequence charSequence2;
        Object object;
        Object object2;
        String string2;
        Object object3;
        Object object4;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        ArrayList<VarListModel> arrayList = this.mLayerWidget.getVarListModels();
        Iterator<VarListModel> iterator = arrayList.iterator();
        DialogDataModel dialogDataModel = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        int n = 0;
        boolean bl = false;
        if (this.mIsBootstrapOK && this.mBootstrappingButton.isEnabled() && dialogDataModel != null) {
            bl = true;
            object4 = "";
            object3 = "";
            String string3 = this.mDependentTargetList.getVariablesStringList();
            string2 = this.mWlsWeightTargetList.getVariablesStringList() + " " + this.mSelectionVarTargetList.getVariablesStringList() + " ";
            object2 = new Vector();
            while (iterator.hasNext()) {
                object = iterator.next();
                for (int i = 0; i < ((VarListModel)object).getSize(); ++i) {
                    String string4 = ((VarListModel)object).getElementAt(i).getName();
                    if (((Vector)object2).contains(string4)) continue;
                    ((Vector)object2).add(string4);
                    string2 = string2 + string4 + " ";
                }
            }
            stringBuffer.append(BootstrapDlg.getBootstrapSyntax(string3, string2, dialogDataModel));
            iterator = arrayList.iterator();
        }
        object4 = this.getDialogDataModel();
        object3 = ((DialogDataModel)object4).getBoolean("IDS_REG_LINEAR_SAVE_CREATE_COEFFICIENT_STAT_CKECK");
        boolean bl2 = false;
        string2 = "";
        if (object3 != null && ((Boolean)object3).booleanValue() && (object3 = ((DialogDataModel)object4).getBoolean("IDS_REG_LINEAR_SAVE_CREATE_DATASET_RADIO")) != null && ((Boolean)object3).booleanValue()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("DATASET DECLARE "));
            string2 = ((DialogDataModel)object4).getString("DATASET_NAME_KEY");
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string2));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            bl2 = true;
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("REGRESSION"));
        stringBuffer.append("\n");
        object3 = ((DialogDataModel)object4).getBoolean("IDS_REG_LINEAR_STATISTICS_DESCRIPTIVES_CHECKBOX");
        if (object3 != null && ((Boolean)object3).booleanValue()) {
            stringBuffer.append(LinearRegressionUtils.generateDescriptiveStatisticsSyntax((DialogDataModel)object4)).append("\n");
        }
        stringBuffer.append(LinearRegressionUtils.generateSelectSyntax((DialogDataModel)object4, this.mSelectionVarTargetList));
        stringBuffer.append(LinearRegressionUtils.generateMissingSyntax((DialogDataModel)object4));
        if (this.mWlsWeightTargetList.getVariablesStringList().length() != 0) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("REGWGT", this.mWlsWeightTargetList.getVariablesStringList(), true));
        }
        if (((String)(object2 = LinearRegressionUtils.generateStatisticsSyntax((DialogDataModel)object4))).trim().length() > 0) {
            stringBuffer.append((String)object2).append("\n");
        }
        stringBuffer.append(LinearRegressionUtils.generateCriteriaSyntax((DialogDataModel)object4));
        object3 = ((DialogDataModel)object4).getBoolean(LinearRegressionOptions.INCLUDE_CONSTANT_KEY);
        if (object3 != null) {
            if (((Boolean)object3).booleanValue()) {
                stringBuffer.append(LinearRegressionUtils.generateOriginOrNoOriginSyntax("NOORIGIN", "", true));
            } else {
                stringBuffer.append(LinearRegressionUtils.generateOriginOrNoOriginSyntax("ORIGIN", "", true));
            }
        } else {
            stringBuffer.append(LinearRegressionUtils.generateOriginOrNoOriginSyntax("NOORIGIN", "", true));
        }
        if (this.mDependentTargetList.getVariablesStringList().length() != 0) {
            stringBuffer.append(SyntaxUtil.getSingleParameterSubCommand("DEPENDENT", "" + this.mDependentTargetList.getVariablesStringList(), false));
        }
        while (iterator.hasNext()) {
            object = new StringBuffer(this.mMethodStr[n]);
            VarListModel varListModel = iterator.next();
            for (int i = 0; i < varListModel.getSize(); ++i) {
                charSequence2 = varListModel.getElementAt(i).getName();
                ((StringBuffer)object).append(" ").append((String)charSequence2);
            }
            if (varListModel.getSize() > 0) {
                stringBuffer.append("\n").append(SyntaxUtil.getSingleValueSubCommand("METHOD", ((StringBuffer)object).toString(), false));
            }
            ++n;
        }
        object = LinearRegressionUtils.generatePartialPlotSyntax((DialogDataModel)object4);
        if (!((String)object).equals("")) {
            stringBuffer.append("\n").append((String)object);
        }
        if (!((String)(object = LinearRegressionUtils.generateScatterPlotSyntax((DialogDataModel)object4))).equals("")) {
            stringBuffer.append("\n").append((String)object);
        }
        if (!((String)(object = LinearRegressionUtils.generateResidualStatisticsSyntax((DialogDataModel)object4))).equals("")) {
            stringBuffer.append("\n").append((String)object);
            if (this.mCaseLabelsTargetList.getVariablesStringList().length() != 0) {
                stringBuffer.append(" ID(").append(this.mCaseLabelsTargetList.getVariablesStringList()).append(")");
            }
        } else if (this.mCaseLabelsTargetList.getVariablesStringList().length() != 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/RESIDUALS"));
            stringBuffer.append(" ID(").append(this.mCaseLabelsTargetList.getVariablesStringList()).append(")");
        }
        if (!((String)(object = LinearRegressionUtils.generateCasewiseStatisticsSyntax((DialogDataModel)object4))).equals("")) {
            stringBuffer.append("\n").append((String)object);
        }
        if (!(string = LinearRegressionUtils.generateSaveSyntax((DialogDataModel)object4)).trim().equals("")) {
            stringBuffer.append(string);
        }
        StringBuffer stringBuffer2 = LinearRegressionUtils.generateOutFileSyntax((DialogDataModel)object4);
        charSequence2 = LinearRegressionUtils.generateOutFileTwoSyntax((DialogDataModel)object4);
        if (stringBuffer2 != null) {
            if (charSequence2 != null) {
                if (stringBuffer2.length() > ((StringBuffer)charSequence2).length()) {
                    stringBuffer.append("\n").append(LinearRegressionUtils.generateOutFileSyntax((DialogDataModel)object4));
                } else {
                    stringBuffer.append("\n").append(LinearRegressionUtils.generateOutFileTwoSyntax((DialogDataModel)object4));
                }
            } else {
                stringBuffer.append("\n").append(LinearRegressionUtils.generateOutFileSyntax((DialogDataModel)object4));
            }
        } else if (charSequence2 != null) {
            stringBuffer.append("\n").append(LinearRegressionUtils.generateOutFileTwoSyntax((DialogDataModel)object4));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if ((stringBuffer2 != null || charSequence2 != null) && (charSequence = LinearRegressionUtils.generatePerAttributeSyntax((DialogDataModel)object4)) != null) {
            stringBuffer.append((StringBuffer)charSequence);
        }
        if (bl && dialogDataModel != null) {
            stringBuffer.append(BootstrapDlg.getRestoreSyntax(dialogDataModel));
        }
        if (bl2 && CommandLine.isClementineCaller() && RemoteFileChooser.enableSaveInModeler()) {
            stringBuffer.append("\nDATASET ACTIVATE " + string2);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if ((charSequence = TableStyleDlg.generateSyntax((DialogDataModel)object4, TableStyleDlg.ConditionalFormatDlgType.LinearRegression)) != null) {
            stringBuffer.append((String)charSequence);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_regression_linear";
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableOkPaste(this.okPasteValue());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.okPasteValue());
        this.enableBootstrappingButton();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSelectionVarTargetList)) {
            if (this.mSelectionVarTargetList.getModel().getSize() > 0) {
                this.mRuleButton.setEnabled(true);
            } else {
                this.mRuleButton.setEnabled(false);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (listDataEvent.getSource() == this.mSelectionVarTargetList.getModel()) {
            dialogDataModel.putString(LinearRegressionRule.RULE_KEY, null);
            this.mRuleButton.setEnabled(false);
            this.mRuleSelected = false;
            this.enableBootstrappingButton();
        }
        this.enableOkPaste(this.okPasteValue());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.okPasteValue());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mMethodCombo)) {
            this.mMethodStr[this.mLayerWidget.getCurrentLayer()] = this.getMethodSyntaxStr();
        }
        if (this.mDependentTargetList.getModel().getSize() > 0) {
            this.mDependentVarArrowButton.setEnabled(false);
        }
        this.mMethodCombo.setSelectedItem(this.mMethodStr[this.mLayerWidget.getCurrentLayer()]);
        this.enableOkPaste(this.okPasteValue());
        this.enableBootstrappingButton();
    }

    @Override
    public void reset() {
        super.reset();
        this.mSrcVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mDependentTargetList.removeAll();
        this.mSelectionVarTargetList.removeAll();
        this.mCaseLabelsTargetList.removeAll();
        this.mWlsWeightTargetList.removeAll();
        mSet.clear();
        this.mMethodCombo.setSelectedIndex(0);
        this.mLayerWidget.resetLayeredListWidget();
        for (int i = 0; i < 9; ++i) {
            this.mMethodStr[i] = this.getMethodSyntaxStr();
        }
        this.setDefaults();
        this.mCount = 0;
    }

    public Set<ISpssVariable> getVariableSet() {
        return mSet;
    }

    public LayeredListWidget getLayeredListWidget() {
        return this.mLayerWidget;
    }

    @Override
    public void pack() {
        super.pack();
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        return !variableList.equals(this.mDependentTargetList) && !variableList.equals(this.mSelectionVarTargetList) && !variableList.equals(this.mWlsWeightTargetList) || this.isAcceptVariable() != false;
    }

    @Override
    protected boolean validateDialogDataModel(boolean bl) {
        super.validateDialogDataModel(bl);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (this.mSelectionVarTargetList.getModel().getSize() == 0) {
            dialogDataModel.putString(LinearRegressionRule.RULE_KEY, null);
            this.mRuleButton.setEnabled(false);
        }
        return true;
    }

    @Override
    protected void loadDialogState() {
        ISpssVariable[] iSpssVariableArray = this.getDialogDataModel().getVarArray("MAP_KEY");
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            mSet.addAll(Arrays.asList(iSpssVariableArray));
        }
        if (this.getDialogDataModel().getArray("COMBO_KEY") != null) {
            this.mMethodStr = (String[])this.getDialogDataModel().getArray("COMBO_KEY");
        }
        this.mRuleSelected = this.getDialogDataModel().getString(LinearRegressionRule.RULE_KEY) != null;
        super.loadDialogState();
        this.mLayerWidget.loadListState(this.getDialogDataModel());
        this.enableOkPaste(this.okPasteValue());
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mMethodCombo.setSelectedItem(this.indexOfCombo(this.mMethodStr[this.mLayerWidget.getCurrentLayer()]));
        this.enableBootstrappingButton();
    }

    @Override
    protected void saveDialogState() {
        this.mLayerWidget.saveListState(this.getDialogDataModel());
        this.getDialogDataModel().putInteger(COUNT_KEY, this.mCount);
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[mSet.size()];
        this.getDialogDataModel().putVarArray("MAP_KEY", mSet.toArray(iSpssVariableArray));
        this.getDialogDataModel().putArray("COMBO_KEY", this.mMethodStr);
        super.saveDialogState();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_REG_LINEAR_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 7, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(0, 6, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupDependentListPanel(), gridBagConstraints, 1, 0, 1, 2, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(5, 6, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mLayerWidget, gridBagConstraints, 1, 2, 1, 3, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.setupSelectionTargetVarsListPanel(), gridBagConstraints, 1, 5, 1, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), 6, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupCaseLabelPanel(), gridBagConstraints, 1, 6, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupWlsWeightPanel(), gridBagConstraints, 1, 7, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        AbstractAction abstractAction = new ToggleButtonAction("IDS_COMMON_STATS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinearRegressionDlg.this.runStatisticsSubDialog();
            }
        };
        this.mStatButton = new JButton(abstractAction);
        this.addOptionsPanelButton(jPanel, this.mStatButton);
        abstractAction = new ToggleButtonAction("IDS_COMMON_PLOTS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinearRegressionDlg.this.runPlotsSubDialog();
            }
        };
        this.mPlotsButton = new JButton(abstractAction);
        this.addOptionsPanelButton(jPanel, this.mPlotsButton);
        abstractAction = new AbstractAction(ResUtil.getCommonDlgString("IDS_COMMON_SAVE_BUTTON")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinearRegressionDlg.this.runSaveSubDialog();
            }
        };
        this.mSaveButton = new JButton(abstractAction);
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.mSaveButton.setMnemonic(this.getDlgAccessKey("IDK_REG_LINEAR_SAVE_BUTTON_KEY"));
        }
        this.addOptionsPanelButton(jPanel, this.mSaveButton);
        abstractAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinearRegressionDlg.this.runOptionsSubDialog();
            }
        };
        this.mOptionsButton = new JButton(abstractAction);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        abstractAction = new ToggleButtonAction("IDS_TABLE_STYLE_BUTTON_LINEAR_REGRESSION"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinearRegressionDlg.this.runConditionalSubDialog();
            }
        };
        this.mTableStyleButton = new JButton(abstractAction);
        this.addOptionsPanelButton(jPanel, this.mTableStyleButton);
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            abstractAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LinearRegressionDlg.this.runBootStrappingSubDialog();
                }
            };
            this.mBootstrappingButton = new JButton(abstractAction);
            this.addOptionsPanelButton(jPanel, this.mBootstrappingButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode() || CommandLine.isClementineCaller() && RemoteFileChooser.getFileBrowseCallback() != null && RemoteFileChooser.getFileBrowseCallback().isFromModelerModelNode()) {
                this.mBootstrappingButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    String getVarName() {
        return this.mVarName;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDependentVarArrowButton);
        vector.add(this.mDependentTargetList);
        Vector<Object> vector2 = this.mLayerWidget.getTraversalComponent();
        Component[] componentArray = new Component[vector2.size()];
        Iterator<Object> iterator = vector2.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            componentArray[n] = (Component)iterator.next();
            ++n;
        }
        vector.add(componentArray[0]);
        vector.add(componentArray[1]);
        vector.add(this.mMethodCombo);
        vector.add(componentArray[3]);
        vector.add(componentArray[2]);
        vector.add(this.mSelectionVarArrowButton);
        vector.add(this.mSelectionVarTargetList);
        vector.add(this.mRuleButton);
        vector.add(this.mCaseLabelsArrowButton);
        vector.add(this.mCaseLabelsTargetList);
        vector.add(this.mWlsWeightArrowButton);
        vector.add(this.mWlsWeightTargetList);
        vector.add(this.mStatButton);
        vector.add(this.mPlotsButton);
        vector.add(this.mSaveButton);
        vector.add(this.mOptionsButton);
        if (this.mTableStyleButton != null) {
            vector.add(this.mTableStyleButton);
        }
        if (this.mBootstrappingButton != null) {
            vector.add(this.mBootstrappingButton);
        }
        Component[] componentArray2 = this.mCmdButtonPanel.getComponents();
        vector.addAll(Arrays.asList(componentArray2));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupDependentListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, this.mArrowInsets.left, 0, this.mArrowInsets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDependentVarArrowButton, gridBagConstraints, 0, 0, 1, 2, n, insets);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_REG_LINEAR_DEP_VAR_LIST_LABEL");
        jLabel.setLabelFor(this.mDependentTargetList);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        JScrollPane jScrollPane = new JScrollPane(this.mDependentTargetList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mDependentTargetList.getMinimumSize());
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(0, 0, 0, 12);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        this.mDependentVarArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDependentVarArrowButton.registerVariableList(this.mDependentTargetList, SpssArrowButton.ButtonOrientation.left);
        return jPanel;
    }

    private JPanel setupCaseLabelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, this.mArrowInsets.left, 0, this.mArrowInsets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCaseLabelsArrowButton, gridBagConstraints, 0, 0, 1, 2, n, insets);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_REG_LINEAR_CASE_VAR_LIST_LABEL");
        jLabel.setLabelFor(this.mCaseLabelsTargetList);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        JScrollPane jScrollPane = new JScrollPane(this.mCaseLabelsTargetList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mCaseLabelsTargetList.getMinimumSize());
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(0, 0, 0, 12);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        this.mCaseLabelsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCaseLabelsArrowButton.registerVariableList(this.mCaseLabelsTargetList, SpssArrowButton.ButtonOrientation.left);
        return jPanel;
    }

    private JPanel setupWlsWeightPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, this.mArrowInsets.left, 0, this.mArrowInsets.right);
        DialogUtil.addUsingGBL(jPanel, this.mWlsWeightArrowButton, gridBagConstraints, 0, 0, 1, 2, n, insets);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_REG_LINEAR_WLS_VAR_LIST_LABEL");
        jLabel.setLabelFor(this.mWlsWeightTargetList);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        JScrollPane jScrollPane = new JScrollPane(this.mWlsWeightTargetList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mWlsWeightTargetList.getMinimumSize());
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(0, 0, 0, 12);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        this.mWlsWeightArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mWlsWeightArrowButton.registerVariableList(this.mWlsWeightTargetList, SpssArrowButton.ButtonOrientation.left);
        return jPanel;
    }

    private JPanel setupSelectionTargetVarsListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 20;
        Insets insets = new Insets(0, this.mArrowInsets.left, 0, this.mArrowInsets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSelectionVarArrowButton, gridBagConstraints, 0, 0, 1, 2, n, insets);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_REG_LINEAR_SEL_VAR_LIST_LABEL");
        jLabel.setLabelFor(this.mSelectionVarTargetList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.mSelectionVarTargetList);
        jScrollPane.setPreferredSize(this.mSelectionVarTargetList.getMinimumSize());
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, n, null);
        this.mSelectionVarArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSelectionVarArrowButton.registerVariableList(this.mSelectionVarTargetList, SpssArrowButton.ButtonOrientation.left);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = DialogUtil.getStandardControlInsets();
        Insets insets3 = new Insets(n2 + insets2.bottom + 4, DialogUtil.getGroupBoxInnerMargin(), 0, n2 + insets2.bottom);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRuleButton, gridBagConstraints, 2, 0, 1, 2, n, insets3);
        return jPanel;
    }

    private void runStatisticsSubDialog() {
        this.runSubDialog(new LinearRegressionStatistics(this));
    }

    private void runPlotsSubDialog() {
        this.runSubDialog(new LinearRegressionPlots(this));
    }

    private void runSaveSubDialog() {
        this.runSubDialog(new LinearRegressionSave(this));
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new LinearRegressionOptions(this));
    }

    private void runConditionalSubDialog() {
        this.runSubDialog(new TableStyleDlg(this, TableStyleDlg.ConditionalFormatDlgType.LinearRegression));
    }

    private void runBootStrappingSubDialog() {
        this.runSubDialog(new BootstrapDlg(this));
    }

    private void runRuleSubDialog() {
        this.mVarName = this.mSelectionVarTargetList.getModel().getElementAt(0).getName();
        this.runSubDialog(new LinearRegressionRule(this));
        if (this.getDialogDataModel().getString(LinearRegressionRule.RULE_KEY) != null) {
            this.mSelectionVarTargetList.updateUI();
            this.mRuleSelected = true;
            this.enableOkPaste(this.okPasteValue());
        }
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.addFocusListener(this);
        this.mSrcVarList.getModel().addListDataListener(this);
        this.mDependentTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDependentTargetList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mDependentTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDependentTargetList.setIdentifier(DEPENDENT_KEY);
        this.mDependentTargetList.getModel().addListDataListener(this);
        this.mDependentTargetList.addFocusListener(this);
        this.mSelectionVarTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSelectionVarTargetList.getModel().addListDataListener(this);
        this.mSelectionVarTargetList.addFocusListener(this);
        this.mSelectionVarTargetList.setIdentifier(SELECTION_KEY);
        this.mSelectionVarTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mSelectionVarTargetList.setCellRenderer(new LinearListCellRenderer(){

            @Override
            protected String getViewText(ISpssVariable iSpssVariable) {
                if (LinearRegressionDlg.this.getDialogDataModel().getString(LinearRegressionRule.RULE_KEY) != null) {
                    return iSpssVariable.getName() + LinearRegressionDlg.this.getDialogDataModel().getString(LinearRegressionRule.RULE_KEY);
                }
                return iSpssVariable.getName() + "=?";
            }
        });
        this.mCaseLabelsTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mCaseLabelsTargetList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mCaseLabelsTargetList.setIdentifier(CASELABELS_KEY);
        this.mCaseLabelsTargetList.getModel().addListDataListener(this);
        this.mCaseLabelsTargetList.addFocusListener(this);
        this.mWlsWeightTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mWlsWeightTargetList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mWlsWeightTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mWlsWeightTargetList.setIdentifier(WLSWEIGHT_KEY);
        this.mWlsWeightTargetList.getModel().addListDataListener(this);
        this.mWlsWeightTargetList.addFocusListener(this);
        mSet = new HashSet<ISpssVariable>();
        this.mArrowInsets = DialogUtil.getArrowButtonInsets();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, RULE_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinearRegressionDlg.this.runRuleSubDialog();
            }
        };
        this.mRuleButton = new JButton(toggleButtonAction);
        this.mMethodComboitem = this.getResStringArray("IDS_REG_LINEAR_METHOD_COMBO");
        this.mMethodCombo = new JComboBox<String>(this.mMethodComboitem);
        this.mMethodCombo.addItemListener(this);
        this.mSelectionVarArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSelectionVarArrowButton.setVarMoveHandler(this);
        this.mDependentVarArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDependentVarArrowButton.setVarMoveHandler(this);
        this.mCaseLabelsArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWlsWeightArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWlsWeightArrowButton.setVarMoveHandler(this);
        this.initializeLayerPanel();
        this.mLayerWidget.setMaxNoOfLayers(9);
        this.mLayerWidget.setSrcList(this.mSrcVarList);
        this.mMethodStr = new String[9];
        this.mMethodCombo.setSelectedIndex(0);
        String string = this.getMethodSyntaxStr();
        for (int i = 0; i < 9; ++i) {
            this.mMethodStr[i] = string.toUpperCase();
        }
        this.setDefaults();
    }

    private void setDefaults() {
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mRuleSelected = false;
        this.enableOkPaste(false);
        this.mRuleButton.setEnabled(false);
    }

    private boolean isElementPresent(VarListModel varListModel, String string) {
        for (int i = 0; i < varListModel.getSize(); ++i) {
            if (!varListModel.getElementAt(i).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private Boolean isAcceptVariable() {
        ISpssVariable[] iSpssVariableArray = this.mSrcVarList.getSelectedValues();
        ArrayList<VarListModel> arrayList = this.getLayeredListWidget().getVarListModels();
        for (VarListModel varListModel : arrayList) {
            if (!this.isElementPresent(varListModel, iSpssVariableArray[0].getName())) continue;
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), ResUtil.getCommonDlgString("ERR_CANNOT_ACCEPT_VARS_PRESENT_IN_OTHER_TARGET_LIST"), VersionInfo.getAppVersionString());
            return false;
        }
        VarListModel varListModel = this.mLayerList.getModel();
        if (this.isElementPresent(varListModel, iSpssVariableArray[0].getName())) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), ResUtil.getCommonDlgString("ERR_CANNOT_ACCEPT_VARS_PRESENT_IN_OTHER_TARGET_LIST"), VersionInfo.getAppVersionString());
            return false;
        }
        if (this.mCaseLabelsTargetList.getModel().getSize() > 0 && this.mCaseLabelsTargetList.getModel().getElementAt(0).getName().equals(iSpssVariableArray[0].getName())) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), ResUtil.getCommonDlgString("ERR_CANNOT_ACCEPT_VARS_PRESENT_IN_OTHER_TARGET_LIST"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    private void initializeLayerPanel() {
        this.mLayerWidget = new LayeredListWidget(this.getResString("IDS_REG_LINEAR_INDEPENDENT_LABEL"), this){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                super.intervalAdded(listDataEvent);
                LinearRegressionDlg.this.enableOkPaste(LinearRegressionDlg.this.okPasteValue());
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                super.intervalRemoved(listDataEvent);
                LinearRegressionDlg.this.enableOkPaste(LinearRegressionDlg.this.okPasteValue());
            }

            @Override
            protected void moreOperationOnNext() {
                LinearRegressionDlg.this.mMethodCombo.setSelectedItem(LinearRegressionDlg.this.indexOfCombo(LinearRegressionDlg.this.mMethodStr[this.getCurrentLayer()]));
                super.moreOperationOnNext();
            }

            @Override
            protected void moreOperationOnPrevious() {
                LinearRegressionDlg.this.mMethodCombo.setSelectedItem(LinearRegressionDlg.this.indexOfCombo(LinearRegressionDlg.this.mMethodStr[this.getCurrentLayer()]));
                super.moreOperationOnPrevious();
            }

            @Override
            protected void setIndependentBorder() {
            }

            @Override
            protected JPanel setupIndependentPanel() {
                LinearRegressionDlg.this.mLayerList = this.mVarList;
                this.mVarList.setIdentifier(LinearRegressionDlg.LAYERED_LIST_IDENTIFIER);
                this.mBorderTitle = LinearRegressionDlg.this.getResString("IDS_REG_LINEAR_LAYERED_TITLE");
                this.mArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 2;
                int n = 23;
                Insets insets = new Insets(2, 8, 3, 0);
                this.mLayeredListPanel = new JPanel(new GridBagLayout());
                this.mLayeredListPanel.setBorder(new TitledBorder(this.mBorderTitle + (this.getCurrentLayer() + 1) + ResUtil.getCommonDlgString("IDS_LAYER_WIDGET_INDEPENDENT_LAYER_TITLE2") + (this.getNoOfLayers() + 1)));
                DialogUtil.addUsingGBL(this.mLayeredListPanel, this.setupButtonPanel(), gridBagConstraints, 0, 0, 3, 1, n, insets);
                gridBagConstraints.weightx = 1.0;
                insets.set(0, 8, 0, 8);
                this.mIndependentListLabel = DialogUtil.createLabel(LinearRegressionDlg.this, "IDS_REG_LINEAR_LAYER_LIST_LABEL");
                this.mIndependentListLabel.setLabelFor(this.mVarList);
                DialogUtil.addUsingGBL(this.mLayeredListPanel, this.mIndependentListLabel, gridBagConstraints, 1, 1, 1, 1, n, insets);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 0;
                Insets insets2 = new Insets(20, 2, 20, 10);
                DialogUtil.addUsingGBL(this.mLayeredListPanel, this.mArrow, gridBagConstraints, 0, 2, 1, 1, 10, insets2);
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                this.mVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
                this.mVarList.addVarFilter(new SpssVarFilter(8, true, false));
                JScrollPane jScrollPane = new JScrollPane(this.mVarList);
                jScrollPane.setPreferredSize(this.mVarList.getMinimumSize());
                insets.set(0, 0, 11, DialogUtil.getGroupBoxInnerMargin());
                DialogUtil.addUsingGBL(this.mLayeredListPanel, jScrollPane, gridBagConstraints, 1, 2, 2, 1, n, insets);
                this.mArrow.registerVariableList(this.mVarList, SpssArrowButton.ButtonOrientation.left);
                JLabel jLabel = DialogUtil.createLabel(LinearRegressionDlg.this, "IDS_REG_LINEAR_LAYER_METHOD_LABEL");
                jLabel.setLabelFor(LinearRegressionDlg.this.mMethodCombo);
                n = 24;
                insets.set(0, 58, 3, 0);
                gridBagConstraints.weighty = 0.0;
                DialogUtil.addUsingGBL(this.mLayeredListPanel, jLabel, gridBagConstraints, 1, 4, 1, 1, n, insets);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 2;
                n = 23;
                insets.set(0, 0, 3, DialogUtil.getGroupBoxInnerMargin());
                DialogUtil.addUsingGBL(this.mLayeredListPanel, LinearRegressionDlg.this.mMethodCombo, gridBagConstraints, 2, 4, 1, 1, n, insets);
                this.mArrow.setEnabled(false);
                return this.mLayeredListPanel;
            }
        };
    }

    private boolean okPasteValue() {
        if (this.mSelectionVarTargetList.getModel().getSize() > 0 ? this.mDependentTargetList.getModel().getSize() > 0 && this.mRuleSelected : this.mDependentTargetList.getModel().getSize() > 0) {
            return this.mLayerWidget.getVarListModels().size() > 1 || this.mLayerList.getModel().getSize() > 0;
        }
        return false;
    }

    private String getMethodSyntaxStr() {
        String string = "";
        int n = this.mMethodCombo.getSelectedIndex();
        switch (n) {
            case 0: {
                string = "ENTER";
                break;
            }
            case 1: {
                string = "STEPWISE";
                break;
            }
            case 2: {
                string = "REMOVE";
                break;
            }
            case 3: {
                string = "BACKWARD";
                break;
            }
            case 4: {
                string = "FORWARD";
            }
        }
        return string;
    }

    private String indexOfCombo(String string) {
        if (string.equals("ENTER")) {
            return this.mMethodComboitem[0];
        }
        if (string.equals("STEPWISE")) {
            return this.mMethodComboitem[1];
        }
        if (string.equals("REMOVE")) {
            return this.mMethodComboitem[2];
        }
        if (string.equals("BACKWARD")) {
            return this.mMethodComboitem[3];
        }
        if (string.equals("FORWARD")) {
            return this.mMethodComboitem[4];
        }
        return this.mMethodComboitem[0];
    }

    private void enableBootstrappingButton() {
        if (this.mBootstrappingButton != null) {
            if (!this.areMethodAllENTER() || this.mSelectionVarTargetList.getModel().getSize() != 0) {
                this.mBootstrappingButton.setEnabled(false);
            } else {
                this.mBootstrappingButton.setEnabled(true);
            }
            if (BootstrapDlg.isCurrentDatasetInMIMode() || CommandLine.isClementineCaller() && RemoteFileChooser.getFileBrowseCallback() != null && RemoteFileChooser.getFileBrowseCallback().isFromModelerModelNode()) {
                this.mBootstrappingButton.setEnabled(false);
            }
        }
    }

    private boolean areMethodAllENTER() {
        for (String string : this.mMethodStr) {
            if (string.equalsIgnoreCase("ENTER")) continue;
            return false;
        }
        return true;
    }
}

